(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.CategoryAdd20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'CategoryAdd20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: { d: 'M15 6l-1.41 1.41L17.17 11l-3.58 3.59L15 16l5-5-5-5z' },
        }),
        createElement('path', {
          attrs: {
            d:
              'M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
