(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.CategoryAnd32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'CategoryAnd32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M4 30v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2H17v-5h-2v5H4a2 2 0 0 0-2 2v4zm16.695-16.014A10.08 10.08 0 0 0 21.946 10H23V8h-3v1a9.263 9.263 0 0 1-.664 3.27L16.65 8.883a5.126 5.126 0 0 0 2.144-2.37 3.252 3.252 0 0 0-.189-2.702 3.38 3.38 0 0 0-2.239-1.706 3.469 3.469 0 0 0-4.222 2.119c-.505 1.552.44 3.116 1.261 4.108a4.726 4.726 0 0 0-2.346 4.828A4.453 4.453 0 0 0 15.427 17h.006a5.784 5.784 0 0 0 3.971-1.423L20.532 17h2.552zM14.047 4.84A1.322 1.322 0 0 1 15.414 4a2.41 2.41 0 0 1 .521.058 1.402 1.402 0 0 1 .912.702 1.25 1.25 0 0 1 .079 1.042 3.687 3.687 0 0 1-1.682 1.593c-.66-.713-1.435-1.822-1.197-2.554zM15.432 15h-.004a2.443 2.443 0 0 1-2.392-2.15 2.826 2.826 0 0 1 1.81-3.026l3.312 4.179a3.885 3.885 0 0 1-2.726.997z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
