(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.ChartVennDiagram20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'ChartVennDiagram20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M20 6a9.92 9.92 0 0 0-4 .84A9.92 9.92 0 0 0 12 6a10 10 0 0 0 0 20 9.92 9.92 0 0 0 4-.84 9.92 9.92 0 0 0 4 .84 10 10 0 0 0 0-20zm-8 18a8 8 0 0 1 0-16 7.91 7.91 0 0 1 1.76.2 10 10 0 0 0 0 15.6A7.91 7.91 0 0 1 12 24zm8-8a8 8 0 0 1-4 6.92 8 8 0 0 1 0-13.84A8 8 0 0 1 20 16zm0 8a7.91 7.91 0 0 1-1.76-.2 10 10 0 0 0 0-15.6A7.91 7.91 0 0 1 20 8a8 8 0 0 1 0 16z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
