(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.ComposerEdit32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'ComposerEdit32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
