(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.CopyFile24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'CopyFile24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M27.435 14.699l-6.058-6.121A1.949 1.949 0 0 0 19.998 8H12a2.002 2.002 0 0 0-2 2v19a2.002 2.002 0 0 0 2 2h14a2.002 2.002 0 0 0 2-2V16.077a1.976 1.976 0 0 0-.565-1.378zM20 10.03L25.924 16H20zM12 29V10h6v6a2.002 2.002 0 0 0 2 2h6l.001 11z',
          },
        }),
        createElement('path', {
          attrs: { d: 'M6 18H4V4a2.002 2.002 0 0 1 2-2h14v2H6z' },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
