(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.DataVis_224 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'DataVis_224',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M28 2H17a2.002 2.002 0 0 0-2 2v6H4a2.002 2.002 0 0 0-2 2v16a2.002 2.002 0 0 0 2 2h11a2.002 2.002 0 0 0 2-2v-6h11a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 2v4H17V4zM15 22H4v-4h11zm2-12h11l.001 4H17zm-2 2v4H4v-4zM4 28v-4h11.001v4zm13-8v-4h11.002v4z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
