(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Document16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Document16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 16 16',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M12.9 4.7L9.4 1.2C9.3 1.1 9.1 1 9 1H4c-.6 0-1 .4-1 1v12c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V5c0-.1-.1-.3-.1-.3zM9 2.2L11.8 5H9V2.2zM12 14H4V2h4v3c0 .6.4 1 1 1h3v8z',
          },
        }),
        createElement('path', { attrs: { d: 'M5 11h6v1H5zm0-3h6v1H5z' } }),
        children,
      ]);
    },
  };

  return _16;

})));
