(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.EdtLoop32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'EdtLoop32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M23.625 22.587a6.129 6.129 0 0 1-4.5-1.9l-3.1-3.2-3.1 3.2a6.458 6.458 0 0 1-9.1 0 7.028 7.028 0 0 1-1.8-4.7 6.655 6.655 0 0 1 1.9-4.7 6.338 6.338 0 0 1 9 0l3.1 3.2 3.1-3.2a6.338 6.338 0 0 1 9 0 6.828 6.828 0 0 1 0 9.4 6.542 6.542 0 0 1-4.5 1.9zm-6.2-6.6l3.1 3.3a4.406 4.406 0 0 0 6.2 0 4.908 4.908 0 0 0 0-6.6 4.406 4.406 0 0 0-6.2 0zm-9-4.6a4.158 4.158 0 0 0-3.1 1.3 4.838 4.838 0 0 0 0 6.6 4.406 4.406 0 0 0 6.2 0l3.1-3.3-3.1-3.3a4.77 4.77 0 0 0-3.1-1.3z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
