(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.FaceAdd24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'FaceAdd24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M16 22a6 6 0 0 1-5.14-2.92l-1.71 1a8 8 0 0 0 13.7 0l-1.71-1A6 6 0 0 1 16 22zM30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M27.61 13a12.33 12.33 0 0 1 .39 3A12 12 0 1 1 16 4V2a14 14 0 1 0 13.67 11z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
