(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.FaceDizzyFilled16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'FaceDizzyFilled16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 16.41L7.59 15l2-2-2-2L9 9.59l2 2 2-2L14.41 11l-2 2 2 2L13 16.41l-2-2zM16 25a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm8.41-10L23 16.41l-2-2-2 2L17.59 15l2-2-2-2L19 9.59l2 2 2-2L24.41 11l-2 2z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
