(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Forward_532 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'Forward_532',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d: 'M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M18.58 15.58h-3.45L15 18.15a4.83 4.83 0 0 1 .26-.45 1.59 1.59 0 0 1 .33-.35 1.53 1.53 0 0 1 .44-.23 2 2 0 0 1 .6-.08 2.54 2.54 0 0 1 .92.16 2.06 2.06 0 0 1 .74.48 2.28 2.28 0 0 1 .5.77 2.73 2.73 0 0 1 .18 1 2.87 2.87 0 0 1-.19 1.07 2.36 2.36 0 0 1-.55.84 2.44 2.44 0 0 1-.89.55 3.23 3.23 0 0 1-1.21.2 3.79 3.79 0 0 1-.94-.11 3 3 0 0 1-.74-.32 2.45 2.45 0 0 1-.55-.45 4.13 4.13 0 0 1-.41-.55l1.06-.81.27.41a1.82 1.82 0 0 0 .34.34 1.59 1.59 0 0 0 .43.22 1.52 1.52 0 0 0 .55.08 1.29 1.29 0 0 0 1-.36 1.41 1.41 0 0 0 .33-1v-.06a1.18 1.18 0 0 0-1.28-1.27 1.44 1.44 0 0 0-.77.18 1.94 1.94 0 0 0-.48.39l-1.19-.17.29-4.31h4.52z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
