(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.HelpFilled16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'HelpFilled16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 16 16',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 11.5c-.4 0-.8-.3-.8-.8s.4-.7.8-.7.8.3.8.8-.4.7-.8.7zm.6-3.9v1.2H7.4V7.5h1.1c.7 0 1.2-.6 1.1-1.3 0-.6-.5-1.1-1.1-1.1h-.7c-.7 0-1.2.5-1.2 1.2v.3H5.4v-.3C5.4 5 6.5 4 7.8 4h.7c1.3 0 2.3 1.1 2.2 2.4 0 1.2-.9 2.2-2.1 2.2z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
