(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Hurricane24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'Hurricane24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('circle', { attrs: { cx: '16', cy: '16', r: '2' } }),
        createElement('path', {
          attrs: {
            d:
              'M16 7a8.966 8.966 0 0 0-2.655.4 15.613 15.613 0 0 1 3.466-1.823A25.969 25.969 0 0 1 25.001 4L25 2c-.18 0-18 .16-18 14a9 9 0 0 0 11.655 8.6 15.61 15.61 0 0 1-3.466 1.823A25.975 25.975 0 0 1 7 28v2c.18 0 18-.16 18-14a9.01 9.01 0 0 0-9-9zm0 16a7 7 0 1 1 7-7 7.008 7.008 0 0 1-7 7z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
