(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.IbmCloud32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'IbmCloud32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M24.58 13.65a9.733 9.733 0 0 0-18.294 3.889A6.75 6.75 0 0 0 7 31h16a8.746 8.746 0 0 0 1.58-17.35zM23 29.5H7a5.237 5.237 0 0 1-.7-10.43 9.726 9.726 0 0 0 1.104 3.785.75.75 0 1 0 1.322-.71 8.25 8.25 0 0 1 14.026-8.632 8.754 8.754 0 0 0-6.315 2.95.75.75 0 1 0 1.124.992A7.25 7.25 0 1 1 23 29.5zm8.898-19.245a.758.758 0 0 0-1.036-.278l-3.02 1.744a.759.759 0 1 0 .758 1.314l3.02-1.744a.759.759 0 0 0 .278-1.036zM22.676 7.87a.758.758 0 0 0 1.037-.278l1.744-3.02a.759.759 0 0 0-1.314-.758l-1.744 3.02a.759.759 0 0 0 .277 1.036zM16 6.081a.759.759 0 0 0 .759-.759V1.835a.759.759 0 1 0-1.518 0v3.487a.759.759 0 0 0 .759.76zM8.287 7.592a.759.759 0 0 0 1.314-.759l-1.744-3.02a.759.759 0 1 0-1.314.76zm-4.128 4.129l-3.02-1.744a.759.759 0 1 0-.76 1.314L3.4 13.035a.759.759 0 1 0 .759-1.314z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
