(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Identification16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Identification16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M28 6v20H4V6h24m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M6 10h7v2H6zm0 4h4v2H6zm17 4h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
