(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.LetterWw24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'LetterWw24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M24.3 13l-.91 8.61L22 13h-2l-1.39 8.61L17.7 13H16l1.36 10h2.28L21 14.63 22.36 23h2.28L26 13h-1.7zM12.21 9l-.34 8-.26 4.54L11.2 18l-.68-5.46H8.5L7.82 18l-.41 3.54L7.16 17l-.35-8h-1.8l1 14h2.27l.76-4.93L9.5 14l.01-.03.01.03.46 4.07.76 4.93h2.27l1-14h-1.8z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
