(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.LogoLivestream20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'LogoLivestream20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M22.49 23.71h-7.54a3.12 3.12 0 0 1-2.41-1A14.91 14.91 0 0 1 10 18.88c-1.3-2.6-2.54-5.22-3.82-7.82-.39-.8-.82-1.56-1.28-2.32A7.84 7.84 0 0 0 2 5.6h3.57a45.63 45.63 0 0 1 7 .61 8.09 8.09 0 0 1 6.34 5.09 48.51 48.51 0 0 1 2.17 7.36 26 26 0 0 0 1.41 5.05zm5.61 2.67a2.93 2.93 0 0 1-2.74-2.64 42.08 42.08 0 0 1-.14-4.9 48 48 0 0 0-.61-7.58 3.75 3.75 0 0 0-.83-2h2.65c.54 0 .73.37.89.78a12.1 12.1 0 0 1 .68 3.24c.29 2.72.31 5.45.33 8.18a10.94 10.94 0 0 0 0 1.15c.09.78.4 1.1 1.17 1.08.5 0 .5-.06.5-.06v2.69a8.62 8.62 0 0 1-1.9.06z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
