(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.LogoSlack24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'LogoSlack24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M9.042 19.166a2.521 2.521 0 1 1-2.52-2.521h2.52zm1.271 0a2.521 2.521 0 0 1 5.042 0v6.313a2.521 2.521 0 1 1-5.042 0zm2.521-10.124a2.521 2.521 0 1 1 2.521-2.52v2.52zm0 1.271a2.521 2.521 0 0 1 0 5.042H6.52a2.521 2.521 0 1 1 0-5.042zm10.124 2.521a2.521 2.521 0 1 1 2.52 2.521h-2.52zm-1.271 0a2.521 2.521 0 0 1-5.042 0V6.52a2.521 2.521 0 1 1 5.042 0zm-2.521 10.124a2.521 2.521 0 1 1-2.521 2.52v-2.52zm0-1.271a2.521 2.521 0 0 1 0-5.042h6.313a2.521 2.521 0 1 1 0 5.042z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
