(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Misuse24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'Misuse24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 24 24',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M12 1C6 1 1 6 1 12s5 11 11 11 11-4.9 11-11S18.1 1 12 1zm4.2 16.5L12 13.3l-4.2 4.2-1.3-1.3 4.2-4.2-4.2-4.2 1.3-1.3 4.2 4.2 4.2-4.2 1.3 1.3-4.2 4.2 4.2 4.2-1.3 1.3z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M16.2 17.5L12 13.3l-4.2 4.2-1.3-1.3 4.2-4.2-4.2-4.2 1.3-1.3 4.2 4.2 4.2-4.2 1.3 1.3-4.2 4.2 4.2 4.2-1.3 1.3z',
            'data-icon-path': 'inner-path',
            opacity: '0',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
