(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.PhoneOff32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'PhoneOff32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M9.19 18.56A25.66 25.66 0 0 1 5 6.08V6a1 1 0 0 1 1-1h5.28l1.5 3.77-2.84 2.87.06.48a13 13 0 0 0 1.46 4.17l1.46-1.46a9.34 9.34 0 0 1-.84-2.52l2.13-2.15A2 2 0 0 0 14.65 8l-1.52-3.74A2 2 0 0 0 11.27 3H5.76A3 3 0 0 0 3 6.23 28 28 0 0 0 7.79 20zm18.58.3L24 17.35a2 2 0 0 0-2.17.41l-2.17 2.15A9.17 9.17 0 0 1 15.45 18L30 3.41 28.59 2 2 28.59 3.41 30l7-7c3.38 3.18 8.28 5.62 15.39 6h.2a3 3 0 0 0 3-3v-5.28a2 2 0 0 0-1.23-1.86zM27 26v.06a1 1 0 0 1-1.06.94c-6.51-.37-11-2.54-14.11-5.42L14 19.44A10.77 10.77 0 0 0 19.88 22l.48.06 2.87-2.85L27 20.72z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
