(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Plane16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Plane16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M29.37 14.75L20 10V6a4 4 0 0 0-8 0v4l-9.37 4.75a1 1 0 0 0-.63.93v5a1 1 0 0 0 1 1 1 1 0 0 0 .29-.05L12 18v5l-3.45 1.72a1 1 0 0 0-.55.9V29a1 1 0 0 0 1 1 .9.9 0 0 0 .28 0L16 28l6.72 2a.9.9 0 0 0 .28 0 1 1 0 0 0 1-1v-3.38a1 1 0 0 0-.55-.9L20 23v-5l8.71 3.61a1 1 0 0 0 .29.05 1 1 0 0 0 1-1v-5a1 1 0 0 0-.63-.91zM28 19.15L18 15v9.24l4 2v1.43l-6-1.75-6 1.75v-1.43l4-2V15L4 19.15V16.3l10-5.07V6a2 2 0 0 1 4 0v5.23l10 5.07z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
