(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Power16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Power16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 16 16',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M11.2 2.9l-.5.9c2.6 1.5 3.5 4.9 2 7.5s-4.9 3.5-7.5 2-3.5-4.9-2-7.5c.5-.8 1.2-1.5 2-2l-.4-.9C1.7 4.7.6 8.7 2.4 11.8s5.8 4.2 8.9 2.4 4.2-5.8 2.4-8.9c-.6-1-1.5-1.9-2.5-2.4z',
          },
        }),
        createElement('path', { attrs: { d: 'M7.5 1h1v7h-1z' } }),
        children,
      ]);
    },
  };

  return _16;

})));
