(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.RulerAlt24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'RulerAlt24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M29.41 21.67L10.34 2.58a2 2 0 0 0-2.83 0L2.59 7.51a2 2 0 0 0 0 2.82l19.07 19.09a2 2 0 0 0 1.42.58 2 2 0 0 0 1.41-.58l4.92-4.93a2 2 0 0 0 0-2.82zM23.08 28L4 8.92 8.92 4l3.79 3.79L10.46 10l1.41 1.41 2.25-2.21 4.13 4.13L16 15.58 17.42 17l2.25-2.25 4.13 4.13-2.25 2.25L23 22.54l2.25-2.25L28 23.08z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
