(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Scalpel20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'Scalpel20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M28.83 5.17a4.1 4.1 0 0 0-5.66 0L.34 28h9.25a5 5 0 0 0 3.53-1.46l15.71-15.71a4 4 0 0 0 0-5.66zM12.29 18.88l2.09-2.09 2.83 2.83-2.09 2.09zm-.58 6.24a3 3 0 0 1-2.12.88H5.17l5.71-5.71 2.83 2.83zm15.7-15.71l-8.79 8.8-2.83-2.83 8.8-8.79a2 2 0 0 1 2.82 0 2 2 0 0 1 0 2.82z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
