(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Smell16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Smell16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M22 15v-5h-2v7h2a3 3 0 0 1 0 6h-1v-2h-2v2a3 3 0 0 1-6 0v-2h-2v2h-1a3 3 0 0 1 0-6h2V9a3 3 0 0 1 3-3h1V4h-1a5 5 0 0 0-5 5v6a5 5 0 0 0 0 10h1.42a5 5 0 0 0 9.16 0H22a5 5 0 0 0 0-10z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
