(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.SprayPaint32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'SprayPaint32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M22.5 23a4.5 4.5 0 1 1 4.5-4.5 4.505 4.505 0 0 1-4.5 4.5zm0-7a2.5 2.5 0 1 0 2.5 2.5 2.503 2.503 0 0 0-2.5-2.5z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M28 8h-2V3h-7v5h-2a2.002 2.002 0 0 0-2 2v18a2.002 2.002 0 0 0 2 2h11a2.003 2.003 0 0 0 2-2V10a2.002 2.002 0 0 0-2-2zm-7-3h3v3h-3zm-4 23V10h11l.002 18zM2 14h3v3H2zm5-5h3v3H7zM2 9h3v3H2zm10-5h3v3h-3zM7 4h3v3H7zM2 4h3v3H2z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
