(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.TextIndentMore32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'TextIndentMore32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M20 6h10v2H20zm0 6h7v2h-7zm0 6h10v2H20zm0 6h7v2h-7zM14 4h2v24h-2zM3.85 22.5l-1.41-1.38L8.73 15 2.44 8.88 3.85 7.5l7.71 7.5-7.71 7.5z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
