(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.TextLeading32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'TextLeading32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M14 13h16v2H14zm1 15h15v2H15zm10.85-1H28l-4.36-10h-2.28L17 27h2.15l.8-2h5.1zm-5.1-4l1.75-4.37L24.25 23zm5.1-11H28L23.64 2h-2.28L17 12h2.15l.8-2h5.1zm-5.1-4l1.75-4.37L24.25 8zM6 15.83l2.58 2.58L10 17l-4-4-4 4 1.41 1.42L6 15.83zm0 11.34l-2.58-2.58L2 26l4 4 4-4-1.41-1.42L6 27.17z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
