(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.ThumbsDown24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'ThumbsDown24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M26.76 21A3.64 3.64 0 0 0 30 17v-6c0-3.65-1.56-8-9-8H2v14h6.46L12 22.37l1 6.34v.12A1.51 1.51 0 0 0 14.43 30H16a3.22 3.22 0 0 0 .76 0A3.64 3.64 0 0 0 20 26v-5h6a3.22 3.22 0 0 0 .76 0zM8 15H4V5h4zm20 2c0 1.44-.56 2-2 2h-8v7c0 1.44-.56 2-2 2h-1.13l-.14-1-.73-5.37-4-5.93V5h11c4.78 0 7 1.91 7 6z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
