(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Train32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'Train32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M21 2H11a5 5 0 0 0-5 5v13a5 5 0 0 0 4.36 4.94L9 30h2.07l1.34-5h7.18l1.34 5H23l-1.36-5.06A5 5 0 0 0 26 20V7a5 5 0 0 0-5-5zm3 6v7H8V8zM11 4h10a3 3 0 0 1 2.82 2H8.18A3 3 0 0 1 11 4zm10 19H11a3 3 0 0 1-2.82-2H11v-2H8v-2h16v2h-3v2h2.82A3 3 0 0 1 21 23z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
