(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Types16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Types16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d: 'M30 16l-8 8-1.414-1.414L27.172 16l-6.586-6.586L22 8l8 8z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M16 22a.997.997 0 0 1-.707-.293l-5-5a1 1 0 0 1 0-1.414l5-5a1 1 0 0 1 1.414 0l5 5a1 1 0 0 1 0 1.414l-5 5A.997.997 0 0 1 16 22zm-3.586-6L16 19.586 19.586 16 16 12.414z',
          },
        }),
        createElement('path', {
          attrs: { d: 'M2 16l8-8 1.414 1.414L4.828 16l6.586 6.586L10 24l-8-8z' },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
