(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Unknown32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'Unknown32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('circle', { attrs: { cx: '16', cy: '22.5', r: '1.5' } }),
        createElement('path', {
          attrs: {
            d:
              'M17 19h-2v-4h2a2 2 0 0 0 0-4h-2a2.002 2.002 0 0 0-2 2v.5h-2V13a4.005 4.005 0 0 1 4-4h2a4 4 0 0 1 0 8z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M16 30a2.076 2.076 0 0 1-1.473-.61L2.609 17.474a2.086 2.086 0 0 1 0-2.946L14.527 2.609a2.086 2.086 0 0 1 2.946 0l11.918 11.918a2.086 2.086 0 0 1 0 2.946L17.473 29.391A2.076 2.076 0 0 1 16 30zm0-26a.084.084 0 0 0-.06.024L4.025 15.94a.084.084 0 0 0 0 .118L15.94 27.976a.084.084 0 0 0 .118 0L27.976 16.06a.084.084 0 0 0 0-.118L16.06 4.024a.084.084 0 0 0-.06-.025z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
