(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.VisualRecognition32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'VisualRecognition32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('circle', { attrs: { cx: '23', cy: '12', r: '2' } }),
        createElement('path', {
          attrs: {
            d:
              'M28 5H16.24A8 8 0 1 0 6 16.92V27a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zM4 10a6 6 0 0 1 11.19-3H8v2h7.91a6.64 6.64 0 0 1 .09 1 6.64 6.64 0 0 1-.09 1H10v2h5.19A6 6 0 0 1 4 10zm24 17H8l5-5 1.59 1.59a2 2 0 0 0 2.82 0L23 18l5 5zm0-6.83l-3.59-3.59a2 2 0 0 0-2.82 0L16 22.17l-1.59-1.59a2 2 0 0 0-2.82 0L8 24.17v-6.43a8.24 8.24 0 0 0 2 .26 8 8 0 0 0 8-8 7.9 7.9 0 0 0-.59-3H28z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
