(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonMachineLearning24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'WatsonMachineLearning24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M22 26h-2v-8.24l-3.23 3.88a1 1 0 0 1-1.54 0L12 17.76V26h-2V15a1 1 0 0 1 .66-.94 1 1 0 0 1 1.11.3L16 19.44l4.23-5.08a1 1 0 0 1 1.11-.3A1 1 0 0 1 22 15zM4.16 14.65l-3-1.75a.76.76 0 1 0-.76 1.32l3 1.78a.76.76 0 1 0 .76-1.31zm4.13-4.13a.73.73 0 0 0 1 .27.75.75 0 0 0 .28-1l-1.74-3a.76.76 0 1 0-1.32.76zM16 9a.76.76 0 0 0 .76-.76V4.76a.76.76 0 1 0-1.52 0v3.49A.76.76 0 0 0 16 9zm6.68 1.79a.75.75 0 0 0 .37.11.76.76 0 0 0 .66-.38l1.75-3a.76.76 0 0 0-1.32-.76l-1.74 3a.75.75 0 0 0 .28 1.03zm9.22 2.39a.76.76 0 0 0-1-.28l-3 1.75a.76.76 0 0 0 .7 1.35l3-1.74a.77.77 0 0 0 .3-1.08z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
