(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealth3DSoftware16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'WatsonHealth3DSoftware16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M21.49 13.115l-9-5a1 1 0 0 0-1 0l-9 5A1.008 1.008 0 0 0 2 14v9.995a1 1 0 0 0 .52.87l9 5A1.004 1.004 0 0 0 12 30a1.056 1.056 0 0 0 .49-.135l9-5A.992.992 0 0 0 22 24V14a1.008 1.008 0 0 0-.51-.885zM11 27.295l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.135l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6h-4V2h-2v4h-4v2h4v4h2V8h4V6z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
