(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthCdCreateArchive24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'WatsonHealthCdCreateArchive24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M14 20a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z',
          },
        }),
        createElement('circle', { attrs: { cx: '14', cy: '14', r: '2' } }),
        createElement('path', {
          attrs: {
            d:
              'M17 23.54A10 10 0 1 1 24 14c0 .34 0 .67-.05 1h2c0-.33.05-.66.05-1a12 12 0 1 0-12 12 12.33 12.33 0 0 0 3-.39z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M25 30l-2.14-1A5 5 0 0 1 20 24.47V18h10v6.47A5 5 0 0 1 27.14 29zm-3-10v4.47a3 3 0 0 0 1.72 2.71l1.28.61 1.28-.61A3 3 0 0 0 28 24.47V20z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
