(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthCdCreateExchange32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'WatsonHealthCdCreateExchange32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('circle', { attrs: { cx: '14', cy: '14', r: '2' } }),
        createElement('path', {
          attrs: {
            d:
              'M14 2a12 12 0 0 0 0 24v-2a10 10 0 1 1 10-10 8.27 8.27 0 0 1 0 1h2c0-.33.05-.66.05-1A12 12 0 0 0 14 2z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M17 24h9.17l-2.59 2.59L25 28l5-5-5-5-1.42 1.42L26.17 22H17v2zm-3-4a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
