(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthICa_3D16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'WatsonHealthICa_3D16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M15 14h-5a2 2 0 0 1-2-2V4a2 2 0 0 1 .59-1.42A3.57 3.57 0 0 1 10 2h5v2h-5v8h5zM4 6h2v8H4zm0-4h2v2H4zm23.45 17.11l-6-3a1 1 0 0 0-.9 0l-6 3A1 1 0 0 0 14 20v7a1 1 0 0 0 .55.89l6 3a1 1 0 0 0 .9 0l6-3A1 1 0 0 0 28 27v-7a1 1 0 0 0-.55-.89zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76v-4.75l4-2v4.76zM23 2h-4a2 2 0 0 0-2 2v10h2v-4h4v4h2V4a2 2 0 0 0-2-2zm-4 6V4h4v4z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
