(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthMammogram32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'WatsonHealthMammogram32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M25 32h7v-7h-2v5h-5v2zm0-5h-3V17h3a3.003 3.003 0 0 1 3 3v4a3.003 3.003 0 0 1-3 3zm-1-2h1a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-1zm-4 2h-6v-4a2.002 2.002 0 0 1 2-2h2v-2h-4v-2h4a2.002 2.002 0 0 1 2 2v2a2.002 2.002 0 0 1-2 2h-2v2h4zm5-12h-3V5h3a3.003 3.003 0 0 1 3 3v4a3.003 3.003 0 0 1-3 3zm-1-2h1a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1h-1zm-6-8h-4v2h4v2h-3v2h3v2h-4v2h4a2.003 2.003 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zm-8 22H8v-3.046c-4.715-.442-6-4.01-6-5.954 0-3.015 2.082-4.502 3.919-5.814C7.572 11.006 9 9.986 9 8V5h2v3c0 3.015-2.082 4.502-3.919 5.814C5.428 14.994 4 16.014 4 18c.005.403.191 4 5 4a1 1 0 0 1 1 1zM7 0H0v7h2V2h5V0z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
