(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthPetImageO20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'WatsonHealthPetImageO20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M11 29h2v3h-2zm0-21h2v3h-2zM0 19h3v2H0zm21 0h3v2h-3zM2.82 12.233l1.4-1.4 2.122 2.121-1.4 1.4zm14.855 14.833l1.4-1.4 2.121 2.122-1.4 1.4zm-14.844.724l2.121-2.12 1.4 1.4-2.12 2.12zm14.833-14.853l2.121-2.121 1.4 1.4-2.121 2.121zM12 13a7 7 0 1 0 7 7 7 7 0 0 0-7-7zm0 12a5 5 0 0 1 0-10zM2 2h7V0H0v9h2V2zm28-2h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm-4 12V2h4v10z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
