(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthRegistration24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'WatsonHealthRegistration24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M28 25h-8a2.003 2.003 0 0 1-2-2v-3h2v3h8V9h-8v3h-2V9a2.002 2.002 0 0 1 2-2h8a2.002 2.002 0 0 1 2 2v14a2.003 2.003 0 0 1-2 2zM8 15h4v2H8z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M20 15h4v2h-4zm-6 0h4v2h-4zm-2 10H4a2.002 2.002 0 0 1-2-2V9a2.002 2.002 0 0 1 2-2h8a2.002 2.002 0 0 1 2 2v3h-2V9H4v14h8v-3h2v3a2.002 2.002 0 0 1-2 2z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
