(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthWindowAuto32 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _32 = {
    name: 'WatsonHealthWindowAuto32',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '32',
        height: '32',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M15 4h2v3h-2zm10 11h3v2h-3zM15 25h2v3h-2zM4 15h3v2H4zm2.777-6.811L8.19 6.775l2.121 2.12-1.414 1.415zm14.91.711l2.121-2.12 1.414 1.414-2.12 2.121zm-.001 14.197l1.414-1.415 2.121 2.122-1.414 1.414zM6.78 23.8l2.12-2.122 1.414 1.414-2.121 2.122zM4 30h24v2H4zM4 0h24v2H4zm12 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6zm-4 6a4 4 0 0 1 4-4v8a4 4 0 0 1-4-4z',
          },
        }),
        children,
      ]);
    },
  };

  return _32;

})));
