(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthWindowBase16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'WatsonHealthWindowBase16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M15 2h2v3h-2zm10 11h3v2h-3zM15 23h2v3h-2zM4 13h3v2H4zm2.775-6.812L8.19 4.773l2.122 2.122-1.414 1.414zm14.921.712l2.12-2.122 1.415 1.415-2.121 2.12zm-.005 14.188l1.415-1.414 2.12 2.122-1.413 1.414zm-14.913.725L8.9 19.69l1.414 1.414-2.121 2.122zM4 28h24v2H4zm12-8a6 6 0 1 0-6-6 6 6 0 0 0 6 6zm0-10v8a4 4 0 0 1 0-8z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
