(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WatsonHealthZoomPan16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'WatsonHealthZoomPan16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M27.01 12l-1.41 1.41L28.18 16l-2.59 2.59L27.01 20l4-4-4-4zm-20.6 1.42L5 12l-4 4 4 4 1.42-1.41L3.83 16l2.58-2.58zM16 28.17l-2.59-2.59L12 27l4 4 4-4-1.41-1.41L16 28.17zm0-24.34l2.58 2.58L20 5l-4-4-4 4 1.41 1.42L16 3.83zM22 16a6 6 0 1 0-2.53 4.89l3.82 3.82 1.42-1.42-3.82-3.82A6 6 0 0 0 22 16zm-6 4a4 4 0 1 1 4-4 4 4 0 0 1-4 4z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
