(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Watson24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'Watson24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M21.74 9.49A11.41 11.41 0 0 0 16 8a.76.76 0 1 0 0 1.51 10.15 10.15 0 0 1 1.91.21c-2.26 1.08-4.76 3.58-6.73 7a22.48 22.48 0 0 0-2 4.44A9.58 9.58 0 0 1 7 17.22a3.43 3.43 0 0 1 .28-2.66c.79-1.37 2.44-2.15 4.63-2.2a.76.76 0 0 0 .74-.78.75.75 0 0 0-.78-.74c-2.68.04-4.77 1.08-5.87 2.9a4.84 4.84 0 0 0-.44 3.79 12 12 0 0 0 3.2 5.22A11.36 11.36 0 0 0 8.52 26a10 10 0 0 1-2-3.48.75.75 0 0 0-.95-.52.76.76 0 0 0-.49 1 11.45 11.45 0 0 0 5.18 6.38A11.42 11.42 0 0 0 16 30.92a11.74 11.74 0 0 0 3-.39 11.48 11.48 0 0 0 2.77-21zm-3.16 19.57a9.9 9.9 0 0 1-7.56-1c-.86-.49-1.21-2-.94-4a18.85 18.85 0 0 0 2.48 1.72 13.92 13.92 0 0 0 6.93 2 11 11 0 0 0 2.42-.28 9.78 9.78 0 0 1-3.33 1.56zm6.06-4.66c-2 2-6.66 2.74-11.32.05a17.36 17.36 0 0 1-2.89-2.12 21.08 21.08 0 0 1 2.08-4.91c2.94-5.08 6.83-7.57 8.47-6.62a10 10 0 0 1 3.66 13.6zM4.16 11.72L1.14 10a.76.76 0 1 0-.76 1.31L3.4 13a.86.86 0 0 0 .38.1.77.77 0 0 0 .66-.38.76.76 0 0 0-.28-1zm4.13-4.13a.74.74 0 0 0 .65.41.75.75 0 0 0 .38-.1.76.76 0 0 0 .28-1l-1.74-3a.76.76 0 0 0-1-.27.75.75 0 0 0-.28 1zM16 6.08a.76.76 0 0 0 .76-.76V1.83a.76.76 0 0 0-1.52 0v3.49a.76.76 0 0 0 .76.76zm6.68 1.79a.75.75 0 0 0 1-.28l1.75-3a.75.75 0 0 0-.28-1 .76.76 0 0 0-1 .27l-1.74 3a.76.76 0 0 0 .27 1.01zm9.22 2.38a.76.76 0 0 0-1-.27l-3 1.74a.76.76 0 0 0-.28 1 .77.77 0 0 0 .66.38.86.86 0 0 0 .38-.1l3-1.75a.76.76 0 0 0 .24-1z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
