(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.WirelessCheckout24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'WirelessCheckout24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: { d: 'M18 28v-2a10 10 0 0 0 10-10h2a12 12 0 0 1-12 12z' },
        }),
        createElement('path', {
          attrs: { d: 'M18 23v-2a5 5 0 0 0 5-5h2a7 7 0 0 1-7 7z' },
        }),
        createElement('path', {
          attrs: {
            d:
              'M27 11h-6V7a3 3 0 0 0-3-3h-6a3 3 0 0 0-3 3v4H3a1 1 0 0 0-1 1.15L3.88 24.3a2 2 0 0 0 2 1.7H15v-2H5.86L4.17 13H27zM11 7a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v4h-8z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
