(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@carbon/icon-helpers'), require('vue')) :
  typeof define === 'function' && define.amd ? define(['exports', '@carbon/icon-helpers', 'vue'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CarbonIconsVue = {}, global.CarbonIconHelpers, global.Vue));
})(this, (function (exports, iconHelpers, Vue) { 'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var Vue__namespace = /*#__PURE__*/_interopNamespace(Vue);

  /**
   * Copyright IBM Corp. 2018, 2023
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  // Note: we dynamically access keys on the Vue namespace so that rollup does not
  // automatically rewrite the binding into `import { h } from 'vue'` as this is
  // currently causing issues in Vue 2 environments
  function getVueExport(key) {
    return Vue__namespace[key];
  }
  const h = getVueExport('h');
  const createApp = getVueExport('createApp');
  const getSvgAttrs = (title, svgAttrs, componentAttrs) => {
    return iconHelpers.getAttributes({
      ...svgAttrs,
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title,
      ...componentAttrs
    });
  };
  const getVue2SvgAttrs = (title, svgAttrs, data, listeners) => {
    const result = {
      attrs: getSvgAttrs(title, svgAttrs, data.attrs),
      on: listeners,
      style: {
        ...data.staticStyle,
        ...data.style
      }
    };

    // remove style set by getAttributes
    delete result.attrs.style;
    if (data.staticClass || data.class) {
      result.class = {};
      if (data.staticClass) {
        result.class[data.staticClass] = true;
      }
      if (data.class) {
        result.class[data.class] = true;
      }
    }
    return result;
  };
  const createSVGComponent = (name, svgAttrs, svgContent) => ({
    // We use title as a prop name for the component
    // as it is not a valid attribute for an SVG HTML element
    props: {
      title: String
    },
    name: name,
    ...(createApp ? {
      // Vue 3 component
      setup(_ref, _ref2) {
        let {
          title
        } = _ref;
        let {
          attrs: componentAttrs,
          slots
        } = _ref2;
        return () => h('svg', getSvgAttrs(title, svgAttrs, componentAttrs), [...(title ? [h('title', title)] : []), ...svgContent.map(_ref3 => {
          let {
            elem,
            attrs
          } = _ref3;
          return h(elem, attrs);
        }), ...(slots.default ? slots.default() : [])]);
      }
    } : {
      // Vue 2 component
      functional: true,
      render(createElement, _ref4) {
        let {
          props: {
            title
          },
          children,
          data,
          listeners
        } = _ref4;
        return createElement('svg', getVue2SvgAttrs(title, svgAttrs, data, listeners), [...(title ? [createElement('title', null, title)] : []), ...svgContent.map(_ref5 => {
          let {
            elem,
            attrs
          } = _ref5;
          return createElement(elem, {
            attrs: attrs
          });
        }), ...(children || [])]);
      }
    })
  });

  const WatsonHealth3DCursor32 = createSVGComponent('WatsonHealth3DCursor32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
    }
  }]);

  const WatsonHealth3DCursor24 = createSVGComponent('WatsonHealth3DCursor24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
    }
  }]);

  const WatsonHealth3DCursor20 = createSVGComponent('WatsonHealth3DCursor20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
    }
  }]);

  const WatsonHealth3DCursor16 = createSVGComponent('WatsonHealth3DCursor16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
    }
  }]);

  const WatsonHealth3DCursorAlt32 = createSVGComponent('WatsonHealth3DCursorAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
    }
  }]);

  const WatsonHealth3DCursorAlt24 = createSVGComponent('WatsonHealth3DCursorAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
    }
  }]);

  const WatsonHealth3DCursorAlt20 = createSVGComponent('WatsonHealth3DCursorAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
    }
  }]);

  const WatsonHealth3DCursorAlt16 = createSVGComponent('WatsonHealth3DCursorAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
    }
  }]);

  const WatsonHealth3DCurveAutoColon32 = createSVGComponent('WatsonHealth3DCurveAutoColon32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoColon24 = createSVGComponent('WatsonHealth3DCurveAutoColon24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoColon20 = createSVGComponent('WatsonHealth3DCurveAutoColon20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoColon16 = createSVGComponent('WatsonHealth3DCurveAutoColon16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoVessels32 = createSVGComponent('WatsonHealth3DCurveAutoVessels32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoVessels24 = createSVGComponent('WatsonHealth3DCurveAutoVessels24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoVessels20 = createSVGComponent('WatsonHealth3DCurveAutoVessels20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveAutoVessels16 = createSVGComponent('WatsonHealth3DCurveAutoVessels16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
    }
  }]);

  const WatsonHealth3DCurveManual32 = createSVGComponent('WatsonHealth3DCurveManual32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
    }
  }]);

  const WatsonHealth3DCurveManual24 = createSVGComponent('WatsonHealth3DCurveManual24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
    }
  }]);

  const WatsonHealth3DCurveManual20 = createSVGComponent('WatsonHealth3DCurveManual20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
    }
  }]);

  const WatsonHealth3DCurveManual16 = createSVGComponent('WatsonHealth3DCurveManual16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
    }
  }]);

  const WatsonHealth3DICa32 = createSVGComponent('WatsonHealth3DICa32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
    }
  }]);

  const WatsonHealth3DICa24 = createSVGComponent('WatsonHealth3DICa24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
    }
  }]);

  const WatsonHealth3DICa20 = createSVGComponent('WatsonHealth3DICa20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
    }
  }]);

  const WatsonHealth3DICa16 = createSVGComponent('WatsonHealth3DICa16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
    }
  }]);

  const WatsonHealth3DMprToggle32 = createSVGComponent('WatsonHealth3DMprToggle32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
    }
  }]);

  const WatsonHealth3DMprToggle24 = createSVGComponent('WatsonHealth3DMprToggle24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
    }
  }]);

  const WatsonHealth3DMprToggle20 = createSVGComponent('WatsonHealth3DMprToggle20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
    }
  }]);

  const WatsonHealth3DMprToggle16 = createSVGComponent('WatsonHealth3DMprToggle16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
    }
  }]);

  const WatsonHealth3DPrintMesh32 = createSVGComponent('WatsonHealth3DPrintMesh32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
    }
  }]);

  const WatsonHealth3DPrintMesh24 = createSVGComponent('WatsonHealth3DPrintMesh24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
    }
  }]);

  const WatsonHealth3DPrintMesh20 = createSVGComponent('WatsonHealth3DPrintMesh20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
    }
  }]);

  const WatsonHealth3DPrintMesh16 = createSVGComponent('WatsonHealth3DPrintMesh16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
    }
  }]);

  const WatsonHealth3DSoftware32 = createSVGComponent('WatsonHealth3DSoftware32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
    }
  }]);

  const WatsonHealth3DSoftware24 = createSVGComponent('WatsonHealth3DSoftware24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
    }
  }]);

  const WatsonHealth3DSoftware20 = createSVGComponent('WatsonHealth3DSoftware20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
    }
  }]);

  const WatsonHealth3DSoftware16 = createSVGComponent('WatsonHealth3DSoftware16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
    }
  }]);

  const WatsonHealth3rdPartyConnected32 = createSVGComponent('WatsonHealth3rdPartyConnected32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
    }
  }]);

  const WatsonHealth3rdPartyConnected24 = createSVGComponent('WatsonHealth3rdPartyConnected24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
    }
  }]);

  const WatsonHealth3rdPartyConnected20 = createSVGComponent('WatsonHealth3rdPartyConnected20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
    }
  }]);

  const WatsonHealth3rdPartyConnected16 = createSVGComponent('WatsonHealth3rdPartyConnected16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
    }
  }]);

  const _4K32 = createSVGComponent('_4K32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
    }
  }]);

  const _4K24 = createSVGComponent('_4K24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
    }
  }]);

  const _4K20 = createSVGComponent('_4K20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
    }
  }]);

  const _4K16 = createSVGComponent('_4K16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
    }
  }]);

  const _4KFilled32 = createSVGComponent('_4KFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
    }
  }]);

  const _4KFilled24 = createSVGComponent('_4KFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
    }
  }]);

  const _4KFilled20 = createSVGComponent('_4KFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
    }
  }]);

  const _4KFilled16 = createSVGComponent('_4KFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
    }
  }]);

  const Accessibility32 = createSVGComponent('Accessibility32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
    }
  }]);

  const Accessibility24 = createSVGComponent('Accessibility24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
    }
  }]);

  const Accessibility20 = createSVGComponent('Accessibility20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
    }
  }]);

  const Accessibility16 = createSVGComponent('Accessibility16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
    }
  }]);

  const AccessibilityAlt32 = createSVGComponent('AccessibilityAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "9",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityAlt24 = createSVGComponent('AccessibilityAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "9",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityAlt20 = createSVGComponent('AccessibilityAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "9",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityAlt16 = createSVGComponent('AccessibilityAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "9",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityColor32 = createSVGComponent('AccessibilityColor32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityColor24 = createSVGComponent('AccessibilityColor24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityColor20 = createSVGComponent('AccessibilityColor20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityColor16 = createSVGComponent('AccessibilityColor16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AccessibilityColorFilled32 = createSVGComponent('AccessibilityColorFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }]);

  const AccessibilityColorFilled24 = createSVGComponent('AccessibilityColorFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }]);

  const AccessibilityColorFilled20 = createSVGComponent('AccessibilityColorFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }]);

  const AccessibilityColorFilled16 = createSVGComponent('AccessibilityColorFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
    }
  }]);

  const Account32 = createSVGComponent('Account32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,14H19v2H8Zm0,5H21v2H8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
    }
  }]);

  const Account24 = createSVGComponent('Account24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,14H19v2H8Zm0,5H21v2H8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
    }
  }]);

  const Account20 = createSVGComponent('Account20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,14H19v2H8Zm0,5H21v2H8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
    }
  }]);

  const Account16 = createSVGComponent('Account16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,14H19v2H8Zm0,5H21v2H8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
    }
  }]);

  const AccumulationIce32 = createSVGComponent('AccumulationIce32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 8L22 16 23 18 24 16 24 8 22 8zM18 8L18 18 19 20 20 18 20 8 18 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h8v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationIce24 = createSVGComponent('AccumulationIce24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 8L22 16 23 18 24 16 24 8 22 8zM18 8L18 18 19 20 20 18 20 8 18 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h8v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationIce20 = createSVGComponent('AccumulationIce20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 8L22 16 23 18 24 16 24 8 22 8zM18 8L18 18 19 20 20 18 20 8 18 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h8v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationIce16 = createSVGComponent('AccumulationIce16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 8L22 16 23 18 24 16 24 8 22 8zM18 8L18 18 19 20 20 18 20 8 18 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h8v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationPrecipitation32 = createSVGComponent('AccumulationPrecipitation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 16H18V18H16zM18 18H20V20H18zM20 20H22V22H20zM20 16H22V18H20zM16 20H18V22H16zM20 12a3.8978 3.8978 0 01-4-3.777 3.9017 3.9017 0 01.6533-2.0639L19.17 2.4141a1.0381 1.0381 0 011.6592 0L23.3154 6.11A3.9693 3.9693 0 0124 8.223 3.8978 3.8978 0 0120 12zm0-7.2368L18.3438 7.2257A1.89 1.89 0 0018 8.223 1.9 1.9 0 0020 10a1.9 1.9 0 002-1.777 1.98 1.98 0 00-.375-1.0466z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V10H8v8l1,2,1-2V10h2v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationPrecipitation24 = createSVGComponent('AccumulationPrecipitation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 16H18V18H16zM18 18H20V20H18zM20 20H22V22H20zM20 16H22V18H20zM16 20H18V22H16zM20 12a3.8978 3.8978 0 01-4-3.777 3.9017 3.9017 0 01.6533-2.0639L19.17 2.4141a1.0381 1.0381 0 011.6592 0L23.3154 6.11A3.9693 3.9693 0 0124 8.223 3.8978 3.8978 0 0120 12zm0-7.2368L18.3438 7.2257A1.89 1.89 0 0018 8.223 1.9 1.9 0 0020 10a1.9 1.9 0 002-1.777 1.98 1.98 0 00-.375-1.0466z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V10H8v8l1,2,1-2V10h2v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationPrecipitation20 = createSVGComponent('AccumulationPrecipitation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 16H18V18H16zM18 18H20V20H18zM20 20H22V22H20zM20 16H22V18H20zM16 20H18V22H16zM20 12a3.8978 3.8978 0 01-4-3.777 3.9017 3.9017 0 01.6533-2.0639L19.17 2.4141a1.0381 1.0381 0 011.6592 0L23.3154 6.11A3.9693 3.9693 0 0124 8.223 3.8978 3.8978 0 0120 12zm0-7.2368L18.3438 7.2257A1.89 1.89 0 0018 8.223 1.9 1.9 0 0020 10a1.9 1.9 0 002-1.777 1.98 1.98 0 00-.375-1.0466z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V10H8v8l1,2,1-2V10h2v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationPrecipitation16 = createSVGComponent('AccumulationPrecipitation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 16H18V18H16zM18 18H20V20H18zM20 20H22V22H20zM20 16H22V18H20zM16 20H18V22H16zM20 12a3.8978 3.8978 0 01-4-3.777 3.9017 3.9017 0 01.6533-2.0639L19.17 2.4141a1.0381 1.0381 0 011.6592 0L23.3154 6.11A3.9693 3.9693 0 0124 8.223 3.8978 3.8978 0 0120 12zm0-7.2368L18.3438 7.2257A1.89 1.89 0 0018 8.223 1.9 1.9 0 0020 10a1.9 1.9 0 002-1.777 1.98 1.98 0 00-.375-1.0466z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V10H8v8l1,2,1-2V10h2v4l1,2,1-2V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationRain32 = createSVGComponent('AccumulationRain32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V8H24a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,20,5a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,16,8a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,12,5a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,8,8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4ZM6,26V22h4V20H6V16h4V14H6V10H8a4.9316,4.9316,0,0,0,4-1.9873,5.0192,5.0192,0,0,0,8,0A4.9316,4.9316,0,0,0,24,10h2V26Z"
    }
  }]);

  const AccumulationRain24 = createSVGComponent('AccumulationRain24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V8H24a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,20,5a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,16,8a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,12,5a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,8,8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4ZM6,26V22h4V20H6V16h4V14H6V10H8a4.9316,4.9316,0,0,0,4-1.9873,5.0192,5.0192,0,0,0,8,0A4.9316,4.9316,0,0,0,24,10h2V26Z"
    }
  }]);

  const AccumulationRain20 = createSVGComponent('AccumulationRain20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V8H24a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,20,5a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,16,8a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,12,5a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,8,8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4ZM6,26V22h4V20H6V16h4V14H6V10H8a4.9316,4.9316,0,0,0,4-1.9873,5.0192,5.0192,0,0,0,8,0A4.9316,4.9316,0,0,0,24,10h2V26Z"
    }
  }]);

  const AccumulationRain16 = createSVGComponent('AccumulationRain16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V8H24a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,20,5a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,16,8a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,12,5a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,8,8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4ZM6,26V22h4V20H6V16h4V14H6V10H8a4.9316,4.9316,0,0,0,4-1.9873,5.0192,5.0192,0,0,0,8,0A4.9316,4.9316,0,0,0,24,10h2V26Z"
    }
  }]);

  const AccumulationSnow32 = createSVGComponent('AccumulationSnow32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 2H14V4H12zM14 4H16V6H14zM16 6H18V8H16zM16 2H18V4H16zM12 6H14V8H12zM14 18H16V20H14zM16 20H18V22H16zM18 22H20V24H18zM18 18H20V20H18zM14 22H16V24H14zM18 10H20V12H18zM20 12H22V14H20zM22 14H24V16H22zM22 10H24V12H22zM18 14H20V16H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h4V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationSnow24 = createSVGComponent('AccumulationSnow24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 2H14V4H12zM14 4H16V6H14zM16 6H18V8H16zM16 2H18V4H16zM12 6H14V8H12zM14 18H16V20H14zM16 20H18V22H16zM18 22H20V24H18zM18 18H20V20H18zM14 22H16V24H14zM18 10H20V12H18zM20 12H22V14H20zM22 14H24V16H22zM22 10H24V12H22zM18 14H20V16H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h4V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationSnow20 = createSVGComponent('AccumulationSnow20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 2H14V4H12zM14 4H16V6H14zM16 6H18V8H16zM16 2H18V4H16zM12 6H14V8H12zM14 18H16V20H14zM16 20H18V22H16zM18 22H20V24H18zM18 18H20V20H18zM14 22H16V24H14zM18 10H20V12H18zM20 12H22V14H20zM22 14H24V16H22zM22 10H24V12H22zM18 14H20V16H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h4V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const AccumulationSnow16 = createSVGComponent('AccumulationSnow16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 2H14V4H12zM14 4H16V6H14zM16 6H18V8H16zM16 2H18V4H16zM12 6H14V8H12zM14 18H16V20H14zM16 20H18V22H16zM18 22H20V24H18zM18 18H20V20H18zM14 22H16V24H14zM18 10H20V12H18zM20 12H22V14H20zM22 14H24V16H22zM22 10H24V12H22zM18 14H20V16H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4a2.0023,2.0023,0,0,0-2,2V26H6V22h4V20H6V16h4V14H6V10h4V8H6V6A2.0023,2.0023,0,0,0,4,4H2V6H4V26a2.0023,2.0023,0,0,0,2,2H26a2.0023,2.0023,0,0,0,2-2V6h2V4Z"
    }
  }]);

  const Activity32 = createSVGComponent('Activity32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
    }
  }]);

  const Activity24 = createSVGComponent('Activity24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
    }
  }]);

  const Activity20 = createSVGComponent('Activity20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
    }
  }]);

  const Activity16 = createSVGComponent('Activity16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
    }
  }]);

  const Add32 = createSVGComponent('Add32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
    }
  }]);

  const Add24 = createSVGComponent('Add24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
    }
  }]);

  const Add20 = createSVGComponent('Add20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
    }
  }]);

  const Add16 = createSVGComponent('Add16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
    }
  }]);

  const AddAlt32 = createSVGComponent('AddAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
    }
  }]);

  const AddAlt24 = createSVGComponent('AddAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
    }
  }]);

  const AddAlt20 = createSVGComponent('AddAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
    }
  }]);

  const AddAlt16 = createSVGComponent('AddAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
    }
  }]);

  const AddFilled32 = createSVGComponent('AddFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14.1725,14.1725,0,0,0,2,16,14.1725,14.1725,0,0,0,16,30,14.1725,14.1725,0,0,0,30,16,14.1725,14.1725,0,0,0,16,2Zm8,15H17v7H15V17H8V15h7V8h2v7h7Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15 24 17z",
      "data-icon-path": "inner-path"
    }
  }]);

  const AddFilled24 = createSVGComponent('AddFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14.1725,14.1725,0,0,0,2,16,14.1725,14.1725,0,0,0,16,30,14.1725,14.1725,0,0,0,30,16,14.1725,14.1725,0,0,0,16,2Zm8,15H17v7H15V17H8V15h7V8h2v7h7Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15 24 17z",
      "data-icon-path": "inner-path"
    }
  }]);

  const AddFilled20 = createSVGComponent('AddFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14.1725,14.1725,0,0,0,2,16,14.1725,14.1725,0,0,0,16,30,14.1725,14.1725,0,0,0,30,16,14.1725,14.1725,0,0,0,16,2Zm8,15H17v7H15V17H8V15h7V8h2v7h7Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15 24 17z",
      "data-icon-path": "inner-path"
    }
  }]);

  const AddFilled16 = createSVGComponent('AddFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14.1725,14.1725,0,0,0,2,16,14.1725,14.1725,0,0,0,16,30,14.1725,14.1725,0,0,0,30,16,14.1725,14.1725,0,0,0,16,2Zm8,15H17v7H15V17H8V15h7V8h2v7h7Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15 24 17z",
      "data-icon-path": "inner-path"
    }
  }]);

  const AddLarge32 = createSVGComponent('AddLarge32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 5 15 5 15 15 5 15 5 17 15 17 15 27 17 27 17 17 27 17 27 15 17 15z"
    }
  }]);

  const AddLarge24 = createSVGComponent('AddLarge24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 5 15 5 15 15 5 15 5 17 15 17 15 27 17 27 17 17 27 17 27 15 17 15z"
    }
  }]);

  const AddLarge20 = createSVGComponent('AddLarge20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 5 15 5 15 15 5 15 5 17 15 17 15 27 17 27 17 17 27 17 27 15 17 15z"
    }
  }]);

  const AddLarge16 = createSVGComponent('AddLarge16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 15L17 5 15 5 15 15 5 15 5 17 15 17 15 27 17 27 17 17 27 17 27 15 17 15z"
    }
  }]);

  const AddComment32 = createSVGComponent('AddComment32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
    }
  }]);

  const AddComment24 = createSVGComponent('AddComment24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
    }
  }]);

  const AddComment20 = createSVGComponent('AddComment20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
    }
  }]);

  const AddComment16 = createSVGComponent('AddComment16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
    }
  }]);

  const AgricultureAnalytics32 = createSVGComponent('AgricultureAnalytics32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.251 21.3691l2.1943 1.4629A1 1 0 0027.8 22.6l3-4-1.6-1.2-2.4326 3.2437L24.5547 19.168a1 1 0 00-1.3687.2509L20 23.8789V16H18V26a2.0023 2.0023 0 002 2H30V26H20.9434zM2 21H16V23H2zM2 26H16V28H2zM11 16V11h1a4.0046 4.0046 0 004-4V4H13a3.9782 3.9782 0 00-2.7468 1.1066A6.0033 6.0033 0 005 2H2V5a6.0066 6.0066 0 006 6H9v5H2v2H16V16zM13 6h1V7a2.002 2.002 0 01-2 2H11V8A2.0019 2.0019 0 0113 6zM8 9A4.0046 4.0046 0 014 5V4H5A4.0045 4.0045 0 019 8V9z"
    }
  }]);

  const AgricultureAnalytics24 = createSVGComponent('AgricultureAnalytics24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.251 21.3691l2.1943 1.4629A1 1 0 0027.8 22.6l3-4-1.6-1.2-2.4326 3.2437L24.5547 19.168a1 1 0 00-1.3687.2509L20 23.8789V16H18V26a2.0023 2.0023 0 002 2H30V26H20.9434zM2 21H16V23H2zM2 26H16V28H2zM11 16V11h1a4.0046 4.0046 0 004-4V4H13a3.9782 3.9782 0 00-2.7468 1.1066A6.0033 6.0033 0 005 2H2V5a6.0066 6.0066 0 006 6H9v5H2v2H16V16zM13 6h1V7a2.002 2.002 0 01-2 2H11V8A2.0019 2.0019 0 0113 6zM8 9A4.0046 4.0046 0 014 5V4H5A4.0045 4.0045 0 019 8V9z"
    }
  }]);

  const AgricultureAnalytics20 = createSVGComponent('AgricultureAnalytics20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.251 21.3691l2.1943 1.4629A1 1 0 0027.8 22.6l3-4-1.6-1.2-2.4326 3.2437L24.5547 19.168a1 1 0 00-1.3687.2509L20 23.8789V16H18V26a2.0023 2.0023 0 002 2H30V26H20.9434zM2 21H16V23H2zM2 26H16V28H2zM11 16V11h1a4.0046 4.0046 0 004-4V4H13a3.9782 3.9782 0 00-2.7468 1.1066A6.0033 6.0033 0 005 2H2V5a6.0066 6.0066 0 006 6H9v5H2v2H16V16zM13 6h1V7a2.002 2.002 0 01-2 2H11V8A2.0019 2.0019 0 0113 6zM8 9A4.0046 4.0046 0 014 5V4H5A4.0045 4.0045 0 019 8V9z"
    }
  }]);

  const AgricultureAnalytics16 = createSVGComponent('AgricultureAnalytics16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.251 21.3691l2.1943 1.4629A1 1 0 0027.8 22.6l3-4-1.6-1.2-2.4326 3.2437L24.5547 19.168a1 1 0 00-1.3687.2509L20 23.8789V16H18V26a2.0023 2.0023 0 002 2H30V26H20.9434zM2 21H16V23H2zM2 26H16V28H2zM11 16V11h1a4.0046 4.0046 0 004-4V4H13a3.9782 3.9782 0 00-2.7468 1.1066A6.0033 6.0033 0 005 2H2V5a6.0066 6.0066 0 006 6H9v5H2v2H16V16zM13 6h1V7a2.002 2.002 0 01-2 2H11V8A2.0019 2.0019 0 0113 6zM8 9A4.0046 4.0046 0 014 5V4H5A4.0045 4.0045 0 019 8V9z"
    }
  }]);

  const WatsonHealthAiResults32 = createSVGComponent('WatsonHealthAiResults32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
    }
  }]);

  const WatsonHealthAiResults24 = createSVGComponent('WatsonHealthAiResults24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
    }
  }]);

  const WatsonHealthAiResults20 = createSVGComponent('WatsonHealthAiResults20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
    }
  }]);

  const WatsonHealthAiResults16 = createSVGComponent('WatsonHealthAiResults16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
    }
  }]);

  const WatsonHealthAiResultsHigh32 = createSVGComponent('WatsonHealthAiResultsHigh32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
    }
  }]);

  const WatsonHealthAiResultsHigh24 = createSVGComponent('WatsonHealthAiResultsHigh24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
    }
  }]);

  const WatsonHealthAiResultsHigh20 = createSVGComponent('WatsonHealthAiResultsHigh20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
    }
  }]);

  const WatsonHealthAiResultsHigh16 = createSVGComponent('WatsonHealthAiResultsHigh16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
    }
  }]);

  const WatsonHealthAiResultsLow32 = createSVGComponent('WatsonHealthAiResultsLow32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsLow24 = createSVGComponent('WatsonHealthAiResultsLow24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsLow20 = createSVGComponent('WatsonHealthAiResultsLow20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsLow16 = createSVGComponent('WatsonHealthAiResultsLow16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsMedium32 = createSVGComponent('WatsonHealthAiResultsMedium32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsMedium24 = createSVGComponent('WatsonHealthAiResultsMedium24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsMedium20 = createSVGComponent('WatsonHealthAiResultsMedium20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsMedium16 = createSVGComponent('WatsonHealthAiResultsMedium16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsUrgent32 = createSVGComponent('WatsonHealthAiResultsUrgent32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsUrgent24 = createSVGComponent('WatsonHealthAiResultsUrgent24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsUrgent20 = createSVGComponent('WatsonHealthAiResultsUrgent20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsUrgent16 = createSVGComponent('WatsonHealthAiResultsUrgent16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
    }
  }]);

  const WatsonHealthAiResultsVeryHigh32 = createSVGComponent('WatsonHealthAiResultsVeryHigh32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
    }
  }]);

  const WatsonHealthAiResultsVeryHigh24 = createSVGComponent('WatsonHealthAiResultsVeryHigh24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
    }
  }]);

  const WatsonHealthAiResultsVeryHigh20 = createSVGComponent('WatsonHealthAiResultsVeryHigh20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
    }
  }]);

  const WatsonHealthAiResultsVeryHigh16 = createSVGComponent('WatsonHealthAiResultsVeryHigh16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
    }
  }]);

  const WatsonHealthAiStatus32 = createSVGComponent('WatsonHealthAiStatus32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
    }
  }]);

  const WatsonHealthAiStatus24 = createSVGComponent('WatsonHealthAiStatus24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
    }
  }]);

  const WatsonHealthAiStatus20 = createSVGComponent('WatsonHealthAiStatus20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
    }
  }]);

  const WatsonHealthAiStatus16 = createSVGComponent('WatsonHealthAiStatus16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
    }
  }]);

  const WatsonHealthAiStatusComplete32 = createSVGComponent('WatsonHealthAiStatusComplete32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
    }
  }]);

  const WatsonHealthAiStatusComplete24 = createSVGComponent('WatsonHealthAiStatusComplete24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
    }
  }]);

  const WatsonHealthAiStatusComplete20 = createSVGComponent('WatsonHealthAiStatusComplete20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
    }
  }]);

  const WatsonHealthAiStatusComplete16 = createSVGComponent('WatsonHealthAiStatusComplete16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
    }
  }]);

  const WatsonHealthAiStatusFailed32 = createSVGComponent('WatsonHealthAiStatusFailed32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
    }
  }]);

  const WatsonHealthAiStatusFailed24 = createSVGComponent('WatsonHealthAiStatusFailed24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
    }
  }]);

  const WatsonHealthAiStatusFailed20 = createSVGComponent('WatsonHealthAiStatusFailed20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
    }
  }]);

  const WatsonHealthAiStatusFailed16 = createSVGComponent('WatsonHealthAiStatusFailed16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
    }
  }]);

  const WatsonHealthAiStatusInProgress32 = createSVGComponent('WatsonHealthAiStatusInProgress32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }]);

  const WatsonHealthAiStatusInProgress24 = createSVGComponent('WatsonHealthAiStatusInProgress24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }]);

  const WatsonHealthAiStatusInProgress20 = createSVGComponent('WatsonHealthAiStatusInProgress20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }]);

  const WatsonHealthAiStatusInProgress16 = createSVGComponent('WatsonHealthAiStatusInProgress16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.5",
      "cy": "7.5",
      "r": "1.5"
    }
  }]);

  const WatsonHealthAiStatusQueued32 = createSVGComponent('WatsonHealthAiStatusQueued32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
    }
  }]);

  const WatsonHealthAiStatusQueued24 = createSVGComponent('WatsonHealthAiStatusQueued24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
    }
  }]);

  const WatsonHealthAiStatusQueued20 = createSVGComponent('WatsonHealthAiStatusQueued20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
    }
  }]);

  const WatsonHealthAiStatusQueued16 = createSVGComponent('WatsonHealthAiStatusQueued16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
    }
  }]);

  const WatsonHealthAiStatusRejected32 = createSVGComponent('WatsonHealthAiStatusRejected32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
    }
  }]);

  const WatsonHealthAiStatusRejected24 = createSVGComponent('WatsonHealthAiStatusRejected24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
    }
  }]);

  const WatsonHealthAiStatusRejected20 = createSVGComponent('WatsonHealthAiStatusRejected20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
    }
  }]);

  const WatsonHealthAiStatusRejected16 = createSVGComponent('WatsonHealthAiStatusRejected16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
    }
  }]);

  const AirlineDigitalGate32 = createSVGComponent('AirlineDigitalGate32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0058 5.0058 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM31.9658 11.7413a1.0007 1.0007 0 00-1.2246-.707l-3.0861.826L24 7l-1 .2676 1.4584 5.4483-2.7663.7405L20 11.2066l-1 .2676.9337 3.4883a.9993.9993 0 001.2246.707l10.1005-2.7036A1 1 0 0031.9658 11.7413z"
    }
  }]);

  const AirlineDigitalGate24 = createSVGComponent('AirlineDigitalGate24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0058 5.0058 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM31.9658 11.7413a1.0007 1.0007 0 00-1.2246-.707l-3.0861.826L24 7l-1 .2676 1.4584 5.4483-2.7663.7405L20 11.2066l-1 .2676.9337 3.4883a.9993.9993 0 001.2246.707l10.1005-2.7036A1 1 0 0031.9658 11.7413z"
    }
  }]);

  const AirlineDigitalGate20 = createSVGComponent('AirlineDigitalGate20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0058 5.0058 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM31.9658 11.7413a1.0007 1.0007 0 00-1.2246-.707l-3.0861.826L24 7l-1 .2676 1.4584 5.4483-2.7663.7405L20 11.2066l-1 .2676.9337 3.4883a.9993.9993 0 001.2246.707l10.1005-2.7036A1 1 0 0031.9658 11.7413z"
    }
  }]);

  const AirlineDigitalGate16 = createSVGComponent('AirlineDigitalGate16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0058 5.0058 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM31.9658 11.7413a1.0007 1.0007 0 00-1.2246-.707l-3.0861.826L24 7l-1 .2676 1.4584 5.4483-2.7663.7405L20 11.2066l-1 .2676.9337 3.4883a.9993.9993 0 001.2246.707l10.1005-2.7036A1 1 0 0031.9658 11.7413z"
    }
  }]);

  const AirlineManageGates32 = createSVGComponent('AirlineManageGates32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4z"
    }
  }]);

  const AirlineManageGates24 = createSVGComponent('AirlineManageGates24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4z"
    }
  }]);

  const AirlineManageGates20 = createSVGComponent('AirlineManageGates20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4z"
    }
  }]);

  const AirlineManageGates16 = createSVGComponent('AirlineManageGates16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4z"
    }
  }]);

  const AirlinePassengerCare32 = createSVGComponent('AirlinePassengerCare32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM27.303 8a2.6616 2.6616 0 00-1.9079.8058L25 9.2112l-.3951-.4054a2.6615 2.6615 0 00-3.8157 0 2.7992 2.7992 0 000 3.8964L25 17l4.2108-4.2978a2.7992 2.7992 0 000-3.8964A2.6616 2.6616 0 0027.303 8z"
    }
  }]);

  const AirlinePassengerCare24 = createSVGComponent('AirlinePassengerCare24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM27.303 8a2.6616 2.6616 0 00-1.9079.8058L25 9.2112l-.3951-.4054a2.6615 2.6615 0 00-3.8157 0 2.7992 2.7992 0 000 3.8964L25 17l4.2108-4.2978a2.7992 2.7992 0 000-3.8964A2.6616 2.6616 0 0027.303 8z"
    }
  }]);

  const AirlinePassengerCare20 = createSVGComponent('AirlinePassengerCare20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM27.303 8a2.6616 2.6616 0 00-1.9079.8058L25 9.2112l-.3951-.4054a2.6615 2.6615 0 00-3.8157 0 2.7992 2.7992 0 000 3.8964L25 17l4.2108-4.2978a2.7992 2.7992 0 000-3.8964A2.6616 2.6616 0 0027.303 8z"
    }
  }]);

  const AirlinePassengerCare16 = createSVGComponent('AirlinePassengerCare16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM27.303 8a2.6616 2.6616 0 00-1.9079.8058L25 9.2112l-.3951-.4054a2.6615 2.6615 0 00-3.8157 0 2.7992 2.7992 0 000 3.8964L25 17l4.2108-4.2978a2.7992 2.7992 0 000-3.8964A2.6616 2.6616 0 0027.303 8z"
    }
  }]);

  const AirlineRapidBoard32 = createSVGComponent('AirlineRapidBoard32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM30 8L28 8 28 6 26 6 26 4 30 4 30 8zM19 4L23 4 23 6 21 6 21 8 19 8 19 4zM28 13H30V15H28zM26 11H28V13H26zM19 11L21 11 21 13 23 13 23 15 19 15 19 11z"
    }
  }]);

  const AirlineRapidBoard24 = createSVGComponent('AirlineRapidBoard24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM30 8L28 8 28 6 26 6 26 4 30 4 30 8zM19 4L23 4 23 6 21 6 21 8 19 8 19 4zM28 13H30V15H28zM26 11H28V13H26zM19 11L21 11 21 13 23 13 23 15 19 15 19 11z"
    }
  }]);

  const AirlineRapidBoard20 = createSVGComponent('AirlineRapidBoard20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM30 8L28 8 28 6 26 6 26 4 30 4 30 8zM19 4L23 4 23 6 21 6 21 8 19 8 19 4zM28 13H30V15H28zM26 11H28V13H26zM19 11L21 11 21 13 23 13 23 15 19 15 19 11z"
    }
  }]);

  const AirlineRapidBoard16 = createSVGComponent('AirlineRapidBoard16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 23H16V21a3.0033 3.0033 0 00-3-3H9a3.0033 3.0033 0 00-3 3v2H4V21a5.0059 5.0059 0 015-5h4a5.0059 5.0059 0 015 5zM11 6A3 3 0 118 9a3 3 0 013-3m0-2a5 5 0 105 5A5 5 0 0011 4zM2 26H30V28H2zM30 8L28 8 28 6 26 6 26 4 30 4 30 8zM19 4L23 4 23 6 21 6 21 8 19 8 19 4zM28 13H30V15H28zM26 11H28V13H26zM19 11L21 11 21 13 23 13 23 15 19 15 19 11z"
    }
  }]);

  const Airplay32 = createSVGComponent('Airplay32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30ZM10.92,28H21.08L16,20.7439Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const Airplay24 = createSVGComponent('Airplay24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30ZM10.92,28H21.08L16,20.7439Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const Airplay20 = createSVGComponent('Airplay20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30ZM10.92,28H21.08L16,20.7439Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const Airplay16 = createSVGComponent('Airplay16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30ZM10.92,28H21.08L16,20.7439Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const AirplayFilled32 = createSVGComponent('AirplayFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const AirplayFilled24 = createSVGComponent('AirplayFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const AirplayFilled20 = createSVGComponent('AirplayFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const AirplayFilled16 = createSVGComponent('AirplayFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.9961,30H9.0039a1.0022,1.0022,0,0,1-.821-1.5769l6.9977-9.9965a1,1,0,0,1,1.6388,0l6.9977,9.9965A1.0022,1.0022,0,0,1,22.9961,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H24V22h4V6H4V22H8v2H4a2.0021,2.0021,0,0,1-2-2V6A2.0021,2.0021,0,0,1,4,4H28a2.0021,2.0021,0,0,1,2,2V22A2.0021,2.0021,0,0,1,28,24Z"
    }
  }]);

  const Airport_0132 = createSVGComponent('Airport_0132', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M17,14.5,23,17V15l-6-3V9a1,1,0,0,0-2,0v3L9,15v2l6-2.5V20l-3,2v1l4-1,4,1V22l-3-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0124 = createSVGComponent('Airport_0124', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M17,14.5,23,17V15l-6-3V9a1,1,0,0,0-2,0v3L9,15v2l6-2.5V20l-3,2v1l4-1,4,1V22l-3-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0120 = createSVGComponent('Airport_0120', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M17,14.5,23,17V15l-6-3V9a1,1,0,0,0-2,0v3L9,15v2l6-2.5V20l-3,2v1l4-1,4,1V22l-3-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0116 = createSVGComponent('Airport_0116', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M17,14.5,23,17V15l-6-3V9a1,1,0,0,0-2,0v3L9,15v2l6-2.5V20l-3,2v1l4-1,4,1V22l-3-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0232 = createSVGComponent('Airport_0232', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,17H19.4141L16,13H14l2.5859,4H10.7207L9.5,15H8l1.0569,3.3046A1,1,0,0,0,10.0094,19H23a1,1,0,0,0,0-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0224 = createSVGComponent('Airport_0224', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,17H19.4141L16,13H14l2.5859,4H10.7207L9.5,15H8l1.0569,3.3046A1,1,0,0,0,10.0094,19H23a1,1,0,0,0,0-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0220 = createSVGComponent('Airport_0220', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,17H19.4141L16,13H14l2.5859,4H10.7207L9.5,15H8l1.0569,3.3046A1,1,0,0,0,10.0094,19H23a1,1,0,0,0,0-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const Airport_0216 = createSVGComponent('Airport_0216', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,17H19.4141L16,13H14l2.5859,4H10.7207L9.5,15H8l1.0569,3.3046A1,1,0,0,0,10.0094,19H23a1,1,0,0,0,0-2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const AirportLocation32 = createSVGComponent('AirportLocation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15h-6.07A8.0076,8.0076,0,0,0,17,8.0693V2H15V8.0693A8.0076,8.0076,0,0,0,8.07,15H2v2H8.07A8.0076,8.0076,0,0,0,15,23.9307V30h2V23.9307A8.0076,8.0076,0,0,0,23.9305,17H30ZM16,22a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,16,22Z"
    }
  }]);

  const AirportLocation24 = createSVGComponent('AirportLocation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15h-6.07A8.0076,8.0076,0,0,0,17,8.0693V2H15V8.0693A8.0076,8.0076,0,0,0,8.07,15H2v2H8.07A8.0076,8.0076,0,0,0,15,23.9307V30h2V23.9307A8.0076,8.0076,0,0,0,23.9305,17H30ZM16,22a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,16,22Z"
    }
  }]);

  const AirportLocation20 = createSVGComponent('AirportLocation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15h-6.07A8.0076,8.0076,0,0,0,17,8.0693V2H15V8.0693A8.0076,8.0076,0,0,0,8.07,15H2v2H8.07A8.0076,8.0076,0,0,0,15,23.9307V30h2V23.9307A8.0076,8.0076,0,0,0,23.9305,17H30ZM16,22a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,16,22Z"
    }
  }]);

  const AirportLocation16 = createSVGComponent('AirportLocation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15h-6.07A8.0076,8.0076,0,0,0,17,8.0693V2H15V8.0693A8.0076,8.0076,0,0,0,8.07,15H2v2H8.07A8.0076,8.0076,0,0,0,15,23.9307V30h2V23.9307A8.0076,8.0076,0,0,0,23.9305,17H30ZM16,22a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,16,22Z"
    }
  }]);

  const Alarm32 = createSVGComponent('Alarm32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }]);

  const Alarm24 = createSVGComponent('Alarm24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }]);

  const Alarm20 = createSVGComponent('Alarm20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }]);

  const Alarm16 = createSVGComponent('Alarm16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }]);

  const AlarmAdd32 = createSVGComponent('AlarmAdd32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
    }
  }]);

  const AlarmAdd24 = createSVGComponent('AlarmAdd24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
    }
  }]);

  const AlarmAdd20 = createSVGComponent('AlarmAdd20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
    }
  }]);

  const AlarmAdd16 = createSVGComponent('AlarmAdd16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
    }
  }]);

  const AlarmSubtract32 = createSVGComponent('AlarmSubtract32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 16H21V18H11z"
    }
  }]);

  const AlarmSubtract24 = createSVGComponent('AlarmSubtract24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 16H21V18H11z"
    }
  }]);

  const AlarmSubtract20 = createSVGComponent('AlarmSubtract20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 16H21V18H11z"
    }
  }]);

  const AlarmSubtract16 = createSVGComponent('AlarmSubtract16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.96 5.5H9.030000000000001V7.5H3.96z",
      "transform": "rotate(-45.06 6.502 6.497)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5 3.96H26.5V9.030000000000001H24.5z",
      "transform": "rotate(-44.94 25.5 6.498)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 16H21V18H11z"
    }
  }]);

  const AlignHorizontalCenter32 = createSVGComponent('AlignHorizontalCenter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
    }
  }]);

  const AlignHorizontalCenter24 = createSVGComponent('AlignHorizontalCenter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
    }
  }]);

  const AlignHorizontalCenter20 = createSVGComponent('AlignHorizontalCenter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
    }
  }]);

  const AlignHorizontalCenter16 = createSVGComponent('AlignHorizontalCenter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
    }
  }]);

  const AlignHorizontalLeft32 = createSVGComponent('AlignHorizontalLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
    }
  }]);

  const AlignHorizontalLeft24 = createSVGComponent('AlignHorizontalLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
    }
  }]);

  const AlignHorizontalLeft20 = createSVGComponent('AlignHorizontalLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
    }
  }]);

  const AlignHorizontalLeft16 = createSVGComponent('AlignHorizontalLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
    }
  }]);

  const AlignHorizontalRight32 = createSVGComponent('AlignHorizontalRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 2H28V30H26z",
      "transform": "rotate(-180 27 16)"
    }
  }]);

  const AlignHorizontalRight24 = createSVGComponent('AlignHorizontalRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 2H28V30H26z",
      "transform": "rotate(-180 27 16)"
    }
  }]);

  const AlignHorizontalRight20 = createSVGComponent('AlignHorizontalRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 2H28V30H26z",
      "transform": "rotate(-180 27 16)"
    }
  }]);

  const AlignHorizontalRight16 = createSVGComponent('AlignHorizontalRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 2H28V30H26z",
      "transform": "rotate(-180 27 16)"
    }
  }]);

  const AlignVerticalBottom32 = createSVGComponent('AlignVerticalBottom32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
    }
  }]);

  const AlignVerticalBottom24 = createSVGComponent('AlignVerticalBottom24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
    }
  }]);

  const AlignVerticalBottom20 = createSVGComponent('AlignVerticalBottom20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
    }
  }]);

  const AlignVerticalBottom16 = createSVGComponent('AlignVerticalBottom16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
    }
  }]);

  const AlignVerticalCenter32 = createSVGComponent('AlignVerticalCenter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
    }
  }]);

  const AlignVerticalCenter24 = createSVGComponent('AlignVerticalCenter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
    }
  }]);

  const AlignVerticalCenter20 = createSVGComponent('AlignVerticalCenter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
    }
  }]);

  const AlignVerticalCenter16 = createSVGComponent('AlignVerticalCenter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
    }
  }]);

  const AlignVerticalTop32 = createSVGComponent('AlignVerticalTop32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
    }
  }]);

  const AlignVerticalTop24 = createSVGComponent('AlignVerticalTop24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
    }
  }]);

  const AlignVerticalTop20 = createSVGComponent('AlignVerticalTop20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
    }
  }]);

  const AlignVerticalTop16 = createSVGComponent('AlignVerticalTop16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
    }
  }]);

  const AlignBoxBottomCenter32 = createSVGComponent('AlignBoxBottomCenter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 18H22V20H10z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 23H20V25H12z",
      "transform": "rotate(-180 16 24)"
    }
  }]);

  const AlignBoxBottomCenter24 = createSVGComponent('AlignBoxBottomCenter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 18H22V20H10z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 23H20V25H12z",
      "transform": "rotate(-180 16 24)"
    }
  }]);

  const AlignBoxBottomCenter20 = createSVGComponent('AlignBoxBottomCenter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 18H22V20H10z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 23H20V25H12z",
      "transform": "rotate(-180 16 24)"
    }
  }]);

  const AlignBoxBottomCenter16 = createSVGComponent('AlignBoxBottomCenter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 18H22V20H10z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 23H20V25H12z",
      "transform": "rotate(-180 16 24)"
    }
  }]);

  const AlignBoxBottomLeft32 = createSVGComponent('AlignBoxBottomLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 18H20V20H9zM9 23H16V25H9z"
    }
  }]);

  const AlignBoxBottomLeft24 = createSVGComponent('AlignBoxBottomLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 18H20V20H9zM9 23H16V25H9z"
    }
  }]);

  const AlignBoxBottomLeft20 = createSVGComponent('AlignBoxBottomLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 18H20V20H9zM9 23H16V25H9z"
    }
  }]);

  const AlignBoxBottomLeft16 = createSVGComponent('AlignBoxBottomLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 18H20V20H9zM9 23H16V25H9z"
    }
  }]);

  const AlignBoxBottomRight32 = createSVGComponent('AlignBoxBottomRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H23V20H12z",
      "transform": "rotate(-180 17.5 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 23H23V25H16z",
      "transform": "rotate(-180 19.5 24)"
    }
  }]);

  const AlignBoxBottomRight24 = createSVGComponent('AlignBoxBottomRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H23V20H12z",
      "transform": "rotate(-180 17.5 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 23H23V25H16z",
      "transform": "rotate(-180 19.5 24)"
    }
  }]);

  const AlignBoxBottomRight20 = createSVGComponent('AlignBoxBottomRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H23V20H12z",
      "transform": "rotate(-180 17.5 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 23H23V25H16z",
      "transform": "rotate(-180 19.5 24)"
    }
  }]);

  const AlignBoxBottomRight16 = createSVGComponent('AlignBoxBottomRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H23V20H12z",
      "transform": "rotate(-180 17.5 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 23H23V25H16z",
      "transform": "rotate(-180 19.5 24)"
    }
  }]);

  const AlignBoxMiddleCenter32 = createSVGComponent('AlignBoxMiddleCenter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 13H22V15H10z",
      "transform": "rotate(-180 16 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H20V20H12z",
      "transform": "rotate(-180 16 19)"
    }
  }]);

  const AlignBoxMiddleCenter24 = createSVGComponent('AlignBoxMiddleCenter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 13H22V15H10z",
      "transform": "rotate(-180 16 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H20V20H12z",
      "transform": "rotate(-180 16 19)"
    }
  }]);

  const AlignBoxMiddleCenter20 = createSVGComponent('AlignBoxMiddleCenter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 13H22V15H10z",
      "transform": "rotate(-180 16 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H20V20H12z",
      "transform": "rotate(-180 16 19)"
    }
  }]);

  const AlignBoxMiddleCenter16 = createSVGComponent('AlignBoxMiddleCenter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 13H22V15H10z",
      "transform": "rotate(-180 16 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 18H20V20H12z",
      "transform": "rotate(-180 16 19)"
    }
  }]);

  const AlignBoxMiddleLeft32 = createSVGComponent('AlignBoxMiddleLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 13H20V15H9zM9 18H16V20H9z"
    }
  }]);

  const AlignBoxMiddleLeft24 = createSVGComponent('AlignBoxMiddleLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 13H20V15H9zM9 18H16V20H9z"
    }
  }]);

  const AlignBoxMiddleLeft20 = createSVGComponent('AlignBoxMiddleLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 13H20V15H9zM9 18H16V20H9z"
    }
  }]);

  const AlignBoxMiddleLeft16 = createSVGComponent('AlignBoxMiddleLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 13H20V15H9zM9 18H16V20H9z"
    }
  }]);

  const AlignBoxMiddleRight32 = createSVGComponent('AlignBoxMiddleRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 13H23V15H12z",
      "transform": "rotate(-180 17.5 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 18H23V20H16z",
      "transform": "rotate(-180 19.5 19)"
    }
  }]);

  const AlignBoxMiddleRight24 = createSVGComponent('AlignBoxMiddleRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 13H23V15H12z",
      "transform": "rotate(-180 17.5 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 18H23V20H16z",
      "transform": "rotate(-180 19.5 19)"
    }
  }]);

  const AlignBoxMiddleRight20 = createSVGComponent('AlignBoxMiddleRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 13H23V15H12z",
      "transform": "rotate(-180 17.5 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 18H23V20H16z",
      "transform": "rotate(-180 19.5 19)"
    }
  }]);

  const AlignBoxMiddleRight16 = createSVGComponent('AlignBoxMiddleRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 13H23V15H12z",
      "transform": "rotate(-180 17.5 14)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 18H23V20H16z",
      "transform": "rotate(-180 19.5 19)"
    }
  }]);

  const AlignBoxTopCenter32 = createSVGComponent('AlignBoxTopCenter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 7H22V9H10z",
      "transform": "rotate(-180 16 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 12H20V14H12z",
      "transform": "rotate(-180 16 13)"
    }
  }]);

  const AlignBoxTopCenter24 = createSVGComponent('AlignBoxTopCenter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 7H22V9H10z",
      "transform": "rotate(-180 16 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 12H20V14H12z",
      "transform": "rotate(-180 16 13)"
    }
  }]);

  const AlignBoxTopCenter20 = createSVGComponent('AlignBoxTopCenter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 7H22V9H10z",
      "transform": "rotate(-180 16 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 12H20V14H12z",
      "transform": "rotate(-180 16 13)"
    }
  }]);

  const AlignBoxTopCenter16 = createSVGComponent('AlignBoxTopCenter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 7H22V9H10z",
      "transform": "rotate(-180 16 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 12H20V14H12z",
      "transform": "rotate(-180 16 13)"
    }
  }]);

  const AlignBoxTopLeft32 = createSVGComponent('AlignBoxTopLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 7H20V9H9zM9 12H16V14H9z"
    }
  }]);

  const AlignBoxTopLeft24 = createSVGComponent('AlignBoxTopLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 7H20V9H9zM9 12H16V14H9z"
    }
  }]);

  const AlignBoxTopLeft20 = createSVGComponent('AlignBoxTopLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 7H20V9H9zM9 12H16V14H9z"
    }
  }]);

  const AlignBoxTopLeft16 = createSVGComponent('AlignBoxTopLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 7H20V9H9zM9 12H16V14H9z"
    }
  }]);

  const AlignBoxTopRight32 = createSVGComponent('AlignBoxTopRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 7H23V9H12z",
      "transform": "rotate(-180 17.5 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 12H23V14H16z",
      "transform": "rotate(-180 19.5 13)"
    }
  }]);

  const AlignBoxTopRight24 = createSVGComponent('AlignBoxTopRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 7H23V9H12z",
      "transform": "rotate(-180 17.5 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 12H23V14H16z",
      "transform": "rotate(-180 19.5 13)"
    }
  }]);

  const AlignBoxTopRight20 = createSVGComponent('AlignBoxTopRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 7H23V9H12z",
      "transform": "rotate(-180 17.5 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 12H23V14H16z",
      "transform": "rotate(-180 19.5 13)"
    }
  }]);

  const AlignBoxTopRight16 = createSVGComponent('AlignBoxTopRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V28A2.0023,2.0023,0,0,1,26,30ZM6,4V28H26V4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 7H23V9H12z",
      "transform": "rotate(-180 17.5 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 12H23V14H16z",
      "transform": "rotate(-180 19.5 13)"
    }
  }]);

  const Analytics32 = createSVGComponent('Analytics32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
    }
  }]);

  const Analytics24 = createSVGComponent('Analytics24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
    }
  }]);

  const Analytics20 = createSVGComponent('Analytics20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
    }
  }]);

  const Analytics16 = createSVGComponent('Analytics16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
    }
  }]);

  const AnalyticsCustom32 = createSVGComponent('AnalyticsCustom32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707 19.293l-3-3a.9994.9994 0 00-1.414 0L16 25.5859V30h4.4141l9.2929-9.293A.9994.9994 0 0029.707 19.293zM19.5859 28H18V26.4141l5-5L24.5859 23zM26 21.5859L24.4141 20 26 18.4141 27.5859 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L6 16.5859 7.4141 18 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2h8V28H4Z"
    }
  }]);

  const AnalyticsCustom24 = createSVGComponent('AnalyticsCustom24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707 19.293l-3-3a.9994.9994 0 00-1.414 0L16 25.5859V30h4.4141l9.2929-9.293A.9994.9994 0 0029.707 19.293zM19.5859 28H18V26.4141l5-5L24.5859 23zM26 21.5859L24.4141 20 26 18.4141 27.5859 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L6 16.5859 7.4141 18 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2h8V28H4Z"
    }
  }]);

  const AnalyticsCustom20 = createSVGComponent('AnalyticsCustom20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707 19.293l-3-3a.9994.9994 0 00-1.414 0L16 25.5859V30h4.4141l9.2929-9.293A.9994.9994 0 0029.707 19.293zM19.5859 28H18V26.4141l5-5L24.5859 23zM26 21.5859L24.4141 20 26 18.4141 27.5859 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L6 16.5859 7.4141 18 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2h8V28H4Z"
    }
  }]);

  const AnalyticsCustom16 = createSVGComponent('AnalyticsCustom16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707 19.293l-3-3a.9994.9994 0 00-1.414 0L16 25.5859V30h4.4141l9.2929-9.293A.9994.9994 0 0029.707 19.293zM19.5859 28H18V26.4141l5-5L24.5859 23zM26 21.5859L24.4141 20 26 18.4141 27.5859 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L6 16.5859 7.4141 18 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2h8V28H4Z"
    }
  }]);

  const AnalyticsReference32 = createSVGComponent('AnalyticsReference32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
    }
  }]);

  const AnalyticsReference24 = createSVGComponent('AnalyticsReference24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
    }
  }]);

  const AnalyticsReference20 = createSVGComponent('AnalyticsReference20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
    }
  }]);

  const AnalyticsReference16 = createSVGComponent('AnalyticsReference16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
    }
  }]);

  const WatsonHealthAngle32 = createSVGComponent('WatsonHealthAngle32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
    }
  }]);

  const WatsonHealthAngle24 = createSVGComponent('WatsonHealthAngle24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
    }
  }]);

  const WatsonHealthAngle20 = createSVGComponent('WatsonHealthAngle20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
    }
  }]);

  const WatsonHealthAngle16 = createSVGComponent('WatsonHealthAngle16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
    }
  }]);

  const WatsonHealthAnnotationVisibility32 = createSVGComponent('WatsonHealthAnnotationVisibility32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
    }
  }]);

  const WatsonHealthAnnotationVisibility24 = createSVGComponent('WatsonHealthAnnotationVisibility24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
    }
  }]);

  const WatsonHealthAnnotationVisibility20 = createSVGComponent('WatsonHealthAnnotationVisibility20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
    }
  }]);

  const WatsonHealthAnnotationVisibility16 = createSVGComponent('WatsonHealthAnnotationVisibility16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
    }
  }]);

  const Aperture32 = createSVGComponent('Aperture32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
    }
  }]);

  const Aperture24 = createSVGComponent('Aperture24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
    }
  }]);

  const Aperture20 = createSVGComponent('Aperture20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
    }
  }]);

  const Aperture16 = createSVGComponent('Aperture16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
    }
  }]);

  const Api32 = createSVGComponent('Api32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
    }
  }]);

  const Api24 = createSVGComponent('Api24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
    }
  }]);

  const Api20 = createSVGComponent('Api20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
    }
  }]);

  const Api16 = createSVGComponent('Api16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
    }
  }]);

  const Api_132 = createSVGComponent('Api_132', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
    }
  }]);

  const Api_124 = createSVGComponent('Api_124', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
    }
  }]);

  const Api_120 = createSVGComponent('Api_120', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
    }
  }]);

  const Api_116 = createSVGComponent('Api_116', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
    }
  }]);

  const App32 = createSVGComponent('App32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
    }
  }]);

  const App24 = createSVGComponent('App24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
    }
  }]);

  const App20 = createSVGComponent('App20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
    }
  }]);

  const App16 = createSVGComponent('App16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
    }
  }]);

  const AppConnectivity32 = createSVGComponent('AppConnectivity32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
    }
  }]);

  const AppConnectivity24 = createSVGComponent('AppConnectivity24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
    }
  }]);

  const AppConnectivity20 = createSVGComponent('AppConnectivity20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
    }
  }]);

  const AppConnectivity16 = createSVGComponent('AppConnectivity16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
    }
  }]);

  const Apple32 = createSVGComponent('Apple32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
    }
  }]);

  const Apple24 = createSVGComponent('Apple24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
    }
  }]);

  const Apple20 = createSVGComponent('Apple20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
    }
  }]);

  const Apple16 = createSVGComponent('Apple16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
    }
  }]);

  const AppleDash32 = createSVGComponent('AppleDash32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.0825 11.6714l-1.6748-1.0928c-.9062 1.3887-1.3928 3.2305-1.4072 5.3267l2 .0137c.0117-1.7119.3857-3.1807 1.082-4.2476zM6.0852 17.8164l-1.9907.1934c.1887 1.938.6592 3.6738 1.3982 5.1592l1.7905-.8911c-.6301-1.2661-1.0332-2.7676-1.198-4.4614zM8.2378 23.7964l-1.5688 1.2402c1.333 1.6865 3.0972 2.7573 4.8396 2.9375l.2061-1.9893c-1.1912-.1235-2.491-.9414-3.4768-2.1885zM16 25c-.7334 0-1.4783.271-2.1987.5332-.1809.0654-.3635.1318-.5469.1943l.6426 1.894c.197-.0669.3936-.1382.5879-.209.5576-.2026 1.134-.4126 1.5151-.4126.3809 0 .9575.21 1.5149.4121.1809.0659.3635.1323.5466.1953l.6479-1.8926c-.1711-.0586-.3418-.1206-.511-.1821-.7205-.2617-1.4653-.5327-2.1985-.5327zM20.2546 25.9878l.1855 1.9917c1.7456-.1631 3.5178-1.2227 4.8621-2.9072l-1.5632-1.2476c-.9924 1.2437-2.2949 2.0522-3.4844 2.1631zM24.7004 22.3115l1.7871.8975c.7449-1.4834 1.2205-3.2178 1.4138-5.1558l-1.9902-.1987c-.1689 1.6938-.5762 3.1934-1.2107 4.457zM28 15.9492c-.0076-2.0938-.4854-3.9365-1.3818-5.3311l-1.6821 1.082c.6897 1.0728 1.0576 2.5444 1.064 4.2559l2-.0068zM20 4h-1c-1.1046 0-2 .8954-2 2v1h1c1.1046 0 2-.8954 2-2v-1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8125,10.5308l1.1035-1.668c-.8655-.5728-1.8467-.8628-2.916-.8628-1.4155,0-2.4175,.2881-3.3013,.542-.5764,.1655-1.1362,.3203-1.7979,.4004-.502-2.8047-2.9541-4.9424-5.9009-4.9424v2c1.8223,0,3.3464,1.2319,3.8274,2.9014-.5442-.0864-1.031-.2173-1.5261-.3594-.8838-.2539-1.8857-.542-3.3013-.542-1.0693,0-2.0505,.29-2.916,.8628l1.1035,1.668c.5325-.3521,1.1423-.5308,1.8125-.5308,1.134,0,1.9185,.2256,2.7488,.4639,.917,.2637,1.8652,.5361,3.2512,.5361s2.3342-.2725,3.2512-.5361c.8303-.2383,1.6147-.4639,2.7488-.4639,.6702,0,1.28,.1787,1.8125,.5308Z"
    }
  }]);

  const AppleDash24 = createSVGComponent('AppleDash24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.0825 11.6714l-1.6748-1.0928c-.9062 1.3887-1.3928 3.2305-1.4072 5.3267l2 .0137c.0117-1.7119.3857-3.1807 1.082-4.2476zM6.0852 17.8164l-1.9907.1934c.1887 1.938.6592 3.6738 1.3982 5.1592l1.7905-.8911c-.6301-1.2661-1.0332-2.7676-1.198-4.4614zM8.2378 23.7964l-1.5688 1.2402c1.333 1.6865 3.0972 2.7573 4.8396 2.9375l.2061-1.9893c-1.1912-.1235-2.491-.9414-3.4768-2.1885zM16 25c-.7334 0-1.4783.271-2.1987.5332-.1809.0654-.3635.1318-.5469.1943l.6426 1.894c.197-.0669.3936-.1382.5879-.209.5576-.2026 1.134-.4126 1.5151-.4126.3809 0 .9575.21 1.5149.4121.1809.0659.3635.1323.5466.1953l.6479-1.8926c-.1711-.0586-.3418-.1206-.511-.1821-.7205-.2617-1.4653-.5327-2.1985-.5327zM20.2546 25.9878l.1855 1.9917c1.7456-.1631 3.5178-1.2227 4.8621-2.9072l-1.5632-1.2476c-.9924 1.2437-2.2949 2.0522-3.4844 2.1631zM24.7004 22.3115l1.7871.8975c.7449-1.4834 1.2205-3.2178 1.4138-5.1558l-1.9902-.1987c-.1689 1.6938-.5762 3.1934-1.2107 4.457zM28 15.9492c-.0076-2.0938-.4854-3.9365-1.3818-5.3311l-1.6821 1.082c.6897 1.0728 1.0576 2.5444 1.064 4.2559l2-.0068zM20 4h-1c-1.1046 0-2 .8954-2 2v1h1c1.1046 0 2-.8954 2-2v-1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8125,10.5308l1.1035-1.668c-.8655-.5728-1.8467-.8628-2.916-.8628-1.4155,0-2.4175,.2881-3.3013,.542-.5764,.1655-1.1362,.3203-1.7979,.4004-.502-2.8047-2.9541-4.9424-5.9009-4.9424v2c1.8223,0,3.3464,1.2319,3.8274,2.9014-.5442-.0864-1.031-.2173-1.5261-.3594-.8838-.2539-1.8857-.542-3.3013-.542-1.0693,0-2.0505,.29-2.916,.8628l1.1035,1.668c.5325-.3521,1.1423-.5308,1.8125-.5308,1.134,0,1.9185,.2256,2.7488,.4639,.917,.2637,1.8652,.5361,3.2512,.5361s2.3342-.2725,3.2512-.5361c.8303-.2383,1.6147-.4639,2.7488-.4639,.6702,0,1.28,.1787,1.8125,.5308Z"
    }
  }]);

  const AppleDash20 = createSVGComponent('AppleDash20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.0825 11.6714l-1.6748-1.0928c-.9062 1.3887-1.3928 3.2305-1.4072 5.3267l2 .0137c.0117-1.7119.3857-3.1807 1.082-4.2476zM6.0852 17.8164l-1.9907.1934c.1887 1.938.6592 3.6738 1.3982 5.1592l1.7905-.8911c-.6301-1.2661-1.0332-2.7676-1.198-4.4614zM8.2378 23.7964l-1.5688 1.2402c1.333 1.6865 3.0972 2.7573 4.8396 2.9375l.2061-1.9893c-1.1912-.1235-2.491-.9414-3.4768-2.1885zM16 25c-.7334 0-1.4783.271-2.1987.5332-.1809.0654-.3635.1318-.5469.1943l.6426 1.894c.197-.0669.3936-.1382.5879-.209.5576-.2026 1.134-.4126 1.5151-.4126.3809 0 .9575.21 1.5149.4121.1809.0659.3635.1323.5466.1953l.6479-1.8926c-.1711-.0586-.3418-.1206-.511-.1821-.7205-.2617-1.4653-.5327-2.1985-.5327zM20.2546 25.9878l.1855 1.9917c1.7456-.1631 3.5178-1.2227 4.8621-2.9072l-1.5632-1.2476c-.9924 1.2437-2.2949 2.0522-3.4844 2.1631zM24.7004 22.3115l1.7871.8975c.7449-1.4834 1.2205-3.2178 1.4138-5.1558l-1.9902-.1987c-.1689 1.6938-.5762 3.1934-1.2107 4.457zM28 15.9492c-.0076-2.0938-.4854-3.9365-1.3818-5.3311l-1.6821 1.082c.6897 1.0728 1.0576 2.5444 1.064 4.2559l2-.0068zM20 4h-1c-1.1046 0-2 .8954-2 2v1h1c1.1046 0 2-.8954 2-2v-1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8125,10.5308l1.1035-1.668c-.8655-.5728-1.8467-.8628-2.916-.8628-1.4155,0-2.4175,.2881-3.3013,.542-.5764,.1655-1.1362,.3203-1.7979,.4004-.502-2.8047-2.9541-4.9424-5.9009-4.9424v2c1.8223,0,3.3464,1.2319,3.8274,2.9014-.5442-.0864-1.031-.2173-1.5261-.3594-.8838-.2539-1.8857-.542-3.3013-.542-1.0693,0-2.0505,.29-2.916,.8628l1.1035,1.668c.5325-.3521,1.1423-.5308,1.8125-.5308,1.134,0,1.9185,.2256,2.7488,.4639,.917,.2637,1.8652,.5361,3.2512,.5361s2.3342-.2725,3.2512-.5361c.8303-.2383,1.6147-.4639,2.7488-.4639,.6702,0,1.28,.1787,1.8125,.5308Z"
    }
  }]);

  const AppleDash16 = createSVGComponent('AppleDash16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.0825 11.6714l-1.6748-1.0928c-.9062 1.3887-1.3928 3.2305-1.4072 5.3267l2 .0137c.0117-1.7119.3857-3.1807 1.082-4.2476zM6.0852 17.8164l-1.9907.1934c.1887 1.938.6592 3.6738 1.3982 5.1592l1.7905-.8911c-.6301-1.2661-1.0332-2.7676-1.198-4.4614zM8.2378 23.7964l-1.5688 1.2402c1.333 1.6865 3.0972 2.7573 4.8396 2.9375l.2061-1.9893c-1.1912-.1235-2.491-.9414-3.4768-2.1885zM16 25c-.7334 0-1.4783.271-2.1987.5332-.1809.0654-.3635.1318-.5469.1943l.6426 1.894c.197-.0669.3936-.1382.5879-.209.5576-.2026 1.134-.4126 1.5151-.4126.3809 0 .9575.21 1.5149.4121.1809.0659.3635.1323.5466.1953l.6479-1.8926c-.1711-.0586-.3418-.1206-.511-.1821-.7205-.2617-1.4653-.5327-2.1985-.5327zM20.2546 25.9878l.1855 1.9917c1.7456-.1631 3.5178-1.2227 4.8621-2.9072l-1.5632-1.2476c-.9924 1.2437-2.2949 2.0522-3.4844 2.1631zM24.7004 22.3115l1.7871.8975c.7449-1.4834 1.2205-3.2178 1.4138-5.1558l-1.9902-.1987c-.1689 1.6938-.5762 3.1934-1.2107 4.457zM28 15.9492c-.0076-2.0938-.4854-3.9365-1.3818-5.3311l-1.6821 1.082c.6897 1.0728 1.0576 2.5444 1.064 4.2559l2-.0068zM20 4h-1c-1.1046 0-2 .8954-2 2v1h1c1.1046 0 2-.8954 2-2v-1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8125,10.5308l1.1035-1.668c-.8655-.5728-1.8467-.8628-2.916-.8628-1.4155,0-2.4175,.2881-3.3013,.542-.5764,.1655-1.1362,.3203-1.7979,.4004-.502-2.8047-2.9541-4.9424-5.9009-4.9424v2c1.8223,0,3.3464,1.2319,3.8274,2.9014-.5442-.0864-1.031-.2173-1.5261-.3594-.8838-.2539-1.8857-.542-3.3013-.542-1.0693,0-2.0505,.29-2.916,.8628l1.1035,1.668c.5325-.3521,1.1423-.5308,1.8125-.5308,1.134,0,1.9185,.2256,2.7488,.4639,.917,.2637,1.8652,.5361,3.2512,.5361s2.3342-.2725,3.2512-.5361c.8303-.2383,1.6147-.4639,2.7488-.4639,.6702,0,1.28,.1787,1.8125,.5308Z"
    }
  }]);

  const Application32 = createSVGComponent('Application32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
    }
  }]);

  const Application24 = createSVGComponent('Application24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
    }
  }]);

  const Application20 = createSVGComponent('Application20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
    }
  }]);

  const Application16 = createSVGComponent('Application16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
    }
  }]);

  const ApplicationMobile32 = createSVGComponent('ApplicationMobile32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 7H27V11H23zM23 13H27V17H23zM17 7H21V11H17zM17 13H21V17H17z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,30H8a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,8,2H21V4H8V28H21V20h2v8A2.0023,2.0023,0,0,1,21,30Z"
    }
  }]);

  const ApplicationMobile24 = createSVGComponent('ApplicationMobile24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 7H27V11H23zM23 13H27V17H23zM17 7H21V11H17zM17 13H21V17H17z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,30H8a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,8,2H21V4H8V28H21V20h2v8A2.0023,2.0023,0,0,1,21,30Z"
    }
  }]);

  const ApplicationMobile20 = createSVGComponent('ApplicationMobile20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 7H27V11H23zM23 13H27V17H23zM17 7H21V11H17zM17 13H21V17H17z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,30H8a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,8,2H21V4H8V28H21V20h2v8A2.0023,2.0023,0,0,1,21,30Z"
    }
  }]);

  const ApplicationMobile16 = createSVGComponent('ApplicationMobile16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 7H27V11H23zM23 13H27V17H23zM17 7H21V11H17zM17 13H21V17H17z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,30H8a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,8,2H21V4H8V28H21V20h2v8A2.0023,2.0023,0,0,1,21,30Z"
    }
  }]);

  const ApplicationVirtual32 = createSVGComponent('ApplicationVirtual32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 19H21V23H17zM11 19H15V23H11zM17 25H21V29H17zM11 25H15V29H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5,25H24V23h.5a5.4961,5.4961,0,0,0,.377-10.9795l-.8365-.0566-.09-.834a7.9979,7.9979,0,0,0-15.9014,0l-.09.834-.8365.0566A5.4961,5.4961,0,0,0,7.5,23H8v2H7.5A7.4964,7.4964,0,0,1,6.1782,10.124a9.9992,9.9992,0,0,1,19.6436,0A7.4964,7.4964,0,0,1,24.5,25Z"
    }
  }]);

  const ApplicationVirtual24 = createSVGComponent('ApplicationVirtual24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 19H21V23H17zM11 19H15V23H11zM17 25H21V29H17zM11 25H15V29H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5,25H24V23h.5a5.4961,5.4961,0,0,0,.377-10.9795l-.8365-.0566-.09-.834a7.9979,7.9979,0,0,0-15.9014,0l-.09.834-.8365.0566A5.4961,5.4961,0,0,0,7.5,23H8v2H7.5A7.4964,7.4964,0,0,1,6.1782,10.124a9.9992,9.9992,0,0,1,19.6436,0A7.4964,7.4964,0,0,1,24.5,25Z"
    }
  }]);

  const ApplicationVirtual20 = createSVGComponent('ApplicationVirtual20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 19H21V23H17zM11 19H15V23H11zM17 25H21V29H17zM11 25H15V29H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5,25H24V23h.5a5.4961,5.4961,0,0,0,.377-10.9795l-.8365-.0566-.09-.834a7.9979,7.9979,0,0,0-15.9014,0l-.09.834-.8365.0566A5.4961,5.4961,0,0,0,7.5,23H8v2H7.5A7.4964,7.4964,0,0,1,6.1782,10.124a9.9992,9.9992,0,0,1,19.6436,0A7.4964,7.4964,0,0,1,24.5,25Z"
    }
  }]);

  const ApplicationVirtual16 = createSVGComponent('ApplicationVirtual16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 19H21V23H17zM11 19H15V23H11zM17 25H21V29H17zM11 25H15V29H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24.5,25H24V23h.5a5.4961,5.4961,0,0,0,.377-10.9795l-.8365-.0566-.09-.834a7.9979,7.9979,0,0,0-15.9014,0l-.09.834-.8365.0566A5.4961,5.4961,0,0,0,7.5,23H8v2H7.5A7.4964,7.4964,0,0,1,6.1782,10.124a9.9992,9.9992,0,0,1,19.6436,0A7.4964,7.4964,0,0,1,24.5,25Z"
    }
  }]);

  const ApplicationWeb32 = createSVGComponent('ApplicationWeb32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 2H30V6H26zM26 8H30V12H26zM20 2H24V6H20zM20 8H24V12H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,16v6H4V6H16V4H4A2,2,0,0,0,2,6V22a2,2,0,0,0,2,2h8v4H8v2H24V28H20V24h8a2,2,0,0,0,2-2V16ZM18,28H14V24h4Z"
    }
  }]);

  const ApplicationWeb24 = createSVGComponent('ApplicationWeb24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 2H30V6H26zM26 8H30V12H26zM20 2H24V6H20zM20 8H24V12H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,16v6H4V6H16V4H4A2,2,0,0,0,2,6V22a2,2,0,0,0,2,2h8v4H8v2H24V28H20V24h8a2,2,0,0,0,2-2V16ZM18,28H14V24h4Z"
    }
  }]);

  const ApplicationWeb20 = createSVGComponent('ApplicationWeb20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 2H30V6H26zM26 8H30V12H26zM20 2H24V6H20zM20 8H24V12H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,16v6H4V6H16V4H4A2,2,0,0,0,2,6V22a2,2,0,0,0,2,2h8v4H8v2H24V28H20V24h8a2,2,0,0,0,2-2V16ZM18,28H14V24h4Z"
    }
  }]);

  const ApplicationWeb16 = createSVGComponent('ApplicationWeb16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 2H30V6H26zM26 8H30V12H26zM20 2H24V6H20zM20 8H24V12H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,16v6H4V6H16V4H4A2,2,0,0,0,2,6V22a2,2,0,0,0,2,2h8v4H8v2H24V28H20V24h8a2,2,0,0,0,2-2V16ZM18,28H14V24h4Z"
    }
  }]);

  const Apps32 = createSVGComponent('Apps32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,4V8H4V4Zm2-2H2v8h8Zm8,2V8H14V4Zm2-2H12v8h8Zm8,2V8H24V4Zm2-2H22v8h8ZM8,14v4H4V14Zm2-2H2v8h8Zm8,2v4H14V14Zm2-2H12v8h8Zm8,2v4H24V14Zm2-2H22v8h8ZM8,24v4H4V24Zm2-2H2v8h8Zm8,2v4H14V24Zm2-2H12v8h8Zm8,2v4H24V24Zm2-2H22v8h8Z"
    }
  }]);

  const Apps24 = createSVGComponent('Apps24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,4V8H4V4Zm2-2H2v8h8Zm8,2V8H14V4Zm2-2H12v8h8Zm8,2V8H24V4Zm2-2H22v8h8ZM8,14v4H4V14Zm2-2H2v8h8Zm8,2v4H14V14Zm2-2H12v8h8Zm8,2v4H24V14Zm2-2H22v8h8ZM8,24v4H4V24Zm2-2H2v8h8Zm8,2v4H14V24Zm2-2H12v8h8Zm8,2v4H24V24Zm2-2H22v8h8Z"
    }
  }]);

  const Apps20 = createSVGComponent('Apps20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,4V8H4V4Zm2-2H2v8h8Zm8,2V8H14V4Zm2-2H12v8h8Zm8,2V8H24V4Zm2-2H22v8h8ZM8,14v4H4V14Zm2-2H2v8h8Zm8,2v4H14V14Zm2-2H12v8h8Zm8,2v4H24V14Zm2-2H22v8h8ZM8,24v4H4V24Zm2-2H2v8h8Zm8,2v4H14V24Zm2-2H12v8h8Zm8,2v4H24V24Zm2-2H22v8h8Z"
    }
  }]);

  const Apps16 = createSVGComponent('Apps16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 2v2H2V2h2zm1-1H1v4h4V1zM9 2v2H7V2h2zm1-1H6v4h4V1zM14 2v2h-2V2h2zm1-1h-4v4h4V1zM4 7v2H2V7h2zm1-1H1v4h4V6zM9 7v2H7V7h2zm1-1H6v4h4V6zM14 7v2h-2V7h2zm1-1h-4v4h4V6zM4 12v2H2v-2h2zm1-1H1v4h4v-4zM9 12v2H7v-2h2zm1-1H6v4h4v-4zM14 12v2h-2v-2h2zm1-1h-4v4h4v-4z"
    }
  }]);

  const Archive32 = createSVGComponent('Archive32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 19H18V21H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
    }
  }]);

  const Archive24 = createSVGComponent('Archive24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 19H18V21H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
    }
  }]);

  const Archive20 = createSVGComponent('Archive20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 19H18V21H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
    }
  }]);

  const Archive16 = createSVGComponent('Archive16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 19H18V21H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
    }
  }]);

  const Area32 = createSVGComponent('Area32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.142V9.858A3.9916,3.9916,0,1,0,22.142,5H9.858A3.9916,3.9916,0,1,0,5,9.858V22.142A3.9916,3.9916,0,1,0,9.858,27H22.142A3.9916,3.9916,0,1,0,27,22.142ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm16.142-3H9.858A3.9937,3.9937,0,0,0,7,22.142V9.858A3.9947,3.9947,0,0,0,9.858,7H22.142A3.9937,3.9937,0,0,0,25,9.858V22.142A3.9931,3.9931,0,0,0,22.142,25ZM26,28a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"
    }
  }]);

  const Area24 = createSVGComponent('Area24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.142V9.858A3.9916,3.9916,0,1,0,22.142,5H9.858A3.9916,3.9916,0,1,0,5,9.858V22.142A3.9916,3.9916,0,1,0,9.858,27H22.142A3.9916,3.9916,0,1,0,27,22.142ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm16.142-3H9.858A3.9937,3.9937,0,0,0,7,22.142V9.858A3.9947,3.9947,0,0,0,9.858,7H22.142A3.9937,3.9937,0,0,0,25,9.858V22.142A3.9931,3.9931,0,0,0,22.142,25ZM26,28a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"
    }
  }]);

  const Area20 = createSVGComponent('Area20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.142V9.858A3.9916,3.9916,0,1,0,22.142,5H9.858A3.9916,3.9916,0,1,0,5,9.858V22.142A3.9916,3.9916,0,1,0,9.858,27H22.142A3.9916,3.9916,0,1,0,27,22.142ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm16.142-3H9.858A3.9937,3.9937,0,0,0,7,22.142V9.858A3.9947,3.9947,0,0,0,9.858,7H22.142A3.9937,3.9937,0,0,0,25,9.858V22.142A3.9931,3.9931,0,0,0,22.142,25ZM26,28a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"
    }
  }]);

  const Area16 = createSVGComponent('Area16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.142V9.858A3.9916,3.9916,0,1,0,22.142,5H9.858A3.9916,3.9916,0,1,0,5,9.858V22.142A3.9916,3.9916,0,1,0,9.858,27H22.142A3.9916,3.9916,0,1,0,27,22.142ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm16.142-3H9.858A3.9937,3.9937,0,0,0,7,22.142V9.858A3.9947,3.9947,0,0,0,9.858,7H22.142A3.9937,3.9937,0,0,0,25,9.858V22.142A3.9931,3.9931,0,0,0,22.142,25ZM26,28a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"
    }
  }]);

  const AreaCustom32 = createSVGComponent('AreaCustom32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6a3.9916,3.9916,0,0,0-7.9773-.2241L9.5864,8.2627A3.99,3.99,0,1,0,5,13.8579v8.2842A3.9915,3.9915,0,1,0,9.8579,27h8.2842a3.9912,3.9912,0,1,0,5.595-4.5864l2.487-12.4361A3.9945,3.9945,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,10a2,2,0,1,1,2,2A2.0023,2.0023,0,0,1,4,10ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm12.1421-3H9.8579A3.9942,3.9942,0,0,0,7,22.1421V13.8579a3.9871,3.9871,0,0,0,2.9773-3.6338L22.4136,7.7373a4.0053,4.0053,0,0,0,1.8493,1.8491l-2.487,12.4361A3.9874,3.9874,0,0,0,18.1421,25ZM22,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,22,28Z"
    }
  }]);

  const AreaCustom24 = createSVGComponent('AreaCustom24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6a3.9916,3.9916,0,0,0-7.9773-.2241L9.5864,8.2627A3.99,3.99,0,1,0,5,13.8579v8.2842A3.9915,3.9915,0,1,0,9.8579,27h8.2842a3.9912,3.9912,0,1,0,5.595-4.5864l2.487-12.4361A3.9945,3.9945,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,10a2,2,0,1,1,2,2A2.0023,2.0023,0,0,1,4,10ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm12.1421-3H9.8579A3.9942,3.9942,0,0,0,7,22.1421V13.8579a3.9871,3.9871,0,0,0,2.9773-3.6338L22.4136,7.7373a4.0053,4.0053,0,0,0,1.8493,1.8491l-2.487,12.4361A3.9874,3.9874,0,0,0,18.1421,25ZM22,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,22,28Z"
    }
  }]);

  const AreaCustom20 = createSVGComponent('AreaCustom20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6a3.9916,3.9916,0,0,0-7.9773-.2241L9.5864,8.2627A3.99,3.99,0,1,0,5,13.8579v8.2842A3.9915,3.9915,0,1,0,9.8579,27h8.2842a3.9912,3.9912,0,1,0,5.595-4.5864l2.487-12.4361A3.9945,3.9945,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,10a2,2,0,1,1,2,2A2.0023,2.0023,0,0,1,4,10ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm12.1421-3H9.8579A3.9942,3.9942,0,0,0,7,22.1421V13.8579a3.9871,3.9871,0,0,0,2.9773-3.6338L22.4136,7.7373a4.0053,4.0053,0,0,0,1.8493,1.8491l-2.487,12.4361A3.9874,3.9874,0,0,0,18.1421,25ZM22,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,22,28Z"
    }
  }]);

  const AreaCustom16 = createSVGComponent('AreaCustom16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6a3.9916,3.9916,0,0,0-7.9773-.2241L9.5864,8.2627A3.99,3.99,0,1,0,5,13.8579v8.2842A3.9915,3.9915,0,1,0,9.8579,27h8.2842a3.9912,3.9912,0,1,0,5.595-4.5864l2.487-12.4361A3.9945,3.9945,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM4,10a2,2,0,1,1,2,2A2.0023,2.0023,0,0,1,4,10ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm12.1421-3H9.8579A3.9942,3.9942,0,0,0,7,22.1421V13.8579a3.9871,3.9871,0,0,0,2.9773-3.6338L22.4136,7.7373a4.0053,4.0053,0,0,0,1.8493,1.8491l-2.487,12.4361A3.9874,3.9874,0,0,0,18.1421,25ZM22,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,22,28Z"
    }
  }]);

  const Arrival32 = createSVGComponent('Arrival32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
    }
  }]);

  const Arrival24 = createSVGComponent('Arrival24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
    }
  }]);

  const Arrival20 = createSVGComponent('Arrival20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
    }
  }]);

  const Arrival16 = createSVGComponent('Arrival16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
    }
  }]);

  const WatsonHealthArrowAnnotation32 = createSVGComponent('WatsonHealthArrowAnnotation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
    }
  }]);

  const WatsonHealthArrowAnnotation24 = createSVGComponent('WatsonHealthArrowAnnotation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
    }
  }]);

  const WatsonHealthArrowAnnotation20 = createSVGComponent('WatsonHealthArrowAnnotation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
    }
  }]);

  const WatsonHealthArrowAnnotation16 = createSVGComponent('WatsonHealthArrowAnnotation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
    }
  }]);

  const ArrowDown32 = createSVGComponent('ArrowDown32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.59 16.59L17 24.17 17 4 15 4 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59z"
    }
  }]);

  const ArrowDown24 = createSVGComponent('ArrowDown24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.59 16.59L17 24.17 17 4 15 4 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59z"
    }
  }]);

  const ArrowDown20 = createSVGComponent('ArrowDown20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24.59 16.59L17 24.17 17 4 15 4 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59z"
    }
  }]);

  const ArrowDown16 = createSVGComponent('ArrowDown16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12.3 9.3L8.5 13.1 8.5 1 7.5 1 7.5 13.1 3.7 9.3 3 10 8 15 13 10z"
    }
  }]);

  const ArrowDownLeft32 = createSVGComponent('ArrowDownLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
    }
  }]);

  const ArrowDownLeft24 = createSVGComponent('ArrowDownLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
    }
  }]);

  const ArrowDownLeft20 = createSVGComponent('ArrowDownLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
    }
  }]);

  const ArrowDownLeft16 = createSVGComponent('ArrowDownLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
    }
  }]);

  const ArrowDownRight32 = createSVGComponent('ArrowDownRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
    }
  }]);

  const ArrowDownRight24 = createSVGComponent('ArrowDownRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
    }
  }]);

  const ArrowDownRight20 = createSVGComponent('ArrowDownRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
    }
  }]);

  const ArrowDownRight16 = createSVGComponent('ArrowDownRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
    }
  }]);

  const ArrowLeft32 = createSVGComponent('ArrowLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 26L15.41 24.59 7.83 17 28 17 28 15 7.83 15 15.41 7.41 14 6 4 16 14 26z"
    }
  }]);

  const ArrowLeft24 = createSVGComponent('ArrowLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 26L15.41 24.59 7.83 17 28 17 28 15 7.83 15 15.41 7.41 14 6 4 16 14 26z"
    }
  }]);

  const ArrowLeft20 = createSVGComponent('ArrowLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 26L15.41 24.59 7.83 17 28 17 28 15 7.83 15 15.41 7.41 14 6 4 16 14 26z"
    }
  }]);

  const ArrowLeft16 = createSVGComponent('ArrowLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6.7 12.3L2.9 8.5 15 8.5 15 7.5 2.9 7.5 6.7 3.7 6 3 1 8 6 13z"
    }
  }]);

  const ArrowRight32 = createSVGComponent('ArrowRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 6L16.57 7.393 24.15 15 4 15 4 17 24.15 17 16.57 24.573 18 26 28 16 18 6z"
    }
  }]);

  const ArrowRight24 = createSVGComponent('ArrowRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 24 24",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 4L12.9 5.1 18.9 11.2 2 11.2 2 12.8 18.9 12.8 12.9 18.9 14 20 22 12z"
    }
  }]);

  const ArrowRight20 = createSVGComponent('ArrowRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 20 20",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.8 2.8L10.8 3.8 16.2 9.3 1 9.3 1 10.7 16.2 10.7 10.8 16.2 11.8 17.2 19 10z"
    }
  }]);

  const ArrowRight16 = createSVGComponent('ArrowRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9.3 3.7L13.1 7.5 1 7.5 1 8.5 13.1 8.5 9.3 12.3 10 13 15 8 10 3z"
    }
  }]);

  const ArrowUp32 = createSVGComponent('ArrowUp32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 4L6 14 7.41 15.41 15 7.83 15 28 17 28 17 7.83 24.59 15.41 26 14 16 4z"
    }
  }]);

  const ArrowUp24 = createSVGComponent('ArrowUp24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 4L6 14 7.41 15.41 15 7.83 15 28 17 28 17 7.83 24.59 15.41 26 14 16 4z"
    }
  }]);

  const ArrowUp20 = createSVGComponent('ArrowUp20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 4L6 14 7.41 15.41 15 7.83 15 28 17 28 17 7.83 24.59 15.41 26 14 16 4z"
    }
  }]);

  const ArrowUp16 = createSVGComponent('ArrowUp16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3.7 6.7L7.5 2.9 7.5 15 8.5 15 8.5 2.9 12.3 6.7 13 6 8 1 3 6z"
    }
  }]);

  const ArrowUpLeft32 = createSVGComponent('ArrowUpLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
    }
  }]);

  const ArrowUpLeft24 = createSVGComponent('ArrowUpLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
    }
  }]);

  const ArrowUpLeft20 = createSVGComponent('ArrowUpLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
    }
  }]);

  const ArrowUpLeft16 = createSVGComponent('ArrowUpLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
    }
  }]);

  const ArrowUpRight32 = createSVGComponent('ArrowUpRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
    }
  }]);

  const ArrowUpRight24 = createSVGComponent('ArrowUpRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
    }
  }]);

  const ArrowUpRight20 = createSVGComponent('ArrowUpRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
    }
  }]);

  const ArrowUpRight16 = createSVGComponent('ArrowUpRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
    }
  }]);

  const ArrowShiftDown32 = createSVGComponent('ArrowShiftDown32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
    }
  }]);

  const ArrowShiftDown24 = createSVGComponent('ArrowShiftDown24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
    }
  }]);

  const ArrowShiftDown20 = createSVGComponent('ArrowShiftDown20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
    }
  }]);

  const ArrowShiftDown16 = createSVGComponent('ArrowShiftDown16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
    }
  }]);

  const ArrowsHorizontal32 = createSVGComponent('ArrowsHorizontal32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
    }
  }]);

  const ArrowsHorizontal24 = createSVGComponent('ArrowsHorizontal24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
    }
  }]);

  const ArrowsHorizontal20 = createSVGComponent('ArrowsHorizontal20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
    }
  }]);

  const ArrowsHorizontal16 = createSVGComponent('ArrowsHorizontal16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
    }
  }]);

  const ArrowsVertical32 = createSVGComponent('ArrowsVertical32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
    }
  }]);

  const ArrowsVertical24 = createSVGComponent('ArrowsVertical24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
    }
  }]);

  const ArrowsVertical20 = createSVGComponent('ArrowsVertical20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
    }
  }]);

  const ArrowsVertical16 = createSVGComponent('ArrowsVertical16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
    }
  }]);

  const Asleep32 = createSVGComponent('Asleep32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const Asleep24 = createSVGComponent('Asleep24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const Asleep20 = createSVGComponent('Asleep20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const Asleep16 = createSVGComponent('Asleep16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.2,2.3c-1,4.4,1.7,8.7,6.1,9.8c0.1,0,0.1,0,0.2,0c-1.1,1.2-2.7,1.8-4.3,1.8c-0.1,0-0.2,0-0.2,0C5.6,13.8,3,11,3.2,7.7\tC3.2,5.3,4.8,3.1,7.2,2.3 M8,1L8,1C4.1,1.6,1.5,5.3,2.1,9.1c0.6,3.3,3.4,5.8,6.8,5.9c0.1,0,0.2,0,0.3,0c2.3,0,4.4-1.1,5.8-3\tc0.2-0.2,0.1-0.6-0.1-0.7c-0.1-0.1-0.2-0.1-0.3-0.1c-3.9-0.3-6.7-3.8-6.4-7.6C8.3,3,8.4,2.4,8.6,1.8c0.1-0.3,0-0.6-0.3-0.7\tC8.1,1,8.1,1,8,1z"
    }
  }]);

  const AsleepFilled32 = createSVGComponent('AsleepFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const AsleepFilled24 = createSVGComponent('AsleepFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const AsleepFilled20 = createSVGComponent('AsleepFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const AsleepFilled16 = createSVGComponent('AsleepFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
    }
  }]);

  const Assembly32 = createSVGComponent('Assembly32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,25.4l-8-4.7v-9.4l8-4.7l8,4.7v9.4L16,25.4z M10,19.6l6,3.5l6-3.5v-7.1l-6-3.5l-6,3.5V19.6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,8.2L17,2.3C16.7,2.1,16.4,2,16,2s-0.7,0.1-1,0.3L5,8.2c-0.6,0.4-1,1-1,1.7v12.2c0,0.7,0.4,1.4,1,1.7l10,5.9\tc0.3,0.2,0.7,0.3,1,0.3s0.7-0.1,1-0.3l10-5.9c0.6-0.4,1-1,1-1.7V9.9C28,9.2,27.6,8.5,27,8.2z M26,22.1L16,28L6,22.1V9.9L16,4l10,5.9\tV22.1z"
    }
  }]);

  const Assembly24 = createSVGComponent('Assembly24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,25.4l-8-4.7v-9.4l8-4.7l8,4.7v9.4L16,25.4z M10,19.6l6,3.5l6-3.5v-7.1l-6-3.5l-6,3.5V19.6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,8.2L17,2.3C16.7,2.1,16.4,2,16,2s-0.7,0.1-1,0.3L5,8.2c-0.6,0.4-1,1-1,1.7v12.2c0,0.7,0.4,1.4,1,1.7l10,5.9\tc0.3,0.2,0.7,0.3,1,0.3s0.7-0.1,1-0.3l10-5.9c0.6-0.4,1-1,1-1.7V9.9C28,9.2,27.6,8.5,27,8.2z M26,22.1L16,28L6,22.1V9.9L16,4l10,5.9\tV22.1z"
    }
  }]);

  const Assembly20 = createSVGComponent('Assembly20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,25.4l-8-4.7v-9.4l8-4.7l8,4.7v9.4L16,25.4z M10,19.6l6,3.5l6-3.5v-7.1l-6-3.5l-6,3.5V19.6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,8.2L17,2.3C16.7,2.1,16.4,2,16,2s-0.7,0.1-1,0.3L5,8.2c-0.6,0.4-1,1-1,1.7v12.2c0,0.7,0.4,1.4,1,1.7l10,5.9\tc0.3,0.2,0.7,0.3,1,0.3s0.7-0.1,1-0.3l10-5.9c0.6-0.4,1-1,1-1.7V9.9C28,9.2,27.6,8.5,27,8.2z M26,22.1L16,28L6,22.1V9.9L16,4l10,5.9\tV22.1z"
    }
  }]);

  const Assembly16 = createSVGComponent('Assembly16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,25.4l-8-4.7v-9.4l8-4.7l8,4.7v9.4L16,25.4z M10,19.6l6,3.5l6-3.5v-7.1l-6-3.5l-6,3.5V19.6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,8.2L17,2.3C16.7,2.1,16.4,2,16,2s-0.7,0.1-1,0.3L5,8.2c-0.6,0.4-1,1-1,1.7v12.2c0,0.7,0.4,1.4,1,1.7l10,5.9\tc0.3,0.2,0.7,0.3,1,0.3s0.7-0.1,1-0.3l10-5.9c0.6-0.4,1-1,1-1.7V9.9C28,9.2,27.6,8.5,27,8.2z M26,22.1L16,28L6,22.1V9.9L16,4l10,5.9\tV22.1z"
    }
  }]);

  const AssemblyCluster32 = createSVGComponent('AssemblyCluster32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.3 4.9l-4.5-2.7C16.5 2.1 16.3 2 16 2s-.5.1-.7.2l-4.5 2.7C10.3 5.2 10 5.7 10 6.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3V6.2C22 5.7 21.7 5.2 21.3 4.9zM20 11.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V11.5zM29.3 18.9l-4.5-2.7C24.5 16.1 24.3 16 24 16s-.5.1-.7.2l-4.5 2.7c-.4.3-.7.7-.7 1.3v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C30 19.7 29.7 19.2 29.3 18.9zM28 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5zM13.3 18.9l-4.5-2.7C8.5 16.1 8.3 16 8 16s-.5.1-.7.2l-4.5 2.7C2.3 19.2 2 19.7 2 20.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7C7.5 29.9 7.7 30 8 30s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C14 19.7 13.7 19.2 13.3 18.9zM12 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5z"
    }
  }]);

  const AssemblyCluster24 = createSVGComponent('AssemblyCluster24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.3 4.9l-4.5-2.7C16.5 2.1 16.3 2 16 2s-.5.1-.7.2l-4.5 2.7C10.3 5.2 10 5.7 10 6.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3V6.2C22 5.7 21.7 5.2 21.3 4.9zM20 11.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V11.5zM29.3 18.9l-4.5-2.7C24.5 16.1 24.3 16 24 16s-.5.1-.7.2l-4.5 2.7c-.4.3-.7.7-.7 1.3v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C30 19.7 29.7 19.2 29.3 18.9zM28 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5zM13.3 18.9l-4.5-2.7C8.5 16.1 8.3 16 8 16s-.5.1-.7.2l-4.5 2.7C2.3 19.2 2 19.7 2 20.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7C7.5 29.9 7.7 30 8 30s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C14 19.7 13.7 19.2 13.3 18.9zM12 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5z"
    }
  }]);

  const AssemblyCluster20 = createSVGComponent('AssemblyCluster20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.3 4.9l-4.5-2.7C16.5 2.1 16.3 2 16 2s-.5.1-.7.2l-4.5 2.7C10.3 5.2 10 5.7 10 6.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3V6.2C22 5.7 21.7 5.2 21.3 4.9zM20 11.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V11.5zM29.3 18.9l-4.5-2.7C24.5 16.1 24.3 16 24 16s-.5.1-.7.2l-4.5 2.7c-.4.3-.7.7-.7 1.3v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C30 19.7 29.7 19.2 29.3 18.9zM28 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5zM13.3 18.9l-4.5-2.7C8.5 16.1 8.3 16 8 16s-.5.1-.7.2l-4.5 2.7C2.3 19.2 2 19.7 2 20.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7C7.5 29.9 7.7 30 8 30s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C14 19.7 13.7 19.2 13.3 18.9zM12 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5z"
    }
  }]);

  const AssemblyCluster16 = createSVGComponent('AssemblyCluster16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.3 4.9l-4.5-2.7C16.5 2.1 16.3 2 16 2s-.5.1-.7.2l-4.5 2.7C10.3 5.2 10 5.7 10 6.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3V6.2C22 5.7 21.7 5.2 21.3 4.9zM20 11.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V11.5zM29.3 18.9l-4.5-2.7C24.5 16.1 24.3 16 24 16s-.5.1-.7.2l-4.5 2.7c-.4.3-.7.7-.7 1.3v5.6c0 .5.3 1 .7 1.3l4.5 2.7c.2.1.5.2.7.2s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C30 19.7 29.7 19.2 29.3 18.9zM28 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5zM13.3 18.9l-4.5-2.7C8.5 16.1 8.3 16 8 16s-.5.1-.7.2l-4.5 2.7C2.3 19.2 2 19.7 2 20.2v5.6c0 .5.3 1 .7 1.3l4.5 2.7C7.5 29.9 7.7 30 8 30s.5-.1.7-.2l4.5-2.7c.4-.3.7-.7.7-1.3v-5.6C14 19.7 13.7 19.2 13.3 18.9zM12 25.5l-4 2.4-4-2.4v-5l4-2.4 4 2.4V25.5z"
    }
  }]);

  const AssemblyReference32 = createSVGComponent('AssemblyReference32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8.7 5.1H12.2V7.1H8.7z",
      "transform": "rotate(-30.582 10.48 6.101)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H4V9.9c0-.7.4-1.4 1-1.7l1.5-.9 1 1.7L6 9.9V12zM4 14H6V18H4zM6.5 24.7L5 23.8c-.6-.4-1-1-1-1.7V20h2v2.1L7.5 23 6.5 24.7z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9.5 24.1H11.5V27.6H9.5z",
      "transform": "rotate(-59.421 10.48 25.9)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,27.1L16,28l-1.5-0.9l-1,1.7l1.5,0.9c0.3,0.2,0.7,0.3,1,0.3c0.4,0,0.7-0.1,1-0.3l1.5-0.9L17.5,27.1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19.8 24.9H23.3V26.9H19.8z",
      "transform": "rotate(-30.582 21.502 25.912)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.2 24.9l-1-1.7 1.8-1V20h2v2.1c0 .7-.4 1.4-1 1.7L25.2 24.9zM26 14H28V18H26zM28 12h-2V9.9l-1.8-1 1-1.7 1.8 1c.6.4 1 1 1 1.7V12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.5 4.3H22.5V7.8H20.5z",
      "transform": "rotate(-59.421 21.501 6.089)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,4.9L16,4l-1.5,0.9l-1-1.7L15,2.3C15.3,2.1,15.6,2,16,2c0.4,0,0.7,0.1,1,0.3l1.5,0.9L17.5,4.9z"
    }
  }]);

  const AssemblyReference24 = createSVGComponent('AssemblyReference24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8.7 5.1H12.2V7.1H8.7z",
      "transform": "rotate(-30.582 10.48 6.101)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H4V9.9c0-.7.4-1.4 1-1.7l1.5-.9 1 1.7L6 9.9V12zM4 14H6V18H4zM6.5 24.7L5 23.8c-.6-.4-1-1-1-1.7V20h2v2.1L7.5 23 6.5 24.7z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9.5 24.1H11.5V27.6H9.5z",
      "transform": "rotate(-59.421 10.48 25.9)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,27.1L16,28l-1.5-0.9l-1,1.7l1.5,0.9c0.3,0.2,0.7,0.3,1,0.3c0.4,0,0.7-0.1,1-0.3l1.5-0.9L17.5,27.1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19.8 24.9H23.3V26.9H19.8z",
      "transform": "rotate(-30.582 21.502 25.912)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.2 24.9l-1-1.7 1.8-1V20h2v2.1c0 .7-.4 1.4-1 1.7L25.2 24.9zM26 14H28V18H26zM28 12h-2V9.9l-1.8-1 1-1.7 1.8 1c.6.4 1 1 1 1.7V12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.5 4.3H22.5V7.8H20.5z",
      "transform": "rotate(-59.421 21.501 6.089)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,4.9L16,4l-1.5,0.9l-1-1.7L15,2.3C15.3,2.1,15.6,2,16,2c0.4,0,0.7,0.1,1,0.3l1.5,0.9L17.5,4.9z"
    }
  }]);

  const AssemblyReference20 = createSVGComponent('AssemblyReference20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8.7 5.1H12.2V7.1H8.7z",
      "transform": "rotate(-30.582 10.48 6.101)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H4V9.9c0-.7.4-1.4 1-1.7l1.5-.9 1 1.7L6 9.9V12zM4 14H6V18H4zM6.5 24.7L5 23.8c-.6-.4-1-1-1-1.7V20h2v2.1L7.5 23 6.5 24.7z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9.5 24.1H11.5V27.6H9.5z",
      "transform": "rotate(-59.421 10.48 25.9)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,27.1L16,28l-1.5-0.9l-1,1.7l1.5,0.9c0.3,0.2,0.7,0.3,1,0.3c0.4,0,0.7-0.1,1-0.3l1.5-0.9L17.5,27.1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19.8 24.9H23.3V26.9H19.8z",
      "transform": "rotate(-30.582 21.502 25.912)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.2 24.9l-1-1.7 1.8-1V20h2v2.1c0 .7-.4 1.4-1 1.7L25.2 24.9zM26 14H28V18H26zM28 12h-2V9.9l-1.8-1 1-1.7 1.8 1c.6.4 1 1 1 1.7V12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.5 4.3H22.5V7.8H20.5z",
      "transform": "rotate(-59.421 21.501 6.089)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,4.9L16,4l-1.5,0.9l-1-1.7L15,2.3C15.3,2.1,15.6,2,16,2c0.4,0,0.7,0.1,1,0.3l1.5,0.9L17.5,4.9z"
    }
  }]);

  const AssemblyReference16 = createSVGComponent('AssemblyReference16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8.7 5.1H12.2V7.1H8.7z",
      "transform": "rotate(-30.582 10.48 6.101)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H4V9.9c0-.7.4-1.4 1-1.7l1.5-.9 1 1.7L6 9.9V12zM4 14H6V18H4zM6.5 24.7L5 23.8c-.6-.4-1-1-1-1.7V20h2v2.1L7.5 23 6.5 24.7z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9.5 24.1H11.5V27.6H9.5z",
      "transform": "rotate(-59.421 10.48 25.9)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,27.1L16,28l-1.5-0.9l-1,1.7l1.5,0.9c0.3,0.2,0.7,0.3,1,0.3c0.4,0,0.7-0.1,1-0.3l1.5-0.9L17.5,27.1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19.8 24.9H23.3V26.9H19.8z",
      "transform": "rotate(-30.582 21.502 25.912)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.2 24.9l-1-1.7 1.8-1V20h2v2.1c0 .7-.4 1.4-1 1.7L25.2 24.9zM26 14H28V18H26zM28 12h-2V9.9l-1.8-1 1-1.7 1.8 1c.6.4 1 1 1 1.7V12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.5 4.3H22.5V7.8H20.5z",
      "transform": "rotate(-59.421 21.501 6.089)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.5,4.9L16,4l-1.5,0.9l-1-1.7L15,2.3C15.3,2.1,15.6,2,16,2c0.4,0,0.7,0.1,1,0.3l1.5,0.9L17.5,4.9z"
    }
  }]);

  const Asset32 = createSVGComponent('Asset32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
    }
  }]);

  const Asset24 = createSVGComponent('Asset24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
    }
  }]);

  const Asset20 = createSVGComponent('Asset20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
    }
  }]);

  const Asset16 = createSVGComponent('Asset16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
    }
  }]);

  const AssetConfirm32 = createSVGComponent('AssetConfirm32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 27.18L18.41 24.59 17 26 21 30 28 23 26.59 21.59 21 27.18zM12 24a4 4 0 114-4A4.0042 4.0042 0 0112 24zm0-6a2 2 0 102 2A2.0023 2.0023 0 0012 18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30a9.3445,9.3445,0,0,0,2-.21V27.75A8.2289,8.2289,0,0,1,12,28a8,8,0,1,1,8-8,8.2656,8.2656,0,0,1-.06,1h2.78L29.56,7.79A3.9727,3.9727,0,0,0,26,2ZM21.86,18.34a10.0187,10.0187,0,0,0-8.22-8.19l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02ZM26,8a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetConfirm24 = createSVGComponent('AssetConfirm24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 27.18L18.41 24.59 17 26 21 30 28 23 26.59 21.59 21 27.18zM12 24a4 4 0 114-4A4.0042 4.0042 0 0112 24zm0-6a2 2 0 102 2A2.0023 2.0023 0 0012 18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30a9.3445,9.3445,0,0,0,2-.21V27.75A8.2289,8.2289,0,0,1,12,28a8,8,0,1,1,8-8,8.2656,8.2656,0,0,1-.06,1h2.78L29.56,7.79A3.9727,3.9727,0,0,0,26,2ZM21.86,18.34a10.0187,10.0187,0,0,0-8.22-8.19l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02ZM26,8a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetConfirm20 = createSVGComponent('AssetConfirm20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 27.18L18.41 24.59 17 26 21 30 28 23 26.59 21.59 21 27.18zM12 24a4 4 0 114-4A4.0042 4.0042 0 0112 24zm0-6a2 2 0 102 2A2.0023 2.0023 0 0012 18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30a9.3445,9.3445,0,0,0,2-.21V27.75A8.2289,8.2289,0,0,1,12,28a8,8,0,1,1,8-8,8.2656,8.2656,0,0,1-.06,1h2.78L29.56,7.79A3.9727,3.9727,0,0,0,26,2ZM21.86,18.34a10.0187,10.0187,0,0,0-8.22-8.19l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02ZM26,8a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetConfirm16 = createSVGComponent('AssetConfirm16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 27.18L18.41 24.59 17 26 21 30 28 23 26.59 21.59 21 27.18zM12 24a4 4 0 114-4A4.0042 4.0042 0 0112 24zm0-6a2 2 0 102 2A2.0023 2.0023 0 0012 18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30a9.3445,9.3445,0,0,0,2-.21V27.75A8.2289,8.2289,0,0,1,12,28a8,8,0,1,1,8-8,8.2656,8.2656,0,0,1-.06,1h2.78L29.56,7.79A3.9727,3.9727,0,0,0,26,2ZM21.86,18.34a10.0187,10.0187,0,0,0-8.22-8.19l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02ZM26,8a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetDigitalTwin32 = createSVGComponent('AssetDigitalTwin32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "25",
      "cy": "7",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,23a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,12,23Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,12,19Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "14",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.909",
      "cy": "5.705",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9.787",
      "cy": "9.907",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.495",
      "cy": "8.506",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15.201",
      "cy": "7.105",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.696",
      "cy": "13.187",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.133",
      "cy": "21.631",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3.079",
      "cy": "24.516",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.848",
      "cy": "26.982",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.272",
      "cy": "28.81",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.098",
      "cy": "18.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.979",
      "cy": "15.691",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.081",
      "cy": "11.308",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.616",
      "cy": "4.304",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.323",
      "cy": "2.903",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.988",
      "cy": "8.89",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27.587",
      "cy": "11.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.186",
      "cy": "14.303",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "24.784",
      "cy": "17.01",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.383",
      "cy": "19.717",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21.982",
      "cy": "22.424",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.637",
      "cy": "27.464",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16.092",
      "cy": "29.122",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.166",
      "cy": "29.932",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10.133",
      "cy": "29.825",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.572",
      "cy": "25.125",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.893",
      "cy": "3.24",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.188",
      "cy": "2.004",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "30",
      "cy": "6.026",
      "r": "1"
    }
  }]);

  const AssetDigitalTwin24 = createSVGComponent('AssetDigitalTwin24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "25",
      "cy": "7",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,23a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,12,23Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,12,19Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "14",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.909",
      "cy": "5.705",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9.787",
      "cy": "9.907",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.495",
      "cy": "8.506",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15.201",
      "cy": "7.105",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.696",
      "cy": "13.187",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.133",
      "cy": "21.631",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3.079",
      "cy": "24.516",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.848",
      "cy": "26.982",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.272",
      "cy": "28.81",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.098",
      "cy": "18.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.979",
      "cy": "15.691",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.081",
      "cy": "11.308",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.616",
      "cy": "4.304",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.323",
      "cy": "2.903",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.988",
      "cy": "8.89",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27.587",
      "cy": "11.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.186",
      "cy": "14.303",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "24.784",
      "cy": "17.01",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.383",
      "cy": "19.717",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21.982",
      "cy": "22.424",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.637",
      "cy": "27.464",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16.092",
      "cy": "29.122",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.166",
      "cy": "29.932",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10.133",
      "cy": "29.825",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.572",
      "cy": "25.125",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.893",
      "cy": "3.24",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.188",
      "cy": "2.004",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "30",
      "cy": "6.026",
      "r": "1"
    }
  }]);

  const AssetDigitalTwin20 = createSVGComponent('AssetDigitalTwin20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "25",
      "cy": "7",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,23a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,12,23Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,12,19Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "14",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.909",
      "cy": "5.705",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9.787",
      "cy": "9.907",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.495",
      "cy": "8.506",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15.201",
      "cy": "7.105",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.696",
      "cy": "13.187",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.133",
      "cy": "21.631",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3.079",
      "cy": "24.516",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.848",
      "cy": "26.982",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.272",
      "cy": "28.81",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.098",
      "cy": "18.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.979",
      "cy": "15.691",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.081",
      "cy": "11.308",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.616",
      "cy": "4.304",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.323",
      "cy": "2.903",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.988",
      "cy": "8.89",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27.587",
      "cy": "11.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.186",
      "cy": "14.303",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "24.784",
      "cy": "17.01",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.383",
      "cy": "19.717",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21.982",
      "cy": "22.424",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.637",
      "cy": "27.464",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16.092",
      "cy": "29.122",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.166",
      "cy": "29.932",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10.133",
      "cy": "29.825",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.572",
      "cy": "25.125",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.893",
      "cy": "3.24",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.188",
      "cy": "2.004",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "30",
      "cy": "6.026",
      "r": "1"
    }
  }]);

  const AssetDigitalTwin16 = createSVGComponent('AssetDigitalTwin16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "25",
      "cy": "7",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,23a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,12,23Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,12,19Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "14",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.909",
      "cy": "5.705",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9.787",
      "cy": "9.907",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.495",
      "cy": "8.506",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15.201",
      "cy": "7.105",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.696",
      "cy": "13.187",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.133",
      "cy": "21.631",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3.079",
      "cy": "24.516",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4.848",
      "cy": "26.982",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.272",
      "cy": "28.81",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.098",
      "cy": "18.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "2.979",
      "cy": "15.691",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7.081",
      "cy": "11.308",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.616",
      "cy": "4.304",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.323",
      "cy": "2.903",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.988",
      "cy": "8.89",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27.587",
      "cy": "11.596",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.186",
      "cy": "14.303",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "24.784",
      "cy": "17.01",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "23.383",
      "cy": "19.717",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21.982",
      "cy": "22.424",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18.637",
      "cy": "27.464",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16.092",
      "cy": "29.122",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.166",
      "cy": "29.932",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10.133",
      "cy": "29.825",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20.572",
      "cy": "25.125",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28.893",
      "cy": "3.24",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26.188",
      "cy": "2.004",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "20",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "14.804",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "25.196",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6.804",
      "cy": "23",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "17.196",
      "cy": "17",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "30",
      "cy": "6.026",
      "r": "1"
    }
  }]);

  const AssetView32 = createSVGComponent('AssetView32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29.7769 23.4785A8.64 8.64 0 0022 18a8.64 8.64 0 00-7.7769 5.4785L14 24l.2231.5215A8.64 8.64 0 0022 30a8.64 8.64 0 007.7769-5.4785L30 24zM22 28a4 4 0 114-4A4.0045 4.0045 0 0122 28zM12 24a4 4 0 112.981-6.667l-1.49 1.334A2 2 0 1012 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30V28a8,8,0,1,1,5.63-13.68l1.4-1.4a10.0059,10.0059,0,0,0-5.39-2.77l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02L23.07,16h2.24l4.25-8.21A3.9727,3.9727,0,0,0,26,2Zm0,6a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetView24 = createSVGComponent('AssetView24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29.7769 23.4785A8.64 8.64 0 0022 18a8.64 8.64 0 00-7.7769 5.4785L14 24l.2231.5215A8.64 8.64 0 0022 30a8.64 8.64 0 007.7769-5.4785L30 24zM22 28a4 4 0 114-4A4.0045 4.0045 0 0122 28zM12 24a4 4 0 112.981-6.667l-1.49 1.334A2 2 0 1012 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30V28a8,8,0,1,1,5.63-13.68l1.4-1.4a10.0059,10.0059,0,0,0-5.39-2.77l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02L23.07,16h2.24l4.25-8.21A3.9727,3.9727,0,0,0,26,2Zm0,6a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetView20 = createSVGComponent('AssetView20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29.7769 23.4785A8.64 8.64 0 0022 18a8.64 8.64 0 00-7.7769 5.4785L14 24l.2231.5215A8.64 8.64 0 0022 30a8.64 8.64 0 007.7769-5.4785L30 24zM22 28a4 4 0 114-4A4.0045 4.0045 0 0122 28zM12 24a4 4 0 112.981-6.667l-1.49 1.334A2 2 0 1012 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30V28a8,8,0,1,1,5.63-13.68l1.4-1.4a10.0059,10.0059,0,0,0-5.39-2.77l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02L23.07,16h2.24l4.25-8.21A3.9727,3.9727,0,0,0,26,2Zm0,6a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const AssetView16 = createSVGComponent('AssetView16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29.7769 23.4785A8.64 8.64 0 0022 18a8.64 8.64 0 00-7.7769 5.4785L14 24l.2231.5215A8.64 8.64 0 0022 30a8.64 8.64 0 007.7769-5.4785L30 24zM22 28a4 4 0 114-4A4.0045 4.0045 0 0122 28zM12 24a4 4 0 112.981-6.667l-1.49 1.334A2 2 0 1012 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,2a3.86,3.86,0,0,0-1.85.48L7.76,10.96A9.99,9.99,0,0,0,12,30V28a8,8,0,1,1,5.63-13.68l1.4-1.4a10.0059,10.0059,0,0,0-5.39-2.77l8.38-4.34c0,.06-.02.12-.02.19a3.9989,3.9989,0,0,0,4,4c.06,0,.12-.02.19-.02L23.07,16h2.24l4.25-8.21A3.9727,3.9727,0,0,0,26,2Zm0,6a2,2,0,1,1,2-2A2.0058,2.0058,0,0,1,26,8Z"
    }
  }]);

  const Asterisk32 = createSVGComponent('Asterisk32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.316 13.949L27.684 12.051 17 15.612 17 4 15 4 15 15.612 4.316 12.051 3.684 13.949 14.368 17.51 7.2 27.066 8.8 28.267 16 18.667 23.2 28.267 24.8 27.066 17.632 17.51 28.316 13.949z"
    }
  }]);

  const Asterisk24 = createSVGComponent('Asterisk24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.316 13.949L27.684 12.051 17 15.612 17 4 15 4 15 15.612 4.316 12.051 3.684 13.949 14.368 17.51 7.2 27.066 8.8 28.267 16 18.667 23.2 28.267 24.8 27.066 17.632 17.51 28.316 13.949z"
    }
  }]);

  const Asterisk20 = createSVGComponent('Asterisk20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.316 13.949L27.684 12.051 17 15.612 17 4 15 4 15 15.612 4.316 12.051 3.684 13.949 14.368 17.51 7.2 27.066 8.8 28.267 16 18.667 23.2 28.267 24.8 27.066 17.632 17.51 28.316 13.949z"
    }
  }]);

  const Asterisk16 = createSVGComponent('Asterisk16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.316 13.949L27.684 12.051 17 15.612 17 4 15 4 15 15.612 4.316 12.051 3.684 13.949 14.368 17.51 7.2 27.066 8.8 28.267 16 18.667 23.2 28.267 24.8 27.066 17.632 17.51 28.316 13.949z"
    }
  }]);

  const At32 = createSVGComponent('At32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
    }
  }]);

  const At24 = createSVGComponent('At24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
    }
  }]);

  const At20 = createSVGComponent('At20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
    }
  }]);

  const At16 = createSVGComponent('At16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
    }
  }]);

  const Attachment32 = createSVGComponent('Attachment32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
    }
  }]);

  const Attachment24 = createSVGComponent('Attachment24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
    }
  }]);

  const Attachment20 = createSVGComponent('Attachment20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
    }
  }]);

  const Attachment16 = createSVGComponent('Attachment16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
    }
  }]);

  const AudioConsole32 = createSVGComponent('AudioConsole32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 14H27V2H25V14H24a2.0019 2.0019 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0028 14zm0 4H24V16h4zM18 6H17V2H15V6H14a2.0019 2.0019 0 00-2 2v2a2.0019 2.0019 0 002 2h1V30h2V12h1a2.002 2.002 0 002-2V8A2.002 2.002 0 0018 6zm0 4H14V8h4zM8 20H7V2H5V20H4a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H5v4H7V26H8a2.0023 2.0023 0 002-2V22A2.0023 2.0023 0 008 20zm0 4H4V22H8z",
      "transform": "translate(0 .005)"
    }
  }]);

  const AudioConsole24 = createSVGComponent('AudioConsole24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 14H27V2H25V14H24a2.0019 2.0019 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0028 14zm0 4H24V16h4zM18 6H17V2H15V6H14a2.0019 2.0019 0 00-2 2v2a2.0019 2.0019 0 002 2h1V30h2V12h1a2.002 2.002 0 002-2V8A2.002 2.002 0 0018 6zm0 4H14V8h4zM8 20H7V2H5V20H4a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H5v4H7V26H8a2.0023 2.0023 0 002-2V22A2.0023 2.0023 0 008 20zm0 4H4V22H8z",
      "transform": "translate(0 .005)"
    }
  }]);

  const AudioConsole20 = createSVGComponent('AudioConsole20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 14H27V2H25V14H24a2.0019 2.0019 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0028 14zm0 4H24V16h4zM18 6H17V2H15V6H14a2.0019 2.0019 0 00-2 2v2a2.0019 2.0019 0 002 2h1V30h2V12h1a2.002 2.002 0 002-2V8A2.002 2.002 0 0018 6zm0 4H14V8h4zM8 20H7V2H5V20H4a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H5v4H7V26H8a2.0023 2.0023 0 002-2V22A2.0023 2.0023 0 008 20zm0 4H4V22H8z",
      "transform": "translate(0 .005)"
    }
  }]);

  const AudioConsole16 = createSVGComponent('AudioConsole16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 14H27V2H25V14H24a2.0019 2.0019 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0028 14zm0 4H24V16h4zM18 6H17V2H15V6H14a2.0019 2.0019 0 00-2 2v2a2.0019 2.0019 0 002 2h1V30h2V12h1a2.002 2.002 0 002-2V8A2.002 2.002 0 0018 6zm0 4H14V8h4zM8 20H7V2H5V20H4a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H5v4H7V26H8a2.0023 2.0023 0 002-2V22A2.0023 2.0023 0 008 20zm0 4H4V22H8z",
      "transform": "translate(0 .005)"
    }
  }]);

  const AugmentedReality32 = createSVGComponent('AugmentedReality32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
    }
  }]);

  const AugmentedReality24 = createSVGComponent('AugmentedReality24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
    }
  }]);

  const AugmentedReality20 = createSVGComponent('AugmentedReality20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
    }
  }]);

  const AugmentedReality16 = createSVGComponent('AugmentedReality16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "13.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
    }
  }]);

  const WatsonHealthAutoScroll32 = createSVGComponent('WatsonHealthAutoScroll32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
    }
  }]);

  const WatsonHealthAutoScroll24 = createSVGComponent('WatsonHealthAutoScroll24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
    }
  }]);

  const WatsonHealthAutoScroll20 = createSVGComponent('WatsonHealthAutoScroll20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
    }
  }]);

  const WatsonHealthAutoScroll16 = createSVGComponent('WatsonHealthAutoScroll16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
    }
  }]);

  const Automatic32 = createSVGComponent('Automatic32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
    }
  }]);

  const Automatic24 = createSVGComponent('Automatic24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
    }
  }]);

  const Automatic20 = createSVGComponent('Automatic20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
    }
  }]);

  const Automatic16 = createSVGComponent('Automatic16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
    }
  }]);

  const Autoscaling32 = createSVGComponent('Autoscaling32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28H12V26H22V10H6V20H4V10A2.0021,2.0021,0,0,1,6,8H22a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,22,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H26V20h2V4H12V6H10V4a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2V20A2.0021,2.0021,0,0,1,28,22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 14L10 16 14.586 16 3 27.586 4.414 29 16 17.414 16 22 18 22 18 14 10 14z"
    }
  }]);

  const Autoscaling24 = createSVGComponent('Autoscaling24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28H12V26H22V10H6V20H4V10A2.0021,2.0021,0,0,1,6,8H22a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,22,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H26V20h2V4H12V6H10V4a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2V20A2.0021,2.0021,0,0,1,28,22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 14L10 16 14.586 16 3 27.586 4.414 29 16 17.414 16 22 18 22 18 14 10 14z"
    }
  }]);

  const Autoscaling20 = createSVGComponent('Autoscaling20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28H12V26H22V10H6V20H4V10A2.0021,2.0021,0,0,1,6,8H22a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,22,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H26V20h2V4H12V6H10V4a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2V20A2.0021,2.0021,0,0,1,28,22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 14L10 16 14.586 16 3 27.586 4.414 29 16 17.414 16 22 18 22 18 14 10 14z"
    }
  }]);

  const Autoscaling16 = createSVGComponent('Autoscaling16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28H12V26H22V10H6V20H4V10A2.0021,2.0021,0,0,1,6,8H22a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,22,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H26V20h2V4H12V6H10V4a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2V20A2.0021,2.0021,0,0,1,28,22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 14L10 16 14.586 16 3 27.586 4.414 29 16 17.414 16 22 18 22 18 14 10 14z"
    }
  }]);

  const Awake32 = createSVGComponent('Awake32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V6.96H15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.67 6.85H26.630000000000003V8.85H21.67z",
      "transform": "rotate(-45 24.142 7.85)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.04 15H30V17H25.04z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.15 21.67H25.15V26.630000000000003H23.15z",
      "transform": "rotate(-45 24.152 24.146)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 25.04H17V30H15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.37 23.15H10.33V25.15H5.37z",
      "transform": "rotate(-45 7.86 24.144)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M2 15H6.96V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.85 5.37H8.85V10.33H6.85z",
      "transform": "rotate(-45 7.85 7.848)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"
    }
  }]);

  const Awake24 = createSVGComponent('Awake24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V6.96H15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.67 6.85H26.630000000000003V8.85H21.67z",
      "transform": "rotate(-45 24.142 7.85)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.04 15H30V17H25.04z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.15 21.67H25.15V26.630000000000003H23.15z",
      "transform": "rotate(-45 24.152 24.146)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 25.04H17V30H15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.37 23.15H10.33V25.15H5.37z",
      "transform": "rotate(-45 7.86 24.144)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M2 15H6.96V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.85 5.37H8.85V10.33H6.85z",
      "transform": "rotate(-45 7.85 7.848)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"
    }
  }]);

  const Awake20 = createSVGComponent('Awake20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V6.96H15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.67 6.85H26.630000000000003V8.85H21.67z",
      "transform": "rotate(-45 24.142 7.85)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.04 15H30V17H25.04z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.15 21.67H25.15V26.630000000000003H23.15z",
      "transform": "rotate(-45 24.152 24.146)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 25.04H17V30H15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.37 23.15H10.33V25.15H5.37z",
      "transform": "rotate(-45 7.86 24.144)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M2 15H6.96V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.85 5.37H8.85V10.33H6.85z",
      "transform": "rotate(-45 7.85 7.848)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"
    }
  }]);

  const Awake16 = createSVGComponent('Awake16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.5 1H8.5V3.5H7.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10.8 3.4H13.3V4.4H10.8z",
      "transform": "rotate(-45.001 12.074 3.922)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12.5 7.5H15V8.5H12.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11.6 10.8H12.6V13.3H11.6z",
      "transform": "rotate(-45.001 12.077 12.075)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7.5 12.5H8.5V15H7.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M2.7 11.6H5.2V12.6H2.7z",
      "transform": "rotate(-45.001 3.929 12.078)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M1 7.5H3.5V8.5H1z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3.4 2.7H4.4V5.2H3.4z",
      "transform": "rotate(-45.001 3.926 3.925)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,6c1.1,0,2,0.9,2,2s-0.9,2-2,2S6,9.1,6,8S6.9,6,8,6 M8,5C6.3,5,5,6.3,5,8s1.3,3,3,3s3-1.3,3-3S9.7,5,8,5z"
    }
  }]);

  const Badge32 = createSVGComponent('Badge32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
    }
  }]);

  const Badge24 = createSVGComponent('Badge24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
    }
  }]);

  const Badge20 = createSVGComponent('Badge20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
    }
  }]);

  const Badge16 = createSVGComponent('Badge16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
    }
  }]);

  const BaggageClaim32 = createSVGComponent('BaggageClaim32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,18H25V16a2.0023,2.0023,0,0,0-2-2H19a2.0023,2.0023,0,0,0-2,2v2H14a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V20A2.0023,2.0023,0,0,0,28,18Zm-9-2h4v2H19Zm9,12H14V20H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10,6h4v6h2V6h4v6h2V6h4v6h2V6.0049A2.0047,2.0047,0,0,0,25.9951,4H4.0049A2.0047,2.0047,0,0,0,2,6.0049v13.99A2.0047,2.0047,0,0,0,4.0049,22H10ZM8,20H4V6H8Z"
    }
  }]);

  const BaggageClaim24 = createSVGComponent('BaggageClaim24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,18H25V16a2.0023,2.0023,0,0,0-2-2H19a2.0023,2.0023,0,0,0-2,2v2H14a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V20A2.0023,2.0023,0,0,0,28,18Zm-9-2h4v2H19Zm9,12H14V20H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10,6h4v6h2V6h4v6h2V6h4v6h2V6.0049A2.0047,2.0047,0,0,0,25.9951,4H4.0049A2.0047,2.0047,0,0,0,2,6.0049v13.99A2.0047,2.0047,0,0,0,4.0049,22H10ZM8,20H4V6H8Z"
    }
  }]);

  const BaggageClaim20 = createSVGComponent('BaggageClaim20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,18H25V16a2.0023,2.0023,0,0,0-2-2H19a2.0023,2.0023,0,0,0-2,2v2H14a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V20A2.0023,2.0023,0,0,0,28,18Zm-9-2h4v2H19Zm9,12H14V20H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10,6h4v6h2V6h4v6h2V6h4v6h2V6.0049A2.0047,2.0047,0,0,0,25.9951,4H4.0049A2.0047,2.0047,0,0,0,2,6.0049v13.99A2.0047,2.0047,0,0,0,4.0049,22H10ZM8,20H4V6H8Z"
    }
  }]);

  const BaggageClaim16 = createSVGComponent('BaggageClaim16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,18H25V16a2.0023,2.0023,0,0,0-2-2H19a2.0023,2.0023,0,0,0-2,2v2H14a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V20A2.0023,2.0023,0,0,0,28,18Zm-9-2h4v2H19Zm9,12H14V20H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10,6h4v6h2V6h4v6h2V6h4v6h2V6.0049A2.0047,2.0047,0,0,0,25.9951,4H4.0049A2.0047,2.0047,0,0,0,2,6.0049v13.99A2.0047,2.0047,0,0,0,4.0049,22H10ZM8,20H4V6H8Z"
    }
  }]);

  const Bar32 = createSVGComponent('Bar32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
    }
  }]);

  const Bar24 = createSVGComponent('Bar24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
    }
  }]);

  const Bar20 = createSVGComponent('Bar20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
    }
  }]);

  const Bar16 = createSVGComponent('Bar16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
    }
  }]);

  const Barcode32 = createSVGComponent('Barcode32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 6H4V28H2zM12 6H14V26H12zM6 6H10V26H6zM16 6H20V26H16zM22 6H26V26H22zM28 6H30V28H28z"
    }
  }]);

  const Barcode24 = createSVGComponent('Barcode24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 6H4V28H2zM12 6H14V26H12zM6 6H10V26H6zM16 6H20V26H16zM22 6H26V26H22zM28 6H30V28H28z"
    }
  }]);

  const Barcode20 = createSVGComponent('Barcode20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 6H4V28H2zM12 6H14V26H12zM6 6H10V26H6zM16 6H20V26H16zM22 6H26V26H22zM28 6H30V28H28z"
    }
  }]);

  const Barcode16 = createSVGComponent('Barcode16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 6H4V28H2zM12 6H14V26H12zM6 6H10V26H6zM16 6H20V26H16zM22 6H26V26H22zM28 6H30V28H28z"
    }
  }]);

  const BareMetalServer32 = createSVGComponent('BareMetalServer32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0021,2.0021,0,0,1,4,8V4A2.0021,2.0021,0,0,1,6,2H26a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0021,2.0021,0,0,1-2-2V14a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,30ZM6,24v4H26V24Z"
    }
  }]);

  const BareMetalServer24 = createSVGComponent('BareMetalServer24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0021,2.0021,0,0,1,4,8V4A2.0021,2.0021,0,0,1,6,2H26a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0021,2.0021,0,0,1-2-2V14a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,30ZM6,24v4H26V24Z"
    }
  }]);

  const BareMetalServer20 = createSVGComponent('BareMetalServer20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0021,2.0021,0,0,1,4,8V4A2.0021,2.0021,0,0,1,6,2H26a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0021,2.0021,0,0,1-2-2V14a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,30ZM6,24v4H26V24Z"
    }
  }]);

  const BareMetalServer16 = createSVGComponent('BareMetalServer16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0021,2.0021,0,0,1,4,8V4A2.0021,2.0021,0,0,1,6,2H26a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0021,2.0021,0,0,1-2-2V14a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "26",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,30H6a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H26a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,26,30ZM6,24v4H26V24Z"
    }
  }]);

  const BareMetalServer_0132 = createSVGComponent('BareMetalServer_0132', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }]);

  const BareMetalServer_0124 = createSVGComponent('BareMetalServer_0124', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }]);

  const BareMetalServer_0120 = createSVGComponent('BareMetalServer_0120', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }]);

  const BareMetalServer_0116 = createSVGComponent('BareMetalServer_0116', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }]);

  const BareMetalServer_0232 = createSVGComponent('BareMetalServer_0232', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0023,2.0023,0,0,1,4,8V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V8A2.0023,2.0023,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }]);

  const BareMetalServer_0224 = createSVGComponent('BareMetalServer_0224', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0023,2.0023,0,0,1,4,8V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V8A2.0023,2.0023,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }]);

  const BareMetalServer_0220 = createSVGComponent('BareMetalServer_0220', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0023,2.0023,0,0,1,4,8V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V8A2.0023,2.0023,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }]);

  const BareMetalServer_0216 = createSVGComponent('BareMetalServer_0216', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17 28L17 22 15 22 15 28 5 28 5 30 27 30 27 28 17 28z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H6a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,20ZM6,14v4H26V14Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,10H6A2.0023,2.0023,0,0,1,4,8V4A2.0023,2.0023,0,0,1,6,2H26a2.0023,2.0023,0,0,1,2,2V8A2.0023,2.0023,0,0,1,26,10ZM6,4V8H26V4Z"
    }
  }]);

  const QBarrier32 = createSVGComponent('QBarrier32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
    }
  }]);

  const QBarrier24 = createSVGComponent('QBarrier24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
    }
  }]);

  const QBarrier20 = createSVGComponent('QBarrier20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
    }
  }]);

  const QBarrier16 = createSVGComponent('QBarrier16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
    }
  }]);

  const Basketball32 = createSVGComponent('Basketball32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
    }
  }]);

  const Basketball24 = createSVGComponent('Basketball24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
    }
  }]);

  const Basketball20 = createSVGComponent('Basketball20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
    }
  }]);

  const Basketball16 = createSVGComponent('Basketball16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
    }
  }]);

  const BastionHost32 = createSVGComponent('BastionHost32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5273,2.709A1.9955,1.9955,0,0,0,26,2H23.3091a1.5,1.5,0,0,0-1.3419.8294L21.3818,4H20V3.5A1.5,1.5,0,0,0,18.5,2h-5A1.5,1.5,0,0,0,12,3.5V4H10.6182l-.585-1.17A1.5017,1.5017,0,0,0,8.69,2H6A2,2,0,0,0,4.0283,4.333L4.7324,8.5A3,3,0,0,0,7.69,11H8V23a3.0033,3.0033,0,0,0-3,3v4H27V26a3.0033,3.0033,0,0,0-3-3V11h.31a3,3,0,0,0,2.9579-2.5l.7041-4.167A1.994,1.994,0,0,0,27.5273,2.709ZM25,26v2H7V26a1.0009,1.0009,0,0,1,1-1H24A1.0009,1.0009,0,0,1,25,26Zm-3-3H10V11H22ZM25.2959,8.167A.9976.9976,0,0,1,24.31,9H7.69a.9976.9976,0,0,1-.9863-.8335L6,4H8.3818l1,2H14V4h4V6h4.6172l1.001-2H26Z"
    }
  }]);

  const BastionHost24 = createSVGComponent('BastionHost24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5273,2.709A1.9955,1.9955,0,0,0,26,2H23.3091a1.5,1.5,0,0,0-1.3419.8294L21.3818,4H20V3.5A1.5,1.5,0,0,0,18.5,2h-5A1.5,1.5,0,0,0,12,3.5V4H10.6182l-.585-1.17A1.5017,1.5017,0,0,0,8.69,2H6A2,2,0,0,0,4.0283,4.333L4.7324,8.5A3,3,0,0,0,7.69,11H8V23a3.0033,3.0033,0,0,0-3,3v4H27V26a3.0033,3.0033,0,0,0-3-3V11h.31a3,3,0,0,0,2.9579-2.5l.7041-4.167A1.994,1.994,0,0,0,27.5273,2.709ZM25,26v2H7V26a1.0009,1.0009,0,0,1,1-1H24A1.0009,1.0009,0,0,1,25,26Zm-3-3H10V11H22ZM25.2959,8.167A.9976.9976,0,0,1,24.31,9H7.69a.9976.9976,0,0,1-.9863-.8335L6,4H8.3818l1,2H14V4h4V6h4.6172l1.001-2H26Z"
    }
  }]);

  const BastionHost20 = createSVGComponent('BastionHost20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5273,2.709A1.9955,1.9955,0,0,0,26,2H23.3091a1.5,1.5,0,0,0-1.3419.8294L21.3818,4H20V3.5A1.5,1.5,0,0,0,18.5,2h-5A1.5,1.5,0,0,0,12,3.5V4H10.6182l-.585-1.17A1.5017,1.5017,0,0,0,8.69,2H6A2,2,0,0,0,4.0283,4.333L4.7324,8.5A3,3,0,0,0,7.69,11H8V23a3.0033,3.0033,0,0,0-3,3v4H27V26a3.0033,3.0033,0,0,0-3-3V11h.31a3,3,0,0,0,2.9579-2.5l.7041-4.167A1.994,1.994,0,0,0,27.5273,2.709ZM25,26v2H7V26a1.0009,1.0009,0,0,1,1-1H24A1.0009,1.0009,0,0,1,25,26Zm-3-3H10V11H22ZM25.2959,8.167A.9976.9976,0,0,1,24.31,9H7.69a.9976.9976,0,0,1-.9863-.8335L6,4H8.3818l1,2H14V4h4V6h4.6172l1.001-2H26Z"
    }
  }]);

  const BastionHost16 = createSVGComponent('BastionHost16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5273,2.709A1.9955,1.9955,0,0,0,26,2H23.3091a1.5,1.5,0,0,0-1.3419.8294L21.3818,4H20V3.5A1.5,1.5,0,0,0,18.5,2h-5A1.5,1.5,0,0,0,12,3.5V4H10.6182l-.585-1.17A1.5017,1.5017,0,0,0,8.69,2H6A2,2,0,0,0,4.0283,4.333L4.7324,8.5A3,3,0,0,0,7.69,11H8V23a3.0033,3.0033,0,0,0-3,3v4H27V26a3.0033,3.0033,0,0,0-3-3V11h.31a3,3,0,0,0,2.9579-2.5l.7041-4.167A1.994,1.994,0,0,0,27.5273,2.709ZM25,26v2H7V26a1.0009,1.0009,0,0,1,1-1H24A1.0009,1.0009,0,0,1,25,26Zm-3-3H10V11H22ZM25.2959,8.167A.9976.9976,0,0,1,24.31,9H7.69a.9976.9976,0,0,1-.9863-.8335L6,4H8.3818l1,2H14V4h4V6h4.6172l1.001-2H26Z"
    }
  }]);

  const Bat32 = createSVGComponent('Bat32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.9093,6.584A1,1,0,0,0,31,6c-4.7683,0-8.2607.8887-11,2.8438V3H18V6H14V3H12V8.8438C9.2608,6.8887,5.7684,6,1,6A1,1,0,0,0,.2437,7.6543C1.9454,9.6221,3,11.7041,3,16a1,1,0,0,0,1,1c2.7678,0,6,1.31,6,5a1.004,1.004,0,0,0,.9341.998C11.35,23.0273,15,23.3872,15,27a1,1,0,0,0,2,0c0-3.6128,3.65-3.9727,4.0622-4.002A1,1,0,0,0,22,22c0-3.69,3.2321-5,6-5a1,1,0,0,0,1-1c0-4.2959,1.0547-6.3779,2.7564-8.3457A1,1,0,0,0,31.9093,6.584Zm-4.893,8.46c-3.3857.3081-6.5534,2.229-6.97,6.0786A6.552,6.552,0,0,0,16,23.6094a6.552,6.552,0,0,0-4.0461-2.4864c-.4168-3.85-3.5845-5.7705-6.97-6.0786a13.2017,13.2017,0,0,0-1.9387-6.98c4.1318.2724,7.0327,1.4277,9.248,3.6425A1,1,0,0,0,14,11V8h4v3a1,1,0,0,0,1.707.707c2.2153-2.2148,5.1162-3.37,9.248-3.6425A13.2017,13.2017,0,0,0,27.0163,15.0444Z"
    }
  }]);

  const Bat24 = createSVGComponent('Bat24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.9093,6.584A1,1,0,0,0,31,6c-4.7683,0-8.2607.8887-11,2.8438V3H18V6H14V3H12V8.8438C9.2608,6.8887,5.7684,6,1,6A1,1,0,0,0,.2437,7.6543C1.9454,9.6221,3,11.7041,3,16a1,1,0,0,0,1,1c2.7678,0,6,1.31,6,5a1.004,1.004,0,0,0,.9341.998C11.35,23.0273,15,23.3872,15,27a1,1,0,0,0,2,0c0-3.6128,3.65-3.9727,4.0622-4.002A1,1,0,0,0,22,22c0-3.69,3.2321-5,6-5a1,1,0,0,0,1-1c0-4.2959,1.0547-6.3779,2.7564-8.3457A1,1,0,0,0,31.9093,6.584Zm-4.893,8.46c-3.3857.3081-6.5534,2.229-6.97,6.0786A6.552,6.552,0,0,0,16,23.6094a6.552,6.552,0,0,0-4.0461-2.4864c-.4168-3.85-3.5845-5.7705-6.97-6.0786a13.2017,13.2017,0,0,0-1.9387-6.98c4.1318.2724,7.0327,1.4277,9.248,3.6425A1,1,0,0,0,14,11V8h4v3a1,1,0,0,0,1.707.707c2.2153-2.2148,5.1162-3.37,9.248-3.6425A13.2017,13.2017,0,0,0,27.0163,15.0444Z"
    }
  }]);

  const Bat20 = createSVGComponent('Bat20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.9093,6.584A1,1,0,0,0,31,6c-4.7683,0-8.2607.8887-11,2.8438V3H18V6H14V3H12V8.8438C9.2608,6.8887,5.7684,6,1,6A1,1,0,0,0,.2437,7.6543C1.9454,9.6221,3,11.7041,3,16a1,1,0,0,0,1,1c2.7678,0,6,1.31,6,5a1.004,1.004,0,0,0,.9341.998C11.35,23.0273,15,23.3872,15,27a1,1,0,0,0,2,0c0-3.6128,3.65-3.9727,4.0622-4.002A1,1,0,0,0,22,22c0-3.69,3.2321-5,6-5a1,1,0,0,0,1-1c0-4.2959,1.0547-6.3779,2.7564-8.3457A1,1,0,0,0,31.9093,6.584Zm-4.893,8.46c-3.3857.3081-6.5534,2.229-6.97,6.0786A6.552,6.552,0,0,0,16,23.6094a6.552,6.552,0,0,0-4.0461-2.4864c-.4168-3.85-3.5845-5.7705-6.97-6.0786a13.2017,13.2017,0,0,0-1.9387-6.98c4.1318.2724,7.0327,1.4277,9.248,3.6425A1,1,0,0,0,14,11V8h4v3a1,1,0,0,0,1.707.707c2.2153-2.2148,5.1162-3.37,9.248-3.6425A13.2017,13.2017,0,0,0,27.0163,15.0444Z"
    }
  }]);

  const Bat16 = createSVGComponent('Bat16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.9093,6.584A1,1,0,0,0,31,6c-4.7683,0-8.2607.8887-11,2.8438V3H18V6H14V3H12V8.8438C9.2608,6.8887,5.7684,6,1,6A1,1,0,0,0,.2437,7.6543C1.9454,9.6221,3,11.7041,3,16a1,1,0,0,0,1,1c2.7678,0,6,1.31,6,5a1.004,1.004,0,0,0,.9341.998C11.35,23.0273,15,23.3872,15,27a1,1,0,0,0,2,0c0-3.6128,3.65-3.9727,4.0622-4.002A1,1,0,0,0,22,22c0-3.69,3.2321-5,6-5a1,1,0,0,0,1-1c0-4.2959,1.0547-6.3779,2.7564-8.3457A1,1,0,0,0,31.9093,6.584Zm-4.893,8.46c-3.3857.3081-6.5534,2.229-6.97,6.0786A6.552,6.552,0,0,0,16,23.6094a6.552,6.552,0,0,0-4.0461-2.4864c-.4168-3.85-3.5845-5.7705-6.97-6.0786a13.2017,13.2017,0,0,0-1.9387-6.98c4.1318.2724,7.0327,1.4277,9.248,3.6425A1,1,0,0,0,14,11V8h4v3a1,1,0,0,0,1.707.707c2.2153-2.2148,5.1162-3.37,9.248-3.6425A13.2017,13.2017,0,0,0,27.0163,15.0444Z"
    }
  }]);

  const BatchJob32 = createSVGComponent('BatchJob32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 26v-2h-2.1011c-.1299-.6372-.3843-1.2285-.7319-1.7529l1.4897-1.4897-1.4141-1.4141-1.4897 1.4897c-.5244-.3477-1.1157-.6021-1.7529-.7319v-2.1011h-2v2.1011c-.6372.1299-1.2285.3843-1.7529.7319l-1.4897-1.4897-1.4141 1.4141 1.4897 1.4897c-.3477.5244-.6021 1.1157-.7319 1.7529h-2.1011v2h2.1011c.1299.6372.3843 1.2285.7319 1.7529l-1.4897 1.4897 1.4141 1.4141 1.4897-1.4897c.5244.3477 1.1157.6021 1.7529.7319v2.1011h2v-2.1011c.6372-.1299 1.2285-.3843 1.7529-.7319l1.4897 1.4897 1.4141-1.4141-1.4897-1.4897c.3477-.5244.6021-1.1157.7319-1.7529h2.1011zm-7 2c-1.6543 0-3-1.3457-3-3s1.3457-3 3-3 3 1.3457 3 3-1.3457 3-3 3zM20 17H12c-1.1046 0-2-.8954-2-2V4c0-1.1046.8954-2 2-2h8c1.1046 0 2 .8954 2 2V15c0 1.1046-.8954 2-2 2zm-8-2h8V4H12V15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,21H8c-1.1046,0-2-.8954-2-2V7h2v12h9v2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,25H4c-1.1028,0-2-.8972-2-2V11h2v12H13v2Z"
    }
  }]);

  const BatchJob24 = createSVGComponent('BatchJob24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 26v-2h-2.1011c-.1299-.6372-.3843-1.2285-.7319-1.7529l1.4897-1.4897-1.4141-1.4141-1.4897 1.4897c-.5244-.3477-1.1157-.6021-1.7529-.7319v-2.1011h-2v2.1011c-.6372.1299-1.2285.3843-1.7529.7319l-1.4897-1.4897-1.4141 1.4141 1.4897 1.4897c-.3477.5244-.6021 1.1157-.7319 1.7529h-2.1011v2h2.1011c.1299.6372.3843 1.2285.7319 1.7529l-1.4897 1.4897 1.4141 1.4141 1.4897-1.4897c.5244.3477 1.1157.6021 1.7529.7319v2.1011h2v-2.1011c.6372-.1299 1.2285-.3843 1.7529-.7319l1.4897 1.4897 1.4141-1.4141-1.4897-1.4897c.3477-.5244.6021-1.1157.7319-1.7529h2.1011zm-7 2c-1.6543 0-3-1.3457-3-3s1.3457-3 3-3 3 1.3457 3 3-1.3457 3-3 3zM20 17H12c-1.1046 0-2-.8954-2-2V4c0-1.1046.8954-2 2-2h8c1.1046 0 2 .8954 2 2V15c0 1.1046-.8954 2-2 2zm-8-2h8V4H12V15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,21H8c-1.1046,0-2-.8954-2-2V7h2v12h9v2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,25H4c-1.1028,0-2-.8972-2-2V11h2v12H13v2Z"
    }
  }]);

  const BatchJob20 = createSVGComponent('BatchJob20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 26v-2h-2.1011c-.1299-.6372-.3843-1.2285-.7319-1.7529l1.4897-1.4897-1.4141-1.4141-1.4897 1.4897c-.5244-.3477-1.1157-.6021-1.7529-.7319v-2.1011h-2v2.1011c-.6372.1299-1.2285.3843-1.7529.7319l-1.4897-1.4897-1.4141 1.4141 1.4897 1.4897c-.3477.5244-.6021 1.1157-.7319 1.7529h-2.1011v2h2.1011c.1299.6372.3843 1.2285.7319 1.7529l-1.4897 1.4897 1.4141 1.4141 1.4897-1.4897c.5244.3477 1.1157.6021 1.7529.7319v2.1011h2v-2.1011c.6372-.1299 1.2285-.3843 1.7529-.7319l1.4897 1.4897 1.4141-1.4141-1.4897-1.4897c.3477-.5244.6021-1.1157.7319-1.7529h2.1011zm-7 2c-1.6543 0-3-1.3457-3-3s1.3457-3 3-3 3 1.3457 3 3-1.3457 3-3 3zM20 17H12c-1.1046 0-2-.8954-2-2V4c0-1.1046.8954-2 2-2h8c1.1046 0 2 .8954 2 2V15c0 1.1046-.8954 2-2 2zm-8-2h8V4H12V15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,21H8c-1.1046,0-2-.8954-2-2V7h2v12h9v2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,25H4c-1.1028,0-2-.8972-2-2V11h2v12H13v2Z"
    }
  }]);

  const BatchJob16 = createSVGComponent('BatchJob16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 26v-2h-2.1011c-.1299-.6372-.3843-1.2285-.7319-1.7529l1.4897-1.4897-1.4141-1.4141-1.4897 1.4897c-.5244-.3477-1.1157-.6021-1.7529-.7319v-2.1011h-2v2.1011c-.6372.1299-1.2285.3843-1.7529.7319l-1.4897-1.4897-1.4141 1.4141 1.4897 1.4897c-.3477.5244-.6021 1.1157-.7319 1.7529h-2.1011v2h2.1011c.1299.6372.3843 1.2285.7319 1.7529l-1.4897 1.4897 1.4141 1.4141 1.4897-1.4897c.5244.3477 1.1157.6021 1.7529.7319v2.1011h2v-2.1011c.6372-.1299 1.2285-.3843 1.7529-.7319l1.4897 1.4897 1.4141-1.4141-1.4897-1.4897c.3477-.5244.6021-1.1157.7319-1.7529h2.1011zm-7 2c-1.6543 0-3-1.3457-3-3s1.3457-3 3-3 3 1.3457 3 3-1.3457 3-3 3zM20 17H12c-1.1046 0-2-.8954-2-2V4c0-1.1046.8954-2 2-2h8c1.1046 0 2 .8954 2 2V15c0 1.1046-.8954 2-2 2zm-8-2h8V4H12V15z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,21H8c-1.1046,0-2-.8954-2-2V7h2v12h9v2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,25H4c-1.1028,0-2-.8972-2-2V11h2v12H13v2Z"
    }
  }]);

  const BatchJobStep32 = createSVGComponent('BatchJobStep32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20L24 24 20 24 20 28 16 28 16 30 22 30 22 26 26 26 26 22 30 22 30 20 24 20zM8 4h8v6c0 1.1025.8972 2 2 2h6v4h2v-6c0-.2651-.1055-.5195-.293-.707l-7-7c-.1875-.1875-.4419-.293-.707-.293H8c-1.1028 0-2 .8975-2 2V28c0 1.1025.8972 2 2 2h4v-2h-4V4zm15.5857 6h-5.5857V4.4141l5.5857 5.5859z"
    }
  }]);

  const BatchJobStep24 = createSVGComponent('BatchJobStep24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20L24 24 20 24 20 28 16 28 16 30 22 30 22 26 26 26 26 22 30 22 30 20 24 20zM8 4h8v6c0 1.1025.8972 2 2 2h6v4h2v-6c0-.2651-.1055-.5195-.293-.707l-7-7c-.1875-.1875-.4419-.293-.707-.293H8c-1.1028 0-2 .8975-2 2V28c0 1.1025.8972 2 2 2h4v-2h-4V4zm15.5857 6h-5.5857V4.4141l5.5857 5.5859z"
    }
  }]);

  const BatchJobStep20 = createSVGComponent('BatchJobStep20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20L24 24 20 24 20 28 16 28 16 30 22 30 22 26 26 26 26 22 30 22 30 20 24 20zM8 4h8v6c0 1.1025.8972 2 2 2h6v4h2v-6c0-.2651-.1055-.5195-.293-.707l-7-7c-.1875-.1875-.4419-.293-.707-.293H8c-1.1028 0-2 .8975-2 2V28c0 1.1025.8972 2 2 2h4v-2h-4V4zm15.5857 6h-5.5857V4.4141l5.5857 5.5859z"
    }
  }]);

  const BatchJobStep16 = createSVGComponent('BatchJobStep16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 20L24 24 20 24 20 28 16 28 16 30 22 30 22 26 26 26 26 22 30 22 30 20 24 20zM8 4h8v6c0 1.1025.8972 2 2 2h6v4h2v-6c0-.2651-.1055-.5195-.293-.707l-7-7c-.1875-.1875-.4419-.293-.707-.293H8c-1.1028 0-2 .8975-2 2V28c0 1.1025.8972 2 2 2h4v-2h-4V4zm15.5857 6h-5.5857V4.4141l5.5857 5.5859z"
    }
  }]);

  const BatteryCharging32 = createSVGComponent('BatteryCharging32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
    }
  }]);

  const BatteryCharging24 = createSVGComponent('BatteryCharging24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
    }
  }]);

  const BatteryCharging20 = createSVGComponent('BatteryCharging20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
    }
  }]);

  const BatteryCharging16 = createSVGComponent('BatteryCharging16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
    }
  }]);

  const BatteryEmpty32 = createSVGComponent('BatteryEmpty32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }]);

  const BatteryEmpty24 = createSVGComponent('BatteryEmpty24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }]);

  const BatteryEmpty20 = createSVGComponent('BatteryEmpty20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }]);

  const BatteryEmpty16 = createSVGComponent('BatteryEmpty16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }]);

  const BatteryFull32 = createSVGComponent('BatteryFull32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 9H19V23H11z",
      "transform": "rotate(90 15 16)"
    }
  }]);

  const BatteryFull24 = createSVGComponent('BatteryFull24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 9H19V23H11z",
      "transform": "rotate(90 15 16)"
    }
  }]);

  const BatteryFull20 = createSVGComponent('BatteryFull20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 9H19V23H11z",
      "transform": "rotate(90 15 16)"
    }
  }]);

  const BatteryFull16 = createSVGComponent('BatteryFull16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 9H19V23H11z",
      "transform": "rotate(90 15 16)"
    }
  }]);

  const BatteryHalf32 = createSVGComponent('BatteryHalf32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 12H16V20H8z",
      "transform": "rotate(90 12 16)"
    }
  }]);

  const BatteryHalf24 = createSVGComponent('BatteryHalf24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 12H16V20H8z",
      "transform": "rotate(90 12 16)"
    }
  }]);

  const BatteryHalf20 = createSVGComponent('BatteryHalf20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 12H16V20H8z",
      "transform": "rotate(90 12 16)"
    }
  }]);

  const BatteryHalf16 = createSVGComponent('BatteryHalf16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 12H16V20H8z",
      "transform": "rotate(90 12 16)"
    }
  }]);

  const BatteryLow32 = createSVGComponent('BatteryLow32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5 15H13V17H5z",
      "transform": "rotate(90 9 16)"
    }
  }]);

  const BatteryLow24 = createSVGComponent('BatteryLow24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5 15H13V17H5z",
      "transform": "rotate(90 9 16)"
    }
  }]);

  const BatteryLow20 = createSVGComponent('BatteryLow20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5 15H13V17H5z",
      "transform": "rotate(90 9 16)"
    }
  }]);

  const BatteryLow16 = createSVGComponent('BatteryLow16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5 15H13V17H5z",
      "transform": "rotate(90 9 16)"
    }
  }]);

  const BatteryQuarter32 = createSVGComponent('BatteryQuarter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 14H14V18H6z",
      "transform": "rotate(90 10 16)"
    }
  }]);

  const BatteryQuarter24 = createSVGComponent('BatteryQuarter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 14H14V18H6z",
      "transform": "rotate(90 10 16)"
    }
  }]);

  const BatteryQuarter20 = createSVGComponent('BatteryQuarter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 14H14V18H6z",
      "transform": "rotate(90 10 16)"
    }
  }]);

  const BatteryQuarter16 = createSVGComponent('BatteryQuarter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 14H14V18H6z",
      "transform": "rotate(90 10 16)"
    }
  }]);

  const Bee32 = createSVGComponent('Bee32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
    }
  }]);

  const Bee24 = createSVGComponent('Bee24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
    }
  }]);

  const Bee20 = createSVGComponent('Bee20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
    }
  }]);

  const Bee16 = createSVGComponent('Bee16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
    }
  }]);

  const BeeBat32 = createSVGComponent('BeeBat32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "13",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "19",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M31.8083,8.665A.8745.8745,0,0,0,31,8.125H29c-4.21,0-7.721,2.002-9.1648,4.9014a4.8186,4.8186,0,0,0-7.67,0C10.721,10.127,7.21,8.125,3,8.125H1A.8749.8749,0,0,0,.3816,9.6191L.4834,9.72A5.3885,5.3885,0,0,1,2.1612,15.751.8751.8751,0,0,0,3,16.875a2.8966,2.8966,0,0,1,2.1587.7266c.9783.9814.9714,2.8872.9668,4.1479l0,.25A.875.875,0,0,0,7,22.875h4.125V23a4.875,4.875,0,0,0,9.75,0v-.125H25A.875.875,0,0,0,25.875,22l0-.25c-.0046-1.2607-.0115-3.1665.9668-4.1479A2.8966,2.8966,0,0,1,29,16.875a.8751.8751,0,0,0,.8388-1.124,5.3883,5.3883,0,0,1,1.6765-6.0293l.1033-.103A.875.875,0,0,0,31.8083,8.665ZM16,12.875A3.1286,3.1286,0,0,1,19.125,16v.125h-6.25V16A3.1286,3.1286,0,0,1,16,12.875Zm-3.125,5h6.25v3.25h-6.25Zm-5.0007,3.25c-.0178-1.459-.1839-3.4619-1.4761-4.7588a4.1876,4.1876,0,0,0-2.31-1.1518A6.657,6.657,0,0,0,2.9524,9.875H3c4.5562,0,8.125,2.69,8.125,6.125v5.125ZM19.125,23a3.125,3.125,0,0,1-6.25,0v-.125h6.25Zm8.7868-7.7856a4.1876,4.1876,0,0,0-2.31,1.1518c-1.2922,1.2969-1.4583,3.3-1.4761,4.7588H20.875V16c0-3.4346,3.5688-6.125,8.125-6.125h.0481A6.6561,6.6561,0,0,0,27.9118,15.2144Z"
    }
  }]);

  const BeeBat24 = createSVGComponent('BeeBat24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "13",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "19",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M31.8083,8.665A.8745.8745,0,0,0,31,8.125H29c-4.21,0-7.721,2.002-9.1648,4.9014a4.8186,4.8186,0,0,0-7.67,0C10.721,10.127,7.21,8.125,3,8.125H1A.8749.8749,0,0,0,.3816,9.6191L.4834,9.72A5.3885,5.3885,0,0,1,2.1612,15.751.8751.8751,0,0,0,3,16.875a2.8966,2.8966,0,0,1,2.1587.7266c.9783.9814.9714,2.8872.9668,4.1479l0,.25A.875.875,0,0,0,7,22.875h4.125V23a4.875,4.875,0,0,0,9.75,0v-.125H25A.875.875,0,0,0,25.875,22l0-.25c-.0046-1.2607-.0115-3.1665.9668-4.1479A2.8966,2.8966,0,0,1,29,16.875a.8751.8751,0,0,0,.8388-1.124,5.3883,5.3883,0,0,1,1.6765-6.0293l.1033-.103A.875.875,0,0,0,31.8083,8.665ZM16,12.875A3.1286,3.1286,0,0,1,19.125,16v.125h-6.25V16A3.1286,3.1286,0,0,1,16,12.875Zm-3.125,5h6.25v3.25h-6.25Zm-5.0007,3.25c-.0178-1.459-.1839-3.4619-1.4761-4.7588a4.1876,4.1876,0,0,0-2.31-1.1518A6.657,6.657,0,0,0,2.9524,9.875H3c4.5562,0,8.125,2.69,8.125,6.125v5.125ZM19.125,23a3.125,3.125,0,0,1-6.25,0v-.125h6.25Zm8.7868-7.7856a4.1876,4.1876,0,0,0-2.31,1.1518c-1.2922,1.2969-1.4583,3.3-1.4761,4.7588H20.875V16c0-3.4346,3.5688-6.125,8.125-6.125h.0481A6.6561,6.6561,0,0,0,27.9118,15.2144Z"
    }
  }]);

  const BeeBat20 = createSVGComponent('BeeBat20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "13",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "19",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M31.8083,8.665A.8745.8745,0,0,0,31,8.125H29c-4.21,0-7.721,2.002-9.1648,4.9014a4.8186,4.8186,0,0,0-7.67,0C10.721,10.127,7.21,8.125,3,8.125H1A.8749.8749,0,0,0,.3816,9.6191L.4834,9.72A5.3885,5.3885,0,0,1,2.1612,15.751.8751.8751,0,0,0,3,16.875a2.8966,2.8966,0,0,1,2.1587.7266c.9783.9814.9714,2.8872.9668,4.1479l0,.25A.875.875,0,0,0,7,22.875h4.125V23a4.875,4.875,0,0,0,9.75,0v-.125H25A.875.875,0,0,0,25.875,22l0-.25c-.0046-1.2607-.0115-3.1665.9668-4.1479A2.8966,2.8966,0,0,1,29,16.875a.8751.8751,0,0,0,.8388-1.124,5.3883,5.3883,0,0,1,1.6765-6.0293l.1033-.103A.875.875,0,0,0,31.8083,8.665ZM16,12.875A3.1286,3.1286,0,0,1,19.125,16v.125h-6.25V16A3.1286,3.1286,0,0,1,16,12.875Zm-3.125,5h6.25v3.25h-6.25Zm-5.0007,3.25c-.0178-1.459-.1839-3.4619-1.4761-4.7588a4.1876,4.1876,0,0,0-2.31-1.1518A6.657,6.657,0,0,0,2.9524,9.875H3c4.5562,0,8.125,2.69,8.125,6.125v5.125ZM19.125,23a3.125,3.125,0,0,1-6.25,0v-.125h6.25Zm8.7868-7.7856a4.1876,4.1876,0,0,0-2.31,1.1518c-1.2922,1.2969-1.4583,3.3-1.4761,4.7588H20.875V16c0-3.4346,3.5688-6.125,8.125-6.125h.0481A6.6561,6.6561,0,0,0,27.9118,15.2144Z"
    }
  }]);

  const BeeBat16 = createSVGComponent('BeeBat16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "13",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "19",
      "cy": "8",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M31.8083,8.665A.8745.8745,0,0,0,31,8.125H29c-4.21,0-7.721,2.002-9.1648,4.9014a4.8186,4.8186,0,0,0-7.67,0C10.721,10.127,7.21,8.125,3,8.125H1A.8749.8749,0,0,0,.3816,9.6191L.4834,9.72A5.3885,5.3885,0,0,1,2.1612,15.751.8751.8751,0,0,0,3,16.875a2.8966,2.8966,0,0,1,2.1587.7266c.9783.9814.9714,2.8872.9668,4.1479l0,.25A.875.875,0,0,0,7,22.875h4.125V23a4.875,4.875,0,0,0,9.75,0v-.125H25A.875.875,0,0,0,25.875,22l0-.25c-.0046-1.2607-.0115-3.1665.9668-4.1479A2.8966,2.8966,0,0,1,29,16.875a.8751.8751,0,0,0,.8388-1.124,5.3883,5.3883,0,0,1,1.6765-6.0293l.1033-.103A.875.875,0,0,0,31.8083,8.665ZM16,12.875A3.1286,3.1286,0,0,1,19.125,16v.125h-6.25V16A3.1286,3.1286,0,0,1,16,12.875Zm-3.125,5h6.25v3.25h-6.25Zm-5.0007,3.25c-.0178-1.459-.1839-3.4619-1.4761-4.7588a4.1876,4.1876,0,0,0-2.31-1.1518A6.657,6.657,0,0,0,2.9524,9.875H3c4.5562,0,8.125,2.69,8.125,6.125v5.125ZM19.125,23a3.125,3.125,0,0,1-6.25,0v-.125h6.25Zm8.7868-7.7856a4.1876,4.1876,0,0,0-2.31,1.1518c-1.2922,1.2969-1.4583,3.3-1.4761,4.7588H20.875V16c0-3.4346,3.5688-6.125,8.125-6.125h.0481A6.6561,6.6561,0,0,0,27.9118,15.2144Z"
    }
  }]);

  const Beta32 = createSVGComponent('Beta32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.7168,13.7705A5.9174,5.9174,0,0,0,23,9c0-3.5327-2.8784-6-7-6a6.627,6.627,0,0,0-7,7V31h2V25.1206a8.1261,8.1261,0,0,0,6,2.48A7.3833,7.3833,0,0,0,24.6528,20,6.6364,6.6364,0,0,0,20.7168,13.7705ZM17,25.6A5.6781,5.6781,0,0,1,11,20V10a4.6856,4.6856,0,0,1,5-5c3.0374,0,5,1.57,5,4a3.8732,3.8732,0,0,1-4,4v2c3.4341,0,5.6528,1.9629,5.6528,5A5.3907,5.3907,0,0,1,17,25.6Z"
    }
  }]);

  const Beta24 = createSVGComponent('Beta24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.7168,13.7705A5.9174,5.9174,0,0,0,23,9c0-3.5327-2.8784-6-7-6a6.627,6.627,0,0,0-7,7V31h2V25.1206a8.1261,8.1261,0,0,0,6,2.48A7.3833,7.3833,0,0,0,24.6528,20,6.6364,6.6364,0,0,0,20.7168,13.7705ZM17,25.6A5.6781,5.6781,0,0,1,11,20V10a4.6856,4.6856,0,0,1,5-5c3.0374,0,5,1.57,5,4a3.8732,3.8732,0,0,1-4,4v2c3.4341,0,5.6528,1.9629,5.6528,5A5.3907,5.3907,0,0,1,17,25.6Z"
    }
  }]);

  const Beta20 = createSVGComponent('Beta20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.7168,13.7705A5.9174,5.9174,0,0,0,23,9c0-3.5327-2.8784-6-7-6a6.627,6.627,0,0,0-7,7V31h2V25.1206a8.1261,8.1261,0,0,0,6,2.48A7.3833,7.3833,0,0,0,24.6528,20,6.6364,6.6364,0,0,0,20.7168,13.7705ZM17,25.6A5.6781,5.6781,0,0,1,11,20V10a4.6856,4.6856,0,0,1,5-5c3.0374,0,5,1.57,5,4a3.8732,3.8732,0,0,1-4,4v2c3.4341,0,5.6528,1.9629,5.6528,5A5.3907,5.3907,0,0,1,17,25.6Z"
    }
  }]);

  const Beta16 = createSVGComponent('Beta16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.7168,13.7705A5.9174,5.9174,0,0,0,23,9c0-3.5327-2.8784-6-7-6a6.627,6.627,0,0,0-7,7V31h2V25.1206a8.1261,8.1261,0,0,0,6,2.48A7.3833,7.3833,0,0,0,24.6528,20,6.6364,6.6364,0,0,0,20.7168,13.7705ZM17,25.6A5.6781,5.6781,0,0,1,11,20V10a4.6856,4.6856,0,0,1,5-5c3.0374,0,5,1.57,5,4a3.8732,3.8732,0,0,1-4,4v2c3.4341,0,5.6528,1.9629,5.6528,5A5.3907,5.3907,0,0,1,17,25.6Z"
    }
  }]);

  const Bicycle32 = createSVGComponent('Bicycle32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
    }
  }]);

  const Bicycle24 = createSVGComponent('Bicycle24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
    }
  }]);

  const Bicycle20 = createSVGComponent('Bicycle20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
    }
  }]);

  const Bicycle16 = createSVGComponent('Bicycle16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
    }
  }]);

  const Binoculars32 = createSVGComponent('Binoculars32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
    }
  }]);

  const Binoculars24 = createSVGComponent('Binoculars24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
    }
  }]);

  const Binoculars20 = createSVGComponent('Binoculars20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
    }
  }]);

  const Binoculars16 = createSVGComponent('Binoculars16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
    }
  }]);

  const QBlochSphere32 = createSVGComponent('QBlochSphere32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
    }
  }]);

  const QBlochSphere24 = createSVGComponent('QBlochSphere24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
    }
  }]);

  const QBlochSphere20 = createSVGComponent('QBlochSphere20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
    }
  }]);

  const QBlochSphere16 = createSVGComponent('QBlochSphere16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
    }
  }]);

  const BlockStorage32 = createSVGComponent('BlockStorage32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,12V10H4a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V19H20v9H4V12"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 12H14V4h8zM12 4v8a2 2 0 002 2h8a2 2 0 002-2V4a2 2 0 00-2-2H14A2 2 0 0012 4zM14 18v4H10V18h4M8 18v4a2 2 0 002 2h4a2 2 0 002-2V18a2 2 0 00-2-2H10A2 2 0 008 18zM28 17v2H26V17h2m-4-1v4a1 1 0 001 1h4a1 1 0 001-1V16a1 1 0 00-1-1H25A1 1 0 0024 16z"
    }
  }]);

  const BlockStorage24 = createSVGComponent('BlockStorage24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,12V10H4a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V19H20v9H4V12"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 12H14V4h8zM12 4v8a2 2 0 002 2h8a2 2 0 002-2V4a2 2 0 00-2-2H14A2 2 0 0012 4zM14 18v4H10V18h4M8 18v4a2 2 0 002 2h4a2 2 0 002-2V18a2 2 0 00-2-2H10A2 2 0 008 18zM28 17v2H26V17h2m-4-1v4a1 1 0 001 1h4a1 1 0 001-1V16a1 1 0 00-1-1H25A1 1 0 0024 16z"
    }
  }]);

  const BlockStorage20 = createSVGComponent('BlockStorage20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,12V10H4a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V19H20v9H4V12"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 12H14V4h8zM12 4v8a2 2 0 002 2h8a2 2 0 002-2V4a2 2 0 00-2-2H14A2 2 0 0012 4zM14 18v4H10V18h4M8 18v4a2 2 0 002 2h4a2 2 0 002-2V18a2 2 0 00-2-2H10A2 2 0 008 18zM28 17v2H26V17h2m-4-1v4a1 1 0 001 1h4a1 1 0 001-1V16a1 1 0 00-1-1H25A1 1 0 0024 16z"
    }
  }]);

  const BlockStorage16 = createSVGComponent('BlockStorage16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9,12V10H4a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V19H20v9H4V12"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 12H14V4h8zM12 4v8a2 2 0 002 2h8a2 2 0 002-2V4a2 2 0 00-2-2H14A2 2 0 0012 4zM14 18v4H10V18h4M8 18v4a2 2 0 002 2h4a2 2 0 002-2V18a2 2 0 00-2-2H10A2 2 0 008 18zM28 17v2H26V17h2m-4-1v4a1 1 0 001 1h4a1 1 0 001-1V16a1 1 0 00-1-1H25A1 1 0 0024 16z"
    }
  }]);

  const BlockStorageAlt32 = createSVGComponent('BlockStorageAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,20H26v2h2v6H4V22H6V20H4a2.0024,2.0024,0,0,0-2,2v6a2.0024,2.0024,0,0,0,2,2H28a2.0024,2.0024,0,0,0,2-2V22A2.0024,2.0024,0,0,0,28,20Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 20H8V13h7zm-5-2h3V15H10zM24 20H17V13h7zm-5-2h3V15H19zM15 11H8V4h7zM10 9h3V6H10zM24 11H17V4h7zM19 9h3V6H19z"
    }
  }]);

  const BlockStorageAlt24 = createSVGComponent('BlockStorageAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,20H26v2h2v6H4V22H6V20H4a2.0024,2.0024,0,0,0-2,2v6a2.0024,2.0024,0,0,0,2,2H28a2.0024,2.0024,0,0,0,2-2V22A2.0024,2.0024,0,0,0,28,20Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 20H8V13h7zm-5-2h3V15H10zM24 20H17V13h7zm-5-2h3V15H19zM15 11H8V4h7zM10 9h3V6H10zM24 11H17V4h7zM19 9h3V6H19z"
    }
  }]);

  const BlockStorageAlt20 = createSVGComponent('BlockStorageAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,20H26v2h2v6H4V22H6V20H4a2.0024,2.0024,0,0,0-2,2v6a2.0024,2.0024,0,0,0,2,2H28a2.0024,2.0024,0,0,0,2-2V22A2.0024,2.0024,0,0,0,28,20Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 20H8V13h7zm-5-2h3V15H10zM24 20H17V13h7zm-5-2h3V15H19zM15 11H8V4h7zM10 9h3V6H10zM24 11H17V4h7zM19 9h3V6H19z"
    }
  }]);

  const BlockStorageAlt16 = createSVGComponent('BlockStorageAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,20H26v2h2v6H4V22H6V20H4a2.0024,2.0024,0,0,0-2,2v6a2.0024,2.0024,0,0,0,2,2H28a2.0024,2.0024,0,0,0,2-2V22A2.0024,2.0024,0,0,0,28,20Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 20H8V13h7zm-5-2h3V15H10zM24 20H17V13h7zm-5-2h3V15H19zM15 11H8V4h7zM10 9h3V6H10zM24 11H17V4h7zM19 9h3V6H19z"
    }
  }]);

  const Blockchain32 = createSVGComponent('Blockchain32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
    }
  }]);

  const Blockchain24 = createSVGComponent('Blockchain24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
    }
  }]);

  const Blockchain20 = createSVGComponent('Blockchain20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
    }
  }]);

  const Blockchain16 = createSVGComponent('Blockchain16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
    }
  }]);

  const Blog32 = createSVGComponent('Blog32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
    }
  }]);

  const Blog24 = createSVGComponent('Blog24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
    }
  }]);

  const Blog20 = createSVGComponent('Blog20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
    }
  }]);

  const Blog16 = createSVGComponent('Blog16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
    }
  }]);

  const Bluetooth32 = createSVGComponent('Bluetooth32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
    }
  }]);

  const Bluetooth24 = createSVGComponent('Bluetooth24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
    }
  }]);

  const Bluetooth20 = createSVGComponent('Bluetooth20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
    }
  }]);

  const Bluetooth16 = createSVGComponent('Bluetooth16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
    }
  }]);

  const BluetoothOff32 = createSVGComponent('BluetoothOff32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
    }
  }]);

  const BluetoothOff24 = createSVGComponent('BluetoothOff24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
    }
  }]);

  const BluetoothOff20 = createSVGComponent('BluetoothOff20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
    }
  }]);

  const BluetoothOff16 = createSVGComponent('BluetoothOff16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
    }
  }]);

  const Book32 = createSVGComponent('Book32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 10H26V12H19zM19 15H26V17H19zM19 20H26V22H19zM6 10H13V12H6zM6 15H13V17H6zM6 20H13V22H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,5H4A2.002,2.002,0,0,0,2,7V25a2.002,2.002,0,0,0,2,2H28a2.002,2.002,0,0,0,2-2V7A2.002,2.002,0,0,0,28,5ZM4,7H15V25H4ZM17,25V7H28V25Z"
    }
  }]);

  const Book24 = createSVGComponent('Book24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 10H26V12H19zM19 15H26V17H19zM19 20H26V22H19zM6 10H13V12H6zM6 15H13V17H6zM6 20H13V22H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,5H4A2.002,2.002,0,0,0,2,7V25a2.002,2.002,0,0,0,2,2H28a2.002,2.002,0,0,0,2-2V7A2.002,2.002,0,0,0,28,5ZM4,7H15V25H4ZM17,25V7H28V25Z"
    }
  }]);

  const Book20 = createSVGComponent('Book20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 10H26V12H19zM19 15H26V17H19zM19 20H26V22H19zM6 10H13V12H6zM6 15H13V17H6zM6 20H13V22H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,5H4A2.002,2.002,0,0,0,2,7V25a2.002,2.002,0,0,0,2,2H28a2.002,2.002,0,0,0,2-2V7A2.002,2.002,0,0,0,28,5ZM4,7H15V25H4ZM17,25V7H28V25Z"
    }
  }]);

  const Book16 = createSVGComponent('Book16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 10H26V12H19zM19 15H26V17H19zM19 20H26V22H19zM6 10H13V12H6zM6 15H13V17H6zM6 20H13V22H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,5H4A2.002,2.002,0,0,0,2,7V25a2.002,2.002,0,0,0,2,2H28a2.002,2.002,0,0,0,2-2V7A2.002,2.002,0,0,0,28,5ZM4,7H15V25H4ZM17,25V7H28V25Z"
    }
  }]);

  const Bookmark32 = createSVGComponent('Bookmark32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const Bookmark24 = createSVGComponent('Bookmark24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const Bookmark20 = createSVGComponent('Bookmark20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const Bookmark16 = createSVGComponent('Bookmark16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const BookmarkAdd32 = createSVGComponent('BookmarkAdd32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,16V26.7515l-7.0962-3.5894L16,22.7051l-.9009.456L8,26.748V4H18V2H8A2,2,0,0,0,6,4V30l10-5.0537L26,30V16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 6L26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6 26 6z"
    }
  }]);

  const BookmarkAdd24 = createSVGComponent('BookmarkAdd24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,16V26.7515l-7.0962-3.5894L16,22.7051l-.9009.456L8,26.748V4H18V2H8A2,2,0,0,0,6,4V30l10-5.0537L26,30V16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 6L26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6 26 6z"
    }
  }]);

  const BookmarkAdd20 = createSVGComponent('BookmarkAdd20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,16V26.7515l-7.0962-3.5894L16,22.7051l-.9009.456L8,26.748V4H18V2H8A2,2,0,0,0,6,4V30l10-5.0537L26,30V16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 6L26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6 26 6z"
    }
  }]);

  const BookmarkAdd16 = createSVGComponent('BookmarkAdd16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,16V26.7515l-7.0962-3.5894L16,22.7051l-.9009.456L8,26.748V4H18V2H8A2,2,0,0,0,6,4V30l10-5.0537L26,30V16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26 6L26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6 26 6z"
    }
  }]);

  const BookmarkFilled32 = createSVGComponent('BookmarkFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,2H8A2,2,0,0,0,6,4V30l10-5.0538L26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const BookmarkFilled24 = createSVGComponent('BookmarkFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,2H8A2,2,0,0,0,6,4V30l10-5.0538L26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const BookmarkFilled20 = createSVGComponent('BookmarkFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,2H8A2,2,0,0,0,6,4V30l10-5.0538L26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const BookmarkFilled16 = createSVGComponent('BookmarkFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,2H8A2,2,0,0,0,6,4V30l10-5.0538L26,30V4A2,2,0,0,0,24,2Z"
    }
  }]);

  const Boolean32 = createSVGComponent('Boolean32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,23a7,7,0,1,1,7-7A7.0078,7.0078,0,0,1,23,23Zm0-12a5,5,0,1,0,5,5A5.0055,5.0055,0,0,0,23,11Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "7"
    }
  }]);

  const Boolean24 = createSVGComponent('Boolean24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,23a7,7,0,1,1,7-7A7.0078,7.0078,0,0,1,23,23Zm0-12a5,5,0,1,0,5,5A5.0055,5.0055,0,0,0,23,11Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "7"
    }
  }]);

  const Boolean20 = createSVGComponent('Boolean20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,23a7,7,0,1,1,7-7A7.0078,7.0078,0,0,1,23,23Zm0-12a5,5,0,1,0,5,5A5.0055,5.0055,0,0,0,23,11Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "7"
    }
  }]);

  const Boolean16 = createSVGComponent('Boolean16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,23a7,7,0,1,1,7-7A7.0078,7.0078,0,0,1,23,23Zm0-12a5,5,0,1,0,5,5A5.0055,5.0055,0,0,0,23,11Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "16",
      "r": "7"
    }
  }]);

  const Boot32 = createSVGComponent('Boot32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,17H18a1.0008,1.0008,0,0,1-1-1V4a2.0025,2.0025,0,0,0-2-2H5A2.0025,2.0025,0,0,0,3,4V28a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V22A5.0057,5.0057,0,0,0,24,17Zm3,5v2H23V19h1A3.0033,3.0033,0,0,1,27,22ZM15,4V6H11V8h4v2H11v2h4v2H11v2h4a3.0033,3.0033,0,0,0,3,3h3v5H14.1624l-3-1H5V4ZM25,28V27H23v1H21V27H19v1H17V27H15v1H13V27H11v1H5V25h5.8376l3,1H27v2Z"
    }
  }]);

  const Boot24 = createSVGComponent('Boot24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,17H18a1.0008,1.0008,0,0,1-1-1V4a2.0025,2.0025,0,0,0-2-2H5A2.0025,2.0025,0,0,0,3,4V28a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V22A5.0057,5.0057,0,0,0,24,17Zm3,5v2H23V19h1A3.0033,3.0033,0,0,1,27,22ZM15,4V6H11V8h4v2H11v2h4v2H11v2h4a3.0033,3.0033,0,0,0,3,3h3v5H14.1624l-3-1H5V4ZM25,28V27H23v1H21V27H19v1H17V27H15v1H13V27H11v1H5V25h5.8376l3,1H27v2Z"
    }
  }]);

  const Boot20 = createSVGComponent('Boot20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,17H18a1.0008,1.0008,0,0,1-1-1V4a2.0025,2.0025,0,0,0-2-2H5A2.0025,2.0025,0,0,0,3,4V28a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V22A5.0057,5.0057,0,0,0,24,17Zm3,5v2H23V19h1A3.0033,3.0033,0,0,1,27,22ZM15,4V6H11V8h4v2H11v2h4v2H11v2h4a3.0033,3.0033,0,0,0,3,3h3v5H14.1624l-3-1H5V4ZM25,28V27H23v1H21V27H19v1H17V27H15v1H13V27H11v1H5V25h5.8376l3,1H27v2Z"
    }
  }]);

  const Boot16 = createSVGComponent('Boot16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24,17H18a1.0008,1.0008,0,0,1-1-1V4a2.0025,2.0025,0,0,0-2-2H5A2.0025,2.0025,0,0,0,3,4V28a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V22A5.0057,5.0057,0,0,0,24,17Zm3,5v2H23V19h1A3.0033,3.0033,0,0,1,27,22ZM15,4V6H11V8h4v2H11v2h4v2H11v2h4a3.0033,3.0033,0,0,0,3,3h3v5H14.1624l-3-1H5V4ZM25,28V27H23v1H21V27H19v1H17V27H15v1H13V27H11v1H5V25h5.8376l3,1H27v2Z"
    }
  }]);

  const BootVolume32 = createSVGComponent('BootVolume32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 22v-2h-3v-2h-2v2h-1v2h1v6c0 1.1025.8975 2 2 2h3v-2h-3v-6h3zM23 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM14 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM5 20H2v-4H0v14H5c1.1025 0 2-.8975 2-2v-6c0-1.103-.8975-2-2-2zm-3 8v-6h3v6H2zM4 14V5h7.5857l4 4h12.4143v7h2v-7c-.0013-1.1041-.8959-1.9987-2-2h-11.5857l-3.4143-3.4141c-.3742-.3764-.8835-.5873-1.4143-.5859H4c-1.1041.0013-1.9987.8959-2 2V14h2z"
    }
  }]);

  const BootVolume24 = createSVGComponent('BootVolume24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 22v-2h-3v-2h-2v2h-1v2h1v6c0 1.1025.8975 2 2 2h3v-2h-3v-6h3zM23 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM14 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM5 20H2v-4H0v14H5c1.1025 0 2-.8975 2-2v-6c0-1.103-.8975-2-2-2zm-3 8v-6h3v6H2zM4 14V5h7.5857l4 4h12.4143v7h2v-7c-.0013-1.1041-.8959-1.9987-2-2h-11.5857l-3.4143-3.4141c-.3742-.3764-.8835-.5873-1.4143-.5859H4c-1.1041.0013-1.9987.8959-2 2V14h2z"
    }
  }]);

  const BootVolume20 = createSVGComponent('BootVolume20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 22v-2h-3v-2h-2v2h-1v2h1v6c0 1.1025.8975 2 2 2h3v-2h-3v-6h3zM23 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM14 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM5 20H2v-4H0v14H5c1.1025 0 2-.8975 2-2v-6c0-1.103-.8975-2-2-2zm-3 8v-6h3v6H2zM4 14V5h7.5857l4 4h12.4143v7h2v-7c-.0013-1.1041-.8959-1.9987-2-2h-11.5857l-3.4143-3.4141c-.3742-.3764-.8835-.5873-1.4143-.5859H4c-1.1041.0013-1.9987.8959-2 2V14h2z"
    }
  }]);

  const BootVolume16 = createSVGComponent('BootVolume16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 22v-2h-3v-2h-2v2h-1v2h1v6c0 1.1025.8975 2 2 2h3v-2h-3v-6h3zM23 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM14 30h-3c-1.1025 0-2-.8975-2-2v-6c0-1.103.8975-2 2-2h3c1.1025 0 2 .897 2 2v6c0 1.1025-.8975 2-2 2zm-3-8v6h3v-6h-3zM5 20H2v-4H0v14H5c1.1025 0 2-.8975 2-2v-6c0-1.103-.8975-2-2-2zm-3 8v-6h3v6H2zM4 14V5h7.5857l4 4h12.4143v7h2v-7c-.0013-1.1041-.8959-1.9987-2-2h-11.5857l-3.4143-3.4141c-.3742-.3764-.8835-.5873-1.4143-.5859H4c-1.1041.0013-1.9987.8959-2 2V14h2z"
    }
  }]);

  const BootVolumeAlt32 = createSVGComponent('BootVolumeAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30h-7c-1.1028,0-2-.8972-2-2v-2h2v2h7v-7h-2v-2h2c1.1028,0,2,.8972,2,2v7c0,1.1028-.8972,2-2,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 24L14 24 13.9998 17.414 22.5823 26 24 24.5857 15.4139 15.9998 22 16 22 14 12 14 12 24z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,27H4c-1.104-.0013-1.9987-.896-2-2V5c.0013-1.104,.896-1.9987,2-2h7.5857c.5308-.0015,1.0401,.2095,1.4143,.5859l3.4143,3.4141h11.5857c1.104,.0013,1.9987,.896,2,2v7h-2v-7H15.5857l-4-4H4V25h4v2Z"
    }
  }]);

  const BootVolumeAlt24 = createSVGComponent('BootVolumeAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30h-7c-1.1028,0-2-.8972-2-2v-2h2v2h7v-7h-2v-2h2c1.1028,0,2,.8972,2,2v7c0,1.1028-.8972,2-2,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 24L14 24 13.9998 17.414 22.5823 26 24 24.5857 15.4139 15.9998 22 16 22 14 12 14 12 24z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,27H4c-1.104-.0013-1.9987-.896-2-2V5c.0013-1.104,.896-1.9987,2-2h7.5857c.5308-.0015,1.0401,.2095,1.4143,.5859l3.4143,3.4141h11.5857c1.104,.0013,1.9987,.896,2,2v7h-2v-7H15.5857l-4-4H4V25h4v2Z"
    }
  }]);

  const BootVolumeAlt20 = createSVGComponent('BootVolumeAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30h-7c-1.1028,0-2-.8972-2-2v-2h2v2h7v-7h-2v-2h2c1.1028,0,2,.8972,2,2v7c0,1.1028-.8972,2-2,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 24L14 24 13.9998 17.414 22.5823 26 24 24.5857 15.4139 15.9998 22 16 22 14 12 14 12 24z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,27H4c-1.104-.0013-1.9987-.896-2-2V5c.0013-1.104,.896-1.9987,2-2h7.5857c.5308-.0015,1.0401,.2095,1.4143,.5859l3.4143,3.4141h11.5857c1.104,.0013,1.9987,.896,2,2v7h-2v-7H15.5857l-4-4H4V25h4v2Z"
    }
  }]);

  const BootVolumeAlt16 = createSVGComponent('BootVolumeAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,30h-7c-1.1028,0-2-.8972-2-2v-2h2v2h7v-7h-2v-2h2c1.1028,0,2,.8972,2,2v7c0,1.1028-.8972,2-2,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 24L14 24 13.9998 17.414 22.5823 26 24 24.5857 15.4139 15.9998 22 16 22 14 12 14 12 24z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,27H4c-1.104-.0013-1.9987-.896-2-2V5c.0013-1.104,.896-1.9987,2-2h7.5857c.5308-.0015,1.0401,.2095,1.4143,.5859l3.4143,3.4141h11.5857c1.104,.0013,1.9987,.896,2,2v7h-2v-7H15.5857l-4-4H4V25h4v2Z"
    }
  }]);

  const BorderBottom32 = createSVGComponent('BorderBottom32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 27H29V29H3z",
      "transform": "rotate(180 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(180 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(180 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(180 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(180 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(180 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(180 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(180 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(180 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(180 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(180 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(180 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(180 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(180 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(180 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(180 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(180 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(180 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderBottom24 = createSVGComponent('BorderBottom24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 27H29V29H3z",
      "transform": "rotate(180 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(180 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(180 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(180 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(180 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(180 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(180 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(180 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(180 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(180 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(180 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(180 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(180 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(180 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(180 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(180 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(180 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(180 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderBottom20 = createSVGComponent('BorderBottom20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 27H29V29H3z",
      "transform": "rotate(180 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(180 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(180 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(180 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(180 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(180 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(180 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(180 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(180 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(180 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(180 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(180 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(180 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(180 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(180 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(180 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(180 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(180 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderBottom16 = createSVGComponent('BorderBottom16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 27H29V29H3z",
      "transform": "rotate(180 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(180 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(180 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(180 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(180 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(180 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(180 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(180 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(180 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(180 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(180 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(180 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(180 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(180 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(180 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(180 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(180 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(180 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderFull32 = createSVGComponent('BorderFull32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,29H3V3H29ZM5,27H27V5H5Z"
    }
  }]);

  const BorderFull24 = createSVGComponent('BorderFull24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,29H3V3H29ZM5,27H27V5H5Z"
    }
  }]);

  const BorderFull20 = createSVGComponent('BorderFull20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,29H3V3H29ZM5,27H27V5H5Z"
    }
  }]);

  const BorderFull16 = createSVGComponent('BorderFull16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,29H3V3H29ZM5,27H27V5H5Z"
    }
  }]);

  const BorderLeft32 = createSVGComponent('BorderLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M-9 15H17V17H-9z",
      "transform": "rotate(-90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(-90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(-90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(-90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(-90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(-90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 27H29V29H27z",
      "transform": "rotate(-90 28 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(-90 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(-90 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(-90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(-90 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(-90 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(-90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(-90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(-90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(-90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(-90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(-90 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderLeft24 = createSVGComponent('BorderLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M-9 15H17V17H-9z",
      "transform": "rotate(-90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(-90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(-90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(-90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(-90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(-90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 27H29V29H27z",
      "transform": "rotate(-90 28 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(-90 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(-90 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(-90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(-90 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(-90 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(-90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(-90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(-90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(-90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(-90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(-90 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderLeft20 = createSVGComponent('BorderLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M-9 15H17V17H-9z",
      "transform": "rotate(-90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(-90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(-90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(-90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(-90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(-90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 27H29V29H27z",
      "transform": "rotate(-90 28 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(-90 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(-90 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(-90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(-90 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(-90 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(-90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(-90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(-90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(-90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(-90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(-90 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderLeft16 = createSVGComponent('BorderLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M-9 15H17V17H-9z",
      "transform": "rotate(-90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(-90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(-90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(-90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(-90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(-90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 27H29V29H27z",
      "transform": "rotate(-90 28 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 23H29V25H27z",
      "transform": "rotate(-90 28 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 19H29V21H27z",
      "transform": "rotate(-90 28 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 15H29V17H27z",
      "transform": "rotate(-90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 7H29V9H27z",
      "transform": "rotate(-90 28 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V13H27z",
      "transform": "rotate(-90 28 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(-90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(-90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(-90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(-90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(-90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 3H29V5H27z",
      "transform": "rotate(-90 28 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderNone32 = createSVGComponent('BorderNone32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3zM7 3H9V5H7zM11 3H13V5H11zM15 3H17V5H15zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM27 3H29V5H27zM23 3H25V5H23zM19 3H21V5H19zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderNone24 = createSVGComponent('BorderNone24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3zM7 3H9V5H7zM11 3H13V5H11zM15 3H17V5H15zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM27 3H29V5H27zM23 3H25V5H23zM19 3H21V5H19zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderNone20 = createSVGComponent('BorderNone20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3zM7 3H9V5H7zM11 3H13V5H11zM15 3H17V5H15zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM27 3H29V5H27zM23 3H25V5H23zM19 3H21V5H19zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderNone16 = createSVGComponent('BorderNone16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3zM7 3H9V5H7zM11 3H13V5H11zM15 3H17V5H15zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM27 3H29V5H27zM23 3H25V5H23zM19 3H21V5H19zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderRight32 = createSVGComponent('BorderRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 15H41V17H15z",
      "transform": "rotate(90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(90 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(90 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(90 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(90 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(90 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 27H5V29H3z",
      "transform": "rotate(90 4 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderRight24 = createSVGComponent('BorderRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 15H41V17H15z",
      "transform": "rotate(90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(90 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(90 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(90 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(90 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(90 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 27H5V29H3z",
      "transform": "rotate(90 4 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderRight20 = createSVGComponent('BorderRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 15H41V17H15z",
      "transform": "rotate(90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(90 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(90 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(90 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(90 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(90 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 27H5V29H3z",
      "transform": "rotate(90 4 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderRight16 = createSVGComponent('BorderRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 15H41V17H15z",
      "transform": "rotate(90 28 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 3H25V5H23z",
      "transform": "rotate(90 24 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 3H21V5H19z",
      "transform": "rotate(90 20 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 3H17V5H15z",
      "transform": "rotate(90 16 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 3H13V5H11z",
      "transform": "rotate(90 12 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 3H9V5H7z",
      "transform": "rotate(90 8 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 3H5V5H3z",
      "transform": "rotate(90 4 4)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 7H5V9H3z",
      "transform": "rotate(90 4 8)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 11H5V13H3z",
      "transform": "rotate(90 4 12)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 15H5V17H3z",
      "transform": "rotate(90 4 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 23H5V25H3z",
      "transform": "rotate(90 4 24)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 19H5V21H3z",
      "transform": "rotate(90 4 20)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 27H25V29H23z",
      "transform": "rotate(90 24 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 27H21V29H19z",
      "transform": "rotate(90 20 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 27H17V29H15z",
      "transform": "rotate(90 16 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M11 27H13V29H11z",
      "transform": "rotate(90 12 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 27H9V29H7z",
      "transform": "rotate(90 8 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M3 27H5V29H3z",
      "transform": "rotate(90 4 28)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderTop32 = createSVGComponent('BorderTop32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H29V5H3zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderTop24 = createSVGComponent('BorderTop24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H29V5H3zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderTop20 = createSVGComponent('BorderTop20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H29V5H3zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const BorderTop16 = createSVGComponent('BorderTop16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M3 3H29V5H3zM3 7H5V9H3zM3 11H5V13H3zM3 15H5V17H3zM3 19H5V21H3zM3 23H5V25H3zM3 27H5V29H3zM7 27H9V29H7zM11 27H13V29H11zM15 27H17V29H15zM23 27H25V29H23zM19 27H21V29H19zM27 7H29V9H27zM27 11H29V13H27zM27 15H29V17H27zM27 19H29V21H27zM27 23H29V25H27zM27 27H29V29H27zM8 10H18V12H8zM8 15H14V17H8z"
    }
  }]);

  const Bot32 = createSVGComponent('Bot32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 10H20V12H18zM12 10H14V12H12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
    }
  }]);

  const Bot24 = createSVGComponent('Bot24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 10H20V12H18zM12 10H14V12H12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
    }
  }]);

  const Bot20 = createSVGComponent('Bot20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 10H20V12H18zM12 10H14V12H12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
    }
  }]);

  const Bot16 = createSVGComponent('Bot16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 10H20V12H18zM12 10H14V12H12z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
    }
  }]);

  const Bottles_0132 = createSVGComponent('Bottles_0132', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v14c0 .5522.4478 1 1 1H14c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zm1 18.6294H5V15c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v13z"
    }
  }]);

  const Bottles_0124 = createSVGComponent('Bottles_0124', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v14c0 .5522.4478 1 1 1H14c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zm1 18.6294H5V15c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v13z"
    }
  }]);

  const Bottles_0120 = createSVGComponent('Bottles_0120', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v14c0 .5522.4478 1 1 1H14c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zm1 18.6294H5V15c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v13z"
    }
  }]);

  const Bottles_0116 = createSVGComponent('Bottles_0116', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v14c0 .5522.4478 1 1 1H14c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zm1 18.6294H5V15c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v13z"
    }
  }]);

  const Bottles_01Dash32 = createSVGComponent('Bottles_01Dash32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM13 28h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM5 25H3v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM13 18H15V23H13zM3 18H5V23H3zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v1h2v-1c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v1h2v-1c0-3.4517-1.9326-5.0239-3-5.6294z"
    }
  }]);

  const Bottles_01Dash24 = createSVGComponent('Bottles_01Dash24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM13 28h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM5 25H3v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM13 18H15V23H13zM3 18H5V23H3zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v1h2v-1c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v1h2v-1c0-3.4517-1.9326-5.0239-3-5.6294z"
    }
  }]);

  const Bottles_01Dash20 = createSVGComponent('Bottles_01Dash20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM13 28h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM5 25H3v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM13 18H15V23H13zM3 18H5V23H3zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v1h2v-1c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v1h2v-1c0-3.4517-1.9326-5.0239-3-5.6294z"
    }
  }]);

  const Bottles_01Dash16 = createSVGComponent('Bottles_01Dash16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM19 9.3706V3c0-.5522-.4478-1-1-1h-3v2h2v6.7207s3 .5066 3 4.2793v13h-3v2h4c.5522 0 1-.4478 1-1V15c0-3.4517-1.9326-5.0239-3-5.6294zM13 28h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM5 25H3v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM13 18H15V23H13zM3 18H5V23H3zM12 9.3706V3c0-.5522-.4478-1-1-1H7c-.5522 0-1 .4478-1 1v6.3706c-1.0674.6055-3 2.1777-3 5.6294v1h2v-1c0-3.7725 3-4.2793 3-4.2793V4h2v6.7207s3 .5068 3 4.2793v1h2v-1c0-3.4517-1.9326-5.0239-3-5.6294z"
    }
  }]);

  const Bottles_0232 = createSVGComponent('Bottles_0232', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v12.5c0 .5522.4478 1 1 1h10c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zm0 15.9487H8V13.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v11.5z"
    }
  }]);

  const Bottles_0224 = createSVGComponent('Bottles_0224', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v12.5c0 .5522.4478 1 1 1h10c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zm0 15.9487H8V13.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v11.5z"
    }
  }]);

  const Bottles_0220 = createSVGComponent('Bottles_0220', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v12.5c0 .5522.4478 1 1 1h10c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zm0 15.9487H8V13.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v11.5z"
    }
  }]);

  const Bottles_0216 = createSVGComponent('Bottles_0216', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v12.5c0 .5522.4478 1 1 1h10c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zm0 15.9487H8V13.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v11.5z"
    }
  }]);

  const Bottles_02Dash32 = createSVGComponent('Bottles_02Dash32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 25h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM8 22h-2v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM16 16H18V20H16zM6 16H8V20H6zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v.5h2v-.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v.5h2v-.5c0-1.7129-.7229-3.3076-2-4.4487z"
    }
  }]);

  const Bottles_02Dash24 = createSVGComponent('Bottles_02Dash24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 25h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM8 22h-2v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM16 16H18V20H16zM6 16H8V20H6zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v.5h2v-.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v.5h2v-.5c0-1.7129-.7229-3.3076-2-4.4487z"
    }
  }]);

  const Bottles_02Dash20 = createSVGComponent('Bottles_02Dash20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 25h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM8 22h-2v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM16 16H18V20H16zM6 16H8V20H6zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v.5h2v-.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v.5h2v-.5c0-1.7129-.7229-3.3076-2-4.4487z"
    }
  }]);

  const Bottles_02Dash16 = createSVGComponent('Bottles_02Dash16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 9.0513v-3.0513c0-.5522-.4478-1-1-1h-3v2h2v3.02s2 1.1238 2 3.48v11.5h-4v2h5c.5522 0 1-.4478 1-1V13.5c0-1.7129-.7229-3.3076-2-4.4487zM16 25h-3v2h4c.5522 0 1-.4478 1-1v-4h-2v3zM8 22h-2v4c0 .5522.4478 1 1 1h4v-2h-3v-3zM16 16H18V20H16zM6 16H8V20H6zM16 9.0513v-3.0513c0-.5522-.4478-1-1-1h-6c-.5522 0-1 .4478-1 1v3.0513c-1.2771 1.1411-2 2.7358-2 4.4487v.5h2v-.5c0-2.356 2-3.48 2-3.48v-3.02h4v3.02s2 1.124 2 3.48v.5h2v-.5c0-1.7129-.7229-3.3076-2-4.4487z"
    }
  }]);

  const BottlesContainer32 = createSVGComponent('BottlesContainer32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 10v-2c0-.5522-.4478-1-1-1h-3v2h2v1.9688s2 1.1238 2 3.48v8.5513h-4v2h5c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zM15 10v-2c0-.5522-.4478-1-1-1h-4c-.5522 0-1 .4478-1 1v2c-1.2771 1.1411-2 2.7358-2 4.4487v9.5513c0 .5522.4478 1 1 1h8c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zm0 13h-6V14.4487c0-2.356 2-3.48 2-3.48v-1.9688h2v1.9688s2 1.124 2 3.48v8.5513z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4c-1.1046,0-2,.8954-2,2V28c0,1.1046,.8954,2,2,2H28c1.1046,0,2-.8954,2-2V4c0-1.1046-.8954-2-2-2Zm0,26H4V4H28V28Z"
    }
  }]);

  const BottlesContainer24 = createSVGComponent('BottlesContainer24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 10v-2c0-.5522-.4478-1-1-1h-3v2h2v1.9688s2 1.1238 2 3.48v8.5513h-4v2h5c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zM15 10v-2c0-.5522-.4478-1-1-1h-4c-.5522 0-1 .4478-1 1v2c-1.2771 1.1411-2 2.7358-2 4.4487v9.5513c0 .5522.4478 1 1 1h8c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zm0 13h-6V14.4487c0-2.356 2-3.48 2-3.48v-1.9688h2v1.9688s2 1.124 2 3.48v8.5513z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4c-1.1046,0-2,.8954-2,2V28c0,1.1046,.8954,2,2,2H28c1.1046,0,2-.8954,2-2V4c0-1.1046-.8954-2-2-2Zm0,26H4V4H28V28Z"
    }
  }]);

  const BottlesContainer20 = createSVGComponent('BottlesContainer20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 10v-2c0-.5522-.4478-1-1-1h-3v2h2v1.9688s2 1.1238 2 3.48v8.5513h-4v2h5c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zM15 10v-2c0-.5522-.4478-1-1-1h-4c-.5522 0-1 .4478-1 1v2c-1.2771 1.1411-2 2.7358-2 4.4487v9.5513c0 .5522.4478 1 1 1h8c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zm0 13h-6V14.4487c0-2.356 2-3.48 2-3.48v-1.9688h2v1.9688s2 1.124 2 3.48v8.5513z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4c-1.1046,0-2,.8954-2,2V28c0,1.1046,.8954,2,2,2H28c1.1046,0,2-.8954,2-2V4c0-1.1046-.8954-2-2-2Zm0,26H4V4H28V28Z"
    }
  }]);

  const BottlesContainer16 = createSVGComponent('BottlesContainer16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 10v-2c0-.5522-.4478-1-1-1h-3v2h2v1.9688s2 1.1238 2 3.48v8.5513h-4v2h5c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zM15 10v-2c0-.5522-.4478-1-1-1h-4c-.5522 0-1 .4478-1 1v2c-1.2771 1.1411-2 2.7358-2 4.4487v9.5513c0 .5522.4478 1 1 1h8c.5522 0 1-.4478 1-1V14.4487c0-1.7129-.7229-3.3076-2-4.4487zm0 13h-6V14.4487c0-2.356 2-3.48 2-3.48v-1.9688h2v1.9688s2 1.124 2 3.48v8.5513z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4c-1.1046,0-2,.8954-2,2V28c0,1.1046,.8954,2,2,2H28c1.1046,0,2-.8954,2-2V4c0-1.1046-.8954-2-2-2Zm0,26H4V4H28V28Z"
    }
  }]);

  const Box32 = createSVGComponent('Box32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
    }
  }]);

  const Box24 = createSVGComponent('Box24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
    }
  }]);

  const Box20 = createSVGComponent('Box20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
    }
  }]);

  const Box16 = createSVGComponent('Box16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
    }
  }]);

  const BoxExtraLarge32 = createSVGComponent('BoxExtraLarge32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 21L19 9 17 9 17 23 24 23 24 21 19 21zM16 9L14 9 12 15 10 9 8 9 10.752 16 8 23 10 23 12 17 14 23 16 23 13.245 16 16 9zM4 4H28V6H4z"
    }
  }]);

  const BoxExtraLarge24 = createSVGComponent('BoxExtraLarge24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 21L19 9 17 9 17 23 24 23 24 21 19 21zM16 9L14 9 12 15 10 9 8 9 10.752 16 8 23 10 23 12 17 14 23 16 23 13.245 16 16 9zM4 4H28V6H4z"
    }
  }]);

  const BoxExtraLarge20 = createSVGComponent('BoxExtraLarge20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 21L19 9 17 9 17 23 24 23 24 21 19 21zM16 9L14 9 12 15 10 9 8 9 10.752 16 8 23 10 23 12 17 14 23 16 23 13.245 16 16 9zM4 4H28V6H4z"
    }
  }]);

  const BoxExtraLarge16 = createSVGComponent('BoxExtraLarge16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 21L19 9 17 9 17 23 24 23 24 21 19 21zM16 9L14 9 12 15 10 9 8 9 10.752 16 8 23 10 23 12 17 14 23 16 23 13.245 16 16 9zM4 4H28V6H4z"
    }
  }]);

  const BoxLarge32 = createSVGComponent('BoxLarge32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21L14 9 12 9 12 23 20 23 20 21 14 21zM4 4H28V6H4z"
    }
  }]);

  const BoxLarge24 = createSVGComponent('BoxLarge24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21L14 9 12 9 12 23 20 23 20 21 14 21zM4 4H28V6H4z"
    }
  }]);

  const BoxLarge20 = createSVGComponent('BoxLarge20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21L14 9 12 9 12 23 20 23 20 21 14 21zM4 4H28V6H4z"
    }
  }]);

  const BoxLarge16 = createSVGComponent('BoxLarge16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21L14 9 12 9 12 23 20 23 20 21 14 21zM4 4H28V6H4z"
    }
  }]);

  const BoxMedium32 = createSVGComponent('BoxMedium32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 9L16.485 14 16 15.977 15.535 14 14 9 12 9 12 23 14 23 14 15 13.842 13.004 14.421 15 16 19.626 17.579 15 18.159 13 18 15 18 23 20 23 20 9 18 9zM4 4H28V6H4z"
    }
  }]);

  const BoxMedium24 = createSVGComponent('BoxMedium24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 9L16.485 14 16 15.977 15.535 14 14 9 12 9 12 23 14 23 14 15 13.842 13.004 14.421 15 16 19.626 17.579 15 18.159 13 18 15 18 23 20 23 20 9 18 9zM4 4H28V6H4z"
    }
  }]);

  const BoxMedium20 = createSVGComponent('BoxMedium20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 9L16.485 14 16 15.977 15.535 14 14 9 12 9 12 23 14 23 14 15 13.842 13.004 14.421 15 16 19.626 17.579 15 18.159 13 18 15 18 23 20 23 20 9 18 9zM4 4H28V6H4z"
    }
  }]);

  const BoxMedium16 = createSVGComponent('BoxMedium16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 9L16.485 14 16 15.977 15.535 14 14 9 12 9 12 23 14 23 14 15 13.842 13.004 14.421 15 16 19.626 17.579 15 18.159 13 18 15 18 23 20 23 20 9 18 9zM4 4H28V6H4z"
    }
  }]);

  const BoxSmall32 = createSVGComponent('BoxSmall32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 23H12V21h6V17H14a2.002 2.002 0 01-2-2V11a2.002 2.002 0 012-2h6v2H14v4h4a2.002 2.002 0 012 2v4A2.0023 2.0023 0 0118 23zM4 4H28V6H4z"
    }
  }]);

  const BoxSmall24 = createSVGComponent('BoxSmall24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 23H12V21h6V17H14a2.002 2.002 0 01-2-2V11a2.002 2.002 0 012-2h6v2H14v4h4a2.002 2.002 0 012 2v4A2.0023 2.0023 0 0118 23zM4 4H28V6H4z"
    }
  }]);

  const BoxSmall20 = createSVGComponent('BoxSmall20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 23H12V21h6V17H14a2.002 2.002 0 01-2-2V11a2.002 2.002 0 012-2h6v2H14v4h4a2.002 2.002 0 012 2v4A2.0023 2.0023 0 0118 23zM4 4H28V6H4z"
    }
  }]);

  const BoxSmall16 = createSVGComponent('BoxSmall16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,28H6a2.0021,2.0021,0,0,1-2-2V9H6V26H26V9h2V26A2.0021,2.0021,0,0,1,26,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 23H12V21h6V17H14a2.002 2.002 0 01-2-2V11a2.002 2.002 0 012-2h6v2H14v4h4a2.002 2.002 0 012 2v4A2.0023 2.0023 0 0118 23zM4 4H28V6H4z"
    }
  }]);

  const BoxPlot32 = createSVGComponent('BoxPlot32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const BoxPlot24 = createSVGComponent('BoxPlot24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const BoxPlot20 = createSVGComponent('BoxPlot20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const BoxPlot16 = createSVGComponent('BoxPlot16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const Branch32 = createSVGComponent('Branch32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
    }
  }]);

  const Branch24 = createSVGComponent('Branch24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
    }
  }]);

  const Branch20 = createSVGComponent('Branch20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
    }
  }]);

  const Branch16 = createSVGComponent('Branch16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
    }
  }]);

  const BreakingChange32 = createSVGComponent('BreakingChange32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 25a6 6 0 10-6 6A6.0066 6.0066 0 0031 25zm-2 0a3.9521 3.9521 0 01-.5669 2.019L22.981 21.5669A3.9529 3.9529 0 0125 21 4.0045 4.0045 0 0129 25zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0125 29 4.0045 4.0045 0 0121 25zM19.59 16L17 18.59 18.42 20 22.42 16 18.42 12 17 13.41 19.59 16zM10.41 16L13 13.41 11.58 12 7.58 16 11.58 20 13 18.59 10.41 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,9H26v7h2V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H16V24H4ZM4,4H26V7H4Z"
    }
  }]);

  const BreakingChange24 = createSVGComponent('BreakingChange24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 25a6 6 0 10-6 6A6.0066 6.0066 0 0031 25zm-2 0a3.9521 3.9521 0 01-.5669 2.019L22.981 21.5669A3.9529 3.9529 0 0125 21 4.0045 4.0045 0 0129 25zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0125 29 4.0045 4.0045 0 0121 25zM19.59 16L17 18.59 18.42 20 22.42 16 18.42 12 17 13.41 19.59 16zM10.41 16L13 13.41 11.58 12 7.58 16 11.58 20 13 18.59 10.41 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,9H26v7h2V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H16V24H4ZM4,4H26V7H4Z"
    }
  }]);

  const BreakingChange20 = createSVGComponent('BreakingChange20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 25a6 6 0 10-6 6A6.0066 6.0066 0 0031 25zm-2 0a3.9521 3.9521 0 01-.5669 2.019L22.981 21.5669A3.9529 3.9529 0 0125 21 4.0045 4.0045 0 0129 25zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0125 29 4.0045 4.0045 0 0121 25zM19.59 16L17 18.59 18.42 20 22.42 16 18.42 12 17 13.41 19.59 16zM10.41 16L13 13.41 11.58 12 7.58 16 11.58 20 13 18.59 10.41 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,9H26v7h2V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H16V24H4ZM4,4H26V7H4Z"
    }
  }]);

  const BreakingChange16 = createSVGComponent('BreakingChange16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 25a6 6 0 10-6 6A6.0066 6.0066 0 0031 25zm-2 0a3.9521 3.9521 0 01-.5669 2.019L22.981 21.5669A3.9529 3.9529 0 0125 21 4.0045 4.0045 0 0129 25zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0125 29 4.0045 4.0045 0 0121 25zM19.59 16L17 18.59 18.42 20 22.42 16 18.42 12 17 13.41 19.59 16zM10.41 16L13 13.41 11.58 12 7.58 16 11.58 20 13 18.59 10.41 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,9H26v7h2V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H16V24H4ZM4,4H26V7H4Z"
    }
  }]);

  const BrightnessContrast32 = createSVGComponent('BrightnessContrast32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V5H15zM27 15H30V17H27zM15 27H17V30H15zM2 15H5V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.22 5.73H8.219999999999999V8.73H6.22z",
      "transform": "rotate(-45 7.227 7.236)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.27 6.23H26.27V8.23H23.27z",
      "transform": "rotate(-45 24.766 7.232)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.77 23.27H25.77V26.27H23.77z",
      "transform": "rotate(-45 24.77 24.77)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.47 25.13L7.59 23 9 24.42 6.88 26.54 5.47 25.13zM16 8a8 8 0 108 8A8 8 0 0016 8zm0 14a6 6 0 010-12z"
    }
  }]);

  const BrightnessContrast24 = createSVGComponent('BrightnessContrast24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V5H15zM27 15H30V17H27zM15 27H17V30H15zM2 15H5V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.22 5.73H8.219999999999999V8.73H6.22z",
      "transform": "rotate(-45 7.227 7.236)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.27 6.23H26.27V8.23H23.27z",
      "transform": "rotate(-45 24.766 7.232)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.77 23.27H25.77V26.27H23.77z",
      "transform": "rotate(-45 24.77 24.77)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.47 25.13L7.59 23 9 24.42 6.88 26.54 5.47 25.13zM16 8a8 8 0 108 8A8 8 0 0016 8zm0 14a6 6 0 010-12z"
    }
  }]);

  const BrightnessContrast20 = createSVGComponent('BrightnessContrast20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V5H15zM27 15H30V17H27zM15 27H17V30H15zM2 15H5V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.22 5.73H8.219999999999999V8.73H6.22z",
      "transform": "rotate(-45 7.227 7.236)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.27 6.23H26.27V8.23H23.27z",
      "transform": "rotate(-45 24.766 7.232)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.77 23.27H25.77V26.27H23.77z",
      "transform": "rotate(-45 24.77 24.77)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.47 25.13L7.59 23 9 24.42 6.88 26.54 5.47 25.13zM16 8a8 8 0 108 8A8 8 0 0016 8zm0 14a6 6 0 010-12z"
    }
  }]);

  const BrightnessContrast16 = createSVGComponent('BrightnessContrast16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 2H17V5H15zM27 15H30V17H27zM15 27H17V30H15zM2 15H5V17H2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6.22 5.73H8.219999999999999V8.73H6.22z",
      "transform": "rotate(-45 7.227 7.236)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.27 6.23H26.27V8.23H23.27z",
      "transform": "rotate(-45 24.766 7.232)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.77 23.27H25.77V26.27H23.77z",
      "transform": "rotate(-45 24.77 24.77)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.47 25.13L7.59 23 9 24.42 6.88 26.54 5.47 25.13zM16 8a8 8 0 108 8A8 8 0 0016 8zm0 14a6 6 0 010-12z"
    }
  }]);

  const BringForward32 = createSVGComponent('BringForward32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 15H10V12a2.0023 2.0023 0 012-2h3v2H12zM15 30H12a2.0023 2.0023 0 01-2-2V25h2v3h3zM18 28H22V30H18zM28 30H25V28h3V25h2v3A2.0023 2.0023 0 0128 30zM10 18H12V22H10zM28 18H30V22H28zM30 15H28V12H25V10h3a2.0023 2.0023 0 012 2zM18 10H22V12H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,22H4a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,4,2H20a2.0023,2.0023,0,0,1,2,2V8H20V4H4V20H8Z"
    }
  }]);

  const BringForward24 = createSVGComponent('BringForward24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 15H10V12a2.0023 2.0023 0 012-2h3v2H12zM15 30H12a2.0023 2.0023 0 01-2-2V25h2v3h3zM18 28H22V30H18zM28 30H25V28h3V25h2v3A2.0023 2.0023 0 0128 30zM10 18H12V22H10zM28 18H30V22H28zM30 15H28V12H25V10h3a2.0023 2.0023 0 012 2zM18 10H22V12H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,22H4a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,4,2H20a2.0023,2.0023,0,0,1,2,2V8H20V4H4V20H8Z"
    }
  }]);

  const BringForward20 = createSVGComponent('BringForward20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 15H10V12a2.0023 2.0023 0 012-2h3v2H12zM15 30H12a2.0023 2.0023 0 01-2-2V25h2v3h3zM18 28H22V30H18zM28 30H25V28h3V25h2v3A2.0023 2.0023 0 0128 30zM10 18H12V22H10zM28 18H30V22H28zM30 15H28V12H25V10h3a2.0023 2.0023 0 012 2zM18 10H22V12H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,22H4a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,4,2H20a2.0023,2.0023,0,0,1,2,2V8H20V4H4V20H8Z"
    }
  }]);

  const BringForward16 = createSVGComponent('BringForward16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 15H10V12a2.0023 2.0023 0 012-2h3v2H12zM15 30H12a2.0023 2.0023 0 01-2-2V25h2v3h3zM18 28H22V30H18zM28 30H25V28h3V25h2v3A2.0023 2.0023 0 0128 30zM10 18H12V22H10zM28 18H30V22H28zM30 15H28V12H25V10h3a2.0023 2.0023 0 012 2zM18 10H22V12H18z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,22H4a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,4,2H20a2.0023,2.0023,0,0,1,2,2V8H20V4H4V20H8Z"
    }
  }]);

  const BringToFront32 = createSVGComponent('BringToFront32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,10H22V4a2.0023,2.0023,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,4V20a2.0023,2.0023,0,0,0,2,2h6v6a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V12A2,2,0,0,0,28,10ZM4,20,3.9985,4H20v6H12a2,2,0,0,0-2,2v8Z"
    }
  }]);

  const BringToFront24 = createSVGComponent('BringToFront24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,10H22V4a2.0023,2.0023,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,4V20a2.0023,2.0023,0,0,0,2,2h6v6a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V12A2,2,0,0,0,28,10ZM4,20,3.9985,4H20v6H12a2,2,0,0,0-2,2v8Z"
    }
  }]);

  const BringToFront20 = createSVGComponent('BringToFront20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,10H22V4a2.0023,2.0023,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,4V20a2.0023,2.0023,0,0,0,2,2h6v6a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V12A2,2,0,0,0,28,10ZM4,20,3.9985,4H20v6H12a2,2,0,0,0-2,2v8Z"
    }
  }]);

  const BringToFront16 = createSVGComponent('BringToFront16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,10H22V4a2.0023,2.0023,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,4V20a2.0023,2.0023,0,0,0,2,2h6v6a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V12A2,2,0,0,0,28,10ZM4,20,3.9985,4H20v6H12a2,2,0,0,0-2,2v8Z"
    }
  }]);

  const WatsonHealthBrushFreehand32 = createSVGComponent('WatsonHealthBrushFreehand32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM6.5 15A3.4994 3.4994 0 014.0249 9.026l3.5005-3.5a1.5019 1.5019 0 000-2.121 1.537 1.537 0 00-2.1216 0L3.415 5.3936 2 3.98 3.99 1.9915a3.5849 3.5849 0 014.95 0 3.5039 3.5039 0 010 4.949L5.439 10.44a1.5019 1.5019 0 000 2.121 1.5369 1.5369 0 002.1215 0l4.0249-4.0243L13 9.9507 8.9746 13.975A3.4754 3.4754 0 016.5 15z"
    }
  }]);

  const WatsonHealthBrushFreehand24 = createSVGComponent('WatsonHealthBrushFreehand24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM6.5 15A3.4994 3.4994 0 014.0249 9.026l3.5005-3.5a1.5019 1.5019 0 000-2.121 1.537 1.537 0 00-2.1216 0L3.415 5.3936 2 3.98 3.99 1.9915a3.5849 3.5849 0 014.95 0 3.5039 3.5039 0 010 4.949L5.439 10.44a1.5019 1.5019 0 000 2.121 1.5369 1.5369 0 002.1215 0l4.0249-4.0243L13 9.9507 8.9746 13.975A3.4754 3.4754 0 016.5 15z"
    }
  }]);

  const WatsonHealthBrushFreehand20 = createSVGComponent('WatsonHealthBrushFreehand20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM6.5 15A3.4994 3.4994 0 014.0249 9.026l3.5005-3.5a1.5019 1.5019 0 000-2.121 1.537 1.537 0 00-2.1216 0L3.415 5.3936 2 3.98 3.99 1.9915a3.5849 3.5849 0 014.95 0 3.5039 3.5039 0 010 4.949L5.439 10.44a1.5019 1.5019 0 000 2.121 1.5369 1.5369 0 002.1215 0l4.0249-4.0243L13 9.9507 8.9746 13.975A3.4754 3.4754 0 016.5 15z"
    }
  }]);

  const WatsonHealthBrushFreehand16 = createSVGComponent('WatsonHealthBrushFreehand16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM6.5 15A3.4994 3.4994 0 014.0249 9.026l3.5005-3.5a1.5019 1.5019 0 000-2.121 1.537 1.537 0 00-2.1216 0L3.415 5.3936 2 3.98 3.99 1.9915a3.5849 3.5849 0 014.95 0 3.5039 3.5039 0 010 4.949L5.439 10.44a1.5019 1.5019 0 000 2.121 1.5369 1.5369 0 002.1215 0l4.0249-4.0243L13 9.9507 8.9746 13.975A3.4754 3.4754 0 016.5 15z"
    }
  }]);

  const WatsonHealthBrushPolygon32 = createSVGComponent('WatsonHealthBrushPolygon32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM14 2a2.9948 2.9948 0 00-2.8157 2H7.8157A2.9925 2.9925 0 104 7.8154v3.3687a3 3 0 102 0V7.8159A2.9959 2.9959 0 007.8157 6h3.3686A2.9947 2.9947 0 1014 2zM5 15a1 1 0 111-1A1.0008 1.0008 0 015 15zM5 6A1 1 0 116 5 1.0008 1.0008 0 015 6zm9 0a1 1 0 111-1A1.0008 1.0008 0 0114 6z"
    }
  }]);

  const WatsonHealthBrushPolygon24 = createSVGComponent('WatsonHealthBrushPolygon24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM14 2a2.9948 2.9948 0 00-2.8157 2H7.8157A2.9925 2.9925 0 104 7.8154v3.3687a3 3 0 102 0V7.8159A2.9959 2.9959 0 007.8157 6h3.3686A2.9947 2.9947 0 1014 2zM5 15a1 1 0 111-1A1.0008 1.0008 0 015 15zM5 6A1 1 0 116 5 1.0008 1.0008 0 015 6zm9 0a1 1 0 111-1A1.0008 1.0008 0 0114 6z"
    }
  }]);

  const WatsonHealthBrushPolygon20 = createSVGComponent('WatsonHealthBrushPolygon20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM14 2a2.9948 2.9948 0 00-2.8157 2H7.8157A2.9925 2.9925 0 104 7.8154v3.3687a3 3 0 102 0V7.8159A2.9959 2.9959 0 007.8157 6h3.3686A2.9947 2.9947 0 1014 2zM5 15a1 1 0 111-1A1.0008 1.0008 0 015 15zM5 6A1 1 0 116 5 1.0008 1.0008 0 015 6zm9 0a1 1 0 111-1A1.0008 1.0008 0 0114 6z"
    }
  }]);

  const WatsonHealthBrushPolygon16 = createSVGComponent('WatsonHealthBrushPolygon16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.8281 3.1719a4.0941 4.0941 0 00-5.6562 0L4.05 22.292A6.9537 6.9537 0 002 27.2412V30H4.7559a6.9523 6.9523 0 004.95-2.05L28.8281 8.8286a3.999 3.999 0 000-5.6567zM10.91 18.26l2.8286 2.8286L11.6172 23.21 8.7886 20.3818zM8.2915 26.5356A4.9665 4.9665 0 014.7559 28H4v-.7588a4.9669 4.9669 0 011.4644-3.5351l1.91-1.91 2.8286 2.8281zM27.4141 7.4141L15.1528 19.6748l-2.8286-2.8286 12.2617-12.26a2.0473 2.0473 0 012.8282 0 1.9995 1.9995 0 010 2.8282zM14 2a2.9948 2.9948 0 00-2.8157 2H7.8157A2.9925 2.9925 0 104 7.8154v3.3687a3 3 0 102 0V7.8159A2.9959 2.9959 0 007.8157 6h3.3686A2.9947 2.9947 0 1014 2zM5 15a1 1 0 111-1A1.0008 1.0008 0 015 15zM5 6A1 1 0 116 5 1.0008 1.0008 0 015 6zm9 0a1 1 0 111-1A1.0008 1.0008 0 0114 6z"
    }
  }]);

  const BuildTool32 = createSVGComponent('BuildTool32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,14h-1V7c0-1.1-0.9-2-2-2h-6v2h6v7h-1c-1.1,0-2,0.9-2,2v9H9.9c-0.4-1.4-1.5-2.5-2.9-2.9V7h6.2l-2.6,2.6L12,11l5-5l-5-5\tl-1.4,1.4L13.2,5H7C5.9,5,5,5.9,5,7v15.1c-1.7,0.4-3,2-3,3.9c0,2.2,1.8,4,4,4c1.9,0,3.4-1.3,3.9-3H22v1c0,1.1,0.9,2,2,2h4\tc1.1,0,2-0.9,2-2V16C30,14.9,29.1,14,28,14z M6,28c-1.1,0-2-0.9-2-2s0.9-2,2-2c1.1,0,2,0.9,2,2S7.1,28,6,28z M24,28V16h4v12H24z"
    }
  }]);

  const BuildTool24 = createSVGComponent('BuildTool24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,14h-1V7c0-1.1-0.9-2-2-2h-6v2h6v7h-1c-1.1,0-2,0.9-2,2v9H9.9c-0.4-1.4-1.5-2.5-2.9-2.9V7h6.2l-2.6,2.6L12,11l5-5l-5-5\tl-1.4,1.4L13.2,5H7C5.9,5,5,5.9,5,7v15.1c-1.7,0.4-3,2-3,3.9c0,2.2,1.8,4,4,4c1.9,0,3.4-1.3,3.9-3H22v1c0,1.1,0.9,2,2,2h4\tc1.1,0,2-0.9,2-2V16C30,14.9,29.1,14,28,14z M6,28c-1.1,0-2-0.9-2-2s0.9-2,2-2c1.1,0,2,0.9,2,2S7.1,28,6,28z M24,28V16h4v12H24z"
    }
  }]);

  const BuildTool20 = createSVGComponent('BuildTool20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,14h-1V7c0-1.1-0.9-2-2-2h-6v2h6v7h-1c-1.1,0-2,0.9-2,2v9H9.9c-0.4-1.4-1.5-2.5-2.9-2.9V7h6.2l-2.6,2.6L12,11l5-5l-5-5\tl-1.4,1.4L13.2,5H7C5.9,5,5,5.9,5,7v15.1c-1.7,0.4-3,2-3,3.9c0,2.2,1.8,4,4,4c1.9,0,3.4-1.3,3.9-3H22v1c0,1.1,0.9,2,2,2h4\tc1.1,0,2-0.9,2-2V16C30,14.9,29.1,14,28,14z M6,28c-1.1,0-2-0.9-2-2s0.9-2,2-2c1.1,0,2,0.9,2,2S7.1,28,6,28z M24,28V16h4v12H24z"
    }
  }]);

  const BuildTool16 = createSVGComponent('BuildTool16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,14h-1V7c0-1.1-0.9-2-2-2h-6v2h6v7h-1c-1.1,0-2,0.9-2,2v9H9.9c-0.4-1.4-1.5-2.5-2.9-2.9V7h6.2l-2.6,2.6L12,11l5-5l-5-5\tl-1.4,1.4L13.2,5H7C5.9,5,5,5.9,5,7v15.1c-1.7,0.4-3,2-3,3.9c0,2.2,1.8,4,4,4c1.9,0,3.4-1.3,3.9-3H22v1c0,1.1,0.9,2,2,2h4\tc1.1,0,2-0.9,2-2V16C30,14.9,29.1,14,28,14z M6,28c-1.1,0-2-0.9-2-2s0.9-2,2-2c1.1,0,2,0.9,2,2S7.1,28,6,28z M24,28V16h4v12H24z"
    }
  }]);

  const Building32 = createSVGComponent('Building32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24z"
    }
  }]);

  const Building24 = createSVGComponent('Building24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24z"
    }
  }]);

  const Building20 = createSVGComponent('Building20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24z"
    }
  }]);

  const Building16 = createSVGComponent('Building16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24z"
    }
  }]);

  const BuildingInsights_132 = createSVGComponent('BuildingInsights_132', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM9 12H7a5.0059 5.0059 0 015-5V9A3.0033 3.0033 0 009 12zM4 12H2A10.0114 10.0114 0 0112 2V4A8.0092 8.0092 0 004 12z"
    }
  }]);

  const BuildingInsights_124 = createSVGComponent('BuildingInsights_124', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM9 12H7a5.0059 5.0059 0 015-5V9A3.0033 3.0033 0 009 12zM4 12H2A10.0114 10.0114 0 0112 2V4A8.0092 8.0092 0 004 12z"
    }
  }]);

  const BuildingInsights_120 = createSVGComponent('BuildingInsights_120', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM9 12H7a5.0059 5.0059 0 015-5V9A3.0033 3.0033 0 009 12zM4 12H2A10.0114 10.0114 0 0112 2V4A8.0092 8.0092 0 004 12z"
    }
  }]);

  const BuildingInsights_116 = createSVGComponent('BuildingInsights_116', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM9 12H7a5.0059 5.0059 0 015-5V9A3.0033 3.0033 0 009 12zM4 12H2A10.0114 10.0114 0 0112 2V4A8.0092 8.0092 0 004 12z"
    }
  }]);

  const BuildingInsights_232 = createSVGComponent('BuildingInsights_232', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM5.5 12a3.5 3.5 0 010-7h.627A4.0062 4.0062 0 0110 2h2V4L10 4A2.0023 2.0023 0 008 6V7H5.5a1.5 1.5 0 000 3H12v2z"
    }
  }]);

  const BuildingInsights_224 = createSVGComponent('BuildingInsights_224', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM5.5 12a3.5 3.5 0 010-7h.627A4.0062 4.0062 0 0110 2h2V4L10 4A2.0023 2.0023 0 008 6V7H5.5a1.5 1.5 0 000 3H12v2z"
    }
  }]);

  const BuildingInsights_220 = createSVGComponent('BuildingInsights_220', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM5.5 12a3.5 3.5 0 010-7h.627A4.0062 4.0062 0 0110 2h2V4L10 4A2.0023 2.0023 0 008 6V7H5.5a1.5 1.5 0 000 3H12v2z"
    }
  }]);

  const BuildingInsights_216 = createSVGComponent('BuildingInsights_216', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM5.5 12a3.5 3.5 0 010-7h.627A4.0062 4.0062 0 0110 2h2V4L10 4A2.0023 2.0023 0 008 6V7H5.5a1.5 1.5 0 000 3H12v2z"
    }
  }]);

  const BuildingInsights_332 = createSVGComponent('BuildingInsights_332', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM2 10H7V12H2zM10 2H12V7H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.5 3.964H7.5V9.035H5.5z",
      "transform": "rotate(-45 6.5 6.5)"
    }
  }]);

  const BuildingInsights_324 = createSVGComponent('BuildingInsights_324', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM2 10H7V12H2zM10 2H12V7H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.5 3.964H7.5V9.035H5.5z",
      "transform": "rotate(-45 6.5 6.5)"
    }
  }]);

  const BuildingInsights_320 = createSVGComponent('BuildingInsights_320', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM2 10H7V12H2zM10 2H12V7H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.5 3.964H7.5V9.035H5.5z",
      "transform": "rotate(-45 6.5 6.5)"
    }
  }]);

  const BuildingInsights_316 = createSVGComponent('BuildingInsights_316', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 8H20V10H18zM24 8H26V10H24zM18 14H20V16H18zM24 14H26V16H24zM18 20H20V22H18zM24 20H26V22H24zM2 10H7V12H2zM10 2H12V7H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5.5 3.964H7.5V9.035H5.5z",
      "transform": "rotate(-45 6.5 6.5)"
    }
  }]);

  const Bullhorn32 = createSVGComponent('Bullhorn32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"
    }
  }]);

  const Bullhorn24 = createSVGComponent('Bullhorn24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"
    }
  }]);

  const Bullhorn20 = createSVGComponent('Bullhorn20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"
    }
  }]);

  const Bullhorn16 = createSVGComponent('Bullhorn16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"
    }
  }]);

  const Buoy32 = createSVGComponent('Buoy32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,22a3.4376,3.4376,0,0,1-3.0513-2.3164,1,1,0,0,0-1.8955-.0049A3.44,3.44,0,0,1,20,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,16,19a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,12,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,8,19a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,4,22H2v2H4a4.9316,4.9316,0,0,0,4-1.9873,5.5965,5.5965,0,0,0,1,.9912,7,7,0,0,0,14,0,5.5965,5.5965,0,0,0,1-.9912A4.9316,4.9316,0,0,0,28,24h2V22ZM16,28a5.0021,5.0021,0,0,1-4.9075-4.0854A5.2252,5.2252,0,0,0,12,24a4.9316,4.9316,0,0,0,4-1.9873A4.9316,4.9316,0,0,0,20,24a5.2252,5.2252,0,0,0,.9075-.0854A5.0021,5.0021,0,0,1,16,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.07,7.8345A2.0116,2.0116,0,0,0,18.0771,6H17V2H15V6H13.9175a1.9949,1.9949,0,0,0-1.9859,1.7715L10.2805,19h2.021l.7346-5h5.9212l.7351,5h2.021ZM13.33,12l.5877-4,4.167.0625L18.6633,12Z"
    }
  }]);

  const Buoy24 = createSVGComponent('Buoy24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,22a3.4376,3.4376,0,0,1-3.0513-2.3164,1,1,0,0,0-1.8955-.0049A3.44,3.44,0,0,1,20,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,16,19a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,12,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,8,19a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,4,22H2v2H4a4.9316,4.9316,0,0,0,4-1.9873,5.5965,5.5965,0,0,0,1,.9912,7,7,0,0,0,14,0,5.5965,5.5965,0,0,0,1-.9912A4.9316,4.9316,0,0,0,28,24h2V22ZM16,28a5.0021,5.0021,0,0,1-4.9075-4.0854A5.2252,5.2252,0,0,0,12,24a4.9316,4.9316,0,0,0,4-1.9873A4.9316,4.9316,0,0,0,20,24a5.2252,5.2252,0,0,0,.9075-.0854A5.0021,5.0021,0,0,1,16,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.07,7.8345A2.0116,2.0116,0,0,0,18.0771,6H17V2H15V6H13.9175a1.9949,1.9949,0,0,0-1.9859,1.7715L10.2805,19h2.021l.7346-5h5.9212l.7351,5h2.021ZM13.33,12l.5877-4,4.167.0625L18.6633,12Z"
    }
  }]);

  const Buoy20 = createSVGComponent('Buoy20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,22a3.4376,3.4376,0,0,1-3.0513-2.3164,1,1,0,0,0-1.8955-.0049A3.44,3.44,0,0,1,20,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,16,19a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,12,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,8,19a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,4,22H2v2H4a4.9316,4.9316,0,0,0,4-1.9873,5.5965,5.5965,0,0,0,1,.9912,7,7,0,0,0,14,0,5.5965,5.5965,0,0,0,1-.9912A4.9316,4.9316,0,0,0,28,24h2V22ZM16,28a5.0021,5.0021,0,0,1-4.9075-4.0854A5.2252,5.2252,0,0,0,12,24a4.9316,4.9316,0,0,0,4-1.9873A4.9316,4.9316,0,0,0,20,24a5.2252,5.2252,0,0,0,.9075-.0854A5.0021,5.0021,0,0,1,16,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.07,7.8345A2.0116,2.0116,0,0,0,18.0771,6H17V2H15V6H13.9175a1.9949,1.9949,0,0,0-1.9859,1.7715L10.2805,19h2.021l.7346-5h5.9212l.7351,5h2.021ZM13.33,12l.5877-4,4.167.0625L18.6633,12Z"
    }
  }]);

  const Buoy16 = createSVGComponent('Buoy16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,22a3.4376,3.4376,0,0,1-3.0513-2.3164,1,1,0,0,0-1.8955-.0049A3.44,3.44,0,0,1,20,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,16,19a.9894.9894,0,0,0-.9468.6787A3.44,3.44,0,0,1,12,22a3.4376,3.4376,0,0,1-3.0513-2.3164A1.007,1.007,0,0,0,8,19a.971.971,0,0,0-.9468.6787A3.44,3.44,0,0,1,4,22H2v2H4a4.9316,4.9316,0,0,0,4-1.9873,5.5965,5.5965,0,0,0,1,.9912,7,7,0,0,0,14,0,5.5965,5.5965,0,0,0,1-.9912A4.9316,4.9316,0,0,0,28,24h2V22ZM16,28a5.0021,5.0021,0,0,1-4.9075-4.0854A5.2252,5.2252,0,0,0,12,24a4.9316,4.9316,0,0,0,4-1.9873A4.9316,4.9316,0,0,0,20,24a5.2252,5.2252,0,0,0,.9075-.0854A5.0021,5.0021,0,0,1,16,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.07,7.8345A2.0116,2.0116,0,0,0,18.0771,6H17V2H15V6H13.9175a1.9949,1.9949,0,0,0-1.9859,1.7715L10.2805,19h2.021l.7346-5h5.9212l.7351,5h2.021ZM13.33,12l.5877-4,4.167.0625L18.6633,12Z"
    }
  }]);

  const Bus32 = createSVGComponent('Bus32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V15H27zM3 11H5V15H3zM20 20H22V22H20zM10 20H12V22H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"
    }
  }]);

  const Bus24 = createSVGComponent('Bus24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V15H27zM3 11H5V15H3zM20 20H22V22H20zM10 20H12V22H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"
    }
  }]);

  const Bus20 = createSVGComponent('Bus20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V15H27zM3 11H5V15H3zM20 20H22V22H20zM10 20H12V22H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"
    }
  }]);

  const Bus16 = createSVGComponent('Bus16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 11H29V15H27zM3 11H5V15H3zM20 20H22V22H20zM10 20H12V22H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"
    }
  }]);

  const BusinessProcesses32 = createSVGComponent('BusinessProcesses32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m23.0002,31c-.0095,0-.0188-.0001-.0283-.0004-.4102-.0115-.7715-.2723-.9116-.6578l-3.1365-8.6252-2.0046,4.6774c-.1577.3677-.519.6061-.9192.6061h-4v-2h3.3406l2.7402-6.3939c.1619-.3772.5479-.6166.9473-.6057.4102.0115.7715.2723.9116.6578l3.1365,8.6252,2.0046-4.6774c.1577-.3677.519-.6061.9192-.6061h4v2h-3.3406l-2.7402,6.3939c-.158.3684-.52.6061-.9189.6061Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m9,25h-5v-15h24v9h2v-9c0-1.103-.8975-2-2-2h-6V4c0-1.103-.8975-2-2-2h-8c-1.103,0-2,.897-2,2v4h-6c-1.103,0-2,.897-2,2v15c0,1.1025.897,2,2,2h5v-2ZM12,4h8v4h-8V4Z"
    }
  }]);

  const BusinessProcesses24 = createSVGComponent('BusinessProcesses24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m23.0002,31c-.0095,0-.0188-.0001-.0283-.0004-.4102-.0115-.7715-.2723-.9116-.6578l-3.1365-8.6252-2.0046,4.6774c-.1577.3677-.519.6061-.9192.6061h-4v-2h3.3406l2.7402-6.3939c.1619-.3772.5479-.6166.9473-.6057.4102.0115.7715.2723.9116.6578l3.1365,8.6252,2.0046-4.6774c.1577-.3677.519-.6061.9192-.6061h4v2h-3.3406l-2.7402,6.3939c-.158.3684-.52.6061-.9189.6061Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m9,25h-5v-15h24v9h2v-9c0-1.103-.8975-2-2-2h-6V4c0-1.103-.8975-2-2-2h-8c-1.103,0-2,.897-2,2v4h-6c-1.103,0-2,.897-2,2v15c0,1.1025.897,2,2,2h5v-2ZM12,4h8v4h-8V4Z"
    }
  }]);

  const BusinessProcesses20 = createSVGComponent('BusinessProcesses20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m23.0002,31c-.0095,0-.0188-.0001-.0283-.0004-.4102-.0115-.7715-.2723-.9116-.6578l-3.1365-8.6252-2.0046,4.6774c-.1577.3677-.519.6061-.9192.6061h-4v-2h3.3406l2.7402-6.3939c.1619-.3772.5479-.6166.9473-.6057.4102.0115.7715.2723.9116.6578l3.1365,8.6252,2.0046-4.6774c.1577-.3677.519-.6061.9192-.6061h4v2h-3.3406l-2.7402,6.3939c-.158.3684-.52.6061-.9189.6061Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m9,25h-5v-15h24v9h2v-9c0-1.103-.8975-2-2-2h-6V4c0-1.103-.8975-2-2-2h-8c-1.103,0-2,.897-2,2v4h-6c-1.103,0-2,.897-2,2v15c0,1.1025.897,2,2,2h5v-2ZM12,4h8v4h-8V4Z"
    }
  }]);

  const BusinessProcesses16 = createSVGComponent('BusinessProcesses16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m23.0002,31c-.0095,0-.0188-.0001-.0283-.0004-.4102-.0115-.7715-.2723-.9116-.6578l-3.1365-8.6252-2.0046,4.6774c-.1577.3677-.519.6061-.9192.6061h-4v-2h3.3406l2.7402-6.3939c.1619-.3772.5479-.6166.9473-.6057.4102.0115.7715.2723.9116.6578l3.1365,8.6252,2.0046-4.6774c.1577-.3677.519-.6061.9192-.6061h4v2h-3.3406l-2.7402,6.3939c-.158.3684-.52.6061-.9189.6061Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m9,25h-5v-15h24v9h2v-9c0-1.103-.8975-2-2-2h-6V4c0-1.103-.8975-2-2-2h-8c-1.103,0-2,.897-2,2v4h-6c-1.103,0-2,.897-2,2v15c0,1.1025.897,2,2,2h5v-2ZM12,4h8v4h-8V4Z"
    }
  }]);

  const ButtonCentered32 = createSVGComponent('ButtonCentered32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9 15H23V17H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM4,12v8H28V12Z"
    }
  }]);

  const ButtonCentered24 = createSVGComponent('ButtonCentered24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9 15H23V17H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM4,12v8H28V12Z"
    }
  }]);

  const ButtonCentered20 = createSVGComponent('ButtonCentered20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9 15H23V17H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM4,12v8H28V12Z"
    }
  }]);

  const ButtonCentered16 = createSVGComponent('ButtonCentered16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M9 15H23V17H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2H28a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM4,12v8H28V12Z"
    }
  }]);

  const ButtonFlushLeft32 = createSVGComponent('ButtonFlushLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 15H20V17H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4c-1.103,0-2-0.897-2-2v-8c0-1.103,0.897-2,2-2h24c1.103,0,2,0.897,2,2v8C30,21.103,29.103,22,28,22z M4,12v8h24v-8\tH4z"
    }
  }]);

  const ButtonFlushLeft24 = createSVGComponent('ButtonFlushLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 15H20V17H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4c-1.103,0-2-0.897-2-2v-8c0-1.103,0.897-2,2-2h24c1.103,0,2,0.897,2,2v8C30,21.103,29.103,22,28,22z M4,12v8h24v-8\tH4z"
    }
  }]);

  const ButtonFlushLeft20 = createSVGComponent('ButtonFlushLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 15H20V17H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4c-1.103,0-2-0.897-2-2v-8c0-1.103,0.897-2,2-2h24c1.103,0,2,0.897,2,2v8C30,21.103,29.103,22,28,22z M4,12v8h24v-8\tH4z"
    }
  }]);

  const ButtonFlushLeft16 = createSVGComponent('ButtonFlushLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 15H20V17H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,22H4c-1.103,0-2-0.897-2-2v-8c0-1.103,0.897-2,2-2h24c1.103,0,2,0.897,2,2v8C30,21.103,29.103,22,28,22z M4,12v8h24v-8\tH4z"
    }
  }]);

  const CabinCare32 = createSVGComponent('CabinCare32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.3022 2a2.6617 2.6617 0 00-1.9079.8059l-.3931.4053-.397-.4053a2.6613 2.6613 0 00-3.8158 0 2.7992 2.7992 0 000 3.8963L25.0012 11 29.21 6.7022a2.7992 2.7992 0 000-3.8963A2.6613 2.6613 0 0027.3022 2zM23.8218 18H15.083L11.8643 5.9653a4 4 0 00-7.7276 2.07L8.5454 24.5168A2 2 0 0010.4775 26H19v2H4v2H19a2 2 0 002-2V26h3a4.0046 4.0046 0 003.98-4.4A4.1214 4.1214 0 0023.8218 18zM24 24H10.4776L6.0686 7.5181A2 2 0 119.9324 6.4829L13.5466 20H24a2 2 0 010 4z"
    }
  }]);

  const CabinCare24 = createSVGComponent('CabinCare24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.3022 2a2.6617 2.6617 0 00-1.9079.8059l-.3931.4053-.397-.4053a2.6613 2.6613 0 00-3.8158 0 2.7992 2.7992 0 000 3.8963L25.0012 11 29.21 6.7022a2.7992 2.7992 0 000-3.8963A2.6613 2.6613 0 0027.3022 2zM23.8218 18H15.083L11.8643 5.9653a4 4 0 00-7.7276 2.07L8.5454 24.5168A2 2 0 0010.4775 26H19v2H4v2H19a2 2 0 002-2V26h3a4.0046 4.0046 0 003.98-4.4A4.1214 4.1214 0 0023.8218 18zM24 24H10.4776L6.0686 7.5181A2 2 0 119.9324 6.4829L13.5466 20H24a2 2 0 010 4z"
    }
  }]);

  const CabinCare20 = createSVGComponent('CabinCare20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.3022 2a2.6617 2.6617 0 00-1.9079.8059l-.3931.4053-.397-.4053a2.6613 2.6613 0 00-3.8158 0 2.7992 2.7992 0 000 3.8963L25.0012 11 29.21 6.7022a2.7992 2.7992 0 000-3.8963A2.6613 2.6613 0 0027.3022 2zM23.8218 18H15.083L11.8643 5.9653a4 4 0 00-7.7276 2.07L8.5454 24.5168A2 2 0 0010.4775 26H19v2H4v2H19a2 2 0 002-2V26h3a4.0046 4.0046 0 003.98-4.4A4.1214 4.1214 0 0023.8218 18zM24 24H10.4776L6.0686 7.5181A2 2 0 119.9324 6.4829L13.5466 20H24a2 2 0 010 4z"
    }
  }]);

  const CabinCare16 = createSVGComponent('CabinCare16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.3022 2a2.6617 2.6617 0 00-1.9079.8059l-.3931.4053-.397-.4053a2.6613 2.6613 0 00-3.8158 0 2.7992 2.7992 0 000 3.8963L25.0012 11 29.21 6.7022a2.7992 2.7992 0 000-3.8963A2.6613 2.6613 0 0027.3022 2zM23.8218 18H15.083L11.8643 5.9653a4 4 0 00-7.7276 2.07L8.5454 24.5168A2 2 0 0010.4775 26H19v2H4v2H19a2 2 0 002-2V26h3a4.0046 4.0046 0 003.98-4.4A4.1214 4.1214 0 0023.8218 18zM24 24H10.4776L6.0686 7.5181A2 2 0 119.9324 6.4829L13.5466 20H24a2 2 0 010 4z"
    }
  }]);

  const CabinCareAlert32 = createSVGComponent('CabinCareAlert32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24z"
    }
  }, {
    "elem": "rect",
    "attrs": {
      "width": "3",
      "height": "3",
      "x": "23.5",
      "y": "11",
      "rx": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8218,18H15.083L11.8643,5.9653a4,4,0,0,0-7.7276,2.07L8.5454,24.5168A2,2,0,0,0,10.4775,26H19v2H4v2H19a2,2,0,0,0,2-2V26h3a4.0046,4.0046,0,0,0,3.98-4.4A4.1215,4.1215,0,0,0,23.8218,18ZM24,24H10.4775L6.0686,7.5181A2,2,0,1,1,9.9324,6.4829L13.5466,20H24a2,2,0,0,1,0,4Z"
    }
  }]);

  const CabinCareAlert24 = createSVGComponent('CabinCareAlert24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24z"
    }
  }, {
    "elem": "rect",
    "attrs": {
      "width": "3",
      "height": "3",
      "x": "23.5",
      "y": "11",
      "rx": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8218,18H15.083L11.8643,5.9653a4,4,0,0,0-7.7276,2.07L8.5454,24.5168A2,2,0,0,0,10.4775,26H19v2H4v2H19a2,2,0,0,0,2-2V26h3a4.0046,4.0046,0,0,0,3.98-4.4A4.1215,4.1215,0,0,0,23.8218,18ZM24,24H10.4775L6.0686,7.5181A2,2,0,1,1,9.9324,6.4829L13.5466,20H24a2,2,0,0,1,0,4Z"
    }
  }]);

  const CabinCareAlert20 = createSVGComponent('CabinCareAlert20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24z"
    }
  }, {
    "elem": "rect",
    "attrs": {
      "width": "3",
      "height": "3",
      "x": "23.5",
      "y": "11",
      "rx": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8218,18H15.083L11.8643,5.9653a4,4,0,0,0-7.7276,2.07L8.5454,24.5168A2,2,0,0,0,10.4775,26H19v2H4v2H19a2,2,0,0,0,2-2V26h3a4.0046,4.0046,0,0,0,3.98-4.4A4.1215,4.1215,0,0,0,23.8218,18ZM24,24H10.4775L6.0686,7.5181A2,2,0,1,1,9.9324,6.4829L13.5466,20H24a2,2,0,0,1,0,4Z"
    }
  }]);

  const CabinCareAlert16 = createSVGComponent('CabinCareAlert16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 2H26V9H24z"
    }
  }, {
    "elem": "rect",
    "attrs": {
      "width": "3",
      "height": "3",
      "x": "23.5",
      "y": "11",
      "rx": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23.8218,18H15.083L11.8643,5.9653a4,4,0,0,0-7.7276,2.07L8.5454,24.5168A2,2,0,0,0,10.4775,26H19v2H4v2H19a2,2,0,0,0,2-2V26h3a4.0046,4.0046,0,0,0,3.98-4.4A4.1215,4.1215,0,0,0,23.8218,18ZM24,24H10.4775L6.0686,7.5181A2,2,0,1,1,9.9324,6.4829L13.5466,20H24a2,2,0,0,1,0,4Z"
    }
  }]);

  const CabinCareAlt32 = createSVGComponent('CabinCareAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 25V23H20.7676l-.8-3H27V18H19.4348l-2.469-9.2578-1.9316.5156 3.8017 14.2568A2.0037 2.0037 0 0020.77 25H22v3H10V25h6V23H6.7676l-.8-3H13V18H5.4348L2.9658 8.7422l-1.9316.5156L4.8359 23.5146A2.0037 2.0037 0 006.77 25H8v3H2v2H30V28H24V25zM27.303 2a2.6613 2.6613 0 00-1.9079.8059L25 3.2112l-.3951-.4053a2.6612 2.6612 0 00-3.8157 0 2.7991 2.7991 0 000 3.8963L25 11l4.2108-4.2978a2.7991 2.7991 0 000-3.8963A2.6613 2.6613 0 0027.303 2z"
    }
  }]);

  const CabinCareAlt24 = createSVGComponent('CabinCareAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 25V23H20.7676l-.8-3H27V18H19.4348l-2.469-9.2578-1.9316.5156 3.8017 14.2568A2.0037 2.0037 0 0020.77 25H22v3H10V25h6V23H6.7676l-.8-3H13V18H5.4348L2.9658 8.7422l-1.9316.5156L4.8359 23.5146A2.0037 2.0037 0 006.77 25H8v3H2v2H30V28H24V25zM27.303 2a2.6613 2.6613 0 00-1.9079.8059L25 3.2112l-.3951-.4053a2.6612 2.6612 0 00-3.8157 0 2.7991 2.7991 0 000 3.8963L25 11l4.2108-4.2978a2.7991 2.7991 0 000-3.8963A2.6613 2.6613 0 0027.303 2z"
    }
  }]);

  const CabinCareAlt20 = createSVGComponent('CabinCareAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 25V23H20.7676l-.8-3H27V18H19.4348l-2.469-9.2578-1.9316.5156 3.8017 14.2568A2.0037 2.0037 0 0020.77 25H22v3H10V25h6V23H6.7676l-.8-3H13V18H5.4348L2.9658 8.7422l-1.9316.5156L4.8359 23.5146A2.0037 2.0037 0 006.77 25H8v3H2v2H30V28H24V25zM27.303 2a2.6613 2.6613 0 00-1.9079.8059L25 3.2112l-.3951-.4053a2.6612 2.6612 0 00-3.8157 0 2.7991 2.7991 0 000 3.8963L25 11l4.2108-4.2978a2.7991 2.7991 0 000-3.8963A2.6613 2.6613 0 0027.303 2z"
    }
  }]);

  const CabinCareAlt16 = createSVGComponent('CabinCareAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 25V23H20.7676l-.8-3H27V18H19.4348l-2.469-9.2578-1.9316.5156 3.8017 14.2568A2.0037 2.0037 0 0020.77 25H22v3H10V25h6V23H6.7676l-.8-3H13V18H5.4348L2.9658 8.7422l-1.9316.5156L4.8359 23.5146A2.0037 2.0037 0 006.77 25H8v3H2v2H30V28H24V25zM27.303 2a2.6613 2.6613 0 00-1.9079.8059L25 3.2112l-.3951-.4053a2.6612 2.6612 0 00-3.8157 0 2.7991 2.7991 0 000 3.8963L25 11l4.2108-4.2978a2.7991 2.7991 0 000-3.8963A2.6613 2.6613 0 0027.303 2z"
    }
  }]);

  const Cad32 = createSVGComponent('Cad32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9H14a2 2 0 00-2 2V23h2V18h4v5h2V11A2 2 0 0018 9zm-4 7V11h4v5zM26 23H22V9h4a4 4 0 014 4v6A4 4 0 0126 23zm-2-2h2a2 2 0 002-2V13a2 2 0 00-2-2H24zM10 23H4a2 2 0 01-2-2V11A2 2 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cad24 = createSVGComponent('Cad24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9H14a2 2 0 00-2 2V23h2V18h4v5h2V11A2 2 0 0018 9zm-4 7V11h4v5zM26 23H22V9h4a4 4 0 014 4v6A4 4 0 0126 23zm-2-2h2a2 2 0 002-2V13a2 2 0 00-2-2H24zM10 23H4a2 2 0 01-2-2V11A2 2 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cad20 = createSVGComponent('Cad20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9H14a2 2 0 00-2 2V23h2V18h4v5h2V11A2 2 0 0018 9zm-4 7V11h4v5zM26 23H22V9h4a4 4 0 014 4v6A4 4 0 0126 23zm-2-2h2a2 2 0 002-2V13a2 2 0 00-2-2H24zM10 23H4a2 2 0 01-2-2V11A2 2 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cad16 = createSVGComponent('Cad16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9H14a2 2 0 00-2 2V23h2V18h4v5h2V11A2 2 0 0018 9zm-4 7V11h4v5zM26 23H22V9h4a4 4 0 014 4v6A4 4 0 0126 23zm-2-2h2a2 2 0 002-2V13a2 2 0 00-2-2H24zM10 23H4a2 2 0 01-2-2V11A2 2 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cafe32 = createSVGComponent('Cafe32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM24.5 11H8a2.002 2.002 0 00-2 2v8a5.0059 5.0059 0 005 5h8a5.0059 5.0059 0 005-5V20h.5a4.5 4.5 0 000-9zM22 21a3.0033 3.0033 0 01-3 3H11a3.0033 3.0033 0 01-3-3V13H22zm2.5-3H24V13h.5a2.5 2.5 0 010 5zM19 9H17V8.854a1.9883 1.9883 0 00-1.1055-1.7886L13.2109 5.7236A3.9788 3.9788 0 0111 2.146V1h2V2.146a1.9892 1.9892 0 001.1055 1.7886l2.6836 1.3418A3.9792 3.9792 0 0119 8.854z"
    }
  }]);

  const Cafe24 = createSVGComponent('Cafe24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM24.5 11H8a2.002 2.002 0 00-2 2v8a5.0059 5.0059 0 005 5h8a5.0059 5.0059 0 005-5V20h.5a4.5 4.5 0 000-9zM22 21a3.0033 3.0033 0 01-3 3H11a3.0033 3.0033 0 01-3-3V13H22zm2.5-3H24V13h.5a2.5 2.5 0 010 5zM19 9H17V8.854a1.9883 1.9883 0 00-1.1055-1.7886L13.2109 5.7236A3.9788 3.9788 0 0111 2.146V1h2V2.146a1.9892 1.9892 0 001.1055 1.7886l2.6836 1.3418A3.9792 3.9792 0 0119 8.854z"
    }
  }]);

  const Cafe20 = createSVGComponent('Cafe20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM24.5 11H8a2.002 2.002 0 00-2 2v8a5.0059 5.0059 0 005 5h8a5.0059 5.0059 0 005-5V20h.5a4.5 4.5 0 000-9zM22 21a3.0033 3.0033 0 01-3 3H11a3.0033 3.0033 0 01-3-3V13H22zm2.5-3H24V13h.5a2.5 2.5 0 010 5zM19 9H17V8.854a1.9883 1.9883 0 00-1.1055-1.7886L13.2109 5.7236A3.9788 3.9788 0 0111 2.146V1h2V2.146a1.9892 1.9892 0 001.1055 1.7886l2.6836 1.3418A3.9792 3.9792 0 0119 8.854z"
    }
  }]);

  const Cafe16 = createSVGComponent('Cafe16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M2 28H30V30H2zM24.5 11H8a2.002 2.002 0 00-2 2v8a5.0059 5.0059 0 005 5h8a5.0059 5.0059 0 005-5V20h.5a4.5 4.5 0 000-9zM22 21a3.0033 3.0033 0 01-3 3H11a3.0033 3.0033 0 01-3-3V13H22zm2.5-3H24V13h.5a2.5 2.5 0 010 5zM19 9H17V8.854a1.9883 1.9883 0 00-1.1055-1.7886L13.2109 5.7236A3.9788 3.9788 0 0111 2.146V1h2V2.146a1.9892 1.9892 0 001.1055 1.7886l2.6836 1.3418A3.9792 3.9792 0 0119 8.854z"
    }
  }]);

  const Calculation32 = createSVGComponent('Calculation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 8L10 8 10 4 8 4 8 8 4 8 4 10 8 10 8 14 10 14 10 10 14 10 14 8zM4 19H14V21H4zM4 24H14V26H4zM18 8H28V10H18zM24.41 22L28 18.41 26.59 17 23 20.59 19.41 17 18 18.41 21.59 22 18 25.59 19.41 27 23 23.41 26.59 27 28 25.59 24.41 22z"
    }
  }]);

  const Calculation24 = createSVGComponent('Calculation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 8L10 8 10 4 8 4 8 8 4 8 4 10 8 10 8 14 10 14 10 10 14 10 14 8zM4 19H14V21H4zM4 24H14V26H4zM18 8H28V10H18zM24.41 22L28 18.41 26.59 17 23 20.59 19.41 17 18 18.41 21.59 22 18 25.59 19.41 27 23 23.41 26.59 27 28 25.59 24.41 22z"
    }
  }]);

  const Calculation20 = createSVGComponent('Calculation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 8L10 8 10 4 8 4 8 8 4 8 4 10 8 10 8 14 10 14 10 10 14 10 14 8zM4 19H14V21H4zM4 24H14V26H4zM18 8H28V10H18zM24.41 22L28 18.41 26.59 17 23 20.59 19.41 17 18 18.41 21.59 22 18 25.59 19.41 27 23 23.41 26.59 27 28 25.59 24.41 22z"
    }
  }]);

  const Calculation16 = createSVGComponent('Calculation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 8L10 8 10 4 8 4 8 8 4 8 4 10 8 10 8 14 10 14 10 10 14 10 14 8zM4 19H14V21H4zM4 24H14V26H4zM18 8H28V10H18zM24.41 22L28 18.41 26.59 17 23 20.59 19.41 17 18 18.41 21.59 22 18 25.59 19.41 27 23 23.41 26.59 27 28 25.59 24.41 22z"
    }
  }]);

  const CalculationAlt32 = createSVGComponent('CalculationAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 13H25V15H19zM13 21L11 21 11 19 9 19 9 21 7 21 7 23 9 23 9 25 11 25 11 23 13 23 13 21zM7 9H13V11H7zM19 17H25V19H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0023,2.0023,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3ZM15,5V15H5V5ZM5,17H15V27H5ZM17,27V5H27V27Z"
    }
  }]);

  const CalculationAlt24 = createSVGComponent('CalculationAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 13H25V15H19zM13 21L11 21 11 19 9 19 9 21 7 21 7 23 9 23 9 25 11 25 11 23 13 23 13 21zM7 9H13V11H7zM19 17H25V19H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0023,2.0023,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3ZM15,5V15H5V5ZM5,17H15V27H5ZM17,27V5H27V27Z"
    }
  }]);

  const CalculationAlt20 = createSVGComponent('CalculationAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 13H25V15H19zM13 21L11 21 11 19 9 19 9 21 7 21 7 23 9 23 9 25 11 25 11 23 13 23 13 21zM7 9H13V11H7zM19 17H25V19H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0023,2.0023,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3ZM15,5V15H5V5ZM5,17H15V27H5ZM17,27V5H27V27Z"
    }
  }]);

  const CalculationAlt16 = createSVGComponent('CalculationAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19 13H25V15H19zM13 21L11 21 11 19 9 19 9 21 7 21 7 23 9 23 9 25 11 25 11 23 13 23 13 21zM7 9H13V11H7zM19 17H25V19H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0023,2.0023,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3ZM15,5V15H5V5ZM5,17H15V27H5ZM17,27V5H27V27Z"
    }
  }]);

  const Calculator32 = createSVGComponent('Calculator32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 23H11V25H9zM21 23H23V25H21zM9 18H11V20H9zM21 18H23V20H21zM9 13H11V15H9zM15 23H17V25H15zM15 18H17V20H15zM15 13H17V15H15zM21 13H23V15H21zM9 7H23V10H9z"
    }
  }]);

  const Calculator24 = createSVGComponent('Calculator24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 23H11V25H9zM21 23H23V25H21zM9 18H11V20H9zM21 18H23V20H21zM9 13H11V15H9zM15 23H17V25H15zM15 18H17V20H15zM15 13H17V15H15zM21 13H23V15H21zM9 7H23V10H9z"
    }
  }]);

  const Calculator20 = createSVGComponent('Calculator20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 23H11V25H9zM21 23H23V25H21zM9 18H11V20H9zM21 18H23V20H21zM9 13H11V15H9zM15 23H17V25H15zM15 18H17V20H15zM15 13H17V15H15zM21 13H23V15H21zM9 7H23V10H9z"
    }
  }]);

  const Calculator16 = createSVGComponent('Calculator16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9 23H11V25H9zM21 23H23V25H21zM9 18H11V20H9zM21 18H23V20H21zM9 13H11V15H9zM15 23H17V25H15zM15 18H17V20H15zM15 13H17V15H15zM21 13H23V15H21zM9 7H23V10H9z"
    }
  }]);

  const CalculatorCheck32 = createSVGComponent('CalculatorCheck32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 26.59L21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59zM15 23H17V25H15zM9 23H11V25H9zM21 18H23V20H21zM15 18H17V20H15zM9 18H11V20H9zM21 13H23V15H21zM15 13H17V15H15zM9 13H11V15H9zM9 7H23V10H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"
    }
  }]);

  const CalculatorCheck24 = createSVGComponent('CalculatorCheck24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 26.59L21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59zM15 23H17V25H15zM9 23H11V25H9zM21 18H23V20H21zM15 18H17V20H15zM9 18H11V20H9zM21 13H23V15H21zM15 13H17V15H15zM9 13H11V15H9zM9 7H23V10H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"
    }
  }]);

  const CalculatorCheck20 = createSVGComponent('CalculatorCheck20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 26.59L21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59zM15 23H17V25H15zM9 23H11V25H9zM21 18H23V20H21zM15 18H17V20H15zM9 18H11V20H9zM21 13H23V15H21zM15 13H17V15H15zM9 13H11V15H9zM9 7H23V10H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"
    }
  }]);

  const CalculatorCheck16 = createSVGComponent('CalculatorCheck16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 26.59L21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59zM15 23H17V25H15zM9 23H11V25H9zM21 18H23V20H21zM15 18H17V20H15zM9 18H11V20H9zM21 13H23V15H21zM15 13H17V15H15zM9 13H11V15H9zM9 7H23V10H9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"
    }
  }]);

  const Calendar32 = createSVGComponent('Calendar32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"
    }
  }]);

  const Calendar24 = createSVGComponent('Calendar24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"
    }
  }]);

  const Calendar20 = createSVGComponent('Calendar20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"
    }
  }]);

  const Calendar16 = createSVGComponent('Calendar16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"
    }
  }]);

  const CalendarAdd32 = createSVGComponent('CalendarAdd32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M30 22L24 22 24 16 22 16 22 22 16 22 16 24 22 24 22 30 24 30 24 24 30 24z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h8v-2H6V6h4v2h2V6h8v2h2V6h4v8h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAdd24 = createSVGComponent('CalendarAdd24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M30 22L24 22 24 16 22 16 22 22 16 22 16 24 22 24 22 30 24 30 24 24 30 24z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h8v-2H6V6h4v2h2V6h8v2h2V6h4v8h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAdd20 = createSVGComponent('CalendarAdd20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M30 22L24 22 24 16 22 16 22 22 16 22 16 24 22 24 22 30 24 30 24 24 30 24z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h8v-2H6V6h4v2h2V6h8v2h2V6h4v8h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAdd16 = createSVGComponent('CalendarAdd16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M30 22L24 22 24 16 22 16 22 22 16 22 16 24 22 24 22 30 24 30 24 24 30 24z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h8v-2H6V6h4v2h2V6h8v2h2V6h4v8h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAddAlt32 = createSVGComponent('CalendarAddAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M26 21L23 21 23 18 21 18 21 21 18 21 18 23 21 23 21 26 23 26 23 23 26 23z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M22,30c-4.4,0-8-3.6-8-8s3.6-8,8-8s8,3.6,8,8S26.4,30,22,30z M22,16c-3.3,0-6,2.7-6,6s2.7,6,6,6s6-2.7,6-6S25.3,16,22,16z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h6v-2H6V6h4v2h2V6h8v2h2V6h4v6h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAddAlt24 = createSVGComponent('CalendarAddAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M26 21L23 21 23 18 21 18 21 21 18 21 18 23 21 23 21 26 23 26 23 23 26 23z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M22,30c-4.4,0-8-3.6-8-8s3.6-8,8-8s8,3.6,8,8S26.4,30,22,30z M22,16c-3.3,0-6,2.7-6,6s2.7,6,6,6s6-2.7,6-6S25.3,16,22,16z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h6v-2H6V6h4v2h2V6h8v2h2V6h4v6h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAddAlt20 = createSVGComponent('CalendarAddAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M26 21L23 21 23 18 21 18 21 21 18 21 18 23 21 23 21 26 23 26 23 23 26 23z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M22,30c-4.4,0-8-3.6-8-8s3.6-8,8-8s8,3.6,8,8S26.4,30,22,30z M22,16c-3.3,0-6,2.7-6,6s2.7,6,6,6s6-2.7,6-6S25.3,16,22,16z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h6v-2H6V6h4v2h2V6h8v2h2V6h4v6h2V6z"
        }
      }]
    }]
  }]);

  const CalendarAddAlt16 = createSVGComponent('CalendarAddAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "switch",
    "attrs": {},
    "content": [{
      "elem": "g",
      "attrs": {},
      "content": [{
        "elem": "path",
        "attrs": {
          "d": "M26 21L23 21 23 18 21 18 21 21 18 21 18 23 21 23 21 26 23 26 23 23 26 23z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M22,30c-4.4,0-8-3.6-8-8s3.6-8,8-8s8,3.6,8,8S26.4,30,22,30z M22,16c-3.3,0-6,2.7-6,6s2.7,6,6,6s6-2.7,6-6S25.3,16,22,16z"
        }
      }, {
        "elem": "path",
        "attrs": {
          "d": "M28,6c0-1.1-0.9-2-2-2h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h6v-2H6V6h4v2h2V6h8v2h2V6h4v6h2V6z"
        }
      }]
    }]
  }]);

  const CalendarHeatMap32 = createSVGComponent('CalendarHeatMap32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,6h4V8h2V6h8V8h2V6h4l0,4H6Zm0,6h5v6H6ZM19,26H13V20h6Zm0-8H13V12h6Zm2,8V20h5l.0012,6Z"
    }
  }]);

  const CalendarHeatMap24 = createSVGComponent('CalendarHeatMap24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,6h4V8h2V6h8V8h2V6h4l0,4H6Zm0,6h5v6H6ZM19,26H13V20h6Zm0-8H13V12h6Zm2,8V20h5l.0012,6Z"
    }
  }]);

  const CalendarHeatMap20 = createSVGComponent('CalendarHeatMap20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,6h4V8h2V6h8V8h2V6h4l0,4H6Zm0,6h5v6H6ZM19,26H13V20h6Zm0-8H13V12h6Zm2,8V20h5l.0012,6Z"
    }
  }]);

  const CalendarHeatMap16 = createSVGComponent('CalendarHeatMap16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,6h4V8h2V6h8V8h2V6h4l0,4H6Zm0,6h5v6H6ZM19,26H13V20h6Zm0-8H13V12h6Zm2,8V20h5l.0012,6Z"
    }
  }]);

  const CalendarSettings32 = createSVGComponent('CalendarSettings32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,23V21H27.91a5.9592,5.9592,0,0,0-1.0244-2.4707L28.364,17.05,26.95,15.6362l-1.4788,1.4785A5.9584,5.9584,0,0,0,23,16.09V14H21v2.09a5.9584,5.9584,0,0,0-2.4709,1.0244L17.05,15.6362,15.636,17.05l1.4787,1.479A5.9618,5.9618,0,0,0,16.09,21H14v2h2.09a5.9618,5.9618,0,0,0,1.0244,2.4707L15.636,26.95,17.05,28.3638l1.4788-1.4785A5.9584,5.9584,0,0,0,21,27.91V30h2V27.91a5.9584,5.9584,0,0,0,2.4709-1.0244L26.95,28.3638,28.364,26.95l-1.4787-1.479A5.9592,5.9592,0,0,0,27.91,23Zm-8,3a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"
    }
  }]);

  const CalendarSettings24 = createSVGComponent('CalendarSettings24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,23V21H27.91a5.9592,5.9592,0,0,0-1.0244-2.4707L28.364,17.05,26.95,15.6362l-1.4788,1.4785A5.9584,5.9584,0,0,0,23,16.09V14H21v2.09a5.9584,5.9584,0,0,0-2.4709,1.0244L17.05,15.6362,15.636,17.05l1.4787,1.479A5.9618,5.9618,0,0,0,16.09,21H14v2h2.09a5.9618,5.9618,0,0,0,1.0244,2.4707L15.636,26.95,17.05,28.3638l1.4788-1.4785A5.9584,5.9584,0,0,0,21,27.91V30h2V27.91a5.9584,5.9584,0,0,0,2.4709-1.0244L26.95,28.3638,28.364,26.95l-1.4787-1.479A5.9592,5.9592,0,0,0,27.91,23Zm-8,3a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"
    }
  }]);

  const CalendarSettings20 = createSVGComponent('CalendarSettings20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,23V21H27.91a5.9592,5.9592,0,0,0-1.0244-2.4707L28.364,17.05,26.95,15.6362l-1.4788,1.4785A5.9584,5.9584,0,0,0,23,16.09V14H21v2.09a5.9584,5.9584,0,0,0-2.4709,1.0244L17.05,15.6362,15.636,17.05l1.4787,1.479A5.9618,5.9618,0,0,0,16.09,21H14v2h2.09a5.9618,5.9618,0,0,0,1.0244,2.4707L15.636,26.95,17.05,28.3638l1.4788-1.4785A5.9584,5.9584,0,0,0,21,27.91V30h2V27.91a5.9584,5.9584,0,0,0,2.4709-1.0244L26.95,28.3638,28.364,26.95l-1.4787-1.479A5.9592,5.9592,0,0,0,27.91,23Zm-8,3a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"
    }
  }]);

  const CalendarSettings16 = createSVGComponent('CalendarSettings16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,23V21H27.91a5.9592,5.9592,0,0,0-1.0244-2.4707L28.364,17.05,26.95,15.6362l-1.4788,1.4785A5.9584,5.9584,0,0,0,23,16.09V14H21v2.09a5.9584,5.9584,0,0,0-2.4709,1.0244L17.05,15.6362,15.636,17.05l1.4787,1.479A5.9618,5.9618,0,0,0,16.09,21H14v2h2.09a5.9618,5.9618,0,0,0,1.0244,2.4707L15.636,26.95,17.05,28.3638l1.4788-1.4785A5.9584,5.9584,0,0,0,21,27.91V30h2V27.91a5.9584,5.9584,0,0,0,2.4709-1.0244L26.95,28.3638,28.364,26.95l-1.4787-1.479A5.9592,5.9592,0,0,0,27.91,23Zm-8,3a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"
    }
  }]);

  const CalendarTools32 = createSVGComponent('CalendarTools32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.981,24.4333A3.9549,3.9549,0,0,0,26,25a4.0045,4.0045,0,0,0,4-4,3.9427,3.9427,0,0,0-.1492-1.0228l-2.4367,2.4369-.0005-.0005a1.9991,1.9991,0,1,1-2.8272-2.8272l-.0005-.0005,2.4368-2.4368A3.95,3.95,0,0,0,26,17a4.0045,4.0045,0,0,0-4,4,3.9544,3.9544,0,0,0,.5669,2.0191L17,28.586,18.4141,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h8V26H6V6h4V8h2V6h8V8h2V6h4v8h2V6A2,2,0,0,0,26,4Z"
    }
  }]);

  const CalendarTools24 = createSVGComponent('CalendarTools24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.981,24.4333A3.9549,3.9549,0,0,0,26,25a4.0045,4.0045,0,0,0,4-4,3.9427,3.9427,0,0,0-.1492-1.0228l-2.4367,2.4369-.0005-.0005a1.9991,1.9991,0,1,1-2.8272-2.8272l-.0005-.0005,2.4368-2.4368A3.95,3.95,0,0,0,26,17a4.0045,4.0045,0,0,0-4,4,3.9544,3.9544,0,0,0,.5669,2.0191L17,28.586,18.4141,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h8V26H6V6h4V8h2V6h8V8h2V6h4v8h2V6A2,2,0,0,0,26,4Z"
    }
  }]);

  const CalendarTools20 = createSVGComponent('CalendarTools20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.981,24.4333A3.9549,3.9549,0,0,0,26,25a4.0045,4.0045,0,0,0,4-4,3.9427,3.9427,0,0,0-.1492-1.0228l-2.4367,2.4369-.0005-.0005a1.9991,1.9991,0,1,1-2.8272-2.8272l-.0005-.0005,2.4368-2.4368A3.95,3.95,0,0,0,26,17a4.0045,4.0045,0,0,0-4,4,3.9544,3.9544,0,0,0,.5669,2.0191L17,28.586,18.4141,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h8V26H6V6h4V8h2V6h8V8h2V6h4v8h2V6A2,2,0,0,0,26,4Z"
    }
  }]);

  const CalendarTools16 = createSVGComponent('CalendarTools16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.981,24.4333A3.9549,3.9549,0,0,0,26,25a4.0045,4.0045,0,0,0,4-4,3.9427,3.9427,0,0,0-.1492-1.0228l-2.4367,2.4369-.0005-.0005a1.9991,1.9991,0,1,1-2.8272-2.8272l-.0005-.0005,2.4368-2.4368A3.95,3.95,0,0,0,26,17a4.0045,4.0045,0,0,0-4,4,3.9544,3.9544,0,0,0,.5669,2.0191L17,28.586,18.4141,30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill-rule": "evenodd",
      "d": "M26,4H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h8V26H6V6h4V8h2V6h8V8h2V6h4v8h2V6A2,2,0,0,0,26,4Z"
    }
  }]);

  const Calibrate32 = createSVGComponent('Calibrate32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"
    }
  }]);

  const Calibrate24 = createSVGComponent('Calibrate24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"
    }
  }]);

  const Calibrate20 = createSVGComponent('Calibrate20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"
    }
  }]);

  const Calibrate16 = createSVGComponent('Calibrate16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"
    }
  }]);

  const Camera32 = createSVGComponent('Camera32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }]);

  const Camera24 = createSVGComponent('Camera24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }]);

  const Camera20 = createSVGComponent('Camera20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }]);

  const Camera16 = createSVGComponent('Camera16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }]);

  const CameraAction32 = createSVGComponent('CameraAction32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 9H26V11H19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "17",
      "r": "1"
    }
  }]);

  const CameraAction24 = createSVGComponent('CameraAction24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 9H26V11H19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "17",
      "r": "1"
    }
  }]);

  const CameraAction20 = createSVGComponent('CameraAction20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 9H26V11H19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "17",
      "r": "1"
    }
  }]);

  const CameraAction16 = createSVGComponent('CameraAction16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M19 9H26V11H19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12",
      "cy": "17",
      "r": "1"
    }
  }]);

  const Campsite32 = createSVGComponent('Campsite32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5618,26,17.17,8.9277,19.5361,5.04,17.8281,4,16,7.0049,14.17,4l-1.708,1.04,2.3665,3.8877L4.438,26H2v2H30V26ZM16,10.8506,25.2207,26H17V18H15v8H6.7791Z"
    }
  }]);

  const Campsite24 = createSVGComponent('Campsite24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5618,26,17.17,8.9277,19.5361,5.04,17.8281,4,16,7.0049,14.17,4l-1.708,1.04,2.3665,3.8877L4.438,26H2v2H30V26ZM16,10.8506,25.2207,26H17V18H15v8H6.7791Z"
    }
  }]);

  const Campsite20 = createSVGComponent('Campsite20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5618,26,17.17,8.9277,19.5361,5.04,17.8281,4,16,7.0049,14.17,4l-1.708,1.04,2.3665,3.8877L4.438,26H2v2H30V26ZM16,10.8506,25.2207,26H17V18H15v8H6.7791Z"
    }
  }]);

  const Campsite16 = createSVGComponent('Campsite16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5618,26,17.17,8.9277,19.5361,5.04,17.8281,4,16,7.0049,14.17,4l-1.708,1.04,2.3665,3.8877L4.438,26H2v2H30V26ZM16,10.8506,25.2207,26H17V18H15v8H6.7791Z"
    }
  }]);

  const Car32 = createSVGComponent('Car32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.3379,15.9336l-7.7324-2.7783L18.374,9.0967A2.99,2.99,0,0,0,16.0537,8H8.0576a2.9982,2.9982,0,0,0-2.48,1.3115L2.8662,13.2949A4.9884,4.9884,0,0,0,2,16.1074V24a1,1,0,0,0,1,1H5.1421a3.9806,3.9806,0,0,0,7.7158,0h6.2842a3.9806,3.9806,0,0,0,7.7158,0H29a1,1,0,0,0,1-1V16.875A1,1,0,0,0,29.3379,15.9336ZM9,26a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2.0025,2.0025,0,0,1,23,26Zm5-3H26.8579a3.9806,3.9806,0,0,0-7.7158,0H12.8579a3.9806,3.9806,0,0,0-7.7158,0H4V16.1074A2.9977,2.9977,0,0,1,4.52,14.4189l2.711-3.9814A.9992.9992,0,0,1,8.0576,10h7.9961a.9928.9928,0,0,1,.7647.3545l3.3994,4.2685a1.0007,1.0007,0,0,0,.4443.3184L28,17.5781Z"
    }
  }]);

  const Car24 = createSVGComponent('Car24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.3379,15.9336l-7.7324-2.7783L18.374,9.0967A2.99,2.99,0,0,0,16.0537,8H8.0576a2.9982,2.9982,0,0,0-2.48,1.3115L2.8662,13.2949A4.9884,4.9884,0,0,0,2,16.1074V24a1,1,0,0,0,1,1H5.1421a3.9806,3.9806,0,0,0,7.7158,0h6.2842a3.9806,3.9806,0,0,0,7.7158,0H29a1,1,0,0,0,1-1V16.875A1,1,0,0,0,29.3379,15.9336ZM9,26a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2.0025,2.0025,0,0,1,23,26Zm5-3H26.8579a3.9806,3.9806,0,0,0-7.7158,0H12.8579a3.9806,3.9806,0,0,0-7.7158,0H4V16.1074A2.9977,2.9977,0,0,1,4.52,14.4189l2.711-3.9814A.9992.9992,0,0,1,8.0576,10h7.9961a.9928.9928,0,0,1,.7647.3545l3.3994,4.2685a1.0007,1.0007,0,0,0,.4443.3184L28,17.5781Z"
    }
  }]);

  const Car20 = createSVGComponent('Car20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.3379,15.9336l-7.7324-2.7783L18.374,9.0967A2.99,2.99,0,0,0,16.0537,8H8.0576a2.9982,2.9982,0,0,0-2.48,1.3115L2.8662,13.2949A4.9884,4.9884,0,0,0,2,16.1074V24a1,1,0,0,0,1,1H5.1421a3.9806,3.9806,0,0,0,7.7158,0h6.2842a3.9806,3.9806,0,0,0,7.7158,0H29a1,1,0,0,0,1-1V16.875A1,1,0,0,0,29.3379,15.9336ZM9,26a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2.0025,2.0025,0,0,1,23,26Zm5-3H26.8579a3.9806,3.9806,0,0,0-7.7158,0H12.8579a3.9806,3.9806,0,0,0-7.7158,0H4V16.1074A2.9977,2.9977,0,0,1,4.52,14.4189l2.711-3.9814A.9992.9992,0,0,1,8.0576,10h7.9961a.9928.9928,0,0,1,.7647.3545l3.3994,4.2685a1.0007,1.0007,0,0,0,.4443.3184L28,17.5781Z"
    }
  }]);

  const Car16 = createSVGComponent('Car16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.3379,15.9336l-7.7324-2.7783L18.374,9.0967A2.99,2.99,0,0,0,16.0537,8H8.0576a2.9982,2.9982,0,0,0-2.48,1.3115L2.8662,13.2949A4.9884,4.9884,0,0,0,2,16.1074V24a1,1,0,0,0,1,1H5.1421a3.9806,3.9806,0,0,0,7.7158,0h6.2842a3.9806,3.9806,0,0,0,7.7158,0H29a1,1,0,0,0,1-1V16.875A1,1,0,0,0,29.3379,15.9336ZM9,26a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2.0025,2.0025,0,0,1,23,26Zm5-3H26.8579a3.9806,3.9806,0,0,0-7.7158,0H12.8579a3.9806,3.9806,0,0,0-7.7158,0H4V16.1074A2.9977,2.9977,0,0,1,4.52,14.4189l2.711-3.9814A.9992.9992,0,0,1,8.0576,10h7.9961a.9928.9928,0,0,1,.7647.3545l3.3994,4.2685a1.0007,1.0007,0,0,0,.4443.3184L28,17.5781Z"
    }
  }]);

  const CarFront32 = createSVGComponent('CarFront32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 19H19V21H13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6v7a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"
    }
  }]);

  const CarFront24 = createSVGComponent('CarFront24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 19H19V21H13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6v7a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"
    }
  }]);

  const CarFront20 = createSVGComponent('CarFront20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 19H19V21H13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6v7a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"
    }
  }]);

  const CarFront16 = createSVGComponent('CarFront16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 19H19V21H13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6v7a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"
    }
  }]);

  const Carbon32 = createSVGComponent('Carbon32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"
    }
  }]);

  const Carbon24 = createSVGComponent('Carbon24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"
    }
  }]);

  const Carbon20 = createSVGComponent('Carbon20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"
    }
  }]);

  const Carbon16 = createSVGComponent('Carbon16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"
    }
  }]);

  const CarbonUiBuilder32 = createSVGComponent('CarbonUiBuilder32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 28H30V30H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "29",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "29",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20 24H26V26H20z",
      "transform": "rotate(-180 23 25)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 20H30V22H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "21",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.4927,14.1299l-8.5-4.8149c-.3057-.1729-.6797-.1729-.9854,0L3.5073,14.1299c-.3135,.1777-.5073,.5098-.5073,.8701v10c0,.3604,.1938,.6924,.5073,.8701l8.5,4.8149,.9854-1.7402-7.9927-4.5278V15.583l7.5-4.2485,7.5,4.2485v2.417h2v-3c0-.3604-.1938-.6924-.5073-.8701Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,15h2V7c0-.3604-.1938-.6924-.5073-.8701L17.9927,1.3149c-.3057-.1729-.6797-.1729-.9854,0L8.5074,6.1299l.9854,1.7402L17.5,3.3345l7.5,4.2485v7.417Z"
    }
  }]);

  const CarbonUiBuilder24 = createSVGComponent('CarbonUiBuilder24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 28H30V30H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "29",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "29",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20 24H26V26H20z",
      "transform": "rotate(-180 23 25)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 20H30V22H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "21",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.4927,14.1299l-8.5-4.8149c-.3057-.1729-.6797-.1729-.9854,0L3.5073,14.1299c-.3135,.1777-.5073,.5098-.5073,.8701v10c0,.3604,.1938,.6924,.5073,.8701l8.5,4.8149,.9854-1.7402-7.9927-4.5278V15.583l7.5-4.2485,7.5,4.2485v2.417h2v-3c0-.3604-.1938-.6924-.5073-.8701Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,15h2V7c0-.3604-.1938-.6924-.5073-.8701L17.9927,1.3149c-.3057-.1729-.6797-.1729-.9854,0L8.5074,6.1299l.9854,1.7402L17.5,3.3345l7.5,4.2485v7.417Z"
    }
  }]);

  const CarbonUiBuilder20 = createSVGComponent('CarbonUiBuilder20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 28H30V30H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "29",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "29",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20 24H26V26H20z",
      "transform": "rotate(-180 23 25)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 20H30V22H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "21",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.4927,14.1299l-8.5-4.8149c-.3057-.1729-.6797-.1729-.9854,0L3.5073,14.1299c-.3135,.1777-.5073,.5098-.5073,.8701v10c0,.3604,.1938,.6924,.5073,.8701l8.5,4.8149,.9854-1.7402-7.9927-4.5278V15.583l7.5-4.2485,7.5,4.2485v2.417h2v-3c0-.3604-.1938-.6924-.5073-.8701Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,15h2V7c0-.3604-.1938-.6924-.5073-.8701L17.9927,1.3149c-.3057-.1729-.6797-.1729-.9854,0L8.5074,6.1299l.9854,1.7402L17.5,3.3345l7.5,4.2485v7.417Z"
    }
  }]);

  const CarbonUiBuilder16 = createSVGComponent('CarbonUiBuilder16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 28H30V30H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "29",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "29",
      "cy": "25",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20 24H26V26H20z",
      "transform": "rotate(-180 23 25)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 20H30V22H24z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "21",
      "cy": "21",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21.4927,14.1299l-8.5-4.8149c-.3057-.1729-.6797-.1729-.9854,0L3.5073,14.1299c-.3135,.1777-.5073,.5098-.5073,.8701v10c0,.3604,.1938,.6924,.5073,.8701l8.5,4.8149,.9854-1.7402-7.9927-4.5278V15.583l7.5-4.2485,7.5,4.2485v2.417h2v-3c0-.3604-.1938-.6924-.5073-.8701Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,15h2V7c0-.3604-.1938-.6924-.5073-.8701L17.9927,1.3149c-.3057-.1729-.6797-.1729-.9854,0L8.5074,6.1299l.9854,1.7402L17.5,3.3345l7.5,4.2485v7.417Z"
    }
  }]);

  const CarbonAccounting32 = createSVGComponent('CarbonAccounting32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 26H23V22a2.002 2.002 0 012-2h2V18H23V16h4a2.0023 2.0023 0 012 2v2a2.0023 2.0023 0 01-2 2H25v2h4zM19 22H15a2.0023 2.0023 0 01-2-2V10a2.002 2.002 0 012-2h4a2.002 2.002 0 012 2V20A2.0023 2.0023 0 0119 22zM15 10V20h4V10zM11 22H5a2.0023 2.0023 0 01-2-2V10A2.002 2.002 0 015 8h6v2H5V20h6z"
    }
  }]);

  const CarbonAccounting24 = createSVGComponent('CarbonAccounting24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 26H23V22a2.002 2.002 0 012-2h2V18H23V16h4a2.0023 2.0023 0 012 2v2a2.0023 2.0023 0 01-2 2H25v2h4zM19 22H15a2.0023 2.0023 0 01-2-2V10a2.002 2.002 0 012-2h4a2.002 2.002 0 012 2V20A2.0023 2.0023 0 0119 22zM15 10V20h4V10zM11 22H5a2.0023 2.0023 0 01-2-2V10A2.002 2.002 0 015 8h6v2H5V20h6z"
    }
  }]);

  const CarbonAccounting20 = createSVGComponent('CarbonAccounting20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 26H23V22a2.002 2.002 0 012-2h2V18H23V16h4a2.0023 2.0023 0 012 2v2a2.0023 2.0023 0 01-2 2H25v2h4zM19 22H15a2.0023 2.0023 0 01-2-2V10a2.002 2.002 0 012-2h4a2.002 2.002 0 012 2V20A2.0023 2.0023 0 0119 22zM15 10V20h4V10zM11 22H5a2.0023 2.0023 0 01-2-2V10A2.002 2.002 0 015 8h6v2H5V20h6z"
    }
  }]);

  const CarbonAccounting16 = createSVGComponent('CarbonAccounting16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 26H23V22a2.002 2.002 0 012-2h2V18H23V16h4a2.0023 2.0023 0 012 2v2a2.0023 2.0023 0 01-2 2H25v2h4zM19 22H15a2.0023 2.0023 0 01-2-2V10a2.002 2.002 0 012-2h4a2.002 2.002 0 012 2V20A2.0023 2.0023 0 0119 22zM15 10V20h4V10zM11 22H5a2.0023 2.0023 0 01-2-2V10A2.002 2.002 0 015 8h6v2H5V20h6z"
    }
  }]);

  const CarbonForIbmDotcom32 = createSVGComponent('CarbonForIbmDotcom32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.509,17.689l-6-3.55C23.352,14.046,23.176,14,23,14s-0.352,0.046-0.509,0.14l-6,3.55C16.187,17.869,16,18.196,16,18.55\tv6.9c0,0.354,0.187,0.681,0.491,0.86l6,3.55C22.648,29.954,22.824,30,23,30s0.352-0.046,0.509-0.14l6-3.55\tC29.813,26.131,30,25.804,30,25.45v-6.9C30,18.196,29.813,17.869,29.509,17.689z M28,24.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV24.88z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4C2.897,2,2,2.897,2,4v20c0,1.103,0.897,2,2,2h9v-2H4V10h24v4h2V4C30,2.897,29.103,2,28,2z M4,8V4h24v4H4z"
    }
  }]);

  const CarbonForIbmDotcom24 = createSVGComponent('CarbonForIbmDotcom24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.509,17.689l-6-3.55C23.352,14.046,23.176,14,23,14s-0.352,0.046-0.509,0.14l-6,3.55C16.187,17.869,16,18.196,16,18.55\tv6.9c0,0.354,0.187,0.681,0.491,0.86l6,3.55C22.648,29.954,22.824,30,23,30s0.352-0.046,0.509-0.14l6-3.55\tC29.813,26.131,30,25.804,30,25.45v-6.9C30,18.196,29.813,17.869,29.509,17.689z M28,24.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV24.88z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4C2.897,2,2,2.897,2,4v20c0,1.103,0.897,2,2,2h9v-2H4V10h24v4h2V4C30,2.897,29.103,2,28,2z M4,8V4h24v4H4z"
    }
  }]);

  const CarbonForIbmDotcom20 = createSVGComponent('CarbonForIbmDotcom20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.509,17.689l-6-3.55C23.352,14.046,23.176,14,23,14s-0.352,0.046-0.509,0.14l-6,3.55C16.187,17.869,16,18.196,16,18.55\tv6.9c0,0.354,0.187,0.681,0.491,0.86l6,3.55C22.648,29.954,22.824,30,23,30s0.352-0.046,0.509-0.14l6-3.55\tC29.813,26.131,30,25.804,30,25.45v-6.9C30,18.196,29.813,17.869,29.509,17.689z M28,24.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV24.88z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4C2.897,2,2,2.897,2,4v20c0,1.103,0.897,2,2,2h9v-2H4V10h24v4h2V4C30,2.897,29.103,2,28,2z M4,8V4h24v4H4z"
    }
  }]);

  const CarbonForIbmDotcom16 = createSVGComponent('CarbonForIbmDotcom16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.509,17.689l-6-3.55C23.352,14.046,23.176,14,23,14s-0.352,0.046-0.509,0.14l-6,3.55C16.187,17.869,16,18.196,16,18.55\tv6.9c0,0.354,0.187,0.681,0.491,0.86l6,3.55C22.648,29.954,22.824,30,23,30s0.352-0.046,0.509-0.14l6-3.55\tC29.813,26.131,30,25.804,30,25.45v-6.9C30,18.196,29.813,17.869,29.509,17.689z M28,24.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV24.88z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,2H4C2.897,2,2,2.897,2,4v20c0,1.103,0.897,2,2,2h9v-2H4V10h24v4h2V4C30,2.897,29.103,2,28,2z M4,8V4h24v4H4z"
    }
  }]);

  const CarbonForIbmProduct32 = createSVGComponent('CarbonForIbmProduct32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.509,12.689l-6-3.55C16.352,9.046,16.176,9,16,9s-0.352,0.046-0.509,0.14l-6,3.55C9.187,12.869,9,13.196,9,13.55v6.9\tc0,0.354,0.187,0.681,0.491,0.86l6,3.55C15.648,24.954,15.824,25,16,25s0.352-0.046,0.509-0.14l6-3.55\tC22.813,21.131,23,20.804,23,20.45v-6.9C23,13.196,22.813,12.869,22.509,12.689z M21,19.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV19.88z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 20.184V11.07l6.2-3.664-1.017-1.722L4.491 9.639C4.187 9.819 4 10.146 4 10.5v9.684C2.839 20.598 2 21.698 2 23c0 1.654 1.346 3 3 3s3-1.346 3-3C8 21.698 7.161 20.598 6 20.184zM5 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S5.551 24 5 24zM27 20c-1.654 0-3 1.346-3 3 0 .353.072.687.185 1.002L16 28.838l-6.404-3.784-1.017 1.722 6.912 4.084C15.648 30.954 15.824 31 16 31s.352-.046.509-.139l8.96-5.295C25.919 25.835 26.439 26 27 26c1.654 0 3-1.346 3-3S28.654 20 27 20zM27 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S27.551 24 27 24zM16 7c.731 0 1.392-.273 1.913-.708L26 11.071V18h2v-7.5c0-.354-.187-.681-.491-.861l-8.567-5.062C18.978 4.39 19 4.198 19 4c0-1.654-1.346-3-3-3s-3 1.346-3 3S14.346 7 16 7zM16 3c.551 0 1 .448 1 1s-.449 1-1 1-1-.448-1-1S15.449 3 16 3z"
    }
  }]);

  const CarbonForIbmProduct24 = createSVGComponent('CarbonForIbmProduct24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.509,12.689l-6-3.55C16.352,9.046,16.176,9,16,9s-0.352,0.046-0.509,0.14l-6,3.55C9.187,12.869,9,13.196,9,13.55v6.9\tc0,0.354,0.187,0.681,0.491,0.86l6,3.55C15.648,24.954,15.824,25,16,25s0.352-0.046,0.509-0.14l6-3.55\tC22.813,21.131,23,20.804,23,20.45v-6.9C23,13.196,22.813,12.869,22.509,12.689z M21,19.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV19.88z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 20.184V11.07l6.2-3.664-1.017-1.722L4.491 9.639C4.187 9.819 4 10.146 4 10.5v9.684C2.839 20.598 2 21.698 2 23c0 1.654 1.346 3 3 3s3-1.346 3-3C8 21.698 7.161 20.598 6 20.184zM5 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S5.551 24 5 24zM27 20c-1.654 0-3 1.346-3 3 0 .353.072.687.185 1.002L16 28.838l-6.404-3.784-1.017 1.722 6.912 4.084C15.648 30.954 15.824 31 16 31s.352-.046.509-.139l8.96-5.295C25.919 25.835 26.439 26 27 26c1.654 0 3-1.346 3-3S28.654 20 27 20zM27 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S27.551 24 27 24zM16 7c.731 0 1.392-.273 1.913-.708L26 11.071V18h2v-7.5c0-.354-.187-.681-.491-.861l-8.567-5.062C18.978 4.39 19 4.198 19 4c0-1.654-1.346-3-3-3s-3 1.346-3 3S14.346 7 16 7zM16 3c.551 0 1 .448 1 1s-.449 1-1 1-1-.448-1-1S15.449 3 16 3z"
    }
  }]);

  const CarbonForIbmProduct20 = createSVGComponent('CarbonForIbmProduct20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.509,12.689l-6-3.55C16.352,9.046,16.176,9,16,9s-0.352,0.046-0.509,0.14l-6,3.55C9.187,12.869,9,13.196,9,13.55v6.9\tc0,0.354,0.187,0.681,0.491,0.86l6,3.55C15.648,24.954,15.824,25,16,25s0.352-0.046,0.509-0.14l6-3.55\tC22.813,21.131,23,20.804,23,20.45v-6.9C23,13.196,22.813,12.869,22.509,12.689z M21,19.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV19.88z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 20.184V11.07l6.2-3.664-1.017-1.722L4.491 9.639C4.187 9.819 4 10.146 4 10.5v9.684C2.839 20.598 2 21.698 2 23c0 1.654 1.346 3 3 3s3-1.346 3-3C8 21.698 7.161 20.598 6 20.184zM5 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S5.551 24 5 24zM27 20c-1.654 0-3 1.346-3 3 0 .353.072.687.185 1.002L16 28.838l-6.404-3.784-1.017 1.722 6.912 4.084C15.648 30.954 15.824 31 16 31s.352-.046.509-.139l8.96-5.295C25.919 25.835 26.439 26 27 26c1.654 0 3-1.346 3-3S28.654 20 27 20zM27 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S27.551 24 27 24zM16 7c.731 0 1.392-.273 1.913-.708L26 11.071V18h2v-7.5c0-.354-.187-.681-.491-.861l-8.567-5.062C18.978 4.39 19 4.198 19 4c0-1.654-1.346-3-3-3s-3 1.346-3 3S14.346 7 16 7zM16 3c.551 0 1 .448 1 1s-.449 1-1 1-1-.448-1-1S15.449 3 16 3z"
    }
  }]);

  const CarbonForIbmProduct16 = createSVGComponent('CarbonForIbmProduct16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.509,12.689l-6-3.55C16.352,9.046,16.176,9,16,9s-0.352,0.046-0.509,0.14l-6,3.55C9.187,12.869,9,13.196,9,13.55v6.9\tc0,0.354,0.187,0.681,0.491,0.86l6,3.55C15.648,24.954,15.824,25,16,25s0.352-0.046,0.509-0.14l6-3.55\tC22.813,21.131,23,20.804,23,20.45v-6.9C23,13.196,22.813,12.869,22.509,12.689z M21,19.88l-5,2.958l-5-2.958v-5.76l5-2.958l5,2.958\tV19.88z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 20.184V11.07l6.2-3.664-1.017-1.722L4.491 9.639C4.187 9.819 4 10.146 4 10.5v9.684C2.839 20.598 2 21.698 2 23c0 1.654 1.346 3 3 3s3-1.346 3-3C8 21.698 7.161 20.598 6 20.184zM5 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S5.551 24 5 24zM27 20c-1.654 0-3 1.346-3 3 0 .353.072.687.185 1.002L16 28.838l-6.404-3.784-1.017 1.722 6.912 4.084C15.648 30.954 15.824 31 16 31s.352-.046.509-.139l8.96-5.295C25.919 25.835 26.439 26 27 26c1.654 0 3-1.346 3-3S28.654 20 27 20zM27 24c-.551 0-1-.448-1-1s.449-1 1-1 1 .448 1 1S27.551 24 27 24zM16 7c.731 0 1.392-.273 1.913-.708L26 11.071V18h2v-7.5c0-.354-.187-.681-.491-.861l-8.567-5.062C18.978 4.39 19 4.198 19 4c0-1.654-1.346-3-3-3s-3 1.346-3 3S14.346 7 16 7zM16 3c.551 0 1 .448 1 1s-.449 1-1 1-1-.448-1-1S15.449 3 16 3z"
    }
  }]);

  const CarbonForMobile32 = createSVGComponent('CarbonForMobile32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 14h-2v-5.9258l-5.5039-3.2104 1.0078-1.7275 6 3.5c.3071.1792.4961.5083.4961.8638v6.5zM20 22c-.1743 0-.3481-.0454-.5039-.1362l-6-3.5c-.3071-.1792-.4961-.5083-.4961-.8638v-7c0-.3555.189-.6846.4961-.8638l6-3.5c.3115-.1816.6963-.1816 1.0078 0l6 3.5c.3071.1792.4961.5083.4961.8638v7c0 .3555-.189.6846-.4961.8638l-6 3.5c-.1558.0908-.3296.1362-.5039.1362zm-5-5.0742l5 2.9165 5-2.9165v-5.8516l-5-2.9165-5 2.9165v5.8516z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m19,30H6c-1.1028,0-2-.8972-2-2V4c0-1.1028.8972-2,2-2h13v2H6v24h13v-4h2v4c0,1.1028-.8972,2-2,2Z"
    }
  }]);

  const CarbonForMobile24 = createSVGComponent('CarbonForMobile24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 14h-2v-5.9258l-5.5039-3.2104 1.0078-1.7275 6 3.5c.3071.1792.4961.5083.4961.8638v6.5zM20 22c-.1743 0-.3481-.0454-.5039-.1362l-6-3.5c-.3071-.1792-.4961-.5083-.4961-.8638v-7c0-.3555.189-.6846.4961-.8638l6-3.5c.3115-.1816.6963-.1816 1.0078 0l6 3.5c.3071.1792.4961.5083.4961.8638v7c0 .3555-.189.6846-.4961.8638l-6 3.5c-.1558.0908-.3296.1362-.5039.1362zm-5-5.0742l5 2.9165 5-2.9165v-5.8516l-5-2.9165-5 2.9165v5.8516z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m19,30H6c-1.1028,0-2-.8972-2-2V4c0-1.1028.8972-2,2-2h13v2H6v24h13v-4h2v4c0,1.1028-.8972,2-2,2Z"
    }
  }]);

  const CarbonForMobile20 = createSVGComponent('CarbonForMobile20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 14h-2v-5.9258l-5.5039-3.2104 1.0078-1.7275 6 3.5c.3071.1792.4961.5083.4961.8638v6.5zM20 22c-.1743 0-.3481-.0454-.5039-.1362l-6-3.5c-.3071-.1792-.4961-.5083-.4961-.8638v-7c0-.3555.189-.6846.4961-.8638l6-3.5c.3115-.1816.6963-.1816 1.0078 0l6 3.5c.3071.1792.4961.5083.4961.8638v7c0 .3555-.189.6846-.4961.8638l-6 3.5c-.1558.0908-.3296.1362-.5039.1362zm-5-5.0742l5 2.9165 5-2.9165v-5.8516l-5-2.9165-5 2.9165v5.8516z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m19,30H6c-1.1028,0-2-.8972-2-2V4c0-1.1028.8972-2,2-2h13v2H6v24h13v-4h2v4c0,1.1028-.8972,2-2,2Z"
    }
  }]);

  const CarbonForMobile16 = createSVGComponent('CarbonForMobile16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M32 14h-2v-5.9258l-5.5039-3.2104 1.0078-1.7275 6 3.5c.3071.1792.4961.5083.4961.8638v6.5zM20 22c-.1743 0-.3481-.0454-.5039-.1362l-6-3.5c-.3071-.1792-.4961-.5083-.4961-.8638v-7c0-.3555.189-.6846.4961-.8638l6-3.5c.3115-.1816.6963-.1816 1.0078 0l6 3.5c.3071.1792.4961.5083.4961.8638v7c0 .3555-.189.6846-.4961.8638l-6 3.5c-.1558.0908-.3296.1362-.5039.1362zm-5-5.0742l5 2.9165 5-2.9165v-5.8516l-5-2.9165-5 2.9165v5.8516z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "12.5",
      "cy": "24.5",
      "r": "1.5"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m19,30H6c-1.1028,0-2-.8972-2-2V4c0-1.1028.8972-2,2-2h13v2H6v24h13v-4h2v4c0,1.1028-.8972,2-2,2Z"
    }
  }]);

  const CaretDown32 = createSVGComponent('CaretDown32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 12L16 22 8 12z"
    }
  }]);

  const CaretDown24 = createSVGComponent('CaretDown24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 12L16 22 8 12z"
    }
  }]);

  const CaretDown20 = createSVGComponent('CaretDown20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 12L16 22 8 12z"
    }
  }]);

  const CaretDown16 = createSVGComponent('CaretDown16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 12L16 22 8 12z"
    }
  }]);

  const CaretDownGlyph = createSVGComponent('CaretDownGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 8 4",
    "fill": "currentColor",
    "width": "8",
    "height": "4"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 0L4 4 0 0z"
    }
  }]);

  const CaretLeft32 = createSVGComponent('CaretLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 24L10 16 20 8z"
    }
  }]);

  const CaretLeft24 = createSVGComponent('CaretLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 24L10 16 20 8z"
    }
  }]);

  const CaretLeft20 = createSVGComponent('CaretLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 24L10 16 20 8z"
    }
  }]);

  const CaretLeft16 = createSVGComponent('CaretLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 24L10 16 20 8z"
    }
  }]);

  const CaretLeftGlyph = createSVGComponent('CaretLeftGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 5 8",
    "fill": "currentColor",
    "width": "5",
    "height": "8"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M5 8L0 4 5 0z"
    }
  }]);

  const CaretRight32 = createSVGComponent('CaretRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 8L22 16 12 24z"
    }
  }]);

  const CaretRight24 = createSVGComponent('CaretRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 8L22 16 12 24z"
    }
  }]);

  const CaretRight20 = createSVGComponent('CaretRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 8L22 16 12 24z"
    }
  }]);

  const CaretRight16 = createSVGComponent('CaretRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12 8L22 16 12 24z"
    }
  }]);

  const CaretRightGlyph = createSVGComponent('CaretRightGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 5 8",
    "fill": "currentColor",
    "width": "5",
    "height": "8"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M0 0L5 4 0 8z"
    }
  }]);

  const CaretSort32 = createSVGComponent('CaretSort32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24zM8 8L16 0 24 8z"
    }
  }]);

  const CaretSort24 = createSVGComponent('CaretSort24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24zM8 8L16 0 24 8z"
    }
  }]);

  const CaretSort20 = createSVGComponent('CaretSort20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24zM8 8L16 0 24 8z"
    }
  }]);

  const CaretSort16 = createSVGComponent('CaretSort16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24zM8 8L16 0 24 8z"
    }
  }]);

  const CaretSortDown32 = createSVGComponent('CaretSortDown32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24z"
    }
  }]);

  const CaretSortDown24 = createSVGComponent('CaretSortDown24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24z"
    }
  }]);

  const CaretSortDown20 = createSVGComponent('CaretSortDown20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24z"
    }
  }]);

  const CaretSortDown16 = createSVGComponent('CaretSortDown16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24L16 32 8 24z"
    }
  }]);

  const CaretSortUp32 = createSVGComponent('CaretSortUp32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 8L16 0 24 8z"
    }
  }]);

  const CaretSortUp24 = createSVGComponent('CaretSortUp24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 8L16 0 24 8z"
    }
  }]);

  const CaretSortUp20 = createSVGComponent('CaretSortUp20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 8L16 0 24 8z"
    }
  }]);

  const CaretSortUp16 = createSVGComponent('CaretSortUp16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 8L16 0 24 8z"
    }
  }]);

  const CaretUp32 = createSVGComponent('CaretUp32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 20L16 10 24 20z"
    }
  }]);

  const CaretUp24 = createSVGComponent('CaretUp24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 20L16 10 24 20z"
    }
  }]);

  const CaretUp20 = createSVGComponent('CaretUp20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 20L16 10 24 20z"
    }
  }]);

  const CaretUp16 = createSVGComponent('CaretUp16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 20L16 10 24 20z"
    }
  }]);

  const CaretUpGlyph = createSVGComponent('CaretUpGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 8 4",
    "fill": "currentColor",
    "width": "8",
    "height": "4"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M0 4L4 0 8 4z"
    }
  }]);

  const CarouselHorizontal32 = createSVGComponent('CarouselHorizontal32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26H10a2 2 0 01-2-2V8a2 2 0 012-2H22a2 2 0 012 2V24A2 2 0 0122 26zM10 8V24H22V8zM4 24H0V22H4V10H0V8H4a2 2 0 012 2V22A2 2 0 014 24zM32 24H28a2 2 0 01-2-2V10a2 2 0 012-2h4v2H28V22h4z"
    }
  }]);

  const CarouselHorizontal24 = createSVGComponent('CarouselHorizontal24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26H10a2 2 0 01-2-2V8a2 2 0 012-2H22a2 2 0 012 2V24A2 2 0 0122 26zM10 8V24H22V8zM4 24H0V22H4V10H0V8H4a2 2 0 012 2V22A2 2 0 014 24zM32 24H28a2 2 0 01-2-2V10a2 2 0 012-2h4v2H28V22h4z"
    }
  }]);

  const CarouselHorizontal20 = createSVGComponent('CarouselHorizontal20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26H10a2 2 0 01-2-2V8a2 2 0 012-2H22a2 2 0 012 2V24A2 2 0 0122 26zM10 8V24H22V8zM4 24H0V22H4V10H0V8H4a2 2 0 012 2V22A2 2 0 014 24zM32 24H28a2 2 0 01-2-2V10a2 2 0 012-2h4v2H28V22h4z"
    }
  }]);

  const CarouselHorizontal16 = createSVGComponent('CarouselHorizontal16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 26H10a2 2 0 01-2-2V8a2 2 0 012-2H22a2 2 0 012 2V24A2 2 0 0122 26zM10 8V24H22V8zM4 24H0V22H4V10H0V8H4a2 2 0 012 2V22A2 2 0 014 24zM32 24H28a2 2 0 01-2-2V10a2 2 0 012-2h4v2H28V22h4z"
    }
  }]);

  const CarouselVertical32 = createSVGComponent('CarouselVertical32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10V22a2 2 0 01-2 2H8a2 2 0 01-2-2V10A2 2 0 018 8H24A2 2 0 0126 10zM8 22H24V10H8zM24 28v4H22V28H10v4H8V28a2 2 0 012-2H22A2 2 0 0124 28zM24 0V4a2 2 0 01-2 2H10A2 2 0 018 4V0h2V4H22V0z"
    }
  }]);

  const CarouselVertical24 = createSVGComponent('CarouselVertical24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10V22a2 2 0 01-2 2H8a2 2 0 01-2-2V10A2 2 0 018 8H24A2 2 0 0126 10zM8 22H24V10H8zM24 28v4H22V28H10v4H8V28a2 2 0 012-2H22A2 2 0 0124 28zM24 0V4a2 2 0 01-2 2H10A2 2 0 018 4V0h2V4H22V0z"
    }
  }]);

  const CarouselVertical20 = createSVGComponent('CarouselVertical20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10V22a2 2 0 01-2 2H8a2 2 0 01-2-2V10A2 2 0 018 8H24A2 2 0 0126 10zM8 22H24V10H8zM24 28v4H22V28H10v4H8V28a2 2 0 012-2H22A2 2 0 0124 28zM24 0V4a2 2 0 01-2 2H10A2 2 0 018 4V0h2V4H22V0z"
    }
  }]);

  const CarouselVertical16 = createSVGComponent('CarouselVertical16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10V22a2 2 0 01-2 2H8a2 2 0 01-2-2V10A2 2 0 018 8H24A2 2 0 0126 10zM8 22H24V10H8zM24 28v4H22V28H10v4H8V28a2 2 0 012-2H22A2 2 0 0124 28zM24 0V4a2 2 0 01-2 2H10A2 2 0 018 4V0h2V4H22V0z"
    }
  }]);

  const Catalog32 = createSVGComponent('Catalog32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 8H22V10H14zM14 15H22V17H14zM14 22H22V24H14z"
    }
  }]);

  const Catalog24 = createSVGComponent('Catalog24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 8H22V10H14zM14 15H22V17H14zM14 22H22V24H14z"
    }
  }]);

  const Catalog20 = createSVGComponent('Catalog20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 8H22V10H14zM14 15H22V17H14zM14 22H22V24H14z"
    }
  }]);

  const Catalog16 = createSVGComponent('Catalog16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 8H22V10H14zM14 15H22V17H14zM14 22H22V24H14z"
    }
  }]);

  const CatalogPublish32 = createSVGComponent('CatalogPublish32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 20L21.4 21.4 18.8 24 28 24 28 26 18.8 26 21.4 28.6 20 30 15 25zM14 15H22V17H14zM14 8H22V10H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,28H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18v16h2V4c0-1.1-0.9-2-2-2H8C6.9,2,6,2.9,6,4v4H4v2h2v5H4v2h2v5H4v2h2v4\tc0,1.1,0.9,2,2,2h5V28z"
    }
  }]);

  const CatalogPublish24 = createSVGComponent('CatalogPublish24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 20L21.4 21.4 18.8 24 28 24 28 26 18.8 26 21.4 28.6 20 30 15 25zM14 15H22V17H14zM14 8H22V10H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,28H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18v16h2V4c0-1.1-0.9-2-2-2H8C6.9,2,6,2.9,6,4v4H4v2h2v5H4v2h2v5H4v2h2v4\tc0,1.1,0.9,2,2,2h5V28z"
    }
  }]);

  const CatalogPublish20 = createSVGComponent('CatalogPublish20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 20L21.4 21.4 18.8 24 28 24 28 26 18.8 26 21.4 28.6 20 30 15 25zM14 15H22V17H14zM14 8H22V10H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,28H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18v16h2V4c0-1.1-0.9-2-2-2H8C6.9,2,6,2.9,6,4v4H4v2h2v5H4v2h2v5H4v2h2v4\tc0,1.1,0.9,2,2,2h5V28z"
    }
  }]);

  const CatalogPublish16 = createSVGComponent('CatalogPublish16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20 20L21.4 21.4 18.8 24 28 24 28 26 18.8 26 21.4 28.6 20 30 15 25zM14 15H22V17H14zM14 8H22V10H14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M13,28H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18v16h2V4c0-1.1-0.9-2-2-2H8C6.9,2,6,2.9,6,4v4H4v2h2v5H4v2h2v5H4v2h2v4\tc0,1.1,0.9,2,2,2h5V28z"
    }
  }]);

  const Categories32 = createSVGComponent('Categories32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6.76 6l.45.89L7.76 8H12v5H4V6H6.76m.62-2H3A1 1 0 002 5v9a1 1 0 001 1H13a1 1 0 001-1V7a1 1 0 00-1-1H9L8.28 4.55A1 1 0 007.38 4zM22.76 6l.45.89L23.76 8H28v5H20V6h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V7a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55zM6.76 19l.45.89L7.76 21H12v5H4V19H6.76m.62-2H3a1 1 0 00-1 1v9a1 1 0 001 1H13a1 1 0 001-1V20a1 1 0 00-1-1H9l-.72-1.45a1 1 0 00-.9-.55zM22.76 19l.45.89L23.76 21H28v5H20V19h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V20a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55z"
    }
  }]);

  const Categories24 = createSVGComponent('Categories24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6.76 6l.45.89L7.76 8H12v5H4V6H6.76m.62-2H3A1 1 0 002 5v9a1 1 0 001 1H13a1 1 0 001-1V7a1 1 0 00-1-1H9L8.28 4.55A1 1 0 007.38 4zM22.76 6l.45.89L23.76 8H28v5H20V6h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V7a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55zM6.76 19l.45.89L7.76 21H12v5H4V19H6.76m.62-2H3a1 1 0 00-1 1v9a1 1 0 001 1H13a1 1 0 001-1V20a1 1 0 00-1-1H9l-.72-1.45a1 1 0 00-.9-.55zM22.76 19l.45.89L23.76 21H28v5H20V19h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V20a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55z"
    }
  }]);

  const Categories20 = createSVGComponent('Categories20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6.76 6l.45.89L7.76 8H12v5H4V6H6.76m.62-2H3A1 1 0 002 5v9a1 1 0 001 1H13a1 1 0 001-1V7a1 1 0 00-1-1H9L8.28 4.55A1 1 0 007.38 4zM22.76 6l.45.89L23.76 8H28v5H20V6h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V7a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55zM6.76 19l.45.89L7.76 21H12v5H4V19H6.76m.62-2H3a1 1 0 00-1 1v9a1 1 0 001 1H13a1 1 0 001-1V20a1 1 0 00-1-1H9l-.72-1.45a1 1 0 00-.9-.55zM22.76 19l.45.89L23.76 21H28v5H20V19h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V20a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55z"
    }
  }]);

  const Categories16 = createSVGComponent('Categories16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6.76 6l.45.89L7.76 8H12v5H4V6H6.76m.62-2H3A1 1 0 002 5v9a1 1 0 001 1H13a1 1 0 001-1V7a1 1 0 00-1-1H9L8.28 4.55A1 1 0 007.38 4zM22.76 6l.45.89L23.76 8H28v5H20V6h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V7a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55zM6.76 19l.45.89L7.76 21H12v5H4V19H6.76m.62-2H3a1 1 0 00-1 1v9a1 1 0 001 1H13a1 1 0 001-1V20a1 1 0 00-1-1H9l-.72-1.45a1 1 0 00-.9-.55zM22.76 19l.45.89L23.76 21H28v5H20V19h2.76m.62-2H19a1 1 0 00-1 1v9a1 1 0 001 1H29a1 1 0 001-1V20a1 1 0 00-1-1H25l-.72-1.45a1 1 0 00-.9-.55z"
    }
  }]);

  const Category32 = createSVGComponent('Category32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"
    }
  }]);

  const Category24 = createSVGComponent('Category24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"
    }
  }]);

  const Category20 = createSVGComponent('Category20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"
    }
  }]);

  const Category16 = createSVGComponent('Category16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"
    }
  }]);

  const CategoryAdd32 = createSVGComponent('CategoryAdd32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 6L13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryAdd24 = createSVGComponent('CategoryAdd24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 6L13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryAdd20 = createSVGComponent('CategoryAdd20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 6L13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryAdd16 = createSVGComponent('CategoryAdd16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 6L13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryAnd32 = createSVGComponent('CategoryAnd32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 30V26H15v4h2V26H28v4h2V26a2 2 0 00-2-2H17V19H15v5H4a2 2 0 00-2 2v4zM20.6953 13.9858A10.08 10.08 0 0021.9463 10H23V8H20V9a9.2634 9.2634 0 01-.6641 3.2705L16.6511 8.8816a5.1261 5.1261 0 002.1436-2.3694A3.2522 3.2522 0 0018.6062 3.81a3.38 3.38 0 00-2.2391-1.7056 3.4688 3.4688 0 00-4.2223 2.1186c-.5044 1.5518.4406 3.1158 1.2612 4.1077A4.7255 4.7255 0 0011.06 13.1587 4.4526 4.4526 0 0015.4268 17h.0058a5.7844 5.7844 0 003.9717-1.4233L20.532 17h2.5519zM14.047 4.8413A1.3224 1.3224 0 0115.4141 4a2.41 2.41 0 01.5214.0581 1.4018 1.4018 0 01.9111.7022 1.2493 1.2493 0 01.0791 1.042A3.6871 3.6871 0 0115.2441 7.395C14.5831 6.6816 13.8087 5.5732 14.047 4.8413zM15.4316 15h-.0039a2.4432 2.4432 0 01-2.3916-2.1509 2.8261 2.8261 0 011.81-3.0249l3.3115 4.1787A3.8853 3.8853 0 0115.4316 15z"
    }
  }]);

  const CategoryAnd24 = createSVGComponent('CategoryAnd24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 30V26H15v4h2V26H28v4h2V26a2 2 0 00-2-2H17V19H15v5H4a2 2 0 00-2 2v4zM20.6953 13.9858A10.08 10.08 0 0021.9463 10H23V8H20V9a9.2634 9.2634 0 01-.6641 3.2705L16.6511 8.8816a5.1261 5.1261 0 002.1436-2.3694A3.2522 3.2522 0 0018.6062 3.81a3.38 3.38 0 00-2.2391-1.7056 3.4688 3.4688 0 00-4.2223 2.1186c-.5044 1.5518.4406 3.1158 1.2612 4.1077A4.7255 4.7255 0 0011.06 13.1587 4.4526 4.4526 0 0015.4268 17h.0058a5.7844 5.7844 0 003.9717-1.4233L20.532 17h2.5519zM14.047 4.8413A1.3224 1.3224 0 0115.4141 4a2.41 2.41 0 01.5214.0581 1.4018 1.4018 0 01.9111.7022 1.2493 1.2493 0 01.0791 1.042A3.6871 3.6871 0 0115.2441 7.395C14.5831 6.6816 13.8087 5.5732 14.047 4.8413zM15.4316 15h-.0039a2.4432 2.4432 0 01-2.3916-2.1509 2.8261 2.8261 0 011.81-3.0249l3.3115 4.1787A3.8853 3.8853 0 0115.4316 15z"
    }
  }]);

  const CategoryAnd20 = createSVGComponent('CategoryAnd20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 30V26H15v4h2V26H28v4h2V26a2 2 0 00-2-2H17V19H15v5H4a2 2 0 00-2 2v4zM20.6953 13.9858A10.08 10.08 0 0021.9463 10H23V8H20V9a9.2634 9.2634 0 01-.6641 3.2705L16.6511 8.8816a5.1261 5.1261 0 002.1436-2.3694A3.2522 3.2522 0 0018.6062 3.81a3.38 3.38 0 00-2.2391-1.7056 3.4688 3.4688 0 00-4.2223 2.1186c-.5044 1.5518.4406 3.1158 1.2612 4.1077A4.7255 4.7255 0 0011.06 13.1587 4.4526 4.4526 0 0015.4268 17h.0058a5.7844 5.7844 0 003.9717-1.4233L20.532 17h2.5519zM14.047 4.8413A1.3224 1.3224 0 0115.4141 4a2.41 2.41 0 01.5214.0581 1.4018 1.4018 0 01.9111.7022 1.2493 1.2493 0 01.0791 1.042A3.6871 3.6871 0 0115.2441 7.395C14.5831 6.6816 13.8087 5.5732 14.047 4.8413zM15.4316 15h-.0039a2.4432 2.4432 0 01-2.3916-2.1509 2.8261 2.8261 0 011.81-3.0249l3.3115 4.1787A3.8853 3.8853 0 0115.4316 15z"
    }
  }]);

  const CategoryAnd16 = createSVGComponent('CategoryAnd16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 30V26H15v4h2V26H28v4h2V26a2 2 0 00-2-2H17V19H15v5H4a2 2 0 00-2 2v4zM20.6953 13.9858A10.08 10.08 0 0021.9463 10H23V8H20V9a9.2634 9.2634 0 01-.6641 3.2705L16.6511 8.8816a5.1261 5.1261 0 002.1436-2.3694A3.2522 3.2522 0 0018.6062 3.81a3.38 3.38 0 00-2.2391-1.7056 3.4688 3.4688 0 00-4.2223 2.1186c-.5044 1.5518.4406 3.1158 1.2612 4.1077A4.7255 4.7255 0 0011.06 13.1587 4.4526 4.4526 0 0015.4268 17h.0058a5.7844 5.7844 0 003.9717-1.4233L20.532 17h2.5519zM14.047 4.8413A1.3224 1.3224 0 0115.4141 4a2.41 2.41 0 01.5214.0581 1.4018 1.4018 0 01.9111.7022 1.2493 1.2493 0 01.0791 1.042A3.6871 3.6871 0 0115.2441 7.395C14.5831 6.6816 13.8087 5.5732 14.047 4.8413zM15.4316 15h-.0039a2.4432 2.4432 0 01-2.3916-2.1509 2.8261 2.8261 0 011.81-3.0249l3.3115 4.1787A3.8853 3.8853 0 0115.4316 15z"
    }
  }]);

  const CategoryNew32 = createSVGComponent('CategoryNew32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 10L17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryNew24 = createSVGComponent('CategoryNew24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 10L17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryNew20 = createSVGComponent('CategoryNew20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 10L17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryNew16 = createSVGComponent('CategoryNew16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 10L17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"
    }
  }]);

  const CategoryNewEach32 = createSVGComponent('CategoryNewEach32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 10H24v2h5v6H22v2h3v2.142a4 4 0 102 0V20h2a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0029 10zM28 26a2 2 0 11-2-2A2.0027 2.0027 0 0128 26zM19 6H14V8h5v6H12v2h3v6.142a4 4 0 102 0V16h2a2.0023 2.0023 0 002-2V8A2.0023 2.0023 0 0019 6zM18 26a2 2 0 11-2-2A2.0027 2.0027 0 0118 26zM9 2H3A2.002 2.002 0 001 4v6a2.002 2.002 0 002 2H5V22.142a4 4 0 102 0V12H9a2.002 2.002 0 002-2V4A2.002 2.002 0 009 2zM8 26a2 2 0 11-2-2A2.0023 2.0023 0 018 26zM3 10V4H9l.0015 6z"
    }
  }]);

  const CategoryNewEach24 = createSVGComponent('CategoryNewEach24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 10H24v2h5v6H22v2h3v2.142a4 4 0 102 0V20h2a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0029 10zM28 26a2 2 0 11-2-2A2.0027 2.0027 0 0128 26zM19 6H14V8h5v6H12v2h3v6.142a4 4 0 102 0V16h2a2.0023 2.0023 0 002-2V8A2.0023 2.0023 0 0019 6zM18 26a2 2 0 11-2-2A2.0027 2.0027 0 0118 26zM9 2H3A2.002 2.002 0 001 4v6a2.002 2.002 0 002 2H5V22.142a4 4 0 102 0V12H9a2.002 2.002 0 002-2V4A2.002 2.002 0 009 2zM8 26a2 2 0 11-2-2A2.0023 2.0023 0 018 26zM3 10V4H9l.0015 6z"
    }
  }]);

  const CategoryNewEach20 = createSVGComponent('CategoryNewEach20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 10H24v2h5v6H22v2h3v2.142a4 4 0 102 0V20h2a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0029 10zM28 26a2 2 0 11-2-2A2.0027 2.0027 0 0128 26zM19 6H14V8h5v6H12v2h3v6.142a4 4 0 102 0V16h2a2.0023 2.0023 0 002-2V8A2.0023 2.0023 0 0019 6zM18 26a2 2 0 11-2-2A2.0027 2.0027 0 0118 26zM9 2H3A2.002 2.002 0 001 4v6a2.002 2.002 0 002 2H5V22.142a4 4 0 102 0V12H9a2.002 2.002 0 002-2V4A2.002 2.002 0 009 2zM8 26a2 2 0 11-2-2A2.0023 2.0023 0 018 26zM3 10V4H9l.0015 6z"
    }
  }]);

  const CategoryNewEach16 = createSVGComponent('CategoryNewEach16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 10H24v2h5v6H22v2h3v2.142a4 4 0 102 0V20h2a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0029 10zM28 26a2 2 0 11-2-2A2.0027 2.0027 0 0128 26zM19 6H14V8h5v6H12v2h3v6.142a4 4 0 102 0V16h2a2.0023 2.0023 0 002-2V8A2.0023 2.0023 0 0019 6zM18 26a2 2 0 11-2-2A2.0027 2.0027 0 0118 26zM9 2H3A2.002 2.002 0 001 4v6a2.002 2.002 0 002 2H5V22.142a4 4 0 102 0V12H9a2.002 2.002 0 002-2V4A2.002 2.002 0 009 2zM8 26a2 2 0 11-2-2A2.0023 2.0023 0 018 26zM3 10V4H9l.0015 6z"
    }
  }]);

  const CautionGlyph = createSVGComponent('CautionGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": "16",
    "height": "16"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12.3154,12H3.6846L8,4.0884,12.3154,12M14,13,8,2,2,13Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12.315 12L3.685 12 8 4.088 12.315 12z"
    }
  }]);

  const CautionInvertedGlyph = createSVGComponent('CautionInvertedGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": "16",
    "height": "16"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 14L2 3 14 3 8 14z"
    }
  }]);

  const QCcX32 = createSVGComponent('QCcX32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 23H5a2 2 0 01-2-2V15a2 2 0 012-2h5v2H5v6h5zM19 23H14a2 2 0 01-2-2V15a2 2 0 012-2h5v2H14v6h5zM29 9L27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9z"
    }
  }]);

  const QCcX24 = createSVGComponent('QCcX24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 23H5a2 2 0 01-2-2V15a2 2 0 012-2h5v2H5v6h5zM19 23H14a2 2 0 01-2-2V15a2 2 0 012-2h5v2H14v6h5zM29 9L27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9z"
    }
  }]);

  const QCcX20 = createSVGComponent('QCcX20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 23H5a2 2 0 01-2-2V15a2 2 0 012-2h5v2H5v6h5zM19 23H14a2 2 0 01-2-2V15a2 2 0 012-2h5v2H14v6h5zM29 9L27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9z"
    }
  }]);

  const QCcX16 = createSVGComponent('QCcX16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 23H5a2 2 0 01-2-2V15a2 2 0 012-2h5v2H5v6h5zM19 23H14a2 2 0 01-2-2V15a2 2 0 012-2h5v2H14v6h5zM29 9L27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9z"
    }
  }]);

  const WatsonHealthCdArchive32 = createSVGComponent('WatsonHealthCdArchive32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A12,12,0,1,1,28,16,12,12,0,0,1,16,28ZM16,6A10,10,0,1,0,26,16,10,10,0,0,0,16,6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }]);

  const WatsonHealthCdArchive24 = createSVGComponent('WatsonHealthCdArchive24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A12,12,0,1,1,28,16,12,12,0,0,1,16,28ZM16,6A10,10,0,1,0,26,16,10,10,0,0,0,16,6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }]);

  const WatsonHealthCdArchive20 = createSVGComponent('WatsonHealthCdArchive20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A12,12,0,1,1,28,16,12,12,0,0,1,16,28ZM16,6A10,10,0,1,0,26,16,10,10,0,0,0,16,6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }]);

  const WatsonHealthCdArchive16 = createSVGComponent('WatsonHealthCdArchive16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,28A12,12,0,1,1,28,16,12,12,0,0,1,16,28ZM16,6A10,10,0,1,0,26,16,10,10,0,0,0,16,6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "2"
    }
  }]);

  const WatsonHealthCdCreateArchive32 = createSVGComponent('WatsonHealthCdCreateArchive32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,20a6,6,0,1,1,6-6A6,6,0,0,1,14,20Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,14,10Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,23.54A10,10,0,1,1,24,14c0,.34,0,.67-.05,1h2c0-.33.05-.66.05-1A12,12,0,1,0,14,26a12.33,12.33,0,0,0,3-.39Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,30l-2.14-1A5,5,0,0,1,20,24.47V18H30v6.47A5,5,0,0,1,27.14,29ZM22,20v4.47a3,3,0,0,0,1.72,2.71l1.28.61,1.28-.61A3,3,0,0,0,28,24.47V20Z"
    }
  }]);

  const WatsonHealthCdCreateArchive24 = createSVGComponent('WatsonHealthCdCreateArchive24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,20a6,6,0,1,1,6-6A6,6,0,0,1,14,20Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,14,10Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,23.54A10,10,0,1,1,24,14c0,.34,0,.67-.05,1h2c0-.33.05-.66.05-1A12,12,0,1,0,14,26a12.33,12.33,0,0,0,3-.39Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,30l-2.14-1A5,5,0,0,1,20,24.47V18H30v6.47A5,5,0,0,1,27.14,29ZM22,20v4.47a3,3,0,0,0,1.72,2.71l1.28.61,1.28-.61A3,3,0,0,0,28,24.47V20Z"
    }
  }]);

  const WatsonHealthCdCreateArchive20 = createSVGComponent('WatsonHealthCdCreateArchive20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,20a6,6,0,1,1,6-6A6,6,0,0,1,14,20Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,14,10Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,23.54A10,10,0,1,1,24,14c0,.34,0,.67-.05,1h2c0-.33.05-.66.05-1A12,12,0,1,0,14,26a12.33,12.33,0,0,0,3-.39Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,30l-2.14-1A5,5,0,0,1,20,24.47V18H30v6.47A5,5,0,0,1,27.14,29ZM22,20v4.47a3,3,0,0,0,1.72,2.71l1.28.61,1.28-.61A3,3,0,0,0,28,24.47V20Z"
    }
  }]);

  const WatsonHealthCdCreateArchive16 = createSVGComponent('WatsonHealthCdCreateArchive16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,20a6,6,0,1,1,6-6A6,6,0,0,1,14,20Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,14,10Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17,23.54A10,10,0,1,1,24,14c0,.34,0,.67-.05,1h2c0-.33.05-.66.05-1A12,12,0,1,0,14,26a12.33,12.33,0,0,0,3-.39Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25,30l-2.14-1A5,5,0,0,1,20,24.47V18H30v6.47A5,5,0,0,1,27.14,29ZM22,20v4.47a3,3,0,0,0,1.72,2.71l1.28.61,1.28-.61A3,3,0,0,0,28,24.47V20Z"
    }
  }]);

  const WatsonHealthCdCreateExchange32 = createSVGComponent('WatsonHealthCdCreateExchange32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,0,0,0,24V24A10,10,0,1,1,24,14,8.27,8.27,0,0,1,24,15h2c0-.33.05-.66.05-1A12,12,0,0,0,14,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 24L26.17 24 23.58 26.59 25 28 30 23 25 18 23.58 19.42 26.17 22 17 22 17 24zM14 20a6 6 0 116-6A6 6 0 0114 20zm0-10a4 4 0 104 4A4 4 0 0014 10z"
    }
  }]);

  const WatsonHealthCdCreateExchange24 = createSVGComponent('WatsonHealthCdCreateExchange24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,0,0,0,24V24A10,10,0,1,1,24,14,8.27,8.27,0,0,1,24,15h2c0-.33.05-.66.05-1A12,12,0,0,0,14,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 24L26.17 24 23.58 26.59 25 28 30 23 25 18 23.58 19.42 26.17 22 17 22 17 24zM14 20a6 6 0 116-6A6 6 0 0114 20zm0-10a4 4 0 104 4A4 4 0 0014 10z"
    }
  }]);

  const WatsonHealthCdCreateExchange20 = createSVGComponent('WatsonHealthCdCreateExchange20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,0,0,0,24V24A10,10,0,1,1,24,14,8.27,8.27,0,0,1,24,15h2c0-.33.05-.66.05-1A12,12,0,0,0,14,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 24L26.17 24 23.58 26.59 25 28 30 23 25 18 23.58 19.42 26.17 22 17 22 17 24zM14 20a6 6 0 116-6A6 6 0 0114 20zm0-10a4 4 0 104 4A4 4 0 0014 10z"
    }
  }]);

  const WatsonHealthCdCreateExchange16 = createSVGComponent('WatsonHealthCdCreateExchange16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,0,0,0,24V24A10,10,0,1,1,24,14,8.27,8.27,0,0,1,24,15h2c0-.33.05-.66.05-1A12,12,0,0,0,14,2Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 24L26.17 24 23.58 26.59 25 28 30 23 25 18 23.58 19.42 26.17 22 17 22 17 24zM14 20a6 6 0 116-6A6 6 0 0114 20zm0-10a4 4 0 104 4A4 4 0 0014 10z"
    }
  }]);

  const Cda32 = createSVGComponent('Cda32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H24a2.002 2.002 0 00-2 2V23h2V18h4v5h2V11A2.0023 2.0023 0 0028 9zm-4 7V11h4v5zM16 23H12V9h4a4.0042 4.0042 0 014 4v6A4.0039 4.0039 0 0116 23zm-2-2h2a2.0027 2.0027 0 002-2V13a2.0023 2.0023 0 00-2-2H14zM10 23H4a2.0023 2.0023 0 01-2-2V11A2.002 2.002 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cda24 = createSVGComponent('Cda24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H24a2.002 2.002 0 00-2 2V23h2V18h4v5h2V11A2.0023 2.0023 0 0028 9zm-4 7V11h4v5zM16 23H12V9h4a4.0042 4.0042 0 014 4v6A4.0039 4.0039 0 0116 23zm-2-2h2a2.0027 2.0027 0 002-2V13a2.0023 2.0023 0 00-2-2H14zM10 23H4a2.0023 2.0023 0 01-2-2V11A2.002 2.002 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cda20 = createSVGComponent('Cda20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H24a2.002 2.002 0 00-2 2V23h2V18h4v5h2V11A2.0023 2.0023 0 0028 9zm-4 7V11h4v5zM16 23H12V9h4a4.0042 4.0042 0 014 4v6A4.0039 4.0039 0 0116 23zm-2-2h2a2.0027 2.0027 0 002-2V13a2.0023 2.0023 0 00-2-2H14zM10 23H4a2.0023 2.0023 0 01-2-2V11A2.002 2.002 0 014 9h6v2H4V21h6z"
    }
  }]);

  const Cda16 = createSVGComponent('Cda16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H24a2.002 2.002 0 00-2 2V23h2V18h4v5h2V11A2.0023 2.0023 0 0028 9zm-4 7V11h4v5zM16 23H12V9h4a4.0042 4.0042 0 014 4v6A4.0039 4.0039 0 0116 23zm-2-2h2a2.0027 2.0027 0 002-2V13a2.0023 2.0023 0 00-2-2H14zM10 23H4a2.0023 2.0023 0 01-2-2V11A2.002 2.002 0 014 9h6v2H4V21h6z"
    }
  }]);

  const CellTower32 = createSVGComponent('CellTower32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25 11L25 16 17 16 17 11 15 11 15 16 7 16 7 11 5 11 5 23 7 23 7 18 10 18 10 30 12 30 12 18 15 18 15 23 17 23 17 18 20 18 20 30 22 30 22 18 25 18 25 23 27 23 27 11zM16 6c-1.7 0-3.2.7-4.2 1.8l1.4 1.4C13.9 8.4 14.9 8 16 8s2.1.4 2.8 1.2l1.4-1.4C19.2 6.7 17.7 6 16 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8.9,4.9l1.4,1.4C11.8,4.9,13.8,4,16,4s4.2,0.9,5.7,2.3l1.4-1.4C21.3,3.1,18.8,2,16,2S10.7,3.1,8.9,4.9z"
    }
  }]);

  const CellTower24 = createSVGComponent('CellTower24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25 11L25 16 17 16 17 11 15 11 15 16 7 16 7 11 5 11 5 23 7 23 7 18 10 18 10 30 12 30 12 18 15 18 15 23 17 23 17 18 20 18 20 30 22 30 22 18 25 18 25 23 27 23 27 11zM16 6c-1.7 0-3.2.7-4.2 1.8l1.4 1.4C13.9 8.4 14.9 8 16 8s2.1.4 2.8 1.2l1.4-1.4C19.2 6.7 17.7 6 16 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8.9,4.9l1.4,1.4C11.8,4.9,13.8,4,16,4s4.2,0.9,5.7,2.3l1.4-1.4C21.3,3.1,18.8,2,16,2S10.7,3.1,8.9,4.9z"
    }
  }]);

  const CellTower20 = createSVGComponent('CellTower20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25 11L25 16 17 16 17 11 15 11 15 16 7 16 7 11 5 11 5 23 7 23 7 18 10 18 10 30 12 30 12 18 15 18 15 23 17 23 17 18 20 18 20 30 22 30 22 18 25 18 25 23 27 23 27 11zM16 6c-1.7 0-3.2.7-4.2 1.8l1.4 1.4C13.9 8.4 14.9 8 16 8s2.1.4 2.8 1.2l1.4-1.4C19.2 6.7 17.7 6 16 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8.9,4.9l1.4,1.4C11.8,4.9,13.8,4,16,4s4.2,0.9,5.7,2.3l1.4-1.4C21.3,3.1,18.8,2,16,2S10.7,3.1,8.9,4.9z"
    }
  }]);

  const CellTower16 = createSVGComponent('CellTower16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25 11L25 16 17 16 17 11 15 11 15 16 7 16 7 11 5 11 5 23 7 23 7 18 10 18 10 30 12 30 12 18 15 18 15 23 17 23 17 18 20 18 20 30 22 30 22 18 25 18 25 23 27 23 27 11zM16 6c-1.7 0-3.2.7-4.2 1.8l1.4 1.4C13.9 8.4 14.9 8 16 8s2.1.4 2.8 1.2l1.4-1.4C19.2 6.7 17.7 6 16 6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8.9,4.9l1.4,1.4C11.8,4.9,13.8,4,16,4s4.2,0.9,5.7,2.3l1.4-1.4C21.3,3.1,18.8,2,16,2S10.7,3.1,8.9,4.9z"
    }
  }]);

  const CenterCircle32 = createSVGComponent('CenterCircle32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"
    }
  }]);

  const CenterCircle24 = createSVGComponent('CenterCircle24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"
    }
  }]);

  const CenterCircle20 = createSVGComponent('CenterCircle20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"
    }
  }]);

  const CenterCircle16 = createSVGComponent('CenterCircle16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"
    }
  }]);

  const CenterSquare32 = createSVGComponent('CenterSquare32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 12L4 12 4 4 12 4 12 6 6 6 6 12zM28 12L26 12 26 6 20 6 20 4 28 4 28 12zM12 28L4 28 4 20 6 20 6 26 12 26 12 28zM28 28L20 28 20 26 26 26 26 20 28 20 28 28zM15 10H17V14H15zM10 15H14V17H10zM18 15H22V17H18zM15 18H17V22H15z"
    }
  }]);

  const CenterSquare24 = createSVGComponent('CenterSquare24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 12L4 12 4 4 12 4 12 6 6 6 6 12zM28 12L26 12 26 6 20 6 20 4 28 4 28 12zM12 28L4 28 4 20 6 20 6 26 12 26 12 28zM28 28L20 28 20 26 26 26 26 20 28 20 28 28zM15 10H17V14H15zM10 15H14V17H10zM18 15H22V17H18zM15 18H17V22H15z"
    }
  }]);

  const CenterSquare20 = createSVGComponent('CenterSquare20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 12L4 12 4 4 12 4 12 6 6 6 6 12zM28 12L26 12 26 6 20 6 20 4 28 4 28 12zM12 28L4 28 4 20 6 20 6 26 12 26 12 28zM28 28L20 28 20 26 26 26 26 20 28 20 28 28zM15 10H17V14H15zM10 15H14V17H10zM18 15H22V17H18zM15 18H17V22H15z"
    }
  }]);

  const CenterSquare16 = createSVGComponent('CenterSquare16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 12L4 12 4 4 12 4 12 6 6 6 6 12zM28 12L26 12 26 6 20 6 20 4 28 4 28 12zM12 28L4 28 4 20 6 20 6 26 12 26 12 28zM28 28L20 28 20 26 26 26 26 20 28 20 28 28zM15 10H17V14H15zM10 15H14V17H10zM18 15H22V17H18zM15 18H17V22H15z"
    }
  }]);

  const CenterToFit32 = createSVGComponent('CenterToFit32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 2L2 2 2 8 4 8 4 4 8 4 8 2zM24 2L30 2 30 8 28 8 28 4 24 4 24 2zM8 30L2 30 2 24 4 24 4 28 8 28 8 30zM24 30L30 30 30 24 28 24 28 28 24 28 24 30zM24 24H8a2.0023 2.0023 0 01-2-2V10A2.0023 2.0023 0 018 8H24a2.0023 2.0023 0 012 2V22A2.0023 2.0023 0 0124 24zM8 10V22H24V10z"
    }
  }]);

  const CenterToFit24 = createSVGComponent('CenterToFit24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 2L2 2 2 8 4 8 4 4 8 4 8 2zM24 2L30 2 30 8 28 8 28 4 24 4 24 2zM8 30L2 30 2 24 4 24 4 28 8 28 8 30zM24 30L30 30 30 24 28 24 28 28 24 28 24 30zM24 24H8a2.0023 2.0023 0 01-2-2V10A2.0023 2.0023 0 018 8H24a2.0023 2.0023 0 012 2V22A2.0023 2.0023 0 0124 24zM8 10V22H24V10z"
    }
  }]);

  const CenterToFit20 = createSVGComponent('CenterToFit20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 2L2 2 2 8 4 8 4 4 8 4 8 2zM24 2L30 2 30 8 28 8 28 4 24 4 24 2zM8 30L2 30 2 24 4 24 4 28 8 28 8 30zM24 30L30 30 30 24 28 24 28 28 24 28 24 30zM24 24H8a2.0023 2.0023 0 01-2-2V10A2.0023 2.0023 0 018 8H24a2.0023 2.0023 0 012 2V22A2.0023 2.0023 0 0124 24zM8 10V22H24V10z"
    }
  }]);

  const CenterToFit16 = createSVGComponent('CenterToFit16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 2L2 2 2 8 4 8 4 4 8 4 8 2zM24 2L30 2 30 8 28 8 28 4 24 4 24 2zM8 30L2 30 2 24 4 24 4 28 8 28 8 30zM24 30L30 30 30 24 28 24 28 28 24 28 24 30zM24 24H8a2.0023 2.0023 0 01-2-2V10A2.0023 2.0023 0 018 8H24a2.0023 2.0023 0 012 2V22A2.0023 2.0023 0 0124 24zM8 10V22H24V10z"
    }
  }]);

  const Certificate32 = createSVGComponent('Certificate32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 17L25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17zM6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"
    }
  }]);

  const Certificate24 = createSVGComponent('Certificate24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 17L25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17zM6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"
    }
  }]);

  const Certificate20 = createSVGComponent('Certificate20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 17L25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17zM6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"
    }
  }]);

  const Certificate16 = createSVGComponent('Certificate16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 17L25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17zM6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"
    }
  }]);

  const CertificateCheck32 = createSVGComponent('CertificateCheck32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 25.59L19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59z"
    }
  }]);

  const CertificateCheck24 = createSVGComponent('CertificateCheck24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 25.59L19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59z"
    }
  }]);

  const CertificateCheck20 = createSVGComponent('CertificateCheck20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 25.59L19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59z"
    }
  }]);

  const CertificateCheck16 = createSVGComponent('CertificateCheck16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 16H12V18H6zM6 12H16V14H6zM6 8H16V10H6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22 25.59L19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59z"
    }
  }]);

  const ChangeCatalog32 = createSVGComponent('ChangeCatalog32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24v2h2.4592A5.94 5.94 0 0122 28a6.0066 6.0066 0 01-6-6H14a7.9841 7.9841 0 0014 5.2651V30h2V24zM22 14a8.04 8.04 0 00-6 2.7349V14H14v6h6V18H17.5408A5.94 5.94 0 0122 16a6.0066 6.0066 0 016 6h2A8.0092 8.0092 0 0022 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"
    }
  }]);

  const ChangeCatalog24 = createSVGComponent('ChangeCatalog24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24v2h2.4592A5.94 5.94 0 0122 28a6.0066 6.0066 0 01-6-6H14a7.9841 7.9841 0 0014 5.2651V30h2V24zM22 14a8.04 8.04 0 00-6 2.7349V14H14v6h6V18H17.5408A5.94 5.94 0 0122 16a6.0066 6.0066 0 016 6h2A8.0092 8.0092 0 0022 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"
    }
  }]);

  const ChangeCatalog20 = createSVGComponent('ChangeCatalog20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24v2h2.4592A5.94 5.94 0 0122 28a6.0066 6.0066 0 01-6-6H14a7.9841 7.9841 0 0014 5.2651V30h2V24zM22 14a8.04 8.04 0 00-6 2.7349V14H14v6h6V18H17.5408A5.94 5.94 0 0122 16a6.0066 6.0066 0 016 6h2A8.0092 8.0092 0 0022 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"
    }
  }]);

  const ChangeCatalog16 = createSVGComponent('ChangeCatalog16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 24v2h2.4592A5.94 5.94 0 0122 28a6.0066 6.0066 0 01-6-6H14a7.9841 7.9841 0 0014 5.2651V30h2V24zM22 14a8.04 8.04 0 00-6 2.7349V14H14v6h6V18H17.5408A5.94 5.94 0 0122 16a6.0066 6.0066 0 016 6h2A8.0092 8.0092 0 0022 14z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"
    }
  }]);

  const CharacterDecimal32 = createSVGComponent('CharacterDecimal32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 15H23V17H21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 23H20a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0124 23zM20 11h0V21h4V11zM11 15H13V17H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 23H10a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0114 23zM10 11h0V21h4V11zM4 21H6V23H4z"
    }
  }]);

  const CharacterDecimal24 = createSVGComponent('CharacterDecimal24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 15H23V17H21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 23H20a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0124 23zM20 11h0V21h4V11zM11 15H13V17H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 23H10a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0114 23zM10 11h0V21h4V11zM4 21H6V23H4z"
    }
  }]);

  const CharacterDecimal20 = createSVGComponent('CharacterDecimal20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 15H23V17H21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 23H20a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0124 23zM20 11h0V21h4V11zM11 15H13V17H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 23H10a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0114 23zM10 11h0V21h4V11zM4 21H6V23H4z"
    }
  }]);

  const CharacterDecimal16 = createSVGComponent('CharacterDecimal16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M21 15H23V17H21z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M24 23H20a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0124 23zM20 11h0V21h4V11zM11 15H13V17H11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 23H10a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h4a2.0023 2.0023 0 012 2V21A2.0027 2.0027 0 0114 23zM10 11h0V21h4V11zM4 21H6V23H4z"
    }
  }]);

  const CharacterFraction32 = createSVGComponent('CharacterFraction32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,30H20V24a2.002,2.002,0,0,1,2-2h4V18H20V16h6a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H22v4h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.479 15.5H26.521V17.5H4.479z",
      "transform": "rotate(-45 15.5 16.5)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.5 15.5L4.5 14.5 7.5 14.5 7.5 3.5 4.5 3.5 4.5 2.5 8.5 2.5 8.5 14.5 11.5 14.5 11.5 15.5 4.5 15.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,3V15H8V3M9,2H4V4H7V14H4v2h8V14H9V2Z"
    }
  }]);

  const CharacterFraction24 = createSVGComponent('CharacterFraction24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,30H20V24a2.002,2.002,0,0,1,2-2h4V18H20V16h6a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H22v4h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.479 15.5H26.521V17.5H4.479z",
      "transform": "rotate(-45 15.5 16.5)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.5 15.5L4.5 14.5 7.5 14.5 7.5 3.5 4.5 3.5 4.5 2.5 8.5 2.5 8.5 14.5 11.5 14.5 11.5 15.5 4.5 15.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,3V15H8V3M9,2H4V4H7V14H4v2h8V14H9V2Z"
    }
  }]);

  const CharacterFraction20 = createSVGComponent('CharacterFraction20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,30H20V24a2.002,2.002,0,0,1,2-2h4V18H20V16h6a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H22v4h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.479 15.5H26.521V17.5H4.479z",
      "transform": "rotate(-45 15.5 16.5)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.5 15.5L4.5 14.5 7.5 14.5 7.5 3.5 4.5 3.5 4.5 2.5 8.5 2.5 8.5 14.5 11.5 14.5 11.5 15.5 4.5 15.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,3V15H8V3M9,2H4V4H7V14H4v2h8V14H9V2Z"
    }
  }]);

  const CharacterFraction16 = createSVGComponent('CharacterFraction16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,30H20V24a2.002,2.002,0,0,1,2-2h4V18H20V16h6a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H22v4h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.479 15.5H26.521V17.5H4.479z",
      "transform": "rotate(-45 15.5 16.5)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4.5 15.5L4.5 14.5 7.5 14.5 7.5 3.5 4.5 3.5 4.5 2.5 8.5 2.5 8.5 14.5 11.5 14.5 11.5 15.5 4.5 15.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8,3V15H8V3M9,2H4V4H7V14H4v2h8V14H9V2Z"
    }
  }]);

  const CharacterInteger32 = createSVGComponent('CharacterInteger32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 21H15V23H5zM15 13L11 13 11 9 9 9 9 13 5 13 5 15 9 15 9 19 11 19 11 15 15 15 15 13z"
    }
  }]);

  const CharacterInteger24 = createSVGComponent('CharacterInteger24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 21H15V23H5zM15 13L11 13 11 9 9 9 9 13 5 13 5 15 9 15 9 19 11 19 11 15 15 15 15 13z"
    }
  }]);

  const CharacterInteger20 = createSVGComponent('CharacterInteger20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 21H15V23H5zM15 13L11 13 11 9 9 9 9 13 5 13 5 15 9 15 9 19 11 19 11 15 15 15 15 13z"
    }
  }]);

  const CharacterInteger16 = createSVGComponent('CharacterInteger16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 21H15V23H5zM15 13L11 13 11 9 9 9 9 13 5 13 5 15 9 15 9 19 11 19 11 15 15 15 15 13z"
    }
  }]);

  const CharacterLowerCase32 = createSVGComponent('CharacterLowerCase32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 13H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V15A2.0023 2.0023 0 008 13zm0 8H4V19H8z"
    }
  }]);

  const CharacterLowerCase24 = createSVGComponent('CharacterLowerCase24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 13H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V15A2.0023 2.0023 0 008 13zm0 8H4V19H8z"
    }
  }]);

  const CharacterLowerCase20 = createSVGComponent('CharacterLowerCase20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 13H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V15A2.0023 2.0023 0 008 13zm0 8H4V19H8z"
    }
  }]);

  const CharacterLowerCase16 = createSVGComponent('CharacterLowerCase16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 13H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V15A2.0023 2.0023 0 008 13zm0 8H4V19H8z"
    }
  }]);

  const CharacterNegativeNumber32 = createSVGComponent('CharacterNegativeNumber32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 15H15V17H5z"
    }
  }]);

  const CharacterNegativeNumber24 = createSVGComponent('CharacterNegativeNumber24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 15H15V17H5z"
    }
  }]);

  const CharacterNegativeNumber20 = createSVGComponent('CharacterNegativeNumber20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 15H15V17H5z"
    }
  }]);

  const CharacterNegativeNumber16 = createSVGComponent('CharacterNegativeNumber16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M19.5 22.5L19.5 21.5 22.5 21.5 22.5 10.5 19.5 10.5 19.5 9.5 23.5 9.5 23.5 21.5 26.5 21.5 26.5 22.5 19.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M23 10V22h0V10m1-1H19v2h3V21H19v2h8V21H24V9zM5 15H15V17H5z"
    }
  }]);

  const CharacterSentenceCase32 = createSVGComponent('CharacterSentenceCase32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterSentenceCase24 = createSVGComponent('CharacterSentenceCase24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterSentenceCase20 = createSVGComponent('CharacterSentenceCase20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterSentenceCase16 = createSVGComponent('CharacterSentenceCase16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29 23H24a2.0027 2.0027 0 01-2-2V15a2.0023 2.0023 0 012-2h5v2H24v6h5zM18 13H14V9H12V23h6a2.0027 2.0027 0 002-2V15A2.0023 2.0023 0 0018 13zm-4 8V15h4v6zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterUpperCase32 = createSVGComponent('CharacterUpperCase32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 23H24a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h6v2H24V21h6zM20 12a3.0033 3.0033 0 00-3-3H12V23h5a3.0033 3.0033 0 003-3V18a2.977 2.977 0 00-.78-2A2.9768 2.9768 0 0020 14zm-6-1h3a1.0013 1.0013 0 011 1v2a1.0013 1.0013 0 01-1 1H14zm4 9a1.0009 1.0009 0 01-1 1H14V17h3a1.0009 1.0009 0 011 1zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterUpperCase24 = createSVGComponent('CharacterUpperCase24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 23H24a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h6v2H24V21h6zM20 12a3.0033 3.0033 0 00-3-3H12V23h5a3.0033 3.0033 0 003-3V18a2.977 2.977 0 00-.78-2A2.9768 2.9768 0 0020 14zm-6-1h3a1.0013 1.0013 0 011 1v2a1.0013 1.0013 0 01-1 1H14zm4 9a1.0009 1.0009 0 01-1 1H14V17h3a1.0009 1.0009 0 011 1zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterUpperCase20 = createSVGComponent('CharacterUpperCase20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 23H24a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h6v2H24V21h6zM20 12a3.0033 3.0033 0 00-3-3H12V23h5a3.0033 3.0033 0 003-3V18a2.977 2.977 0 00-.78-2A2.9768 2.9768 0 0020 14zm-6-1h3a1.0013 1.0013 0 011 1v2a1.0013 1.0013 0 01-1 1H14zm4 9a1.0009 1.0009 0 01-1 1H14V17h3a1.0009 1.0009 0 011 1zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterUpperCase16 = createSVGComponent('CharacterUpperCase16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 23H24a2.0023 2.0023 0 01-2-2V11a2.002 2.002 0 012-2h6v2H24V21h6zM20 12a3.0033 3.0033 0 00-3-3H12V23h5a3.0033 3.0033 0 003-3V18a2.977 2.977 0 00-.78-2A2.9768 2.9768 0 0020 14zm-6-1h3a1.0013 1.0013 0 011 1v2a1.0013 1.0013 0 01-1 1H14zm4 9a1.0009 1.0009 0 01-1 1H14V17h3a1.0009 1.0009 0 011 1zM8 9H4a2.002 2.002 0 00-2 2V23H4V18H8v5h2V11A2.002 2.002 0 008 9zM4 16V11H8v5z"
    }
  }]);

  const CharacterWholeNumber32 = createSVGComponent('CharacterWholeNumber32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H22v2h6v4H24v2h4v4H22v2h6a2.0027 2.0027 0 002-2V11A2.0023 2.0023 0 0028 9zM20 23H12V17a2.002 2.002 0 012-2h4V11H12V9h6a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14v4h6zM2.5 22.5L2.5 21.5 5.5 21.5 5.5 10.5 2.5 10.5 2.5 9.5 6.5 9.5 6.5 21.5 9.5 21.5 9.5 22.5 2.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,10V22H6V10M7,9H2v2H5V21H2v2h8V21H7V9Z"
    }
  }]);

  const CharacterWholeNumber24 = createSVGComponent('CharacterWholeNumber24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H22v2h6v4H24v2h4v4H22v2h6a2.0027 2.0027 0 002-2V11A2.0023 2.0023 0 0028 9zM20 23H12V17a2.002 2.002 0 012-2h4V11H12V9h6a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14v4h6zM2.5 22.5L2.5 21.5 5.5 21.5 5.5 10.5 2.5 10.5 2.5 9.5 6.5 9.5 6.5 21.5 9.5 21.5 9.5 22.5 2.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,10V22H6V10M7,9H2v2H5V21H2v2h8V21H7V9Z"
    }
  }]);

  const CharacterWholeNumber20 = createSVGComponent('CharacterWholeNumber20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H22v2h6v4H24v2h4v4H22v2h6a2.0027 2.0027 0 002-2V11A2.0023 2.0023 0 0028 9zM20 23H12V17a2.002 2.002 0 012-2h4V11H12V9h6a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14v4h6zM2.5 22.5L2.5 21.5 5.5 21.5 5.5 10.5 2.5 10.5 2.5 9.5 6.5 9.5 6.5 21.5 9.5 21.5 9.5 22.5 2.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,10V22H6V10M7,9H2v2H5V21H2v2h8V21H7V9Z"
    }
  }]);

  const CharacterWholeNumber16 = createSVGComponent('CharacterWholeNumber16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 9H22v2h6v4H24v2h4v4H22v2h6a2.0027 2.0027 0 002-2V11A2.0023 2.0023 0 0028 9zM20 23H12V17a2.002 2.002 0 012-2h4V11H12V9h6a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14v4h6zM2.5 22.5L2.5 21.5 5.5 21.5 5.5 10.5 2.5 10.5 2.5 9.5 6.5 9.5 6.5 21.5 9.5 21.5 9.5 22.5 2.5 22.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,10V22H6V10M7,9H2v2H5V21H2v2h8V21H7V9Z"
    }
  }]);

  const CharacterPatterns32 = createSVGComponent('CharacterPatterns32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 26V17.8281l-3.5859 3.586L1 20l6-6 6 6-1.4141 1.4141L8 17.8281V26H18v2H8A2.0024 2.0024 0 016 26zM30 22L30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22zM26 6v8.1719l3.5859-3.586L31 12l-6 6-6-6 1.4141-1.4141L24 14.1719V6H14V4H24A2.0024 2.0024 0 0126 6zM8 2H3V4H8V6H4A2 2 0 002 8v2a2 2 0 002 2h6V4A2.0023 2.0023 0 008 2zm0 8H4V8H8z"
    }
  }]);

  const CharacterPatterns24 = createSVGComponent('CharacterPatterns24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 26V17.8281l-3.5859 3.586L1 20l6-6 6 6-1.4141 1.4141L8 17.8281V26H18v2H8A2.0024 2.0024 0 016 26zM30 22L30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22zM26 6v8.1719l3.5859-3.586L31 12l-6 6-6-6 1.4141-1.4141L24 14.1719V6H14V4H24A2.0024 2.0024 0 0126 6zM8 2H3V4H8V6H4A2 2 0 002 8v2a2 2 0 002 2h6V4A2.0023 2.0023 0 008 2zm0 8H4V8H8z"
    }
  }]);

  const CharacterPatterns20 = createSVGComponent('CharacterPatterns20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 26V17.8281l-3.5859 3.586L1 20l6-6 6 6-1.4141 1.4141L8 17.8281V26H18v2H8A2.0024 2.0024 0 016 26zM30 22L30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22zM26 6v8.1719l3.5859-3.586L31 12l-6 6-6-6 1.4141-1.4141L24 14.1719V6H14V4H24A2.0024 2.0024 0 0126 6zM8 2H3V4H8V6H4A2 2 0 002 8v2a2 2 0 002 2h6V4A2.0023 2.0023 0 008 2zm0 8H4V8H8z"
    }
  }]);

  const CharacterPatterns16 = createSVGComponent('CharacterPatterns16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 26V17.8281l-3.5859 3.586L1 20l6-6 6 6-1.4141 1.4141L8 17.8281V26H18v2H8A2.0024 2.0024 0 016 26zM30 22L30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22zM26 6v8.1719l3.5859-3.586L31 12l-6 6-6-6 1.4141-1.4141L24 14.1719V6H14V4H24A2.0024 2.0024 0 0126 6zM8 2H3V4H8V6H4A2 2 0 002 8v2a2 2 0 002 2h6V4A2.0023 2.0023 0 008 2zm0 8H4V8H8z"
    }
  }]);

  const ChargingStation32 = createSVGComponent('ChargingStation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"
    }
  }]);

  const ChargingStation24 = createSVGComponent('ChargingStation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"
    }
  }]);

  const ChargingStation20 = createSVGComponent('ChargingStation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"
    }
  }]);

  const ChargingStation16 = createSVGComponent('ChargingStation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"
    }
  }]);

  const ChargingStationFilled32 = createSVGComponent('ChargingStationFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z",
      "data-icon-path": "inner-path"
    }
  }]);

  const ChargingStationFilled24 = createSVGComponent('ChargingStationFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z",
      "data-icon-path": "inner-path"
    }
  }]);

  const ChargingStationFilled20 = createSVGComponent('ChargingStationFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z",
      "data-icon-path": "inner-path"
    }
  }]);

  const ChargingStationFilled16 = createSVGComponent('ChargingStationFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M11.857 21.514L10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514z",
      "data-icon-path": "inner-path"
    }
  }]);

  const Chart_3D32 = createSVGComponent('Chart_3D32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,23v3.5859l-5-5V15a1,1,0,0,0-.5527-.8945L17,11.3818V5.8281l2.5859,2.586L21,7,16,2,11,7l1.4141,1.4141L15,5.8281v5.5537L9.5527,14.1055A1,1,0,0,0,9,15v6.5859l-5,5V23H2v7H9V28H5.4141l4.7832-4.7832,5.3554,2.6777a1.001,1.001,0,0,0,.8946,0l5.3554-2.6777L26.5859,28H23v2h7V23Zm-13,.3818-4-2V16.6182l4,2Zm1-6.5L12.2363,15,16,13.1182,19.7637,15Zm5,4.5-4,2V18.6182l4-2Z"
    }
  }]);

  const Chart_3D24 = createSVGComponent('Chart_3D24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,23v3.5859l-5-5V15a1,1,0,0,0-.5527-.8945L17,11.3818V5.8281l2.5859,2.586L21,7,16,2,11,7l1.4141,1.4141L15,5.8281v5.5537L9.5527,14.1055A1,1,0,0,0,9,15v6.5859l-5,5V23H2v7H9V28H5.4141l4.7832-4.7832,5.3554,2.6777a1.001,1.001,0,0,0,.8946,0l5.3554-2.6777L26.5859,28H23v2h7V23Zm-13,.3818-4-2V16.6182l4,2Zm1-6.5L12.2363,15,16,13.1182,19.7637,15Zm5,4.5-4,2V18.6182l4-2Z"
    }
  }]);

  const Chart_3D20 = createSVGComponent('Chart_3D20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,23v3.5859l-5-5V15a1,1,0,0,0-.5527-.8945L17,11.3818V5.8281l2.5859,2.586L21,7,16,2,11,7l1.4141,1.4141L15,5.8281v5.5537L9.5527,14.1055A1,1,0,0,0,9,15v6.5859l-5,5V23H2v7H9V28H5.4141l4.7832-4.7832,5.3554,2.6777a1.001,1.001,0,0,0,.8946,0l5.3554-2.6777L26.5859,28H23v2h7V23Zm-13,.3818-4-2V16.6182l4,2Zm1-6.5L12.2363,15,16,13.1182,19.7637,15Zm5,4.5-4,2V18.6182l4-2Z"
    }
  }]);

  const Chart_3D16 = createSVGComponent('Chart_3D16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,23v3.5859l-5-5V15a1,1,0,0,0-.5527-.8945L17,11.3818V5.8281l2.5859,2.586L21,7,16,2,11,7l1.4141,1.4141L15,5.8281v5.5537L9.5527,14.1055A1,1,0,0,0,9,15v6.5859l-5,5V23H2v7H9V28H5.4141l4.7832-4.7832,5.3554,2.6777a1.001,1.001,0,0,0,.8946,0l5.3554-2.6777L26.5859,28H23v2h7V23Zm-13,.3818-4-2V16.6182l4,2Zm1-6.5L12.2363,15,16,13.1182,19.7637,15Zm5,4.5-4,2V18.6182l4-2Z"
    }
  }]);

  const ChartArea32 = createSVGComponent('ChartArea32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.4761,8.0151,13.4473,4.2109a2.0076,2.0076,0,0,0-2.1158.2051L4,10.001V2H2V28a2,2,0,0,0,2,2H30V5.7354ZM28,20.209l-7.62,1.8022-7.0288-2.8838a1.99,1.99,0,0,0-2.022.37L4,25.8359v-4.455l8.375-9.4,7.0186,5.62a2.0155,2.0155,0,0,0,2.0459.2119L28,14.6025ZM12.5239,5.9849l7.03,3.8042a2.012,2.012,0,0,0,1.3408.16L28,8.2646v4.1138L20.6187,16.02,13.6,10.4a1.99,1.99,0,0,0-2.6885.2642L4,18.3838v-5.87ZM4.5513,28,12.62,20.9888l7.0288,2.8838a1.9977,1.9977,0,0,0,1.147.0771L28,22.2612V28Z"
    }
  }]);

  const ChartArea24 = createSVGComponent('ChartArea24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.4761,8.0151,13.4473,4.2109a2.0076,2.0076,0,0,0-2.1158.2051L4,10.001V2H2V28a2,2,0,0,0,2,2H30V5.7354ZM28,20.209l-7.62,1.8022-7.0288-2.8838a1.99,1.99,0,0,0-2.022.37L4,25.8359v-4.455l8.375-9.4,7.0186,5.62a2.0155,2.0155,0,0,0,2.0459.2119L28,14.6025ZM12.5239,5.9849l7.03,3.8042a2.012,2.012,0,0,0,1.3408.16L28,8.2646v4.1138L20.6187,16.02,13.6,10.4a1.99,1.99,0,0,0-2.6885.2642L4,18.3838v-5.87ZM4.5513,28,12.62,20.9888l7.0288,2.8838a1.9977,1.9977,0,0,0,1.147.0771L28,22.2612V28Z"
    }
  }]);

  const ChartArea20 = createSVGComponent('ChartArea20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.4761,8.0151,13.4473,4.2109a2.0076,2.0076,0,0,0-2.1158.2051L4,10.001V2H2V28a2,2,0,0,0,2,2H30V5.7354ZM28,20.209l-7.62,1.8022-7.0288-2.8838a1.99,1.99,0,0,0-2.022.37L4,25.8359v-4.455l8.375-9.4,7.0186,5.62a2.0155,2.0155,0,0,0,2.0459.2119L28,14.6025ZM12.5239,5.9849l7.03,3.8042a2.012,2.012,0,0,0,1.3408.16L28,8.2646v4.1138L20.6187,16.02,13.6,10.4a1.99,1.99,0,0,0-2.6885.2642L4,18.3838v-5.87ZM4.5513,28,12.62,20.9888l7.0288,2.8838a1.9977,1.9977,0,0,0,1.147.0771L28,22.2612V28Z"
    }
  }]);

  const ChartArea16 = createSVGComponent('ChartArea16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.4761,8.0151,13.4473,4.2109a2.0076,2.0076,0,0,0-2.1158.2051L4,10.001V2H2V28a2,2,0,0,0,2,2H30V5.7354ZM28,20.209l-7.62,1.8022-7.0288-2.8838a1.99,1.99,0,0,0-2.022.37L4,25.8359v-4.455l8.375-9.4,7.0186,5.62a2.0155,2.0155,0,0,0,2.0459.2119L28,14.6025ZM12.5239,5.9849l7.03,3.8042a2.012,2.012,0,0,0,1.3408.16L28,8.2646v4.1138L20.6187,16.02,13.6,10.4a1.99,1.99,0,0,0-2.6885.2642L4,18.3838v-5.87ZM4.5513,28,12.62,20.9888l7.0288,2.8838a1.9977,1.9977,0,0,0,1.147.0771L28,22.2612V28Z"
    }
  }]);

  const ChartAreaSmooth32 = createSVGComponent('ChartAreaSmooth32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6.6143l-1.3152.4365A20.9218,20.9218,0,0,1,23,8c-1.7344,0-3.3225-.9072-5.0039-1.8682C16.1621,5.084,14.2656,4,12,4,9.123,4,5.9146,6.2061,4,7.772V2H2V28a2.0025,2.0025,0,0,0,2,2H30ZM4,20.2944C5.874,17.3765,9.56,13,12,13c1.6379,0,2.96,1.1016,4.36,2.2686C17.8965,16.5488,19.6379,18,22,18a9.4686,9.4686,0,0,0,6-2.5288v4.9556A13.0026,13.0026,0,0,1,22,22a13.8619,13.8619,0,0,1-4.6838-.9487A15.682,15.682,0,0,0,12,20c-2.927,0-6.0676,2.959-8,5.1577ZM12,6c1.7344,0,3.3225.9072,5.0039,1.8682C18.8379,8.916,20.7344,10,23,10a21.432,21.432,0,0,0,5-.6782v3.3213C27.3167,13.4463,24.9155,16,22,16c-1.6379,0-2.96-1.1016-4.36-2.2686C16.1035,12.4512,14.3621,11,12,11c-2.9358,0-6.0632,3.3394-8,5.8447V10.4238C5.5461,8.9658,9.2588,6,12,6ZM4.249,28C5.8623,25.9087,9.41,22,12,22a13.8619,13.8619,0,0,1,4.6838.9487A15.682,15.682,0,0,0,22,24a14.7362,14.7362,0,0,0,6-1.34V28Z"
    }
  }]);

  const ChartAreaSmooth24 = createSVGComponent('ChartAreaSmooth24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6.6143l-1.3152.4365A20.9218,20.9218,0,0,1,23,8c-1.7344,0-3.3225-.9072-5.0039-1.8682C16.1621,5.084,14.2656,4,12,4,9.123,4,5.9146,6.2061,4,7.772V2H2V28a2.0025,2.0025,0,0,0,2,2H30ZM4,20.2944C5.874,17.3765,9.56,13,12,13c1.6379,0,2.96,1.1016,4.36,2.2686C17.8965,16.5488,19.6379,18,22,18a9.4686,9.4686,0,0,0,6-2.5288v4.9556A13.0026,13.0026,0,0,1,22,22a13.8619,13.8619,0,0,1-4.6838-.9487A15.682,15.682,0,0,0,12,20c-2.927,0-6.0676,2.959-8,5.1577ZM12,6c1.7344,0,3.3225.9072,5.0039,1.8682C18.8379,8.916,20.7344,10,23,10a21.432,21.432,0,0,0,5-.6782v3.3213C27.3167,13.4463,24.9155,16,22,16c-1.6379,0-2.96-1.1016-4.36-2.2686C16.1035,12.4512,14.3621,11,12,11c-2.9358,0-6.0632,3.3394-8,5.8447V10.4238C5.5461,8.9658,9.2588,6,12,6ZM4.249,28C5.8623,25.9087,9.41,22,12,22a13.8619,13.8619,0,0,1,4.6838.9487A15.682,15.682,0,0,0,22,24a14.7362,14.7362,0,0,0,6-1.34V28Z"
    }
  }]);

  const ChartAreaSmooth20 = createSVGComponent('ChartAreaSmooth20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6.6143l-1.3152.4365A20.9218,20.9218,0,0,1,23,8c-1.7344,0-3.3225-.9072-5.0039-1.8682C16.1621,5.084,14.2656,4,12,4,9.123,4,5.9146,6.2061,4,7.772V2H2V28a2.0025,2.0025,0,0,0,2,2H30ZM4,20.2944C5.874,17.3765,9.56,13,12,13c1.6379,0,2.96,1.1016,4.36,2.2686C17.8965,16.5488,19.6379,18,22,18a9.4686,9.4686,0,0,0,6-2.5288v4.9556A13.0026,13.0026,0,0,1,22,22a13.8619,13.8619,0,0,1-4.6838-.9487A15.682,15.682,0,0,0,12,20c-2.927,0-6.0676,2.959-8,5.1577ZM12,6c1.7344,0,3.3225.9072,5.0039,1.8682C18.8379,8.916,20.7344,10,23,10a21.432,21.432,0,0,0,5-.6782v3.3213C27.3167,13.4463,24.9155,16,22,16c-1.6379,0-2.96-1.1016-4.36-2.2686C16.1035,12.4512,14.3621,11,12,11c-2.9358,0-6.0632,3.3394-8,5.8447V10.4238C5.5461,8.9658,9.2588,6,12,6ZM4.249,28C5.8623,25.9087,9.41,22,12,22a13.8619,13.8619,0,0,1,4.6838.9487A15.682,15.682,0,0,0,22,24a14.7362,14.7362,0,0,0,6-1.34V28Z"
    }
  }]);

  const ChartAreaSmooth16 = createSVGComponent('ChartAreaSmooth16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,6.6143l-1.3152.4365A20.9218,20.9218,0,0,1,23,8c-1.7344,0-3.3225-.9072-5.0039-1.8682C16.1621,5.084,14.2656,4,12,4,9.123,4,5.9146,6.2061,4,7.772V2H2V28a2.0025,2.0025,0,0,0,2,2H30ZM4,20.2944C5.874,17.3765,9.56,13,12,13c1.6379,0,2.96,1.1016,4.36,2.2686C17.8965,16.5488,19.6379,18,22,18a9.4686,9.4686,0,0,0,6-2.5288v4.9556A13.0026,13.0026,0,0,1,22,22a13.8619,13.8619,0,0,1-4.6838-.9487A15.682,15.682,0,0,0,12,20c-2.927,0-6.0676,2.959-8,5.1577ZM12,6c1.7344,0,3.3225.9072,5.0039,1.8682C18.8379,8.916,20.7344,10,23,10a21.432,21.432,0,0,0,5-.6782v3.3213C27.3167,13.4463,24.9155,16,22,16c-1.6379,0-2.96-1.1016-4.36-2.2686C16.1035,12.4512,14.3621,11,12,11c-2.9358,0-6.0632,3.3394-8,5.8447V10.4238C5.5461,8.9658,9.2588,6,12,6ZM4.249,28C5.8623,25.9087,9.41,22,12,22a13.8619,13.8619,0,0,1,4.6838.9487A15.682,15.682,0,0,0,22,24a14.7362,14.7362,0,0,0,6-1.34V28Z"
    }
  }]);

  const ChartAreaStepper32 = createSVGComponent('ChartAreaStepper32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,10V6H10v6H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V10ZM12,14V8h8v4h8V22H22V16H12v6H4V14ZM4,28V24H14V18h6v6h8v4Z"
    }
  }]);

  const ChartAreaStepper24 = createSVGComponent('ChartAreaStepper24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,10V6H10v6H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V10ZM12,14V8h8v4h8V22H22V16H12v6H4V14ZM4,28V24H14V18h6v6h8v4Z"
    }
  }]);

  const ChartAreaStepper20 = createSVGComponent('ChartAreaStepper20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,10V6H10v6H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V10ZM12,14V8h8v4h8V22H22V16H12v6H4V14ZM4,28V24H14V18h6v6h8v4Z"
    }
  }]);

  const ChartAreaStepper16 = createSVGComponent('ChartAreaStepper16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,10V6H10v6H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V10ZM12,14V8h8v4h8V22H22V16H12v6H4V14ZM4,28V24H14V18h6v6h8v4Z"
    }
  }]);

  const ChartAverage32 = createSVGComponent('ChartAverage32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,24c-3.5991,0-5.0293-4.1758-6.4126-8.2139C15.2764,11.9583,13.92,8,11,8a3.44,3.44,0,0,0-3.0532,2.3215L6.0513,9.6838C6.1016,9.5334,7.3218,6,11,6c4.3491,0,6.0122,4.8547,7.48,9.1379C19.6885,18.6667,20.83,22,23,22a3.44,3.44,0,0,0,3.0532-2.3215l1.8955.6377C27.8984,20.4666,26.6782,24,23,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V17H6V15H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 15H10V17H8zM12 15H14V17H12zM20 15H22V17H20zM24 15H26V17H24zM28 15H30V17H28z"
    }
  }]);

  const ChartAverage24 = createSVGComponent('ChartAverage24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,24c-3.5991,0-5.0293-4.1758-6.4126-8.2139C15.2764,11.9583,13.92,8,11,8a3.44,3.44,0,0,0-3.0532,2.3215L6.0513,9.6838C6.1016,9.5334,7.3218,6,11,6c4.3491,0,6.0122,4.8547,7.48,9.1379C19.6885,18.6667,20.83,22,23,22a3.44,3.44,0,0,0,3.0532-2.3215l1.8955.6377C27.8984,20.4666,26.6782,24,23,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V17H6V15H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 15H10V17H8zM12 15H14V17H12zM20 15H22V17H20zM24 15H26V17H24zM28 15H30V17H28z"
    }
  }]);

  const ChartAverage20 = createSVGComponent('ChartAverage20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,24c-3.5991,0-5.0293-4.1758-6.4126-8.2139C15.2764,11.9583,13.92,8,11,8a3.44,3.44,0,0,0-3.0532,2.3215L6.0513,9.6838C6.1016,9.5334,7.3218,6,11,6c4.3491,0,6.0122,4.8547,7.48,9.1379C19.6885,18.6667,20.83,22,23,22a3.44,3.44,0,0,0,3.0532-2.3215l1.8955.6377C27.8984,20.4666,26.6782,24,23,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V17H6V15H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 15H10V17H8zM12 15H14V17H12zM20 15H22V17H20zM24 15H26V17H24zM28 15H30V17H28z"
    }
  }]);

  const ChartAverage16 = createSVGComponent('ChartAverage16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23,24c-3.5991,0-5.0293-4.1758-6.4126-8.2139C15.2764,11.9583,13.92,8,11,8a3.44,3.44,0,0,0-3.0532,2.3215L6.0513,9.6838C6.1016,9.5334,7.3218,6,11,6c4.3491,0,6.0122,4.8547,7.48,9.1379C19.6885,18.6667,20.83,22,23,22a3.44,3.44,0,0,0,3.0532-2.3215l1.8955.6377C27.8984,20.4666,26.6782,24,23,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V17H6V15H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 15H10V17H8zM12 15H14V17H12zM20 15H22V17H20zM24 15H26V17H24zM28 15H30V17H28z"
    }
  }]);

  const ChartBar32 = createSVGComponent('ChartBar32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBar24 = createSVGComponent('ChartBar24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBar20 = createSVGComponent('ChartBar20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBar16 = createSVGComponent('ChartBar16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBarFloating32 = createSVGComponent('ChartBarFloating32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 24H14V16H28zM16 22H26V18H16zM26 12H8V4H26zM10 10H24V6H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartBarFloating24 = createSVGComponent('ChartBarFloating24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 24H14V16H28zM16 22H26V18H16zM26 12H8V4H26zM10 10H24V6H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartBarFloating20 = createSVGComponent('ChartBarFloating20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 24H14V16H28zM16 22H26V18H16zM26 12H8V4H26zM10 10H24V6H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartBarFloating16 = createSVGComponent('ChartBarFloating16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 24H14V16H28zM16 22H26V18H16zM26 12H8V4H26zM10 10H24V6H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartBarOverlay32 = createSVGComponent('ChartBarOverlay32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H26V16H4V14H18V4H4V2H2V28a2,2,0,0,0,2,2H30V28ZM24,18v6H4V22H20V20H4V18ZM16,6v6H4V10h8V8H4V6Z"
    }
  }]);

  const ChartBarOverlay24 = createSVGComponent('ChartBarOverlay24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H26V16H4V14H18V4H4V2H2V28a2,2,0,0,0,2,2H30V28ZM24,18v6H4V22H20V20H4V18ZM16,6v6H4V10h8V8H4V6Z"
    }
  }]);

  const ChartBarOverlay20 = createSVGComponent('ChartBarOverlay20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H26V16H4V14H18V4H4V2H2V28a2,2,0,0,0,2,2H30V28ZM24,18v6H4V22H20V20H4V18ZM16,6v6H4V10h8V8H4V6Z"
    }
  }]);

  const ChartBarOverlay16 = createSVGComponent('ChartBarOverlay16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H26V16H4V14H18V4H4V2H2V28a2,2,0,0,0,2,2H30V28ZM24,18v6H4V22H20V20H4V18ZM16,6v6H4V10h8V8H4V6Z"
    }
  }]);

  const ChartBarStacked32 = createSVGComponent('ChartBarStacked32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V25H26V17H4V13H18V5H4V2H2V28a2,2,0,0,0,2,2H30V28Zm20-5H14V19H24ZM16,11H10V7h6Z"
    }
  }]);

  const ChartBarStacked24 = createSVGComponent('ChartBarStacked24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V25H26V17H4V13H18V5H4V2H2V28a2,2,0,0,0,2,2H30V28Zm20-5H14V19H24ZM16,11H10V7h6Z"
    }
  }]);

  const ChartBarStacked20 = createSVGComponent('ChartBarStacked20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V25H26V17H4V13H18V5H4V2H2V28a2,2,0,0,0,2,2H30V28Zm20-5H14V19H24ZM16,11H10V7h6Z"
    }
  }]);

  const ChartBarStacked16 = createSVGComponent('ChartBarStacked16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V25H26V17H4V13H18V5H4V2H2V28a2,2,0,0,0,2,2H30V28Zm20-5H14V19H24ZM16,11H10V7h6Z"
    }
  }]);

  const ChartBarTarget32 = createSVGComponent('ChartBarTarget32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 17H30V25H28zM20 5H22V13H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBarTarget24 = createSVGComponent('ChartBarTarget24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 17H30V25H28zM20 5H22V13H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBarTarget20 = createSVGComponent('ChartBarTarget20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 17H30V25H28zM20 5H22V13H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBarTarget16 = createSVGComponent('ChartBarTarget16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 17H30V25H28zM20 5H22V13H20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,2H2V28a2,2,0,0,0,2,2H30V28H4V25H26V17H4V13H18V5H4ZM24,19v4H4V19ZM16,7v4H4V7Z"
    }
  }]);

  const ChartBubble32 = createSVGComponent('ChartBubble32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16a2 2 0 11-2 2 2 2 0 012-2m0-2a4 4 0 104 4 4 4 0 00-4-4zM21 6a4 4 0 11-4 4 4 4 0 014-4m0-2a6 6 0 106 6 6 6 0 00-6-6zM24.5 21A1.5 1.5 0 1123 22.5 1.5 1.5 0 0124.5 21m0-2A3.5 3.5 0 1028 22.5 3.5 3.5 0 0024.5 19z"
    }
  }]);

  const ChartBubble24 = createSVGComponent('ChartBubble24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16a2 2 0 11-2 2 2 2 0 012-2m0-2a4 4 0 104 4 4 4 0 00-4-4zM21 6a4 4 0 11-4 4 4 4 0 014-4m0-2a6 6 0 106 6 6 6 0 00-6-6zM24.5 21A1.5 1.5 0 1123 22.5 1.5 1.5 0 0124.5 21m0-2A3.5 3.5 0 1028 22.5 3.5 3.5 0 0024.5 19z"
    }
  }]);

  const ChartBubble20 = createSVGComponent('ChartBubble20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16a2 2 0 11-2 2 2 2 0 012-2m0-2a4 4 0 104 4 4 4 0 00-4-4zM21 6a4 4 0 11-4 4 4 4 0 014-4m0-2a6 6 0 106 6 6 6 0 00-6-6zM24.5 21A1.5 1.5 0 1123 22.5 1.5 1.5 0 0124.5 21m0-2A3.5 3.5 0 1028 22.5 3.5 3.5 0 0024.5 19z"
    }
  }]);

  const ChartBubble16 = createSVGComponent('ChartBubble16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16a2 2 0 11-2 2 2 2 0 012-2m0-2a4 4 0 104 4 4 4 0 00-4-4zM21 6a4 4 0 11-4 4 4 4 0 014-4m0-2a6 6 0 106 6 6 6 0 00-6-6zM24.5 21A1.5 1.5 0 1123 22.5 1.5 1.5 0 0124.5 21m0-2A3.5 3.5 0 1028 22.5 3.5 3.5 0 0024.5 19z"
    }
  }]);

  const ChartBubblePacked32 = createSVGComponent('ChartBubblePacked32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5322,17.1724A8.99,8.99,0,1,0,13.6074,5.88,5.9969,5.9969,0,1,0,5.051,13.2217a6.9967,6.9967,0,1,0,7.9942,11.4844A5.9981,5.9981,0,0,0,25,24c0-.1216-.011-.24-.0181-.3594a3.4873,3.4873,0,1,0,2.55-6.4682ZM21,4a7,7,0,1,1-7,7A7.0078,7.0078,0,0,1,21,4ZM8,4A4,4,0,1,1,4,8,4.0045,4.0045,0,0,1,8,4ZM19,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,28Z"
    }
  }]);

  const ChartBubblePacked24 = createSVGComponent('ChartBubblePacked24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5322,17.1724A8.99,8.99,0,1,0,13.6074,5.88,5.9969,5.9969,0,1,0,5.051,13.2217a6.9967,6.9967,0,1,0,7.9942,11.4844A5.9981,5.9981,0,0,0,25,24c0-.1216-.011-.24-.0181-.3594a3.4873,3.4873,0,1,0,2.55-6.4682ZM21,4a7,7,0,1,1-7,7A7.0078,7.0078,0,0,1,21,4ZM8,4A4,4,0,1,1,4,8,4.0045,4.0045,0,0,1,8,4ZM19,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,28Z"
    }
  }]);

  const ChartBubblePacked20 = createSVGComponent('ChartBubblePacked20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5322,17.1724A8.99,8.99,0,1,0,13.6074,5.88,5.9969,5.9969,0,1,0,5.051,13.2217a6.9967,6.9967,0,1,0,7.9942,11.4844A5.9981,5.9981,0,0,0,25,24c0-.1216-.011-.24-.0181-.3594a3.4873,3.4873,0,1,0,2.55-6.4682ZM21,4a7,7,0,1,1-7,7A7.0078,7.0078,0,0,1,21,4ZM8,4A4,4,0,1,1,4,8,4.0045,4.0045,0,0,1,8,4ZM19,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,28Z"
    }
  }]);

  const ChartBubblePacked16 = createSVGComponent('ChartBubblePacked16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.5322,17.1724A8.99,8.99,0,1,0,13.6074,5.88,5.9969,5.9969,0,1,0,5.051,13.2217a6.9967,6.9967,0,1,0,7.9942,11.4844A5.9981,5.9981,0,0,0,25,24c0-.1216-.011-.24-.0181-.3594a3.4873,3.4873,0,1,0,2.55-6.4682ZM21,4a7,7,0,1,1-7,7A7.0078,7.0078,0,0,1,21,4ZM8,4A4,4,0,1,1,4,8,4.0045,4.0045,0,0,1,8,4ZM19,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,28Z"
    }
  }]);

  const ChartBullet32 = createSVGComponent('ChartBullet32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 22H16V21H14v1H2v6H14v1h2V28H30zM4 26V24H14v2zm24 0H16V24H28zM30 13H24V12H22v1H2v6H22v1h2V19h6zM4 17V15H22v2zm24 0H24V15h4zM30 4H10V3H8V4H2v6H8v1h2V10H30zM4 8V6H8V8zM28 8H10V6H28z"
    }
  }]);

  const ChartBullet24 = createSVGComponent('ChartBullet24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 22H16V21H14v1H2v6H14v1h2V28H30zM4 26V24H14v2zm24 0H16V24H28zM30 13H24V12H22v1H2v6H22v1h2V19h6zM4 17V15H22v2zm24 0H24V15h4zM30 4H10V3H8V4H2v6H8v1h2V10H30zM4 8V6H8V8zM28 8H10V6H28z"
    }
  }]);

  const ChartBullet20 = createSVGComponent('ChartBullet20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 22H16V21H14v1H2v6H14v1h2V28H30zM4 26V24H14v2zm24 0H16V24H28zM30 13H24V12H22v1H2v6H22v1h2V19h6zM4 17V15H22v2zm24 0H24V15h4zM30 4H10V3H8V4H2v6H8v1h2V10H30zM4 8V6H8V8zM28 8H10V6H28z"
    }
  }]);

  const ChartBullet16 = createSVGComponent('ChartBullet16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30 22H16V21H14v1H2v6H14v1h2V28H30zM4 26V24H14v2zm24 0H16V24H28zM30 13H24V12H22v1H2v6H22v1h2V19h6zM4 17V15H22v2zm24 0H24V15h4zM30 4H10V3H8V4H2v6H8v1h2V10H30zM4 8V6H8V8zM28 8H10V6H28z"
    }
  }]);

  const ChartCandlestick32 = createSVGComponent('ChartCandlestick32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10H24V6H22v4H20V22h2v4h2V22h2zM24 20H22V12h2zM14 8H12V4H10V8H8V18h2v4h2V18h2zm-2 8H10V10h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartCandlestick24 = createSVGComponent('ChartCandlestick24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10H24V6H22v4H20V22h2v4h2V22h2zM24 20H22V12h2zM14 8H12V4H10V8H8V18h2v4h2V18h2zm-2 8H10V10h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartCandlestick20 = createSVGComponent('ChartCandlestick20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10H24V6H22v4H20V22h2v4h2V22h2zM24 20H22V12h2zM14 8H12V4H10V8H8V18h2v4h2V18h2zm-2 8H10V10h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartCandlestick16 = createSVGComponent('ChartCandlestick16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 10H24V6H22v4H20V22h2v4h2V22h2zM24 20H22V12h2zM14 8H12V4H10V8H8V18h2v4h2V18h2zm-2 8H10V10h2z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartClusterBar32 = createSVGComponent('ChartClusterBar32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16H12V26H10zM7 22H9V26H7zM26 8H28V26H26zM23 14H25V26H23z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 12H17V26H15z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 18H20V26H18z",
      "transform": "rotate(-180 19 22)"
    }
  }]);

  const ChartClusterBar24 = createSVGComponent('ChartClusterBar24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16H12V26H10zM7 22H9V26H7zM26 8H28V26H26zM23 14H25V26H23z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 12H17V26H15z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 18H20V26H18z",
      "transform": "rotate(-180 19 22)"
    }
  }]);

  const ChartClusterBar20 = createSVGComponent('ChartClusterBar20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16H12V26H10zM7 22H9V26H7zM26 8H28V26H26zM23 14H25V26H23z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 12H17V26H15z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 18H20V26H18z",
      "transform": "rotate(-180 19 22)"
    }
  }]);

  const ChartClusterBar16 = createSVGComponent('ChartClusterBar16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M10 16H12V26H10zM7 22H9V26H7zM26 8H28V26H26zM23 14H25V26H23z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15 12H17V26H15z",
      "transform": "rotate(-180 16 19)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18 18H20V26H18z",
      "transform": "rotate(-180 19 22)"
    }
  }]);

  const ChartColumn32 = createSVGComponent('ChartColumn32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"
    }
  }]);

  const ChartColumn24 = createSVGComponent('ChartColumn24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"
    }
  }]);

  const ChartColumn20 = createSVGComponent('ChartColumn20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"
    }
  }]);

  const ChartColumn16 = createSVGComponent('ChartColumn16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"
    }
  }]);

  const ChartColumnFloating32 = createSVGComponent('ChartColumnFloating32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H20V4h8zm-6-2h4V6H22zM16 24H8V10h8zm-6-2h4V12H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0021,2.0021,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartColumnFloating24 = createSVGComponent('ChartColumnFloating24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H20V4h8zm-6-2h4V6H22zM16 24H8V10h8zm-6-2h4V12H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0021,2.0021,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartColumnFloating20 = createSVGComponent('ChartColumnFloating20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H20V4h8zm-6-2h4V6H22zM16 24H8V10h8zm-6-2h4V12H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0021,2.0021,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartColumnFloating16 = createSVGComponent('ChartColumnFloating16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H20V4h8zm-6-2h4V6H22zM16 24H8V10h8zm-6-2h4V12H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0021,2.0021,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartColumnTarget32 = createSVGComponent('ChartColumnTarget32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 28V6H19V28H15V14H7V28H4V2H2V28a2 2 0 002 2H30V28zM13 28H9V16h4zm12 0H21V8h4zM19 2H27V4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 10H15V12H7z"
    }
  }]);

  const ChartColumnTarget24 = createSVGComponent('ChartColumnTarget24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 28V6H19V28H15V14H7V28H4V2H2V28a2 2 0 002 2H30V28zM13 28H9V16h4zm12 0H21V8h4zM19 2H27V4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 10H15V12H7z"
    }
  }]);

  const ChartColumnTarget20 = createSVGComponent('ChartColumnTarget20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 28V6H19V28H15V14H7V28H4V2H2V28a2 2 0 002 2H30V28zM13 28H9V16h4zm12 0H21V8h4zM19 2H27V4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 10H15V12H7z"
    }
  }]);

  const ChartColumnTarget16 = createSVGComponent('ChartColumnTarget16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27 28V6H19V28H15V14H7V28H4V2H2V28a2 2 0 002 2H30V28zM13 28H9V16h4zm12 0H21V8h4zM19 2H27V4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7 10H15V12H7z"
    }
  }]);

  const ChartCombo32 = createSVGComponent('ChartCombo32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V14h4Zm12,0H21V18h4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartCombo24 = createSVGComponent('ChartCombo24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V14h4Zm12,0H21V18h4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartCombo20 = createSVGComponent('ChartCombo20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V14h4Zm12,0H21V18h4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartCombo16 = createSVGComponent('ChartCombo16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V14h4Zm12,0H21V18h4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartComboStacked32 = createSVGComponent('ChartComboStacked32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,14v6H9V14Zm12,4v6H21V18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartComboStacked24 = createSVGComponent('ChartComboStacked24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,14v6H9V14Zm12,4v6H21V18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartComboStacked20 = createSVGComponent('ChartComboStacked20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,14v6H9V14Zm12,4v6H21V18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartComboStacked16 = createSVGComponent('ChartComboStacked16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,28V16H19V28H15V12H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,14v6H9V14Zm12,4v6H21V18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M22.7856,14a1.9877,1.9877,0,0,1-1.1787-.3865L11.2041,5.987,8.2419,10,6.6374,8.8065l2.9812-4a1.9978,1.9978,0,0,1,2.749-.446l10.4214,7.64,3.6045-4.8613L28,8.3306l-3.6045,4.8611A2.0014,2.0014,0,0,1,22.7856,14Z"
    }
  }]);

  const ChartCustom32 = createSVGComponent('ChartCustom32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707,19.293l-3-3a.9994.9994,0,0,0-1.414,0L16,25.5859V30h4.4141l9.2929-9.293A.9994.9994,0,0,0,29.707,19.293ZM19.5859,28H18V26.4141l5-5L24.5859,23ZM26,21.5859,24.4141,20,26,18.4141,27.5859,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 15H21V17H17z",
      "transform": "rotate(-90 19 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 14H18V16H12z",
      "transform": "rotate(-90 15 15)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H16V14H6z",
      "transform": "rotate(-90 11 13)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,30H6a2.0021,2.0021,0,0,1-2-2V4A2.0021,2.0021,0,0,1,6,2H22a2.0021,2.0021,0,0,1,2,2V14H22V4H6V28h6Z"
    }
  }]);

  const ChartCustom24 = createSVGComponent('ChartCustom24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707,19.293l-3-3a.9994.9994,0,0,0-1.414,0L16,25.5859V30h4.4141l9.2929-9.293A.9994.9994,0,0,0,29.707,19.293ZM19.5859,28H18V26.4141l5-5L24.5859,23ZM26,21.5859,24.4141,20,26,18.4141,27.5859,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 15H21V17H17z",
      "transform": "rotate(-90 19 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 14H18V16H12z",
      "transform": "rotate(-90 15 15)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H16V14H6z",
      "transform": "rotate(-90 11 13)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,30H6a2.0021,2.0021,0,0,1-2-2V4A2.0021,2.0021,0,0,1,6,2H22a2.0021,2.0021,0,0,1,2,2V14H22V4H6V28h6Z"
    }
  }]);

  const ChartCustom20 = createSVGComponent('ChartCustom20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707,19.293l-3-3a.9994.9994,0,0,0-1.414,0L16,25.5859V30h4.4141l9.2929-9.293A.9994.9994,0,0,0,29.707,19.293ZM19.5859,28H18V26.4141l5-5L24.5859,23ZM26,21.5859,24.4141,20,26,18.4141,27.5859,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 15H21V17H17z",
      "transform": "rotate(-90 19 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 14H18V16H12z",
      "transform": "rotate(-90 15 15)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H16V14H6z",
      "transform": "rotate(-90 11 13)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,30H6a2.0021,2.0021,0,0,1-2-2V4A2.0021,2.0021,0,0,1,6,2H22a2.0021,2.0021,0,0,1,2,2V14H22V4H6V28h6Z"
    }
  }]);

  const ChartCustom16 = createSVGComponent('ChartCustom16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.707,19.293l-3-3a.9994.9994,0,0,0-1.414,0L16,25.5859V30h4.4141l9.2929-9.293A.9994.9994,0,0,0,29.707,19.293ZM19.5859,28H18V26.4141l5-5L24.5859,23ZM26,21.5859,24.4141,20,26,18.4141,27.5859,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17 15H21V17H17z",
      "transform": "rotate(-90 19 16)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 14H18V16H12z",
      "transform": "rotate(-90 15 15)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6 12H16V14H6z",
      "transform": "rotate(-90 11 13)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12,30H6a2.0021,2.0021,0,0,1-2-2V4A2.0021,2.0021,0,0,1,6,2H22a2.0021,2.0021,0,0,1,2,2V14H22V4H6V28h6Z"
    }
  }]);

  const ChartDualYAxis32 = createSVGComponent('ChartDualYAxis32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m28,2v5.7222l-7.5317,6.9521L12.3818,6.5879c-.3918-.3911-.9111-.5918-1.4302-.5879-.4644.0034-.9285.1714-1.301.4976l-5.6506,4.9443V2h-2v26c0,1.1025.8972,2,2,2h24c1.1028,0,2-.8975,2-2V2h-2Zm0,8.4438v11.7622l-6.1165-6.1162,6.1165-5.646Zm-17.0322-2.4414l8.0298,8.0298-3.2141,2.9668-3.4148-3.415c-.3711-.3706-.8564-.5674-1.3479-.584s-.9885.1475-1.3833.4932l-5.6375,4.9326v-6.3262l6.9678-6.0972Zm-6.9678,19.9976v-4.9165l6.9546-6.085,3.4146,3.4146c.3809.3809.8755.5771,1.374.5869s1.0007-.166,1.3967-.5312l3.2729-3.0215,7.5872,7.5869v2.9658H4Z"
    }
  }]);

  const ChartDualYAxis24 = createSVGComponent('ChartDualYAxis24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m28,2v5.7222l-7.5317,6.9521L12.3818,6.5879c-.3918-.3911-.9111-.5918-1.4302-.5879-.4644.0034-.9285.1714-1.301.4976l-5.6506,4.9443V2h-2v26c0,1.1025.8972,2,2,2h24c1.1028,0,2-.8975,2-2V2h-2Zm0,8.4438v11.7622l-6.1165-6.1162,6.1165-5.646Zm-17.0322-2.4414l8.0298,8.0298-3.2141,2.9668-3.4148-3.415c-.3711-.3706-.8564-.5674-1.3479-.584s-.9885.1475-1.3833.4932l-5.6375,4.9326v-6.3262l6.9678-6.0972Zm-6.9678,19.9976v-4.9165l6.9546-6.085,3.4146,3.4146c.3809.3809.8755.5771,1.374.5869s1.0007-.166,1.3967-.5312l3.2729-3.0215,7.5872,7.5869v2.9658H4Z"
    }
  }]);

  const ChartDualYAxis20 = createSVGComponent('ChartDualYAxis20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m28,2v5.7222l-7.5317,6.9521L12.3818,6.5879c-.3918-.3911-.9111-.5918-1.4302-.5879-.4644.0034-.9285.1714-1.301.4976l-5.6506,4.9443V2h-2v26c0,1.1025.8972,2,2,2h24c1.1028,0,2-.8975,2-2V2h-2Zm0,8.4438v11.7622l-6.1165-6.1162,6.1165-5.646Zm-17.0322-2.4414l8.0298,8.0298-3.2141,2.9668-3.4148-3.415c-.3711-.3706-.8564-.5674-1.3479-.584s-.9885.1475-1.3833.4932l-5.6375,4.9326v-6.3262l6.9678-6.0972Zm-6.9678,19.9976v-4.9165l6.9546-6.085,3.4146,3.4146c.3809.3809.8755.5771,1.374.5869s1.0007-.166,1.3967-.5312l3.2729-3.0215,7.5872,7.5869v2.9658H4Z"
    }
  }]);

  const ChartDualYAxis16 = createSVGComponent('ChartDualYAxis16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "m28,2v5.7222l-7.5317,6.9521L12.3818,6.5879c-.3918-.3911-.9111-.5918-1.4302-.5879-.4644.0034-.9285.1714-1.301.4976l-5.6506,4.9443V2h-2v26c0,1.1025.8972,2,2,2h24c1.1028,0,2-.8975,2-2V2h-2Zm0,8.4438v11.7622l-6.1165-6.1162,6.1165-5.646Zm-17.0322-2.4414l8.0298,8.0298-3.2141,2.9668-3.4148-3.415c-.3711-.3706-.8564-.5674-1.3479-.584s-.9885.1475-1.3833.4932l-5.6375,4.9326v-6.3262l6.9678-6.0972Zm-6.9678,19.9976v-4.9165l6.9546-6.085,3.4146,3.4146c.3809.3809.8755.5771,1.374.5869s1.0007-.166,1.3967-.5312l3.2729-3.0215,7.5872,7.5869v2.9658H4Z"
    }
  }]);

  const ChartErrorBar32 = createSVGComponent('ChartErrorBar32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28V12H18V8h2V6H14V8h2v4H12V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM14,14h2v4H14Zm6,14H14V20h6Zm0-10H18V14h2Z"
    }
  }]);

  const ChartErrorBar24 = createSVGComponent('ChartErrorBar24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28V12H18V8h2V6H14V8h2v4H12V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM14,14h2v4H14Zm6,14H14V20h6Zm0-10H18V14h2Z"
    }
  }]);

  const ChartErrorBar20 = createSVGComponent('ChartErrorBar20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28V12H18V8h2V6H14V8h2v4H12V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM14,14h2v4H14Zm6,14H14V20h6Zm0-10H18V14h2Z"
    }
  }]);

  const ChartErrorBar16 = createSVGComponent('ChartErrorBar16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22,28V12H18V8h2V6H14V8h2v4H12V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM14,14h2v4H14Zm6,14H14V20h6Zm0-10H18V14h2Z"
    }
  }]);

  const ChartErrorBarAlt32 = createSVGComponent('ChartErrorBarAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 10V8H8v2h2v4.1836a2.983 2.983 0 000 5.6328V24H8v2h6V24H12V19.8164a2.983 2.983 0 000-5.6328V10zM26 6V4H20V6h2V8.1836a2.983 2.983 0 000 5.6328V18H20v2h6V18H24V13.8164a2.983 2.983 0 000-5.6328V6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartErrorBarAlt24 = createSVGComponent('ChartErrorBarAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 10V8H8v2h2v4.1836a2.983 2.983 0 000 5.6328V24H8v2h6V24H12V19.8164a2.983 2.983 0 000-5.6328V10zM26 6V4H20V6h2V8.1836a2.983 2.983 0 000 5.6328V18H20v2h6V18H24V13.8164a2.983 2.983 0 000-5.6328V6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartErrorBarAlt20 = createSVGComponent('ChartErrorBarAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 10V8H8v2h2v4.1836a2.983 2.983 0 000 5.6328V24H8v2h6V24H12V19.8164a2.983 2.983 0 000-5.6328V10zM26 6V4H20V6h2V8.1836a2.983 2.983 0 000 5.6328V18H20v2h6V18H24V13.8164a2.983 2.983 0 000-5.6328V6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartErrorBarAlt16 = createSVGComponent('ChartErrorBarAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 10V8H8v2h2v4.1836a2.983 2.983 0 000 5.6328V24H8v2h6V24H12V19.8164a2.983 2.983 0 000-5.6328V10zM26 6V4H20V6h2V8.1836a2.983 2.983 0 000 5.6328V18H20v2h6V18H24V13.8164a2.983 2.983 0 000-5.6328V6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartEvaluation32 = createSVGComponent('ChartEvaluation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25.672 6.207H29.915V8.206H25.672z",
      "transform": "rotate(-45.02 27.793 7.207)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 20.5L11 15.539 12.59 13.969 16 17.349 23.41 10 25 11.579 16 20.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V25.4131L10.4141,19,9,17.585l-5,5V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartEvaluation24 = createSVGComponent('ChartEvaluation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25.672 6.207H29.915V8.206H25.672z",
      "transform": "rotate(-45.02 27.793 7.207)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 20.5L11 15.539 12.59 13.969 16 17.349 23.41 10 25 11.579 16 20.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V25.4131L10.4141,19,9,17.585l-5,5V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartEvaluation20 = createSVGComponent('ChartEvaluation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25.672 6.207H29.915V8.206H25.672z",
      "transform": "rotate(-45.02 27.793 7.207)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 20.5L11 15.539 12.59 13.969 16 17.349 23.41 10 25 11.579 16 20.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V25.4131L10.4141,19,9,17.585l-5,5V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartEvaluation16 = createSVGComponent('ChartEvaluation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M25.672 6.207H29.915V8.206H25.672z",
      "transform": "rotate(-45.02 27.793 7.207)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 20.5L11 15.539 12.59 13.969 16 17.349 23.41 10 25 11.579 16 20.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,28V25.4131L10.4141,19,9,17.585l-5,5V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartHighLow32 = createSVGComponent('ChartHighLow32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 8L12 8 12 6 10 6 10 20 7 20 7 22 10 22 10 24 12 24 12 10 15 10 15 8zM27 10L24 10 24 6 22 6 22 18 19 18 19 20 22 20 22 24 24 24 24 12 27 12 27 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartHighLow24 = createSVGComponent('ChartHighLow24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 8L12 8 12 6 10 6 10 20 7 20 7 22 10 22 10 24 12 24 12 10 15 10 15 8zM27 10L24 10 24 6 22 6 22 18 19 18 19 20 22 20 22 24 24 24 24 12 27 12 27 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartHighLow20 = createSVGComponent('ChartHighLow20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 8L12 8 12 6 10 6 10 20 7 20 7 22 10 22 10 24 12 24 12 10 15 10 15 8zM27 10L24 10 24 6 22 6 22 18 19 18 19 20 22 20 22 24 24 24 24 12 27 12 27 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartHighLow16 = createSVGComponent('ChartHighLow16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 8L12 8 12 6 10 6 10 20 7 20 7 22 10 22 10 24 12 24 12 10 15 10 15 8zM27 10L24 10 24 6 22 6 22 18 19 18 19 20 22 20 22 24 24 24 24 12 27 12 27 10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }]);

  const ChartHistogram32 = createSVGComponent('ChartHistogram32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,16c2.9727,0,4.2324-2.251,5.3447-4.2373C12.4741,9.7441,13.45,8,16,8s3.5259,1.7441,4.6553,3.7627C21.7676,13.749,23.0273,16,26,16h4V14H26c-1.7129,0-2.4834-1.2207-3.5991-3.2144C21.2075,8.6543,19.7231,6,16,6s-5.2075,2.6543-6.4009,4.7856C8.4834,12.7793,7.7129,14,6,14H4V2H2V28a2,2,0,0,0,2,2H30V28H28V22H26v6H21.9992L22,20H20v8H16V16H14V28H9.9992L10,20H8v8H4V16Z"
    }
  }]);

  const ChartHistogram24 = createSVGComponent('ChartHistogram24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,16c2.9727,0,4.2324-2.251,5.3447-4.2373C12.4741,9.7441,13.45,8,16,8s3.5259,1.7441,4.6553,3.7627C21.7676,13.749,23.0273,16,26,16h4V14H26c-1.7129,0-2.4834-1.2207-3.5991-3.2144C21.2075,8.6543,19.7231,6,16,6s-5.2075,2.6543-6.4009,4.7856C8.4834,12.7793,7.7129,14,6,14H4V2H2V28a2,2,0,0,0,2,2H30V28H28V22H26v6H21.9992L22,20H20v8H16V16H14V28H9.9992L10,20H8v8H4V16Z"
    }
  }]);

  const ChartHistogram20 = createSVGComponent('ChartHistogram20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,16c2.9727,0,4.2324-2.251,5.3447-4.2373C12.4741,9.7441,13.45,8,16,8s3.5259,1.7441,4.6553,3.7627C21.7676,13.749,23.0273,16,26,16h4V14H26c-1.7129,0-2.4834-1.2207-3.5991-3.2144C21.2075,8.6543,19.7231,6,16,6s-5.2075,2.6543-6.4009,4.7856C8.4834,12.7793,7.7129,14,6,14H4V2H2V28a2,2,0,0,0,2,2H30V28H28V22H26v6H21.9992L22,20H20v8H16V16H14V28H9.9992L10,20H8v8H4V16Z"
    }
  }]);

  const ChartHistogram16 = createSVGComponent('ChartHistogram16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6,16c2.9727,0,4.2324-2.251,5.3447-4.2373C12.4741,9.7441,13.45,8,16,8s3.5259,1.7441,4.6553,3.7627C21.7676,13.749,23.0273,16,26,16h4V14H26c-1.7129,0-2.4834-1.2207-3.5991-3.2144C21.2075,8.6543,19.7231,6,16,6s-5.2075,2.6543-6.4009,4.7856C8.4834,12.7793,7.7129,14,6,14H4V2H2V28a2,2,0,0,0,2,2H30V28H28V22H26v6H21.9992L22,20H20v8H16V16H14V28H9.9992L10,20H8v8H4V16Z"
    }
  }]);

  const ChartLine32 = createSVGComponent('ChartLine32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartLine24 = createSVGComponent('ChartLine24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartLine20 = createSVGComponent('ChartLine20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartLine16 = createSVGComponent('ChartLine16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartLineData32 = createSVGComponent('ChartLineData32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"
    }
  }]);

  const ChartLineData24 = createSVGComponent('ChartLineData24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"
    }
  }]);

  const ChartLineData20 = createSVGComponent('ChartLineData20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"
    }
  }]);

  const ChartLineData16 = createSVGComponent('ChartLineData16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"
    }
  }]);

  const ChartLineSmooth32 = createSVGComponent('ChartLineSmooth32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13,15c1.4854,0,2.5544,1.4966,3.6863,3.0811C17.9983,19.918,19.4854,22,22,22c5.6709,0,7.78-10.79,8-12l-1.9678-.3584C27.55,12.2827,25.3938,20,22,20c-1.4854,0-2.5544-1.4966-3.6863-3.0811C17.0017,15.082,15.5146,13,13,13c-4.186,0-7.4448,7.4043-9,11.7617V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H5.0439C6.5544,22.8574,9.9634,15,13,15Z"
    }
  }]);

  const ChartLineSmooth24 = createSVGComponent('ChartLineSmooth24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13,15c1.4854,0,2.5544,1.4966,3.6863,3.0811C17.9983,19.918,19.4854,22,22,22c5.6709,0,7.78-10.79,8-12l-1.9678-.3584C27.55,12.2827,25.3938,20,22,20c-1.4854,0-2.5544-1.4966-3.6863-3.0811C17.0017,15.082,15.5146,13,13,13c-4.186,0-7.4448,7.4043-9,11.7617V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H5.0439C6.5544,22.8574,9.9634,15,13,15Z"
    }
  }]);

  const ChartLineSmooth20 = createSVGComponent('ChartLineSmooth20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13,15c1.4854,0,2.5544,1.4966,3.6863,3.0811C17.9983,19.918,19.4854,22,22,22c5.6709,0,7.78-10.79,8-12l-1.9678-.3584C27.55,12.2827,25.3938,20,22,20c-1.4854,0-2.5544-1.4966-3.6863-3.0811C17.0017,15.082,15.5146,13,13,13c-4.186,0-7.4448,7.4043-9,11.7617V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H5.0439C6.5544,22.8574,9.9634,15,13,15Z"
    }
  }]);

  const ChartLineSmooth16 = createSVGComponent('ChartLineSmooth16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13,15c1.4854,0,2.5544,1.4966,3.6863,3.0811C17.9983,19.918,19.4854,22,22,22c5.6709,0,7.78-10.79,8-12l-1.9678-.3584C27.55,12.2827,25.3938,20,22,20c-1.4854,0-2.5544-1.4966-3.6863-3.0811C17.0017,15.082,15.5146,13,13,13c-4.186,0-7.4448,7.4043-9,11.7617V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H5.0439C6.5544,22.8574,9.9634,15,13,15Z"
    }
  }]);

  const ChartLogisticRegression32 = createSVGComponent('ChartLogisticRegression32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "8",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m8.2339,24c3.8799,0,7.311-2.4731,8.5383-6.1543l2.353-7.0591c.9543-2.8628,3.6233-4.7866,6.6409-4.7866h4.2339v-2h-4.2339c-3.8799,0-7.311,2.4731-8.5383,6.1543l-2.353,7.0591c-.9543,2.8628-3.6233,4.7866-6.6409,4.7866h-4.2339V2h-2v26c0,1.1025.897,2,2,2h26v-2H4v-4h4.2339Z"
    }
  }]);

  const ChartLogisticRegression24 = createSVGComponent('ChartLogisticRegression24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "8",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m8.2339,24c3.8799,0,7.311-2.4731,8.5383-6.1543l2.353-7.0591c.9543-2.8628,3.6233-4.7866,6.6409-4.7866h4.2339v-2h-4.2339c-3.8799,0-7.311,2.4731-8.5383,6.1543l-2.353,7.0591c-.9543,2.8628-3.6233,4.7866-6.6409,4.7866h-4.2339V2h-2v26c0,1.1025.897,2,2,2h26v-2H4v-4h4.2339Z"
    }
  }]);

  const ChartLogisticRegression20 = createSVGComponent('ChartLogisticRegression20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "8",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m8.2339,24c3.8799,0,7.311-2.4731,8.5383-6.1543l2.353-7.0591c.9543-2.8628,3.6233-4.7866,6.6409-4.7866h4.2339v-2h-4.2339c-3.8799,0-7.311,2.4731-8.5383,6.1543l-2.353,7.0591c-.9543,2.8628-3.6233,4.7866-6.6409,4.7866h-4.2339V2h-2v26c0,1.1025.897,2,2,2h26v-2H4v-4h4.2339Z"
    }
  }]);

  const ChartLogisticRegression16 = createSVGComponent('ChartLogisticRegression16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "8",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "m8.2339,24c3.8799,0,7.311-2.4731,8.5383-6.1543l2.353-7.0591c.9543-2.8628,3.6233-4.7866,6.6409-4.7866h4.2339v-2h-4.2339c-3.8799,0-7.311,2.4731-8.5383,6.1543l-2.353,7.0591c-.9543,2.8628-3.6233,4.7866-6.6409,4.7866h-4.2339V2h-2v26c0,1.1025.897,2,2,2h26v-2H4v-4h4.2339Z"
    }
  }]);

  const ChartMarimekko32 = createSVGComponent('ChartMarimekko32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,7H21V5h6ZM19,8H13V5h6Zm0,2v8H13V10ZM11,22H5V12h6Zm2-2h6v7H13Zm8-8h6v4H21ZM11,5v5H5V5ZM5,24h6v3H5Zm16,3V18h6v9Z"
    }
  }]);

  const ChartMarimekko24 = createSVGComponent('ChartMarimekko24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,7H21V5h6ZM19,8H13V5h6Zm0,2v8H13V10ZM11,22H5V12h6Zm2-2h6v7H13Zm8-8h6v4H21ZM11,5v5H5V5ZM5,24h6v3H5Zm16,3V18h6v9Z"
    }
  }]);

  const ChartMarimekko20 = createSVGComponent('ChartMarimekko20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,7H21V5h6ZM19,8H13V5h6Zm0,2v8H13V10ZM11,22H5V12h6Zm2-2h6v7H13Zm8-8h6v4H21ZM11,5v5H5V5ZM5,24h6v3H5Zm16,3V18h6v9Z"
    }
  }]);

  const ChartMarimekko16 = createSVGComponent('ChartMarimekko16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,7H21V5h6ZM19,8H13V5h6Zm0,2v8H13V10ZM11,22H5V12h6Zm2-2h6v7H13Zm8-8h6v4H21ZM11,5v5H5V5ZM5,24h6v3H5Zm16,3V18h6v9Z"
    }
  }]);

  const ChartMaximum32 = createSVGComponent('ChartMaximum32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 6H10V8H8zM12 6H14V8H12zM20 6H22V8H20zM24 6H26V8H24zM28 6H30V8H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.989,28l-.0271-.1631C26.5105,19.0742,24.0662,9.0894,18,8.0889V6H16V8.085c-6.084.978-8.533,10.9775-9.9863,19.7519L5.9866,28H4V8H6V6H4V2H2V28a2,2,0,0,0,2,2H30V28ZM8.0151,28c2.024-12.1084,4.959-18,8.9727-18s6.9487,5.8916,8.9726,18Z"
    }
  }]);

  const ChartMaximum24 = createSVGComponent('ChartMaximum24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 6H10V8H8zM12 6H14V8H12zM20 6H22V8H20zM24 6H26V8H24zM28 6H30V8H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.989,28l-.0271-.1631C26.5105,19.0742,24.0662,9.0894,18,8.0889V6H16V8.085c-6.084.978-8.533,10.9775-9.9863,19.7519L5.9866,28H4V8H6V6H4V2H2V28a2,2,0,0,0,2,2H30V28ZM8.0151,28c2.024-12.1084,4.959-18,8.9727-18s6.9487,5.8916,8.9726,18Z"
    }
  }]);

  const ChartMaximum20 = createSVGComponent('ChartMaximum20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 6H10V8H8zM12 6H14V8H12zM20 6H22V8H20zM24 6H26V8H24zM28 6H30V8H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.989,28l-.0271-.1631C26.5105,19.0742,24.0662,9.0894,18,8.0889V6H16V8.085c-6.084.978-8.533,10.9775-9.9863,19.7519L5.9866,28H4V8H6V6H4V2H2V28a2,2,0,0,0,2,2H30V28ZM8.0151,28c2.024-12.1084,4.959-18,8.9727-18s6.9487,5.8916,8.9726,18Z"
    }
  }]);

  const ChartMaximum16 = createSVGComponent('ChartMaximum16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 6H10V8H8zM12 6H14V8H12zM20 6H22V8H20zM24 6H26V8H24zM28 6H30V8H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.989,28l-.0271-.1631C26.5105,19.0742,24.0662,9.0894,18,8.0889V6H16V8.085c-6.084.978-8.533,10.9775-9.9863,19.7519L5.9866,28H4V8H6V6H4V2H2V28a2,2,0,0,0,2,2H30V28ZM8.0151,28c2.024-12.1084,4.959-18,8.9727-18s6.9487,5.8916,8.9726,18Z"
    }
  }]);

  const ChartMedian32 = createSVGComponent('ChartMedian32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22H18V24H16z",
      "transform": "rotate(-90 17 23)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,28V26H16v2H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26.0532,19.6787A3.44,3.44,0,0,1,23,22c-2.17,0-3.3115-3.333-4.52-6.8623-.3557-1.0386-.7239-2.1094-1.1382-3.1377H18V10H16.4221C15.2124,7.7148,13.5811,6,11,6,7.3218,6,6.1016,9.5332,6.0513,9.6836l1.8955.6377A3.44,3.44,0,0,1,11,8c2.92,0,4.2764,3.958,5.5874,7.7861.2544.7422.5105,1.4893.7813,2.2139H16v2h2.2019c1.0828,2.2886,2.4959,4,4.7981,4,3.6782,0,4.8984-3.5332,4.9487-3.6836Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 6H18V8H16z",
      "transform": "rotate(-90 17 7)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 2H18V4H16z",
      "transform": "rotate(-90 17 3)"
    }
  }]);

  const ChartMedian24 = createSVGComponent('ChartMedian24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22H18V24H16z",
      "transform": "rotate(-90 17 23)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,28V26H16v2H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26.0532,19.6787A3.44,3.44,0,0,1,23,22c-2.17,0-3.3115-3.333-4.52-6.8623-.3557-1.0386-.7239-2.1094-1.1382-3.1377H18V10H16.4221C15.2124,7.7148,13.5811,6,11,6,7.3218,6,6.1016,9.5332,6.0513,9.6836l1.8955.6377A3.44,3.44,0,0,1,11,8c2.92,0,4.2764,3.958,5.5874,7.7861.2544.7422.5105,1.4893.7813,2.2139H16v2h2.2019c1.0828,2.2886,2.4959,4,4.7981,4,3.6782,0,4.8984-3.5332,4.9487-3.6836Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 6H18V8H16z",
      "transform": "rotate(-90 17 7)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 2H18V4H16z",
      "transform": "rotate(-90 17 3)"
    }
  }]);

  const ChartMedian20 = createSVGComponent('ChartMedian20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22H18V24H16z",
      "transform": "rotate(-90 17 23)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,28V26H16v2H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26.0532,19.6787A3.44,3.44,0,0,1,23,22c-2.17,0-3.3115-3.333-4.52-6.8623-.3557-1.0386-.7239-2.1094-1.1382-3.1377H18V10H16.4221C15.2124,7.7148,13.5811,6,11,6,7.3218,6,6.1016,9.5332,6.0513,9.6836l1.8955.6377A3.44,3.44,0,0,1,11,8c2.92,0,4.2764,3.958,5.5874,7.7861.2544.7422.5105,1.4893.7813,2.2139H16v2h2.2019c1.0828,2.2886,2.4959,4,4.7981,4,3.6782,0,4.8984-3.5332,4.9487-3.6836Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 6H18V8H16z",
      "transform": "rotate(-90 17 7)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 2H18V4H16z",
      "transform": "rotate(-90 17 3)"
    }
  }]);

  const ChartMedian16 = createSVGComponent('ChartMedian16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22H18V24H16z",
      "transform": "rotate(-90 17 23)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,28V26H16v2H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26.0532,19.6787A3.44,3.44,0,0,1,23,22c-2.17,0-3.3115-3.333-4.52-6.8623-.3557-1.0386-.7239-2.1094-1.1382-3.1377H18V10H16.4221C15.2124,7.7148,13.5811,6,11,6,7.3218,6,6.1016,9.5332,6.0513,9.6836l1.8955.6377A3.44,3.44,0,0,1,11,8c2.92,0,4.2764,3.958,5.5874,7.7861.2544.7422.5105,1.4893.7813,2.2139H16v2h2.2019c1.0828,2.2886,2.4959,4,4.7981,4,3.6782,0,4.8984-3.5332,4.9487-3.6836Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 6H18V8H16z",
      "transform": "rotate(-90 17 7)"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16 2H18V4H16z",
      "transform": "rotate(-90 17 3)"
    }
  }]);

  const ChartMinimum32 = createSVGComponent('ChartMinimum32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H6V24H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 24H10V26H8zM12 24H14V26H12zM20 24H22V26H20zM24 24H26V26H24zM28 24H30V26H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.9463,4.3281,25.9727,4C23.9487,16.1084,21.0137,22,17,22S10.0513,16.1084,8.0271,4l-1.9734.3281C7.51,13.0566,9.9631,22.93,16,23.9131V26h2V23.9131C24.0371,22.93,26.4907,13.0566,27.9463,4.3281Z"
    }
  }]);

  const ChartMinimum24 = createSVGComponent('ChartMinimum24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H6V24H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 24H10V26H8zM12 24H14V26H12zM20 24H22V26H20zM24 24H26V26H24zM28 24H30V26H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.9463,4.3281,25.9727,4C23.9487,16.1084,21.0137,22,17,22S10.0513,16.1084,8.0271,4l-1.9734.3281C7.51,13.0566,9.9631,22.93,16,23.9131V26h2V23.9131C24.0371,22.93,26.4907,13.0566,27.9463,4.3281Z"
    }
  }]);

  const ChartMinimum20 = createSVGComponent('ChartMinimum20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H6V24H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 24H10V26H8zM12 24H14V26H12zM20 24H22V26H20zM24 24H26V26H24zM28 24H30V26H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.9463,4.3281,25.9727,4C23.9487,16.1084,21.0137,22,17,22S10.0513,16.1084,8.0271,4l-1.9734.3281C7.51,13.0566,9.9631,22.93,16,23.9131V26h2V23.9131C24.0371,22.93,26.4907,13.0566,27.9463,4.3281Z"
    }
  }]);

  const ChartMinimum16 = createSVGComponent('ChartMinimum16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4,28V26H6V24H4V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 24H10V26H8zM12 24H14V26H12zM20 24H22V26H20zM24 24H26V26H24zM28 24H30V26H28z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.9463,4.3281,25.9727,4C23.9487,16.1084,21.0137,22,17,22S10.0513,16.1084,8.0271,4l-1.9734.3281C7.51,13.0566,9.9631,22.93,16,23.9131V26h2V23.9131C24.0371,22.93,26.4907,13.0566,27.9463,4.3281Z"
    }
  }]);

  const ChartMultiLine32 = createSVGComponent('ChartMultiLine32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.5859,28l7.1783-5.998L19.7578,23.94a2.021,2.021,0,0,0,1.314-.1206L28,20.5811l-.8479-1.8121-6.9163,3.229L12.2422,20.06a2.0033,2.0033,0,0,0-1.74.3838L4,25.8818V20.49l7.7642-6.4877L19.7578,15.94a2.021,2.021,0,0,0,1.314-.1206l6.9287-3.2383-.8467-1.812-6.918,3.2285L12.2422,12.06a2.0049,2.0049,0,0,0-1.74.3838L4,17.8818V12.49L11.7642,6.002,19.7578,7.94a2.021,2.021,0,0,0,1.314-.1206L28,4.5859l-.8457-1.8115L20.2358,5.998,12.2422,4.06a2.0033,2.0033,0,0,0-1.74.3838L4,9.8818V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartMultiLine24 = createSVGComponent('ChartMultiLine24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.5859,28l7.1783-5.998L19.7578,23.94a2.021,2.021,0,0,0,1.314-.1206L28,20.5811l-.8479-1.8121-6.9163,3.229L12.2422,20.06a2.0033,2.0033,0,0,0-1.74.3838L4,25.8818V20.49l7.7642-6.4877L19.7578,15.94a2.021,2.021,0,0,0,1.314-.1206l6.9287-3.2383-.8467-1.812-6.918,3.2285L12.2422,12.06a2.0049,2.0049,0,0,0-1.74.3838L4,17.8818V12.49L11.7642,6.002,19.7578,7.94a2.021,2.021,0,0,0,1.314-.1206L28,4.5859l-.8457-1.8115L20.2358,5.998,12.2422,4.06a2.0033,2.0033,0,0,0-1.74.3838L4,9.8818V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartMultiLine20 = createSVGComponent('ChartMultiLine20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.5859,28l7.1783-5.998L19.7578,23.94a2.021,2.021,0,0,0,1.314-.1206L28,20.5811l-.8479-1.8121-6.9163,3.229L12.2422,20.06a2.0033,2.0033,0,0,0-1.74.3838L4,25.8818V20.49l7.7642-6.4877L19.7578,15.94a2.021,2.021,0,0,0,1.314-.1206l6.9287-3.2383-.8467-1.812-6.918,3.2285L12.2422,12.06a2.0049,2.0049,0,0,0-1.74.3838L4,17.8818V12.49L11.7642,6.002,19.7578,7.94a2.021,2.021,0,0,0,1.314-.1206L28,4.5859l-.8457-1.8115L20.2358,5.998,12.2422,4.06a2.0033,2.0033,0,0,0-1.74.3838L4,9.8818V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartMultiLine16 = createSVGComponent('ChartMultiLine16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4.5859,28l7.1783-5.998L19.7578,23.94a2.021,2.021,0,0,0,1.314-.1206L28,20.5811l-.8479-1.8121-6.9163,3.229L12.2422,20.06a2.0033,2.0033,0,0,0-1.74.3838L4,25.8818V20.49l7.7642-6.4877L19.7578,15.94a2.021,2.021,0,0,0,1.314-.1206l6.9287-3.2383-.8467-1.812-6.918,3.2285L12.2422,12.06a2.0049,2.0049,0,0,0-1.74.3838L4,17.8818V12.49L11.7642,6.002,19.7578,7.94a2.021,2.021,0,0,0,1.314-.1206L28,4.5859l-.8457-1.8115L20.2358,5.998,12.2422,4.06a2.0033,2.0033,0,0,0-1.74.3838L4,9.8818V2H2V28a2,2,0,0,0,2,2H30V28Z"
    }
  }]);

  const ChartMultitype32 = createSVGComponent('ChartMultitype32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H30V30H28zM24 18H26V30H24zM20 26H22V30H20zM9 16a7 7 0 107 7A7.0078 7.0078 0 009 16zm4.8989 6H10V18.1011A5.0145 5.0145 0 0113.8989 22zM9 28a5 5 0 01-1-9.8989V22a2 2 0 002 2h3.8989A5.0081 5.0081 0 019 28zM22.5352 12l4-6H30V4H25.4648l-4 6H18V2H16V14a2 2 0 002 2H30V14H18V12z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "11",
      "cy": "7",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "11",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "5",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "5",
      "cy": "9",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3",
      "cy": "13",
      "r": "1"
    }
  }]);

  const ChartMultitype24 = createSVGComponent('ChartMultitype24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H30V30H28zM24 18H26V30H24zM20 26H22V30H20zM9 16a7 7 0 107 7A7.0078 7.0078 0 009 16zm4.8989 6H10V18.1011A5.0145 5.0145 0 0113.8989 22zM9 28a5 5 0 01-1-9.8989V22a2 2 0 002 2h3.8989A5.0081 5.0081 0 019 28zM22.5352 12l4-6H30V4H25.4648l-4 6H18V2H16V14a2 2 0 002 2H30V14H18V12z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "11",
      "cy": "7",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "11",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "5",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "5",
      "cy": "9",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3",
      "cy": "13",
      "r": "1"
    }
  }]);

  const ChartMultitype20 = createSVGComponent('ChartMultitype20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H30V30H28zM24 18H26V30H24zM20 26H22V30H20zM9 16a7 7 0 107 7A7.0078 7.0078 0 009 16zm4.8989 6H10V18.1011A5.0145 5.0145 0 0113.8989 22zM9 28a5 5 0 01-1-9.8989V22a2 2 0 002 2h3.8989A5.0081 5.0081 0 019 28zM22.5352 12l4-6H30V4H25.4648l-4 6H18V2H16V14a2 2 0 002 2H30V14H18V12z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "11",
      "cy": "7",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "11",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "5",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "5",
      "cy": "9",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3",
      "cy": "13",
      "r": "1"
    }
  }]);

  const ChartMultitype16 = createSVGComponent('ChartMultitype16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 22H30V30H28zM24 18H26V30H24zM20 26H22V30H20zM9 16a7 7 0 107 7A7.0078 7.0078 0 009 16zm4.8989 6H10V18.1011A5.0145 5.0145 0 0113.8989 22zM9 28a5 5 0 01-1-9.8989V22a2 2 0 002 2h3.8989A5.0081 5.0081 0 019 28zM22.5352 12l4-6H30V4H25.4648l-4 6H18V2H16V14a2 2 0 002 2H30V14H18V12z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "11",
      "cy": "7",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "11",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "7",
      "cy": "5",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "5",
      "cy": "9",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "3",
      "cy": "13",
      "r": "1"
    }
  }]);

  const ChartNetwork32 = createSVGComponent('ChartNetwork32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"
    }
  }]);

  const ChartNetwork24 = createSVGComponent('ChartNetwork24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"
    }
  }]);

  const ChartNetwork20 = createSVGComponent('ChartNetwork20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"
    }
  }]);

  const ChartNetwork16 = createSVGComponent('ChartNetwork16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"
    }
  }]);

  const ChartParallel32 = createSVGComponent('ChartParallel32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2V5.3071l-6,2.25V2H20V7.5229l-8-3.2V2H10V4.4458l-6,3.75V2H2V30H4V27.6182l6-3V30h2V24.3442l8,2.4V30h2V26.5542l6-3.75V30h2V2Zm0,5.4429V12.5L22,17V9.6929ZM20,9.6768v7.5571l-8-4.8V6.4771ZM10,6.8042v5.7417l-6,5.25V10.5542ZM4,25.3818V20.4541l6-5.25v7.1777Zm8-3.1259v-7.49l8,4.8v5.0894Zm10,1.94V19.5L28,15v5.4458Z"
    }
  }]);

  const ChartParallel24 = createSVGComponent('ChartParallel24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2V5.3071l-6,2.25V2H20V7.5229l-8-3.2V2H10V4.4458l-6,3.75V2H2V30H4V27.6182l6-3V30h2V24.3442l8,2.4V30h2V26.5542l6-3.75V30h2V2Zm0,5.4429V12.5L22,17V9.6929ZM20,9.6768v7.5571l-8-4.8V6.4771ZM10,6.8042v5.7417l-6,5.25V10.5542ZM4,25.3818V20.4541l6-5.25v7.1777Zm8-3.1259v-7.49l8,4.8v5.0894Zm10,1.94V19.5L28,15v5.4458Z"
    }
  }]);

  const ChartParallel20 = createSVGComponent('ChartParallel20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2V5.3071l-6,2.25V2H20V7.5229l-8-3.2V2H10V4.4458l-6,3.75V2H2V30H4V27.6182l6-3V30h2V24.3442l8,2.4V30h2V26.5542l6-3.75V30h2V2Zm0,5.4429V12.5L22,17V9.6929ZM20,9.6768v7.5571l-8-4.8V6.4771ZM10,6.8042v5.7417l-6,5.25V10.5542ZM4,25.3818V20.4541l6-5.25v7.1777Zm8-3.1259v-7.49l8,4.8v5.0894Zm10,1.94V19.5L28,15v5.4458Z"
    }
  }]);

  const ChartParallel16 = createSVGComponent('ChartParallel16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2V5.3071l-6,2.25V2H20V7.5229l-8-3.2V2H10V4.4458l-6,3.75V2H2V30H4V27.6182l6-3V30h2V24.3442l8,2.4V30h2V26.5542l6-3.75V30h2V2Zm0,5.4429V12.5L22,17V9.6929ZM20,9.6768v7.5571l-8-4.8V6.4771ZM10,6.8042v5.7417l-6,5.25V10.5542ZM4,25.3818V20.4541l6-5.25v7.1777Zm8-3.1259v-7.49l8,4.8v5.0894Zm10,1.94V19.5L28,15v5.4458Z"
    }
  }]);

  const ChartPie32 = createSVGComponent('ChartPie32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"
    }
  }]);

  const ChartPie24 = createSVGComponent('ChartPie24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"
    }
  }]);

  const ChartPie20 = createSVGComponent('ChartPie20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"
    }
  }]);

  const ChartPie16 = createSVGComponent('ChartPie16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"
    }
  }]);

  const ChartPoint32 = createSVGComponent('ChartPoint32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "14",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9,17a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,9,17Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,9,13Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 17a3 3 0 113-3A3.0033 3.0033 0 0127 17zm0-4a1 1 0 101 1A1.001 1.001 0 0027 13zM18 26a3 3 0 113-3A3.0033 3.0033 0 0118 26zm0-4a1 1 0 101 1A1.001 1.001 0 0018 22zM18 8a3 3 0 113-3A3.0033 3.0033 0 0118 8zm0-4a1 1 0 101 1A1.001 1.001 0 0018 4z"
    }
  }]);

  const ChartPoint24 = createSVGComponent('ChartPoint24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "14",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9,17a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,9,17Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,9,13Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 17a3 3 0 113-3A3.0033 3.0033 0 0127 17zm0-4a1 1 0 101 1A1.001 1.001 0 0027 13zM18 26a3 3 0 113-3A3.0033 3.0033 0 0118 26zm0-4a1 1 0 101 1A1.001 1.001 0 0018 22zM18 8a3 3 0 113-3A3.0033 3.0033 0 0118 8zm0-4a1 1 0 101 1A1.001 1.001 0 0018 4z"
    }
  }]);

  const ChartPoint20 = createSVGComponent('ChartPoint20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "14",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9,17a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,9,17Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,9,13Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 17a3 3 0 113-3A3.0033 3.0033 0 0127 17zm0-4a1 1 0 101 1A1.001 1.001 0 0027 13zM18 26a3 3 0 113-3A3.0033 3.0033 0 0118 26zm0-4a1 1 0 101 1A1.001 1.001 0 0018 22zM18 8a3 3 0 113-3A3.0033 3.0033 0 0118 8zm0-4a1 1 0 101 1A1.001 1.001 0 0018 4z"
    }
  }]);

  const ChartPoint16 = createSVGComponent('ChartPoint16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2.0023,2.0023,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "18",
      "cy": "14",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M9,17a3,3,0,1,1,3-3A3.0033,3.0033,0,0,1,9,17Zm0-4a1,1,0,1,0,1,1A1.001,1.001,0,0,0,9,13Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "6",
      "r": "3"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "27",
      "cy": "22",
      "r": "3"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27 17a3 3 0 113-3A3.0033 3.0033 0 0127 17zm0-4a1 1 0 101 1A1.001 1.001 0 0027 13zM18 26a3 3 0 113-3A3.0033 3.0033 0 0118 26zm0-4a1 1 0 101 1A1.001 1.001 0 0018 22zM18 8a3 3 0 113-3A3.0033 3.0033 0 0118 8zm0-4a1 1 0 101 1A1.001 1.001 0 0018 4z"
    }
  }]);

  const ChartPopulation32 = createSVGComponent('ChartPopulation32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,22H17V20h9V14H17V12h5V6H17V2H15V6H10v6h5v2H6v6h9v2H2v6H15v2h2V28H30ZM20,8v2H17V8Zm-8,2V8h3v2Zm12,6v2H17V16ZM8,18V16h7v2ZM4,26V24H15v2Zm24,0H17V24H28Z"
    }
  }]);

  const ChartPopulation24 = createSVGComponent('ChartPopulation24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,22H17V20h9V14H17V12h5V6H17V2H15V6H10v6h5v2H6v6h9v2H2v6H15v2h2V28H30ZM20,8v2H17V8Zm-8,2V8h3v2Zm12,6v2H17V16ZM8,18V16h7v2ZM4,26V24H15v2Zm24,0H17V24H28Z"
    }
  }]);

  const ChartPopulation20 = createSVGComponent('ChartPopulation20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,22H17V20h9V14H17V12h5V6H17V2H15V6H10v6h5v2H6v6h9v2H2v6H15v2h2V28H30ZM20,8v2H17V8Zm-8,2V8h3v2Zm12,6v2H17V16ZM8,18V16h7v2ZM4,26V24H15v2Zm24,0H17V24H28Z"
    }
  }]);

  const ChartPopulation16 = createSVGComponent('ChartPopulation16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,22H17V20h9V14H17V12h5V6H17V2H15V6H10v6h5v2H6v6h9v2H2v6H15v2h2V28H30ZM20,8v2H17V8Zm-8,2V8h3v2Zm12,6v2H17V16ZM8,18V16h7v2ZM4,26V24H15v2Zm24,0H17V24H28Z"
    }
  }]);

  const ChartRadar32 = createSVGComponent('ChartRadar32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2,2,13,8,30H24l6-17Zm2.5818,19.2651-5.9861,1.3306-1.4226-7.8252,4.91-4.209,5.4416,4.0816Zm.1977,2.0054L21.3264,28H10.6736l1.7912-3.3267ZM9.59,13.4937,5.74,12.605,15,5.3291V8.8569ZM17,8.75V5.3291l9.26,7.2759-3.15.727ZM4.6143,14.3979l4.6535,1.0738,1.4844,8.164-1.738,3.2281ZM22.9858,26.8638l-2.5766-4.7852,3.0063-6.7646,3.97-.9161Z"
    }
  }]);

  const ChartRadar24 = createSVGComponent('ChartRadar24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2,2,13,8,30H24l6-17Zm2.5818,19.2651-5.9861,1.3306-1.4226-7.8252,4.91-4.209,5.4416,4.0816Zm.1977,2.0054L21.3264,28H10.6736l1.7912-3.3267ZM9.59,13.4937,5.74,12.605,15,5.3291V8.8569ZM17,8.75V5.3291l9.26,7.2759-3.15.727ZM4.6143,14.3979l4.6535,1.0738,1.4844,8.164-1.738,3.2281ZM22.9858,26.8638l-2.5766-4.7852,3.0063-6.7646,3.97-.9161Z"
    }
  }]);

  const ChartRadar20 = createSVGComponent('ChartRadar20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2,2,13,8,30H24l6-17Zm2.5818,19.2651-5.9861,1.3306-1.4226-7.8252,4.91-4.209,5.4416,4.0816Zm.1977,2.0054L21.3264,28H10.6736l1.7912-3.3267ZM9.59,13.4937,5.74,12.605,15,5.3291V8.8569ZM17,8.75V5.3291l9.26,7.2759-3.15.727ZM4.6143,14.3979l4.6535,1.0738,1.4844,8.164-1.738,3.2281ZM22.9858,26.8638l-2.5766-4.7852,3.0063-6.7646,3.97-.9161Z"
    }
  }]);

  const ChartRadar16 = createSVGComponent('ChartRadar16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2,2,13,8,30H24l6-17Zm2.5818,19.2651-5.9861,1.3306-1.4226-7.8252,4.91-4.209,5.4416,4.0816Zm.1977,2.0054L21.3264,28H10.6736l1.7912-3.3267ZM9.59,13.4937,5.74,12.605,15,5.3291V8.8569ZM17,8.75V5.3291l9.26,7.2759-3.15.727ZM4.6143,14.3979l4.6535,1.0738,1.4844,8.164-1.738,3.2281ZM22.9858,26.8638l-2.5766-4.7852,3.0063-6.7646,3.97-.9161Z"
    }
  }]);

  const ChartRadial32 = createSVGComponent('ChartRadial32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14.0158,14.0158,0,0,1,2,16H4A12,12,0,1,0,16,4V2a14,14,0,0,1,0,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26A10.0115,10.0115,0,0,1,6,16H8a8,8,0,1,0,8-8V6a10,10,0,0,1,0,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6.0069,6.0069,0,0,1-6-6h2a4,4,0,1,0,4-4V10a6,6,0,0,1,0,12Z"
    }
  }]);

  const ChartRadial24 = createSVGComponent('ChartRadial24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14.0158,14.0158,0,0,1,2,16H4A12,12,0,1,0,16,4V2a14,14,0,0,1,0,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26A10.0115,10.0115,0,0,1,6,16H8a8,8,0,1,0,8-8V6a10,10,0,0,1,0,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6.0069,6.0069,0,0,1-6-6h2a4,4,0,1,0,4-4V10a6,6,0,0,1,0,12Z"
    }
  }]);

  const ChartRadial20 = createSVGComponent('ChartRadial20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14.0158,14.0158,0,0,1,2,16H4A12,12,0,1,0,16,4V2a14,14,0,0,1,0,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26A10.0115,10.0115,0,0,1,6,16H8a8,8,0,1,0,8-8V6a10,10,0,0,1,0,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6.0069,6.0069,0,0,1-6-6h2a4,4,0,1,0,4-4V10a6,6,0,0,1,0,12Z"
    }
  }]);

  const ChartRadial16 = createSVGComponent('ChartRadial16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14.0158,14.0158,0,0,1,2,16H4A12,12,0,1,0,16,4V2a14,14,0,0,1,0,28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,26A10.0115,10.0115,0,0,1,6,16H8a8,8,0,1,0,8-8V6a10,10,0,0,1,0,20Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,22a6.0069,6.0069,0,0,1-6-6h2a4,4,0,1,0,4-4V10a6,6,0,0,1,0,12Z"
    }
  }]);

  const ChartRelationship32 = createSVGComponent('ChartRelationship32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6a3.9963,3.9963,0,0,0-3.8579,3H17.9305A7.9964,7.9964,0,1,0,9,17.9307v4.2114a4,4,0,1,0,2,0V17.9307a7.951,7.951,0,0,0,3.8976-1.6192l3.6693,3.67A3.9529,3.9529,0,0,0,18,22a4,4,0,1,0,4-4,3.9521,3.9521,0,0,0-2.019.5669l-3.6694-3.6694A7.9493,7.9493,0,0,0,17.9305,11h4.2116A3.9934,3.9934,0,1,0,26,6ZM12,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,12,26ZM10,16a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,10,16Zm14,6a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,24,22Zm2-10a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,12Z"
    }
  }]);

  const ChartRelationship24 = createSVGComponent('ChartRelationship24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6a3.9963,3.9963,0,0,0-3.8579,3H17.9305A7.9964,7.9964,0,1,0,9,17.9307v4.2114a4,4,0,1,0,2,0V17.9307a7.951,7.951,0,0,0,3.8976-1.6192l3.6693,3.67A3.9529,3.9529,0,0,0,18,22a4,4,0,1,0,4-4,3.9521,3.9521,0,0,0-2.019.5669l-3.6694-3.6694A7.9493,7.9493,0,0,0,17.9305,11h4.2116A3.9934,3.9934,0,1,0,26,6ZM12,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,12,26ZM10,16a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,10,16Zm14,6a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,24,22Zm2-10a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,12Z"
    }
  }]);

  const ChartRelationship20 = createSVGComponent('ChartRelationship20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6a3.9963,3.9963,0,0,0-3.8579,3H17.9305A7.9964,7.9964,0,1,0,9,17.9307v4.2114a4,4,0,1,0,2,0V17.9307a7.951,7.951,0,0,0,3.8976-1.6192l3.6693,3.67A3.9529,3.9529,0,0,0,18,22a4,4,0,1,0,4-4,3.9521,3.9521,0,0,0-2.019.5669l-3.6694-3.6694A7.9493,7.9493,0,0,0,17.9305,11h4.2116A3.9934,3.9934,0,1,0,26,6ZM12,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,12,26ZM10,16a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,10,16Zm14,6a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,24,22Zm2-10a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,12Z"
    }
  }]);

  const ChartRelationship16 = createSVGComponent('ChartRelationship16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,6a3.9963,3.9963,0,0,0-3.8579,3H17.9305A7.9964,7.9964,0,1,0,9,17.9307v4.2114a4,4,0,1,0,2,0V17.9307a7.951,7.951,0,0,0,3.8976-1.6192l3.6693,3.67A3.9529,3.9529,0,0,0,18,22a4,4,0,1,0,4-4,3.9521,3.9521,0,0,0-2.019.5669l-3.6694-3.6694A7.9493,7.9493,0,0,0,17.9305,11h4.2116A3.9934,3.9934,0,1,0,26,6ZM12,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,12,26ZM10,16a6,6,0,1,1,6-6A6.0066,6.0066,0,0,1,10,16Zm14,6a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,24,22Zm2-10a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,12Z"
    }
  }]);

  const ChartRing32 = createSVGComponent('ChartRing32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9493,15.001H21.91a5.9825,5.9825,0,0,0-9.3806-3.8853l-4.27-4.27a11.9783,11.9783,0,0,1,19.69,8.1548ZM16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20ZM4,16A11.937,11.937,0,0,1,6.8455,8.26l4.27,4.2695A5.9836,5.9836,0,0,0,15,21.9106v6.04A12.0105,12.0105,0,0,1,4,16ZM17,27.95v-6.04A6.0069,6.0069,0,0,0,21.91,17h6.04A12.0082,12.0082,0,0,1,17,27.95Z"
    }
  }]);

  const ChartRing24 = createSVGComponent('ChartRing24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9493,15.001H21.91a5.9825,5.9825,0,0,0-9.3806-3.8853l-4.27-4.27a11.9783,11.9783,0,0,1,19.69,8.1548ZM16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20ZM4,16A11.937,11.937,0,0,1,6.8455,8.26l4.27,4.2695A5.9836,5.9836,0,0,0,15,21.9106v6.04A12.0105,12.0105,0,0,1,4,16ZM17,27.95v-6.04A6.0069,6.0069,0,0,0,21.91,17h6.04A12.0082,12.0082,0,0,1,17,27.95Z"
    }
  }]);

  const ChartRing20 = createSVGComponent('ChartRing20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9493,15.001H21.91a5.9825,5.9825,0,0,0-9.3806-3.8853l-4.27-4.27a11.9783,11.9783,0,0,1,19.69,8.1548ZM16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20ZM4,16A11.937,11.937,0,0,1,6.8455,8.26l4.27,4.2695A5.9836,5.9836,0,0,0,15,21.9106v6.04A12.0105,12.0105,0,0,1,4,16ZM17,27.95v-6.04A6.0069,6.0069,0,0,0,21.91,17h6.04A12.0082,12.0082,0,0,1,17,27.95Z"
    }
  }]);

  const ChartRing16 = createSVGComponent('ChartRing16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9493,15.001H21.91a5.9825,5.9825,0,0,0-9.3806-3.8853l-4.27-4.27a11.9783,11.9783,0,0,1,19.69,8.1548ZM16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20ZM4,16A11.937,11.937,0,0,1,6.8455,8.26l4.27,4.2695A5.9836,5.9836,0,0,0,15,21.9106v6.04A12.0105,12.0105,0,0,1,4,16ZM17,27.95v-6.04A6.0069,6.0069,0,0,0,21.91,17h6.04A12.0082,12.0082,0,0,1,17,27.95Z"
    }
  }]);

  const ChartRiver32 = createSVGComponent('ChartRiver32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12.4326,20.0171l8.0376,4.68a1.958,1.958,0,0,0,1.0508.3012,2.2412,2.2412,0,0,0,.4888-.0556l7.2532-1.9769A1,1,0,0,0,30,22.0007V7.996A1,1,0,0,0,28.74,7.0305L21.5034,8.9829l-8.0371-4.68a1.9917,1.9917,0,0,0-1.8652-.1352L4,7.4727V2H2V28a2,2,0,0,0,2,2H30V28H4V23.6577ZM28,21.2344l-6.4966,1.75-8.0371-4.68a1.9931,1.9931,0,0,0-1.8652-.1353L4,21.4746V16.6572l8.4326-3.6416L20.47,17.6968a1.962,1.962,0,0,0,1.0508.3008,2.2112,2.2112,0,0,0,.4888-.0557L28,16.31ZM12.4326,6.0156l8.0376,4.68a2.0091,2.0091,0,0,0,1.54.2451L28,9.3081v4.9258l-6.4966,1.7505-8.0371-4.6812a1.9917,1.9917,0,0,0-1.8652-.1352L4,14.4736V9.6562Z"
    }
  }]);

  const ChartRiver24 = createSVGComponent('ChartRiver24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12.4326,20.0171l8.0376,4.68a1.958,1.958,0,0,0,1.0508.3012,2.2412,2.2412,0,0,0,.4888-.0556l7.2532-1.9769A1,1,0,0,0,30,22.0007V7.996A1,1,0,0,0,28.74,7.0305L21.5034,8.9829l-8.0371-4.68a1.9917,1.9917,0,0,0-1.8652-.1352L4,7.4727V2H2V28a2,2,0,0,0,2,2H30V28H4V23.6577ZM28,21.2344l-6.4966,1.75-8.0371-4.68a1.9931,1.9931,0,0,0-1.8652-.1353L4,21.4746V16.6572l8.4326-3.6416L20.47,17.6968a1.962,1.962,0,0,0,1.0508.3008,2.2112,2.2112,0,0,0,.4888-.0557L28,16.31ZM12.4326,6.0156l8.0376,4.68a2.0091,2.0091,0,0,0,1.54.2451L28,9.3081v4.9258l-6.4966,1.7505-8.0371-4.6812a1.9917,1.9917,0,0,0-1.8652-.1352L4,14.4736V9.6562Z"
    }
  }]);

  const ChartRiver20 = createSVGComponent('ChartRiver20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12.4326,20.0171l8.0376,4.68a1.958,1.958,0,0,0,1.0508.3012,2.2412,2.2412,0,0,0,.4888-.0556l7.2532-1.9769A1,1,0,0,0,30,22.0007V7.996A1,1,0,0,0,28.74,7.0305L21.5034,8.9829l-8.0371-4.68a1.9917,1.9917,0,0,0-1.8652-.1352L4,7.4727V2H2V28a2,2,0,0,0,2,2H30V28H4V23.6577ZM28,21.2344l-6.4966,1.75-8.0371-4.68a1.9931,1.9931,0,0,0-1.8652-.1353L4,21.4746V16.6572l8.4326-3.6416L20.47,17.6968a1.962,1.962,0,0,0,1.0508.3008,2.2112,2.2112,0,0,0,.4888-.0557L28,16.31ZM12.4326,6.0156l8.0376,4.68a2.0091,2.0091,0,0,0,1.54.2451L28,9.3081v4.9258l-6.4966,1.7505-8.0371-4.6812a1.9917,1.9917,0,0,0-1.8652-.1352L4,14.4736V9.6562Z"
    }
  }]);

  const ChartRiver16 = createSVGComponent('ChartRiver16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12.4326,20.0171l8.0376,4.68a1.958,1.958,0,0,0,1.0508.3012,2.2412,2.2412,0,0,0,.4888-.0556l7.2532-1.9769A1,1,0,0,0,30,22.0007V7.996A1,1,0,0,0,28.74,7.0305L21.5034,8.9829l-8.0371-4.68a1.9917,1.9917,0,0,0-1.8652-.1352L4,7.4727V2H2V28a2,2,0,0,0,2,2H30V28H4V23.6577ZM28,21.2344l-6.4966,1.75-8.0371-4.68a1.9931,1.9931,0,0,0-1.8652-.1353L4,21.4746V16.6572l8.4326-3.6416L20.47,17.6968a1.962,1.962,0,0,0,1.0508.3008,2.2112,2.2112,0,0,0,.4888-.0557L28,16.31ZM12.4326,6.0156l8.0376,4.68a2.0091,2.0091,0,0,0,1.54.2451L28,9.3081v4.9258l-6.4966,1.7505-8.0371-4.6812a1.9917,1.9917,0,0,0-1.8652-.1352L4,14.4736V9.6562Z"
    }
  }]);

  const ChartRose32 = createSVGComponent('ChartRose32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,17A15.017,15.017,0,0,0,15,2H14V8.0591A9.0122,9.0122,0,0,0,6.0591,16H4v1A11.0109,11.0109,0,0,0,14,27.9492V30h1A13.0084,13.0084,0,0,0,27.9492,18H30ZM16,4.0381A13.0217,13.0217,0,0,1,27.9619,16H16ZM14,10.08V16H8.08A7.0037,7.0037,0,0,1,14,10.08ZM6.0552,18H14v7.939A9.0134,9.0134,0,0,1,6.0552,18ZM16,27.9551V18h9.9551A11.0191,11.0191,0,0,1,16,27.9551Z"
    }
  }]);

  const ChartRose24 = createSVGComponent('ChartRose24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,17A15.017,15.017,0,0,0,15,2H14V8.0591A9.0122,9.0122,0,0,0,6.0591,16H4v1A11.0109,11.0109,0,0,0,14,27.9492V30h1A13.0084,13.0084,0,0,0,27.9492,18H30ZM16,4.0381A13.0217,13.0217,0,0,1,27.9619,16H16ZM14,10.08V16H8.08A7.0037,7.0037,0,0,1,14,10.08ZM6.0552,18H14v7.939A9.0134,9.0134,0,0,1,6.0552,18ZM16,27.9551V18h9.9551A11.0191,11.0191,0,0,1,16,27.9551Z"
    }
  }]);

  const ChartRose20 = createSVGComponent('ChartRose20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,17A15.017,15.017,0,0,0,15,2H14V8.0591A9.0122,9.0122,0,0,0,6.0591,16H4v1A11.0109,11.0109,0,0,0,14,27.9492V30h1A13.0084,13.0084,0,0,0,27.9492,18H30ZM16,4.0381A13.0217,13.0217,0,0,1,27.9619,16H16ZM14,10.08V16H8.08A7.0037,7.0037,0,0,1,14,10.08ZM6.0552,18H14v7.939A9.0134,9.0134,0,0,1,6.0552,18ZM16,27.9551V18h9.9551A11.0191,11.0191,0,0,1,16,27.9551Z"
    }
  }]);

  const ChartRose16 = createSVGComponent('ChartRose16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,17A15.017,15.017,0,0,0,15,2H14V8.0591A9.0122,9.0122,0,0,0,6.0591,16H4v1A11.0109,11.0109,0,0,0,14,27.9492V30h1A13.0084,13.0084,0,0,0,27.9492,18H30ZM16,4.0381A13.0217,13.0217,0,0,1,27.9619,16H16ZM14,10.08V16H8.08A7.0037,7.0037,0,0,1,14,10.08ZM6.0552,18H14v7.939A9.0134,9.0134,0,0,1,6.0552,18ZM16,27.9551V18h9.9551A11.0191,11.0191,0,0,1,16,27.9551Z"
    }
  }]);

  const ChartScatter32 = createSVGComponent('ChartScatter32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "8",
      "r": "2"
    }
  }]);

  const ChartScatter24 = createSVGComponent('ChartScatter24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "8",
      "r": "2"
    }
  }]);

  const ChartScatter20 = createSVGComponent('ChartScatter20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "8",
      "r": "2"
    }
  }]);

  const ChartScatter16 = createSVGComponent('ChartScatter16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "15",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "14",
      "cy": "8",
      "r": "2"
    }
  }]);

  const ChartSpiral32 = createSVGComponent('ChartSpiral32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A13.919,13.919,0,0,0,7.3245,5.0327,1.9728,1.9728,0,0,0,7,5,2,2,0,0,0,5,7a1.9752,1.9752,0,0,0,.0327.3247A13.986,13.986,0,1,0,16,2Zm0,26A11.977,11.977,0,0,1,6.3589,8.8857a1.8311,1.8311,0,0,0,1.1528.04l1.4634,1.4634a8.9862,8.9862,0,0,0,11.8311,13.207,1.9916,1.9916,0,0,0,2.79-2.79,8.9294,8.9294,0,0,0,0-9.6124,1.9916,1.9916,0,0,0-2.79-2.79,8.9445,8.9445,0,0,0-10.417.5713L8.9258,7.5117a1.8294,1.8294,0,0,0-.04-1.1528A11.9925,11.9925,0,1,1,16,28Zm0-14a2,2,0,1,1-2,2A2.0025,2.0025,0,0,1,16,14Zm3.4331-.019,2.0552-2.0552a2.0443,2.0443,0,0,0,.2265.0454,6.9573,6.9573,0,0,1,0,8.0576,2.0443,2.0443,0,0,0-.2265.0454L19.4331,18.019a3.8788,3.8788,0,0,0,0-4.038Zm.5957-3.6958a1.9993,1.9993,0,0,0,.0454.2265L18.019,12.5669a3.8788,3.8788,0,0,0-4.038,0l-2.1653-2.1655a6.9522,6.9522,0,0,1,8.2131-.1162ZM12.5669,13.981A3.951,3.951,0,0,0,12,16a4.0045,4.0045,0,0,0,4,4,3.9521,3.9521,0,0,0,2.019-.5669l2.0552,2.0552a1.9993,1.9993,0,0,0-.0454.2265,6.988,6.988,0,0,1-9.6272-9.8994Z"
    }
  }]);

  const ChartSpiral24 = createSVGComponent('ChartSpiral24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A13.919,13.919,0,0,0,7.3245,5.0327,1.9728,1.9728,0,0,0,7,5,2,2,0,0,0,5,7a1.9752,1.9752,0,0,0,.0327.3247A13.986,13.986,0,1,0,16,2Zm0,26A11.977,11.977,0,0,1,6.3589,8.8857a1.8311,1.8311,0,0,0,1.1528.04l1.4634,1.4634a8.9862,8.9862,0,0,0,11.8311,13.207,1.9916,1.9916,0,0,0,2.79-2.79,8.9294,8.9294,0,0,0,0-9.6124,1.9916,1.9916,0,0,0-2.79-2.79,8.9445,8.9445,0,0,0-10.417.5713L8.9258,7.5117a1.8294,1.8294,0,0,0-.04-1.1528A11.9925,11.9925,0,1,1,16,28Zm0-14a2,2,0,1,1-2,2A2.0025,2.0025,0,0,1,16,14Zm3.4331-.019,2.0552-2.0552a2.0443,2.0443,0,0,0,.2265.0454,6.9573,6.9573,0,0,1,0,8.0576,2.0443,2.0443,0,0,0-.2265.0454L19.4331,18.019a3.8788,3.8788,0,0,0,0-4.038Zm.5957-3.6958a1.9993,1.9993,0,0,0,.0454.2265L18.019,12.5669a3.8788,3.8788,0,0,0-4.038,0l-2.1653-2.1655a6.9522,6.9522,0,0,1,8.2131-.1162ZM12.5669,13.981A3.951,3.951,0,0,0,12,16a4.0045,4.0045,0,0,0,4,4,3.9521,3.9521,0,0,0,2.019-.5669l2.0552,2.0552a1.9993,1.9993,0,0,0-.0454.2265,6.988,6.988,0,0,1-9.6272-9.8994Z"
    }
  }]);

  const ChartSpiral20 = createSVGComponent('ChartSpiral20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A13.919,13.919,0,0,0,7.3245,5.0327,1.9728,1.9728,0,0,0,7,5,2,2,0,0,0,5,7a1.9752,1.9752,0,0,0,.0327.3247A13.986,13.986,0,1,0,16,2Zm0,26A11.977,11.977,0,0,1,6.3589,8.8857a1.8311,1.8311,0,0,0,1.1528.04l1.4634,1.4634a8.9862,8.9862,0,0,0,11.8311,13.207,1.9916,1.9916,0,0,0,2.79-2.79,8.9294,8.9294,0,0,0,0-9.6124,1.9916,1.9916,0,0,0-2.79-2.79,8.9445,8.9445,0,0,0-10.417.5713L8.9258,7.5117a1.8294,1.8294,0,0,0-.04-1.1528A11.9925,11.9925,0,1,1,16,28Zm0-14a2,2,0,1,1-2,2A2.0025,2.0025,0,0,1,16,14Zm3.4331-.019,2.0552-2.0552a2.0443,2.0443,0,0,0,.2265.0454,6.9573,6.9573,0,0,1,0,8.0576,2.0443,2.0443,0,0,0-.2265.0454L19.4331,18.019a3.8788,3.8788,0,0,0,0-4.038Zm.5957-3.6958a1.9993,1.9993,0,0,0,.0454.2265L18.019,12.5669a3.8788,3.8788,0,0,0-4.038,0l-2.1653-2.1655a6.9522,6.9522,0,0,1,8.2131-.1162ZM12.5669,13.981A3.951,3.951,0,0,0,12,16a4.0045,4.0045,0,0,0,4,4,3.9521,3.9521,0,0,0,2.019-.5669l2.0552,2.0552a1.9993,1.9993,0,0,0-.0454.2265,6.988,6.988,0,0,1-9.6272-9.8994Z"
    }
  }]);

  const ChartSpiral16 = createSVGComponent('ChartSpiral16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A13.919,13.919,0,0,0,7.3245,5.0327,1.9728,1.9728,0,0,0,7,5,2,2,0,0,0,5,7a1.9752,1.9752,0,0,0,.0327.3247A13.986,13.986,0,1,0,16,2Zm0,26A11.977,11.977,0,0,1,6.3589,8.8857a1.8311,1.8311,0,0,0,1.1528.04l1.4634,1.4634a8.9862,8.9862,0,0,0,11.8311,13.207,1.9916,1.9916,0,0,0,2.79-2.79,8.9294,8.9294,0,0,0,0-9.6124,1.9916,1.9916,0,0,0-2.79-2.79,8.9445,8.9445,0,0,0-10.417.5713L8.9258,7.5117a1.8294,1.8294,0,0,0-.04-1.1528A11.9925,11.9925,0,1,1,16,28Zm0-14a2,2,0,1,1-2,2A2.0025,2.0025,0,0,1,16,14Zm3.4331-.019,2.0552-2.0552a2.0443,2.0443,0,0,0,.2265.0454,6.9573,6.9573,0,0,1,0,8.0576,2.0443,2.0443,0,0,0-.2265.0454L19.4331,18.019a3.8788,3.8788,0,0,0,0-4.038Zm.5957-3.6958a1.9993,1.9993,0,0,0,.0454.2265L18.019,12.5669a3.8788,3.8788,0,0,0-4.038,0l-2.1653-2.1655a6.9522,6.9522,0,0,1,8.2131-.1162ZM12.5669,13.981A3.951,3.951,0,0,0,12,16a4.0045,4.0045,0,0,0,4,4,3.9521,3.9521,0,0,0,2.019-.5669l2.0552,2.0552a1.9993,1.9993,0,0,0-.0454.2265,6.988,6.988,0,0,1-9.6272-9.8994Z"
    }
  }]);

  const ChartStacked32 = createSVGComponent('ChartStacked32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V6H20V28H16V14H8V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM22,8h4V18H22ZM10,16h4v6H10Z"
    }
  }]);

  const ChartStacked24 = createSVGComponent('ChartStacked24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V6H20V28H16V14H8V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM22,8h4V18H22ZM10,16h4v6H10Z"
    }
  }]);

  const ChartStacked20 = createSVGComponent('ChartStacked20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V6H20V28H16V14H8V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM22,8h4V18H22ZM10,16h4v6H10Z"
    }
  }]);

  const ChartStacked16 = createSVGComponent('ChartStacked16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V6H20V28H16V14H8V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM22,8h4V18H22ZM10,16h4v6H10Z"
    }
  }]);

  const ChartStepper32 = createSVGComponent('ChartStepper32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,22V14h8V6h8V4H20v8H12v8H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H4V22Z"
    }
  }]);

  const ChartStepper24 = createSVGComponent('ChartStepper24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,22V14h8V6h8V4H20v8H12v8H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H4V22Z"
    }
  }]);

  const ChartStepper20 = createSVGComponent('ChartStepper20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,22V14h8V6h8V4H20v8H12v8H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H4V22Z"
    }
  }]);

  const ChartStepper16 = createSVGComponent('ChartStepper16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,22V14h8V6h8V4H20v8H12v8H4V2H2V28a2.0025,2.0025,0,0,0,2,2H30V28H4V22Z"
    }
  }]);

  const ChartSunburst32 = createSVGComponent('ChartSunburst32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2a1,1,0,0,0-1,1v7.09a5.9618,5.9618,0,0,0-2.46,1.043L7.8384,6.4311a1.4554,1.4554,0,0,0-2.087.0244A14.05,14.05,0,0,0,9.8047,28.5972a10.8482,10.8482,0,0,0,1.8989.7676,14.0982,14.0982,0,0,0,13.8443-3.1319,1.4336,1.4336,0,0,0,.0278-2.0639L20.877,19.47A5.963,5.963,0,0,0,21.91,17H29a1,1,0,0,0,1-1A14.0158,14.0158,0,0,0,16,2Zm0,10a4,4,0,1,1-4,4A4.0045,4.0045,0,0,1,16,12ZM6.83,8.251l4.2959,4.2959a5.91,5.91,0,0,0-.0113,6.9243L6.8381,23.7481A12.0168,12.0168,0,0,1,6.83,8.251Zm1.4228,16.91,4.2759-4.2759A5.9589,5.9589,0,0,0,15,21.91v6.042A11.8783,11.8783,0,0,1,8.2529,25.1612ZM17,27.9561V21.9092a5.9631,5.9631,0,0,0,2.4609-1.0273l4.2818,4.2817A11.8905,11.8905,0,0,1,17,27.9561ZM21.91,15A6.0063,6.0063,0,0,0,17,10.09V4.041A12.0208,12.0208,0,0,1,27.9585,15Z"
    }
  }]);

  const ChartSunburst24 = createSVGComponent('ChartSunburst24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2a1,1,0,0,0-1,1v7.09a5.9618,5.9618,0,0,0-2.46,1.043L7.8384,6.4311a1.4554,1.4554,0,0,0-2.087.0244A14.05,14.05,0,0,0,9.8047,28.5972a10.8482,10.8482,0,0,0,1.8989.7676,14.0982,14.0982,0,0,0,13.8443-3.1319,1.4336,1.4336,0,0,0,.0278-2.0639L20.877,19.47A5.963,5.963,0,0,0,21.91,17H29a1,1,0,0,0,1-1A14.0158,14.0158,0,0,0,16,2Zm0,10a4,4,0,1,1-4,4A4.0045,4.0045,0,0,1,16,12ZM6.83,8.251l4.2959,4.2959a5.91,5.91,0,0,0-.0113,6.9243L6.8381,23.7481A12.0168,12.0168,0,0,1,6.83,8.251Zm1.4228,16.91,4.2759-4.2759A5.9589,5.9589,0,0,0,15,21.91v6.042A11.8783,11.8783,0,0,1,8.2529,25.1612ZM17,27.9561V21.9092a5.9631,5.9631,0,0,0,2.4609-1.0273l4.2818,4.2817A11.8905,11.8905,0,0,1,17,27.9561ZM21.91,15A6.0063,6.0063,0,0,0,17,10.09V4.041A12.0208,12.0208,0,0,1,27.9585,15Z"
    }
  }]);

  const ChartSunburst20 = createSVGComponent('ChartSunburst20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2a1,1,0,0,0-1,1v7.09a5.9618,5.9618,0,0,0-2.46,1.043L7.8384,6.4311a1.4554,1.4554,0,0,0-2.087.0244A14.05,14.05,0,0,0,9.8047,28.5972a10.8482,10.8482,0,0,0,1.8989.7676,14.0982,14.0982,0,0,0,13.8443-3.1319,1.4336,1.4336,0,0,0,.0278-2.0639L20.877,19.47A5.963,5.963,0,0,0,21.91,17H29a1,1,0,0,0,1-1A14.0158,14.0158,0,0,0,16,2Zm0,10a4,4,0,1,1-4,4A4.0045,4.0045,0,0,1,16,12ZM6.83,8.251l4.2959,4.2959a5.91,5.91,0,0,0-.0113,6.9243L6.8381,23.7481A12.0168,12.0168,0,0,1,6.83,8.251Zm1.4228,16.91,4.2759-4.2759A5.9589,5.9589,0,0,0,15,21.91v6.042A11.8783,11.8783,0,0,1,8.2529,25.1612ZM17,27.9561V21.9092a5.9631,5.9631,0,0,0,2.4609-1.0273l4.2818,4.2817A11.8905,11.8905,0,0,1,17,27.9561ZM21.91,15A6.0063,6.0063,0,0,0,17,10.09V4.041A12.0208,12.0208,0,0,1,27.9585,15Z"
    }
  }]);

  const ChartSunburst16 = createSVGComponent('ChartSunburst16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2a1,1,0,0,0-1,1v7.09a5.9618,5.9618,0,0,0-2.46,1.043L7.8384,6.4311a1.4554,1.4554,0,0,0-2.087.0244A14.05,14.05,0,0,0,9.8047,28.5972a10.8482,10.8482,0,0,0,1.8989.7676,14.0982,14.0982,0,0,0,13.8443-3.1319,1.4336,1.4336,0,0,0,.0278-2.0639L20.877,19.47A5.963,5.963,0,0,0,21.91,17H29a1,1,0,0,0,1-1A14.0158,14.0158,0,0,0,16,2Zm0,10a4,4,0,1,1-4,4A4.0045,4.0045,0,0,1,16,12ZM6.83,8.251l4.2959,4.2959a5.91,5.91,0,0,0-.0113,6.9243L6.8381,23.7481A12.0168,12.0168,0,0,1,6.83,8.251Zm1.4228,16.91,4.2759-4.2759A5.9589,5.9589,0,0,0,15,21.91v6.042A11.8783,11.8783,0,0,1,8.2529,25.1612ZM17,27.9561V21.9092a5.9631,5.9631,0,0,0,2.4609-1.0273l4.2818,4.2817A11.8905,11.8905,0,0,1,17,27.9561ZM21.91,15A6.0063,6.0063,0,0,0,17,10.09V4.041A12.0208,12.0208,0,0,1,27.9585,15Z"
    }
  }]);

  const ChartTSne32 = createSVGComponent('ChartTSne32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "12",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "16",
      "r": "2"
    }
  }]);

  const ChartTSne24 = createSVGComponent('ChartTSne24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "12",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "16",
      "r": "2"
    }
  }]);

  const ChartTSne20 = createSVGComponent('ChartTSne20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "12",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "16",
      "r": "2"
    }
  }]);

  const ChartTSne16 = createSVGComponent('ChartTSne16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "10",
      "cy": "14",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "6",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "12",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "26",
      "cy": "28",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "20",
      "cy": "26",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "22",
      "cy": "20",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "4",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "24",
      "r": "2"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "16",
      "r": "2"
    }
  }]);

  const ChartTreemap32 = createSVGComponent('ChartTreemap32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H4A2.0023,2.0023,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,12H23V4h5ZM16,4h5V14H16ZM14,4V20H4V4ZM4,22H14v6H4Zm12,6V16H28V28Z"
    }
  }]);

  const ChartTreemap24 = createSVGComponent('ChartTreemap24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H4A2.0023,2.0023,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,12H23V4h5ZM16,4h5V14H16ZM14,4V20H4V4ZM4,22H14v6H4Zm12,6V16H28V28Z"
    }
  }]);

  const ChartTreemap20 = createSVGComponent('ChartTreemap20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H4A2.0023,2.0023,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,12H23V4h5ZM16,4h5V14H16ZM14,4V20H4V4ZM4,22H14v6H4Zm12,6V16H28V28Z"
    }
  }]);

  const ChartTreemap16 = createSVGComponent('ChartTreemap16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,2H4A2.0023,2.0023,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0023,2.0023,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,12H23V4h5ZM16,4h5V14H16ZM14,4V20H4V4ZM4,22H14v6H4Zm12,6V16H28V28Z"
    }
  }]);

  const ChartVennDiagram32 = createSVGComponent('ChartVennDiagram32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"
    }
  }]);

  const ChartVennDiagram24 = createSVGComponent('ChartVennDiagram24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"
    }
  }]);

  const ChartVennDiagram20 = createSVGComponent('ChartVennDiagram20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"
    }
  }]);

  const ChartVennDiagram16 = createSVGComponent('ChartVennDiagram16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"
    }
  }]);

  const ChartViolinPlot32 = createSVGComponent('ChartViolinPlot32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.86 7.8232L13 4.7231V2H11V4.7231l-1.86 3.1A7.9986 7.9986 0 008 11.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V19.2769l1.86-3.1A7.9986 7.9986 0 0016 12.061v-.122A7.9961 7.9961 0 0014.86 7.8232zM12 6.9434l1.145 1.9087A6.0027 6.0027 0 0113.9185 11h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0110.0815 13h3.837a6.0086 6.0086 0 01-.7735 2.1484zM27.86 11.8232L26 8.7231V2H24V8.7231l-1.86 3.1A7.9986 7.9986 0 0021 15.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V23.2769l1.86-3.1A7.9986 7.9986 0 0029 16.061v-.122A7.9961 7.9961 0 0027.86 11.8232zm-2.86-.88l1.145 1.9087A6.0027 6.0027 0 0126.9185 15h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0123.0815 17h3.837a6.0086 6.0086 0 01-.7735 2.1484z"
    }
  }]);

  const ChartViolinPlot24 = createSVGComponent('ChartViolinPlot24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.86 7.8232L13 4.7231V2H11V4.7231l-1.86 3.1A7.9986 7.9986 0 008 11.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V19.2769l1.86-3.1A7.9986 7.9986 0 0016 12.061v-.122A7.9961 7.9961 0 0014.86 7.8232zM12 6.9434l1.145 1.9087A6.0027 6.0027 0 0113.9185 11h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0110.0815 13h3.837a6.0086 6.0086 0 01-.7735 2.1484zM27.86 11.8232L26 8.7231V2H24V8.7231l-1.86 3.1A7.9986 7.9986 0 0021 15.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V23.2769l1.86-3.1A7.9986 7.9986 0 0029 16.061v-.122A7.9961 7.9961 0 0027.86 11.8232zm-2.86-.88l1.145 1.9087A6.0027 6.0027 0 0126.9185 15h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0123.0815 17h3.837a6.0086 6.0086 0 01-.7735 2.1484z"
    }
  }]);

  const ChartViolinPlot20 = createSVGComponent('ChartViolinPlot20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.86 7.8232L13 4.7231V2H11V4.7231l-1.86 3.1A7.9986 7.9986 0 008 11.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V19.2769l1.86-3.1A7.9986 7.9986 0 0016 12.061v-.122A7.9961 7.9961 0 0014.86 7.8232zM12 6.9434l1.145 1.9087A6.0027 6.0027 0 0113.9185 11h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0110.0815 13h3.837a6.0086 6.0086 0 01-.7735 2.1484zM27.86 11.8232L26 8.7231V2H24V8.7231l-1.86 3.1A7.9986 7.9986 0 0021 15.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V23.2769l1.86-3.1A7.9986 7.9986 0 0029 16.061v-.122A7.9961 7.9961 0 0027.86 11.8232zm-2.86-.88l1.145 1.9087A6.0027 6.0027 0 0126.9185 15h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0123.0815 17h3.837a6.0086 6.0086 0 01-.7735 2.1484z"
    }
  }]);

  const ChartViolinPlot16 = createSVGComponent('ChartViolinPlot16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14.86 7.8232L13 4.7231V2H11V4.7231l-1.86 3.1A7.9986 7.9986 0 008 11.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V19.2769l1.86-3.1A7.9986 7.9986 0 0016 12.061v-.122A7.9961 7.9961 0 0014.86 7.8232zM12 6.9434l1.145 1.9087A6.0027 6.0027 0 0113.9185 11h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0110.0815 13h3.837a6.0086 6.0086 0 01-.7735 2.1484zM27.86 11.8232L26 8.7231V2H24V8.7231l-1.86 3.1A7.9986 7.9986 0 0021 15.939v.122a7.9961 7.9961 0 001.14 4.1158l1.86 3.1V26h2V23.2769l1.86-3.1A7.9986 7.9986 0 0029 16.061v-.122A7.9961 7.9961 0 0027.86 11.8232zm-2.86-.88l1.145 1.9087A6.0027 6.0027 0 0126.9185 15h-3.837a6.0086 6.0086 0 01.7735-2.1484zm0 10.1132l-1.145-1.9087A6.0027 6.0027 0 0123.0815 17h3.837a6.0086 6.0086 0 01-.7735 2.1484z"
    }
  }]);

  const ChartWaterfall32 = createSVGComponent('ChartWaterfall32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V18H26V28H22V4H20V28H10V14H8V28H4V2H2V28a2.0023,2.0023,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 4H16V18H14z"
    }
  }]);

  const ChartWaterfall24 = createSVGComponent('ChartWaterfall24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V18H26V28H22V4H20V28H10V14H8V28H4V2H2V28a2.0023,2.0023,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 4H16V18H14z"
    }
  }]);

  const ChartWaterfall20 = createSVGComponent('ChartWaterfall20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V18H26V28H22V4H20V28H10V14H8V28H4V2H2V28a2.0023,2.0023,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 4H16V18H14z"
    }
  }]);

  const ChartWaterfall16 = createSVGComponent('ChartWaterfall16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28,28V18H26V28H22V4H20V28H10V14H8V28H4V2H2V28a2.0023,2.0023,0,0,0,2,2H30V28Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 4H16V18H14z"
    }
  }]);

  const ChartWinLoss32 = createSVGComponent('ChartWinLoss32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H16V6a2.0023,2.0023,0,0,0-2-2H6A2.0023,2.0023,0,0,0,4,6v9H2v2H16v9a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V17h2ZM6,6h8v9H6ZM26,26H18V17h8Z"
    }
  }]);

  const ChartWinLoss24 = createSVGComponent('ChartWinLoss24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H16V6a2.0023,2.0023,0,0,0-2-2H6A2.0023,2.0023,0,0,0,4,6v9H2v2H16v9a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V17h2ZM6,6h8v9H6ZM26,26H18V17h8Z"
    }
  }]);

  const ChartWinLoss20 = createSVGComponent('ChartWinLoss20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H16V6a2.0023,2.0023,0,0,0-2-2H6A2.0023,2.0023,0,0,0,4,6v9H2v2H16v9a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V17h2ZM6,6h8v9H6ZM26,26H18V17h8Z"
    }
  }]);

  const ChartWinLoss16 = createSVGComponent('ChartWinLoss16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,15H16V6a2.0023,2.0023,0,0,0-2-2H6A2.0023,2.0023,0,0,0,4,6v9H2v2H16v9a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V17h2ZM6,6h8v9H6ZM26,26H18V17h8Z"
    }
  }]);

  const Chat32 = createSVGComponent('Chat32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H24V12H8zM8 16H18V18H8z"
    }
  }]);

  const Chat24 = createSVGComponent('Chat24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H24V12H8zM8 16H18V18H8z"
    }
  }]);

  const Chat20 = createSVGComponent('Chat20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H24V12H8zM8 16H18V18H8z"
    }
  }]);

  const Chat16 = createSVGComponent('Chat16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M8 10H24V12H8zM8 16H18V18H8z"
    }
  }]);

  const ChatLaunch32 = createSVGComponent('ChatLaunch32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4zM28 16v4a1.9965 1.9965 0 01-2 2H20l-4 7 1.7358 1 3.4288-6H26a3.9992 3.9992 0 004-4V16zM4 20V8A1.9965 1.9965 0 016 6H18V4H6A3.9986 3.9986 0 002 8V20a3.9992 3.9992 0 004 4h9V22H6A1.9965 1.9965 0 014 20z"
    }
  }]);

  const ChatLaunch24 = createSVGComponent('ChatLaunch24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4zM28 16v4a1.9965 1.9965 0 01-2 2H20l-4 7 1.7358 1 3.4288-6H26a3.9992 3.9992 0 004-4V16zM4 20V8A1.9965 1.9965 0 016 6H18V4H6A3.9986 3.9986 0 002 8V20a3.9992 3.9992 0 004 4h9V22H6A1.9965 1.9965 0 014 20z"
    }
  }]);

  const ChatLaunch20 = createSVGComponent('ChatLaunch20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4zM28 16v4a1.9965 1.9965 0 01-2 2H20l-4 7 1.7358 1 3.4288-6H26a3.9992 3.9992 0 004-4V16zM4 20V8A1.9965 1.9965 0 016 6H18V4H6A3.9986 3.9986 0 002 8V20a3.9992 3.9992 0 004 4h9V22H6A1.9965 1.9965 0 014 20z"
    }
  }]);

  const ChatLaunch16 = createSVGComponent('ChatLaunch16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 4L22 6 26.586 6 20 12.586 21.414 14 28 7.414 28 12 30 12 30 4 22 4zM28 16v4a1.9965 1.9965 0 01-2 2H20l-4 7 1.7358 1 3.4288-6H26a3.9992 3.9992 0 004-4V16zM4 20V8A1.9965 1.9965 0 016 6H18V4H6A3.9986 3.9986 0 002 8V20a3.9992 3.9992 0 004 4h9V22H6A1.9965 1.9965 0 014 20z"
    }
  }]);

  const ChatOff32 = createSVGComponent('ChatOff32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 8V21h2V8a3.9986 3.9986 0 00-4-4H8.2429l2 2H26A1.9965 1.9965 0 0128 8zM30 28.5859L3.4141 2 2 3.4141 3.5039 4.918A3.9181 3.9181 0 002 8V20a3.9992 3.9992 0 004 4h6V22H6a1.9965 1.9965 0 01-2-2V8a1.9814 1.9814 0 01.9194-1.6665L20.5859 22H17l-4 7 1.7358 1 3.4288-6h4.4213l6 6z"
    }
  }]);

  const ChatOff24 = createSVGComponent('ChatOff24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 8V21h2V8a3.9986 3.9986 0 00-4-4H8.2429l2 2H26A1.9965 1.9965 0 0128 8zM30 28.5859L3.4141 2 2 3.4141 3.5039 4.918A3.9181 3.9181 0 002 8V20a3.9992 3.9992 0 004 4h6V22H6a1.9965 1.9965 0 01-2-2V8a1.9814 1.9814 0 01.9194-1.6665L20.5859 22H17l-4 7 1.7358 1 3.4288-6h4.4213l6 6z"
    }
  }]);

  const ChatOff20 = createSVGComponent('ChatOff20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 8V21h2V8a3.9986 3.9986 0 00-4-4H8.2429l2 2H26A1.9965 1.9965 0 0128 8zM30 28.5859L3.4141 2 2 3.4141 3.5039 4.918A3.9181 3.9181 0 002 8V20a3.9992 3.9992 0 004 4h6V22H6a1.9965 1.9965 0 01-2-2V8a1.9814 1.9814 0 01.9194-1.6665L20.5859 22H17l-4 7 1.7358 1 3.4288-6h4.4213l6 6z"
    }
  }]);

  const ChatOff16 = createSVGComponent('ChatOff16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 8V21h2V8a3.9986 3.9986 0 00-4-4H8.2429l2 2H26A1.9965 1.9965 0 0128 8zM30 28.5859L3.4141 2 2 3.4141 3.5039 4.918A3.9181 3.9181 0 002 8V20a3.9992 3.9992 0 004 4h6V22H6a1.9965 1.9965 0 01-2-2V8a1.9814 1.9814 0 01.9194-1.6665L20.5859 22H17l-4 7 1.7358 1 3.4288-6h4.4213l6 6z"
    }
  }]);

  const ChatOperational32 = createSVGComponent('ChatOperational32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15.586 10.414L19.166 14 19.166 14 15.584 17.587 17 19 22 14 17 9 15.586 10.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.586 10.414L24.166 14 24.166 14 20.584 17.587 22 19 27 14 22 9 20.586 10.414zM10 9L11.593 12 15 12.414 12.5 14.667 13 18 10 16.125 7 18 7.5 14.667 5 12.414 8.5 12 10 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatOperational24 = createSVGComponent('ChatOperational24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15.586 10.414L19.166 14 19.166 14 15.584 17.587 17 19 22 14 17 9 15.586 10.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.586 10.414L24.166 14 24.166 14 20.584 17.587 22 19 27 14 22 9 20.586 10.414zM10 9L11.593 12 15 12.414 12.5 14.667 13 18 10 16.125 7 18 7.5 14.667 5 12.414 8.5 12 10 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatOperational20 = createSVGComponent('ChatOperational20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15.586 10.414L19.166 14 19.166 14 15.584 17.587 17 19 22 14 17 9 15.586 10.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.586 10.414L24.166 14 24.166 14 20.584 17.587 22 19 27 14 22 9 20.586 10.414zM10 9L11.593 12 15 12.414 12.5 14.667 13 18 10 16.125 7 18 7.5 14.667 5 12.414 8.5 12 10 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatOperational16 = createSVGComponent('ChatOperational16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15.586 10.414L19.166 14 19.166 14 15.584 17.587 17 19 22 14 17 9 15.586 10.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20.586 10.414L24.166 14 24.166 14 20.584 17.587 22 19 27 14 22 9 20.586 10.414zM10 9L11.593 12 15 12.414 12.5 14.667 13 18 10 16.125 7 18 7.5 14.667 5 12.414 8.5 12 10 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatBot32 = createSVGComponent('ChatBot32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 19a6.9908 6.9908 0 01-5.833-3.1287l1.666-1.1074a5.0007 5.0007 0 008.334 0l1.666 1.1074A6.9908 6.9908 0 0116 19zM20 8a2 2 0 102 2A1.9806 1.9806 0 0020 8zM12 8a2 2 0 102 2A1.9806 1.9806 0 0012 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatBot24 = createSVGComponent('ChatBot24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 19a6.9908 6.9908 0 01-5.833-3.1287l1.666-1.1074a5.0007 5.0007 0 008.334 0l1.666 1.1074A6.9908 6.9908 0 0116 19zM20 8a2 2 0 102 2A1.9806 1.9806 0 0020 8zM12 8a2 2 0 102 2A1.9806 1.9806 0 0012 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatBot20 = createSVGComponent('ChatBot20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 19a6.9908 6.9908 0 01-5.833-3.1287l1.666-1.1074a5.0007 5.0007 0 008.334 0l1.666 1.1074A6.9908 6.9908 0 0116 19zM20 8a2 2 0 102 2A1.9806 1.9806 0 0020 8zM12 8a2 2 0 102 2A1.9806 1.9806 0 0012 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const ChatBot16 = createSVGComponent('ChatBot16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 19a6.9908 6.9908 0 01-5.833-3.1287l1.666-1.1074a5.0007 5.0007 0 008.334 0l1.666 1.1074A6.9908 6.9908 0 0116 19zM20 8a2 2 0 102 2A1.9806 1.9806 0 0020 8zM12 8a2 2 0 102 2A1.9806 1.9806 0 0012 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"
    }
  }]);

  const Checkbox32 = createSVGComponent('Checkbox32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const Checkbox24 = createSVGComponent('Checkbox24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const Checkbox20 = createSVGComponent('Checkbox20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const Checkbox16 = createSVGComponent('Checkbox16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CheckboxChecked32 = createSVGComponent('CheckboxChecked32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21.5L9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5z"
    }
  }]);

  const CheckboxChecked24 = createSVGComponent('CheckboxChecked24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21.5L9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5z"
    }
  }]);

  const CheckboxChecked20 = createSVGComponent('CheckboxChecked20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21.5L9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5z"
    }
  }]);

  const CheckboxChecked16 = createSVGComponent('CheckboxChecked16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14 21.5L9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5z"
    }
  }]);

  const CheckboxCheckedFilled32 = createSVGComponent('CheckboxCheckedFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxCheckedFilled24 = createSVGComponent('CheckboxCheckedFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxCheckedFilled20 = createSVGComponent('CheckboxCheckedFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxCheckedFilled16 = createSVGComponent('CheckboxCheckedFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxIndeterminate32 = createSVGComponent('CheckboxIndeterminate32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 14H22V18H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CheckboxIndeterminate24 = createSVGComponent('CheckboxIndeterminate24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 14H22V18H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CheckboxIndeterminate20 = createSVGComponent('CheckboxIndeterminate20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 14H22V18H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CheckboxIndeterminate16 = createSVGComponent('CheckboxIndeterminate16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 14H22V18H10z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CheckboxIndeterminateFilled32 = createSVGComponent('CheckboxIndeterminateFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M22,18H10V14H22Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxIndeterminateFilled24 = createSVGComponent('CheckboxIndeterminateFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M22,18H10V14H22Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxIndeterminateFilled20 = createSVGComponent('CheckboxIndeterminateFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M22,18H10V14H22Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckboxIndeterminateFilled16 = createSVGComponent('CheckboxIndeterminateFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M22,18H10V14H22Z",
      "data-icon-path": "inner-path"
    }
  }]);

  const Checkmark32 = createSVGComponent('Checkmark32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 24L4 15 5.414 13.586 13 21.171 26.586 7.586 28 9 13 24z"
    }
  }]);

  const Checkmark24 = createSVGComponent('Checkmark24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 24 24",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 15.9L4.7 10.6 3.6 11.6 8.9 16.9 10 18 20.6 7.4 19.5 6.3z"
    }
  }]);

  const Checkmark20 = createSVGComponent('Checkmark20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 20 20",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 13.2L3.6 8.8 2.7 9.7 7.1 14.1 8 15 16.5 6.5 15.6 5.6z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M15.6 5.6L8 13.2 3.6 8.8 2.7 9.7 7.1 14.1 8 15 16.5 6.5 15.6 5.6z"
    }
  }]);

  const Checkmark16 = createSVGComponent('Checkmark16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M13 24L4 15 5.414 13.586 13 21.171 26.586 7.586 28 9 13 24z"
    }
  }]);

  const CheckmarkFilled32 = createSVGComponent('CheckmarkFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM14,21.5908l-5-5L10.5906,15,14,18.4092,21.41,11l1.5957,1.5859Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M14 21.591L9 16.591 10.591 15 14 18.409 21.41 11 23.005 12.585 14 21.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilled24 = createSVGComponent('CheckmarkFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 24 24",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M12,1C6,1,1,6,1,12s5,11,11,11s11-4.9,11-11S18.1,1,12,1z M10.4,16.3l-3.9-3.9l1.3-1.2l2.7,2.7l5.8-5.8l1.3,1.3L10.4,16.3z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M10.4,16.3l-3.9-3.9l1.3-1.2l2.7,2.7l5.8-5.8l1.3,1.3L10.4,16.3z",
      "data-icon-path": "inner-path",
      "opacity": "0"
    }
  }]);

  const CheckmarkFilled20 = createSVGComponent('CheckmarkFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 20 20",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10,1c-4.9,0-9,4.1-9,9s4.1,9,9,9s9-4,9-9S15,1,10,1z M8.7,13.5l-3.2-3.2l1-1l2.2,2.2l4.8-4.8l1,1L8.7,13.5z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M8.7,13.5l-3.2-3.2l1-1l2.2,2.2l4.8-4.8l1,1L8.7,13.5z",
      "data-icon-path": "inner-path",
      "opacity": "0"
    }
  }]);

  const CheckmarkFilled16 = createSVGComponent('CheckmarkFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,1C4.1,1,1,4.1,1,8c0,3.9,3.1,7,7,7s7-3.1,7-7C15,4.1,11.9,1,8,1z M7,11L4.3,8.3l0.9-0.8L7,9.3l4-3.9l0.9,0.8L7,11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M7,11L4.3,8.3l0.9-0.8L7,9.3l4-3.9l0.9,0.8L7,11z",
      "data-icon-path": "inner-path",
      "opacity": "0"
    }
  }]);

  const CheckmarkFilledError32 = createSVGComponent('CheckmarkFilledError32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,24a6,6,0,1,0-6,6A6.0066,6.0066,0,0,0,30,24Zm-2,0a3.9521,3.9521,0,0,1-.5669,2.019L21.981,20.5669A3.9529,3.9529,0,0,1,24,20,4.0045,4.0045,0,0,1,28,24Zm-8,0a3.9521,3.9521,0,0,1,.5669-2.019l5.4521,5.4521A3.9529,3.9529,0,0,1,24,28,4.0045,4.0045,0,0,1,20,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,2,23.82V24a8,8,0,0,1,8-8h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledError24 = createSVGComponent('CheckmarkFilledError24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,24a6,6,0,1,0-6,6A6.0066,6.0066,0,0,0,30,24Zm-2,0a3.9521,3.9521,0,0,1-.5669,2.019L21.981,20.5669A3.9529,3.9529,0,0,1,24,20,4.0045,4.0045,0,0,1,28,24Zm-8,0a3.9521,3.9521,0,0,1,.5669-2.019l5.4521,5.4521A3.9529,3.9529,0,0,1,24,28,4.0045,4.0045,0,0,1,20,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,2,23.82V24a8,8,0,0,1,8-8h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledError20 = createSVGComponent('CheckmarkFilledError20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,24a6,6,0,1,0-6,6A6.0066,6.0066,0,0,0,30,24Zm-2,0a3.9521,3.9521,0,0,1-.5669,2.019L21.981,20.5669A3.9529,3.9529,0,0,1,24,20,4.0045,4.0045,0,0,1,28,24Zm-8,0a3.9521,3.9521,0,0,1,.5669-2.019l5.4521,5.4521A3.9529,3.9529,0,0,1,24,28,4.0045,4.0045,0,0,1,20,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,2,23.82V24a8,8,0,0,1,8-8h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledError16 = createSVGComponent('CheckmarkFilledError16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30,24a6,6,0,1,0-6,6A6.0066,6.0066,0,0,0,30,24Zm-2,0a3.9521,3.9521,0,0,1-.5669,2.019L21.981,20.5669A3.9529,3.9529,0,0,1,24,20,4.0045,4.0045,0,0,1,28,24Zm-8,0a3.9521,3.9521,0,0,1,.5669-2.019l5.4521,5.4521A3.9529,3.9529,0,0,1,24,28,4.0045,4.0045,0,0,1,20,24Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,2,23.82V24a8,8,0,0,1,8-8h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledWarning32 = createSVGComponent('CheckmarkFilledWarning32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,3.3928,23.5059l3.9246-7.8492A2.9846,2.9846,0,0,1,24,16h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.38,28H20.6178L24,21.2358ZM24,18a1,1,0,0,0-.8947.5527l-5,10A1.0005,1.0005,0,0,0,19,30H29a1,1,0,0,0,.9214-1.3892L24.8946,18.5527A1,1,0,0,0,24,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledWarning24 = createSVGComponent('CheckmarkFilledWarning24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,3.3928,23.5059l3.9246-7.8492A2.9846,2.9846,0,0,1,24,16h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.38,28H20.6178L24,21.2358ZM24,18a1,1,0,0,0-.8947.5527l-5,10A1.0005,1.0005,0,0,0,19,30H29a1,1,0,0,0,.9214-1.3892L24.8946,18.5527A1,1,0,0,0,24,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledWarning20 = createSVGComponent('CheckmarkFilledWarning20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,3.3928,23.5059l3.9246-7.8492A2.9846,2.9846,0,0,1,24,16h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.38,28H20.6178L24,21.2358ZM24,18a1,1,0,0,0-.8947.5527l-5,10A1.0005,1.0005,0,0,0,19,30H29a1,1,0,0,0,.9214-1.3892L24.8946,18.5527A1,1,0,0,0,24,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkFilledWarning16 = createSVGComponent('CheckmarkFilledWarning16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,2a12,12,0,1,0,3.3928,23.5059l3.9246-7.8492A2.9846,2.9846,0,0,1,24,16h1.82A11.9348,11.9348,0,0,0,14,2ZM12,18.5908l-4-4L9.5908,13,12,15.4092,17.4092,10,19,11.5908Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.38,28H20.6178L24,21.2358ZM24,18a1,1,0,0,0-.8947.5527l-5,10A1.0005,1.0005,0,0,0,19,30H29a1,1,0,0,0,.9214-1.3892L24.8946,18.5527A1,1,0,0,0,24,18Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "fill": "none",
      "d": "M12 18.591L8 14.591 9.591 13 12 15.409 17.409 10 19 11.591 12 18.591z",
      "data-icon-path": "inner-path"
    }
  }]);

  const CheckmarkOutline32 = createSVGComponent('CheckmarkOutline32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 21.414L9 16.413 10.413 15 14 18.586 21.585 11 23 12.415 14 21.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"
    }
  }]);

  const CheckmarkOutline24 = createSVGComponent('CheckmarkOutline24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 21.414L9 16.413 10.413 15 14 18.586 21.585 11 23 12.415 14 21.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"
    }
  }]);

  const CheckmarkOutline20 = createSVGComponent('CheckmarkOutline20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 21.414L9 16.413 10.413 15 14 18.586 21.585 11 23 12.415 14 21.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"
    }
  }]);

  const CheckmarkOutline16 = createSVGComponent('CheckmarkOutline16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14 21.414L9 16.413 10.413 15 14 18.586 21.585 11 23 12.415 14 21.414z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"
    }
  }]);

  const CheckmarkOutlineError32 = createSVGComponent('CheckmarkOutlineError32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM30 24a6 6 0 10-6 6A6.0066 6.0066 0 0030 24zm-2 0a3.9521 3.9521 0 01-.5669 2.019L21.981 20.5669A3.9529 3.9529 0 0124 20 4.0045 4.0045 0 0128 24zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 28 4.0045 4.0045 0 0120 24z"
    }
  }]);

  const CheckmarkOutlineError24 = createSVGComponent('CheckmarkOutlineError24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM30 24a6 6 0 10-6 6A6.0066 6.0066 0 0030 24zm-2 0a3.9521 3.9521 0 01-.5669 2.019L21.981 20.5669A3.9529 3.9529 0 0124 20 4.0045 4.0045 0 0128 24zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 28 4.0045 4.0045 0 0120 24z"
    }
  }]);

  const CheckmarkOutlineError20 = createSVGComponent('CheckmarkOutlineError20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM30 24a6 6 0 10-6 6A6.0066 6.0066 0 0030 24zm-2 0a3.9521 3.9521 0 01-.5669 2.019L21.981 20.5669A3.9529 3.9529 0 0124 20 4.0045 4.0045 0 0128 24zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 28 4.0045 4.0045 0 0120 24z"
    }
  }]);

  const CheckmarkOutlineError16 = createSVGComponent('CheckmarkOutlineError16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM30 24a6 6 0 10-6 6A6.0066 6.0066 0 0030 24zm-2 0a3.9521 3.9521 0 01-.5669 2.019L21.981 20.5669A3.9529 3.9529 0 0124 20 4.0045 4.0045 0 0128 24zm-8 0a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 28 4.0045 4.0045 0 0120 24z"
    }
  }]);

  const CheckmarkOutlineWarning32 = createSVGComponent('CheckmarkOutlineWarning32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM27.38 28H20.6178L24 21.2358zM24 18a1 1 0 00-.8947.5527l-5 10A1.0005 1.0005 0 0019 30H29a1 1 0 00.9214-1.3892L24.8946 18.5527A1 1 0 0024 18z"
    }
  }]);

  const CheckmarkOutlineWarning24 = createSVGComponent('CheckmarkOutlineWarning24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM27.38 28H20.6178L24 21.2358zM24 18a1 1 0 00-.8947.5527l-5 10A1.0005 1.0005 0 0019 30H29a1 1 0 00.9214-1.3892L24.8946 18.5527A1 1 0 0024 18z"
    }
  }]);

  const CheckmarkOutlineWarning20 = createSVGComponent('CheckmarkOutlineWarning20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM27.38 28H20.6178L24 21.2358zM24 18a1 1 0 00-.8947.5527l-5 10A1.0005 1.0005 0 0019 30H29a1 1 0 00.9214-1.3892L24.8946 18.5527A1 1 0 0024 18z"
    }
  }]);

  const CheckmarkOutlineWarning16 = createSVGComponent('CheckmarkOutlineWarning16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M14,24A10,10,0,1,1,24,14h2A12,12,0,1,0,14,26Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M12 15.59L9.41 13 8 14.41 12 18.41 19 11.41 17.59 10 12 15.59zM27.38 28H20.6178L24 21.2358zM24 18a1 1 0 00-.8947.5527l-5 10A1.0005 1.0005 0 0019 30H29a1 1 0 00.9214-1.3892L24.8946 18.5527A1 1 0 0024 18z"
    }
  }]);

  const Chemistry32 = createSVGComponent('Chemistry32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"
    }
  }]);

  const Chemistry24 = createSVGComponent('Chemistry24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"
    }
  }]);

  const Chemistry20 = createSVGComponent('Chemistry20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"
    }
  }]);

  const Chemistry16 = createSVGComponent('Chemistry16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"
    }
  }]);

  const ChemistryReference32 = createSVGComponent('ChemistryReference32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,13.67V4h2V2H10V4h2v9.67L9.58,17h2.4767L14,14.33V4h4V14.33l7.61,10.46a2.0133,2.0133,0,0,1-.44,2.82,2.0406,2.0406,0,0,1-1.19.39H15v2h8.98a4.0154,4.0154,0,0,0,3.25-6.38Z"
    }
  }]);

  const ChemistryReference24 = createSVGComponent('ChemistryReference24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,13.67V4h2V2H10V4h2v9.67L9.58,17h2.4767L14,14.33V4h4V14.33l7.61,10.46a2.0133,2.0133,0,0,1-.44,2.82,2.0406,2.0406,0,0,1-1.19.39H15v2h8.98a4.0154,4.0154,0,0,0,3.25-6.38Z"
    }
  }]);

  const ChemistryReference20 = createSVGComponent('ChemistryReference20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,13.67V4h2V2H10V4h2v9.67L9.58,17h2.4767L14,14.33V4h4V14.33l7.61,10.46a2.0133,2.0133,0,0,1-.44,2.82,2.0406,2.0406,0,0,1-1.19.39H15v2h8.98a4.0154,4.0154,0,0,0,3.25-6.38Z"
    }
  }]);

  const ChemistryReference16 = createSVGComponent('ChemistryReference16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M20,13.67V4h2V2H10V4h2v9.67L9.58,17h2.4767L14,14.33V4h4V14.33l7.61,10.46a2.0133,2.0133,0,0,1-.44,2.82,2.0406,2.0406,0,0,1-1.19.39H15v2h8.98a4.0154,4.0154,0,0,0,3.25-6.38Z"
    }
  }]);

  const ChevronDown32 = createSVGComponent('ChevronDown32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22L6 12 7.4 10.6 16 19.2 24.6 10.6 26 12z"
    }
  }]);

  const ChevronDown24 = createSVGComponent('ChevronDown24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22L6 12 7.4 10.6 16 19.2 24.6 10.6 26 12z"
    }
  }]);

  const ChevronDown20 = createSVGComponent('ChevronDown20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 22L6 12 7.4 10.6 16 19.2 24.6 10.6 26 12z"
    }
  }]);

  const ChevronDown16 = createSVGComponent('ChevronDown16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 11L3 6 3.7 5.3 8 9.6 12.3 5.3 13 6z"
    }
  }]);

  const ChevronDownGlyph = createSVGComponent('ChevronDownGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 10 6",
    "fill": "currentColor",
    "width": "10",
    "height": "6"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M5 6L0 1 0.7 0.3 5 4.6 9.3 0.3 10 1z"
    }
  }]);

  const ChevronLeft32 = createSVGComponent('ChevronLeft32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 16L20 6 21.4 7.4 12.8 16 21.4 24.6 20 26z"
    }
  }]);

  const ChevronLeft24 = createSVGComponent('ChevronLeft24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 16L20 6 21.4 7.4 12.8 16 21.4 24.6 20 26z"
    }
  }]);

  const ChevronLeft20 = createSVGComponent('ChevronLeft20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M10 16L20 6 21.4 7.4 12.8 16 21.4 24.6 20 26z"
    }
  }]);

  const ChevronLeft16 = createSVGComponent('ChevronLeft16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M5 8L10 3 10.7 3.7 6.4 8 10.7 12.3 10 13z"
    }
  }]);

  const ChevronLeftGlyph = createSVGComponent('ChevronLeftGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 6 10",
    "fill": "currentColor",
    "width": "6",
    "height": "10"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M0 5L5 0 5.7 0.7 1.4 5 5.7 9.3 5 10z"
    }
  }]);

  const ChevronMini32 = createSVGComponent('ChevronMini32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 19L31 31 19 31 31 19z"
    }
  }]);

  const ChevronMini24 = createSVGComponent('ChevronMini24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 19L31 31 19 31 31 19z"
    }
  }]);

  const ChevronMini20 = createSVGComponent('ChevronMini20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 19L31 31 19 31 31 19z"
    }
  }]);

  const ChevronMini16 = createSVGComponent('ChevronMini16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M15 9L15 15 9 15z"
    }
  }]);

  const ChevronRight32 = createSVGComponent('ChevronRight32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 16L12 26 10.6 24.6 19.2 16 10.6 7.4 12 6z"
    }
  }]);

  const ChevronRight24 = createSVGComponent('ChevronRight24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 16L12 26 10.6 24.6 19.2 16 10.6 7.4 12 6z"
    }
  }]);

  const ChevronRight20 = createSVGComponent('ChevronRight20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 16L12 26 10.6 24.6 19.2 16 10.6 7.4 12 6z"
    }
  }]);

  const ChevronRight16 = createSVGComponent('ChevronRight16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11 8L6 13 5.3 12.3 9.6 8 5.3 3.7 6 3z"
    }
  }]);

  const ChevronRightGlyph = createSVGComponent('ChevronRightGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 6 10",
    "fill": "currentColor",
    "width": "6",
    "height": "10"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M6 5L1 10 0.3 9.3 4.6 5 0.3 0.7 1 0z"
    }
  }]);

  const ChevronSort32 = createSVGComponent('ChevronSort32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 28L9 21 10.41 19.59 16 25.17 21.59 19.59 23 21 16 28zM16 4L23 11 21.59 12.41 16 6.83 10.41 12.41 9 11 16 4z"
    }
  }]);

  const ChevronSort24 = createSVGComponent('ChevronSort24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 28L9 21 10.41 19.59 16 25.17 21.59 19.59 23 21 16 28zM16 4L23 11 21.59 12.41 16 6.83 10.41 12.41 9 11 16 4z"
    }
  }]);

  const ChevronSort20 = createSVGComponent('ChevronSort20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 28L9 21 10.41 19.59 16 25.17 21.59 19.59 23 21 16 28zM16 4L23 11 21.59 12.41 16 6.83 10.41 12.41 9 11 16 4z"
    }
  }]);

  const ChevronSort16 = createSVGComponent('ChevronSort16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 14L4.5 10.5 5.2 9.8 8 12.6 10.8 9.8 11.5 10.5zM8 2L11.5 5.5 10.8 6.2 8 3.4 5.2 6.2 4.5 5.5z"
    }
  }]);

  const ChevronSortDown32 = createSVGComponent('ChevronSortDown32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 28L9 21 10.4 19.6 16 25.2 21.6 19.6 23 21z"
    }
  }]);

  const ChevronSortDown24 = createSVGComponent('ChevronSortDown24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 28L9 21 10.4 19.6 16 25.2 21.6 19.6 23 21z"
    }
  }]);

  const ChevronSortDown20 = createSVGComponent('ChevronSortDown20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 28L9 21 10.4 19.6 16 25.2 21.6 19.6 23 21z"
    }
  }]);

  const ChevronSortDown16 = createSVGComponent('ChevronSortDown16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 14L4.5 10.5 5.2 9.8 8 12.6 10.8 9.8 11.5 10.5z"
    }
  }]);

  const ChevronSortUp32 = createSVGComponent('ChevronSortUp32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 4L23 11 21.6 12.4 16 6.8 10.4 12.4 9 11z"
    }
  }]);

  const ChevronSortUp24 = createSVGComponent('ChevronSortUp24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 4L23 11 21.6 12.4 16 6.8 10.4 12.4 9 11z"
    }
  }]);

  const ChevronSortUp20 = createSVGComponent('ChevronSortUp20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 4L23 11 21.6 12.4 16 6.8 10.4 12.4 9 11z"
    }
  }]);

  const ChevronSortUp16 = createSVGComponent('ChevronSortUp16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 2L11.5 5.5 10.8 6.2 8 3.4 5.2 6.2 4.5 5.5z"
    }
  }]);

  const ChevronUp32 = createSVGComponent('ChevronUp32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10L26 20 24.6 21.4 16 12.8 7.4 21.4 6 20z"
    }
  }]);

  const ChevronUp24 = createSVGComponent('ChevronUp24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10L26 20 24.6 21.4 16 12.8 7.4 21.4 6 20z"
    }
  }]);

  const ChevronUp20 = createSVGComponent('ChevronUp20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16 10L26 20 24.6 21.4 16 12.8 7.4 21.4 6 20z"
    }
  }]);

  const ChevronUp16 = createSVGComponent('ChevronUp16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 5L13 10 12.3 10.7 8 6.4 3.7 10.7 3 10z"
    }
  }]);

  const ChevronUpGlyph = createSVGComponent('ChevronUpGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 10 6",
    "fill": "currentColor",
    "width": "10",
    "height": "6"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M5 0L10 5 9.3 5.7 5 1.4 0.7 5.7 0 5z"
    }
  }]);

  const Chip32 = createSVGComponent('Chip32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11,11V21H21V11Zm8,8H13V13h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"
    }
  }]);

  const Chip24 = createSVGComponent('Chip24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11,11V21H21V11Zm8,8H13V13h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"
    }
  }]);

  const Chip20 = createSVGComponent('Chip20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11,11V21H21V11Zm8,8H13V13h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"
    }
  }]);

  const Chip16 = createSVGComponent('Chip16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M11,11V21H21V11Zm8,8H13V13h6Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"
    }
  }]);

  const Choices32 = createSVGComponent('Choices32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 13L28 4 19 4 19 6 24.586 6 16 14.586 7.414 6 13 6 13 4 4 4 4 13 6 13 6 7.414 15 16.414 15 26 4 26 4 28 28 28 28 26 17 26 17 16.414 26 7.414 26 13 28 13z"
    }
  }]);

  const Choices24 = createSVGComponent('Choices24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 13L28 4 19 4 19 6 24.586 6 16 14.586 7.414 6 13 6 13 4 4 4 4 13 6 13 6 7.414 15 16.414 15 26 4 26 4 28 28 28 28 26 17 26 17 16.414 26 7.414 26 13 28 13z"
    }
  }]);

  const Choices20 = createSVGComponent('Choices20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 13L28 4 19 4 19 6 24.586 6 16 14.586 7.414 6 13 6 13 4 4 4 4 13 6 13 6 7.414 15 16.414 15 26 4 26 4 28 28 28 28 26 17 26 17 16.414 26 7.414 26 13 28 13z"
    }
  }]);

  const Choices16 = createSVGComponent('Choices16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 13L28 4 19 4 19 6 24.586 6 16 14.586 7.414 6 13 6 13 4 4 4 4 13 6 13 6 7.414 15 16.414 15 26 4 26 4 28 28 28 28 26 17 26 17 16.414 26 7.414 26 13 28 13z"
    }
  }]);

  const ChooseItem32 = createSVGComponent('ChooseItem32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 6H30V26H28zM17 6L15.57 7.393 23.15 15 2 15 2 17 23.15 17 15.57 24.573 17 26 27 16 17 6z"
    }
  }]);

  const ChooseItem24 = createSVGComponent('ChooseItem24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 6H30V26H28zM17 6L15.57 7.393 23.15 15 2 15 2 17 23.15 17 15.57 24.573 17 26 27 16 17 6z"
    }
  }]);

  const ChooseItem20 = createSVGComponent('ChooseItem20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 6H30V26H28zM17 6L15.57 7.393 23.15 15 2 15 2 17 23.15 17 15.57 24.573 17 26 27 16 17 6z"
    }
  }]);

  const ChooseItem16 = createSVGComponent('ChooseItem16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 6H30V26H28zM17 6L15.57 7.393 23.15 15 2 15 2 17 23.15 17 15.57 24.573 17 26 27 16 17 6z"
    }
  }]);

  const ChoroplethMap32 = createSVGComponent('ChoroplethMap32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.2427,4.03l-8-2a1.0065,1.0065,0,0,0-.6143.0415l-9.7,3.88L3.2427,4.03A1,1,0,0,0,2,5V27a1,1,0,0,0,.7573.97l8,2A1.0244,1.0244,0,0,0,11,30a.9953.9953,0,0,0,.3716-.0718l9.7-3.88,7.686,1.9219A1,1,0,0,0,30,27V5A1,1,0,0,0,29.2427,4.03ZM28,11H22V4.2806l6,1.5ZM10,19H4V13h6Zm2-8V7.6771l8-3.2V11Zm8,2v6H12V13Zm-8,8h8v3.3227l-8,3.2Zm10-8h6v6H22ZM10,7.7806V11H4V6.2806ZM4,21h6v6.7192l-6-1.5Zm18,3.2187V21h6v4.7192Z"
    }
  }]);

  const ChoroplethMap24 = createSVGComponent('ChoroplethMap24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.2427,4.03l-8-2a1.0065,1.0065,0,0,0-.6143.0415l-9.7,3.88L3.2427,4.03A1,1,0,0,0,2,5V27a1,1,0,0,0,.7573.97l8,2A1.0244,1.0244,0,0,0,11,30a.9953.9953,0,0,0,.3716-.0718l9.7-3.88,7.686,1.9219A1,1,0,0,0,30,27V5A1,1,0,0,0,29.2427,4.03ZM28,11H22V4.2806l6,1.5ZM10,19H4V13h6Zm2-8V7.6771l8-3.2V11Zm8,2v6H12V13Zm-8,8h8v3.3227l-8,3.2Zm10-8h6v6H22ZM10,7.7806V11H4V6.2806ZM4,21h6v6.7192l-6-1.5Zm18,3.2187V21h6v4.7192Z"
    }
  }]);

  const ChoroplethMap20 = createSVGComponent('ChoroplethMap20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.2427,4.03l-8-2a1.0065,1.0065,0,0,0-.6143.0415l-9.7,3.88L3.2427,4.03A1,1,0,0,0,2,5V27a1,1,0,0,0,.7573.97l8,2A1.0244,1.0244,0,0,0,11,30a.9953.9953,0,0,0,.3716-.0718l9.7-3.88,7.686,1.9219A1,1,0,0,0,30,27V5A1,1,0,0,0,29.2427,4.03ZM28,11H22V4.2806l6,1.5ZM10,19H4V13h6Zm2-8V7.6771l8-3.2V11Zm8,2v6H12V13Zm-8,8h8v3.3227l-8,3.2Zm10-8h6v6H22ZM10,7.7806V11H4V6.2806ZM4,21h6v6.7192l-6-1.5Zm18,3.2187V21h6v4.7192Z"
    }
  }]);

  const ChoroplethMap16 = createSVGComponent('ChoroplethMap16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M29.2427,4.03l-8-2a1.0065,1.0065,0,0,0-.6143.0415l-9.7,3.88L3.2427,4.03A1,1,0,0,0,2,5V27a1,1,0,0,0,.7573.97l8,2A1.0244,1.0244,0,0,0,11,30a.9953.9953,0,0,0,.3716-.0718l9.7-3.88,7.686,1.9219A1,1,0,0,0,30,27V5A1,1,0,0,0,29.2427,4.03ZM28,11H22V4.2806l6,1.5ZM10,19H4V13h6Zm2-8V7.6771l8-3.2V11Zm8,2v6H12V13Zm-8,8h8v3.3227l-8,3.2Zm10-8h6v6H22ZM10,7.7806V11H4V6.2806ZM4,21h6v6.7192l-6-1.5Zm18,3.2187V21h6v4.7192Z"
    }
  }]);

  const CicsCmas32 = createSVGComponent('CicsCmas32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30.3335 30H26V28h4V26H28a2.002 2.002 0 01-2-2V21.6665A1.6684 1.6684 0 0127.6665 20H32v2H28v2h2a2.002 2.002 0 012 2v2.3335A1.6684 1.6684 0 0130.3335 30zM22.3335 20h-2.667A1.6665 1.6665 0 0018 21.6665V30h2V26h2v4h2V21.6665A1.6665 1.6665 0 0022.3335 20zM20 24V22h2v2zM12.5 24L11 20 9 20 9 30 11 30 11 23 12.5 27 14 23 14 30 16 30 16 20 14 20 12.5 24zM1 22v6.5A1.4727 1.4727 0 002.5 30H7V28H3V22H7V20H3A2.0059 2.0059 0 001 22zM13 8L11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11 13 11 13 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,6H26V18h2V6a2.0059,2.0059,0,0,0-2-2H6A2.0059,2.0059,0,0,0,4,6V18H6Z"
    }
  }]);

  const CicsCmas24 = createSVGComponent('CicsCmas24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30.3335 30H26V28h4V26H28a2.002 2.002 0 01-2-2V21.6665A1.6684 1.6684 0 0127.6665 20H32v2H28v2h2a2.002 2.002 0 012 2v2.3335A1.6684 1.6684 0 0130.3335 30zM22.3335 20h-2.667A1.6665 1.6665 0 0018 21.6665V30h2V26h2v4h2V21.6665A1.6665 1.6665 0 0022.3335 20zM20 24V22h2v2zM12.5 24L11 20 9 20 9 30 11 30 11 23 12.5 27 14 23 14 30 16 30 16 20 14 20 12.5 24zM1 22v6.5A1.4727 1.4727 0 002.5 30H7V28H3V22H7V20H3A2.0059 2.0059 0 001 22zM13 8L11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11 13 11 13 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,6H26V18h2V6a2.0059,2.0059,0,0,0-2-2H6A2.0059,2.0059,0,0,0,4,6V18H6Z"
    }
  }]);

  const CicsCmas20 = createSVGComponent('CicsCmas20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30.3335 30H26V28h4V26H28a2.002 2.002 0 01-2-2V21.6665A1.6684 1.6684 0 0127.6665 20H32v2H28v2h2a2.002 2.002 0 012 2v2.3335A1.6684 1.6684 0 0130.3335 30zM22.3335 20h-2.667A1.6665 1.6665 0 0018 21.6665V30h2V26h2v4h2V21.6665A1.6665 1.6665 0 0022.3335 20zM20 24V22h2v2zM12.5 24L11 20 9 20 9 30 11 30 11 23 12.5 27 14 23 14 30 16 30 16 20 14 20 12.5 24zM1 22v6.5A1.4727 1.4727 0 002.5 30H7V28H3V22H7V20H3A2.0059 2.0059 0 001 22zM13 8L11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11 13 11 13 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,6H26V18h2V6a2.0059,2.0059,0,0,0-2-2H6A2.0059,2.0059,0,0,0,4,6V18H6Z"
    }
  }]);

  const CicsCmas16 = createSVGComponent('CicsCmas16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M30.3335 30H26V28h4V26H28a2.002 2.002 0 01-2-2V21.6665A1.6684 1.6684 0 0127.6665 20H32v2H28v2h2a2.002 2.002 0 012 2v2.3335A1.6684 1.6684 0 0130.3335 30zM22.3335 20h-2.667A1.6665 1.6665 0 0018 21.6665V30h2V26h2v4h2V21.6665A1.6665 1.6665 0 0022.3335 20zM20 24V22h2v2zM12.5 24L11 20 9 20 9 30 11 30 11 23 12.5 27 14 23 14 30 16 30 16 20 14 20 12.5 24zM1 22v6.5A1.4727 1.4727 0 002.5 30H7V28H3V22H7V20H3A2.0059 2.0059 0 001 22zM13 8L11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11 13 11 13 8z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M6,6H26V18h2V6a2.0059,2.0059,0,0,0-2-2H6A2.0059,2.0059,0,0,0,4,6V18H6Z"
    }
  }]);

  const CicsDb2Connection32 = createSVGComponent('CicsDb2Connection32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.5,30c-1.9299,0-3.5-1.5701-3.5-3.5,0-.9346,.3638-1.8134,1.0244-2.4742l1.4146,1.4138c-.283,.2832-.439,.6598-.439,1.0604,0,.8271,.6729,1.5,1.5,1.5,.4009,0,.7776-.1561,1.061-.4396l4.9998-4.9998c.2832-.2833,.4392-.66,.4392-1.0607,0-.8271-.6729-1.5-1.5-1.5-.4011,0-.7783,.1564-1.0618,.4404l-1.4155-1.4131c.6616-.6625,1.5413-1.0273,2.4773-1.0273,1.9299,0,3.5,1.5701,3.5,3.5,0,.9348-.364,1.8137-1.0249,2.4749l-4.9998,4.9996c-.6609,.6613-1.54,1.0255-2.4753,1.0255Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16.5 31c-1.9299 0-3.5-1.5701-3.5-3.5 0-.9348.364-1.8137 1.0249-2.4749l4.9998-4.9996c.6609-.6613 1.54-1.0255 2.4753-1.0255 1.9299 0 3.5 1.5701 3.5 3.5 0 .9346-.3638 1.8134-1.0244 2.4742l-1.4146-1.4138c.283-.2832.439-.6598.439-1.0604 0-.8271-.6729-1.5-1.5-1.5-.4009 0-.7776.1561-1.061.4396l-4.9998 4.9998c-.2832.2833-.4392.66-.4392 1.0607 0 .8271.6729 1.5 1.5 1.5.4011 0 .7783-.1564 1.0618-.4404l1.4155 1.4131c-.6616.6625-1.5413 1.0273-2.4773 1.0273zM16 2c-5.2979 0-11 1.252-11 4V24c0 1.6797 2.134 2.7979 5 3.415v-2.0459c-1.9939-.4727-2.9453-1.1431-3-1.3691v-3.5723c1.4937.749 3.6738 1.2153 6 1.4302v-1.9976c-3.8779-.3774-5.8774-1.4219-6-1.8604v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723 5.2979 0 11-1.252 11-4V5.9995c-.0007-2.748-5.7024-3.9995-11-3.9995zM6.9985 6.0151c.1523-.5552 3.1514-2.0151 9.0015-2.0151 5.7976 0 8.7949 1.4341 8.9968 2-.2019.5659-3.1992 2-8.9968 2-5.8501 0-8.8491-1.46-9.0015-1.9849zm18.0015 5.9722c-.1606.5571-3.1587 2.0127-9 2.0127-5.8501 0-8.8491-1.46-9-2v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723s6.8721-.5049 9-1.5723v3.5596z"
    }
  }]);

  const CicsDb2Connection24 = createSVGComponent('CicsDb2Connection24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.5,30c-1.9299,0-3.5-1.5701-3.5-3.5,0-.9346,.3638-1.8134,1.0244-2.4742l1.4146,1.4138c-.283,.2832-.439,.6598-.439,1.0604,0,.8271,.6729,1.5,1.5,1.5,.4009,0,.7776-.1561,1.061-.4396l4.9998-4.9998c.2832-.2833,.4392-.66,.4392-1.0607,0-.8271-.6729-1.5-1.5-1.5-.4011,0-.7783,.1564-1.0618,.4404l-1.4155-1.4131c.6616-.6625,1.5413-1.0273,2.4773-1.0273,1.9299,0,3.5,1.5701,3.5,3.5,0,.9348-.364,1.8137-1.0249,2.4749l-4.9998,4.9996c-.6609,.6613-1.54,1.0255-2.4753,1.0255Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16.5 31c-1.9299 0-3.5-1.5701-3.5-3.5 0-.9348.364-1.8137 1.0249-2.4749l4.9998-4.9996c.6609-.6613 1.54-1.0255 2.4753-1.0255 1.9299 0 3.5 1.5701 3.5 3.5 0 .9346-.3638 1.8134-1.0244 2.4742l-1.4146-1.4138c.283-.2832.439-.6598.439-1.0604 0-.8271-.6729-1.5-1.5-1.5-.4009 0-.7776.1561-1.061.4396l-4.9998 4.9998c-.2832.2833-.4392.66-.4392 1.0607 0 .8271.6729 1.5 1.5 1.5.4011 0 .7783-.1564 1.0618-.4404l1.4155 1.4131c-.6616.6625-1.5413 1.0273-2.4773 1.0273zM16 2c-5.2979 0-11 1.252-11 4V24c0 1.6797 2.134 2.7979 5 3.415v-2.0459c-1.9939-.4727-2.9453-1.1431-3-1.3691v-3.5723c1.4937.749 3.6738 1.2153 6 1.4302v-1.9976c-3.8779-.3774-5.8774-1.4219-6-1.8604v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723 5.2979 0 11-1.252 11-4V5.9995c-.0007-2.748-5.7024-3.9995-11-3.9995zM6.9985 6.0151c.1523-.5552 3.1514-2.0151 9.0015-2.0151 5.7976 0 8.7949 1.4341 8.9968 2-.2019.5659-3.1992 2-8.9968 2-5.8501 0-8.8491-1.46-9.0015-1.9849zm18.0015 5.9722c-.1606.5571-3.1587 2.0127-9 2.0127-5.8501 0-8.8491-1.46-9-2v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723s6.8721-.5049 9-1.5723v3.5596z"
    }
  }]);

  const CicsDb2Connection20 = createSVGComponent('CicsDb2Connection20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.5,30c-1.9299,0-3.5-1.5701-3.5-3.5,0-.9346,.3638-1.8134,1.0244-2.4742l1.4146,1.4138c-.283,.2832-.439,.6598-.439,1.0604,0,.8271,.6729,1.5,1.5,1.5,.4009,0,.7776-.1561,1.061-.4396l4.9998-4.9998c.2832-.2833,.4392-.66,.4392-1.0607,0-.8271-.6729-1.5-1.5-1.5-.4011,0-.7783,.1564-1.0618,.4404l-1.4155-1.4131c.6616-.6625,1.5413-1.0273,2.4773-1.0273,1.9299,0,3.5,1.5701,3.5,3.5,0,.9348-.364,1.8137-1.0249,2.4749l-4.9998,4.9996c-.6609,.6613-1.54,1.0255-2.4753,1.0255Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16.5 31c-1.9299 0-3.5-1.5701-3.5-3.5 0-.9348.364-1.8137 1.0249-2.4749l4.9998-4.9996c.6609-.6613 1.54-1.0255 2.4753-1.0255 1.9299 0 3.5 1.5701 3.5 3.5 0 .9346-.3638 1.8134-1.0244 2.4742l-1.4146-1.4138c.283-.2832.439-.6598.439-1.0604 0-.8271-.6729-1.5-1.5-1.5-.4009 0-.7776.1561-1.061.4396l-4.9998 4.9998c-.2832.2833-.4392.66-.4392 1.0607 0 .8271.6729 1.5 1.5 1.5.4011 0 .7783-.1564 1.0618-.4404l1.4155 1.4131c-.6616.6625-1.5413 1.0273-2.4773 1.0273zM16 2c-5.2979 0-11 1.252-11 4V24c0 1.6797 2.134 2.7979 5 3.415v-2.0459c-1.9939-.4727-2.9453-1.1431-3-1.3691v-3.5723c1.4937.749 3.6738 1.2153 6 1.4302v-1.9976c-3.8779-.3774-5.8774-1.4219-6-1.8604v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723 5.2979 0 11-1.252 11-4V5.9995c-.0007-2.748-5.7024-3.9995-11-3.9995zM6.9985 6.0151c.1523-.5552 3.1514-2.0151 9.0015-2.0151 5.7976 0 8.7949 1.4341 8.9968 2-.2019.5659-3.1992 2-8.9968 2-5.8501 0-8.8491-1.46-9.0015-1.9849zm18.0015 5.9722c-.1606.5571-3.1587 2.0127-9 2.0127-5.8501 0-8.8491-1.46-9-2v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723s6.8721-.5049 9-1.5723v3.5596z"
    }
  }]);

  const CicsDb2Connection16 = createSVGComponent('CicsDb2Connection16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22.5,30c-1.9299,0-3.5-1.5701-3.5-3.5,0-.9346,.3638-1.8134,1.0244-2.4742l1.4146,1.4138c-.283,.2832-.439,.6598-.439,1.0604,0,.8271,.6729,1.5,1.5,1.5,.4009,0,.7776-.1561,1.061-.4396l4.9998-4.9998c.2832-.2833,.4392-.66,.4392-1.0607,0-.8271-.6729-1.5-1.5-1.5-.4011,0-.7783,.1564-1.0618,.4404l-1.4155-1.4131c.6616-.6625,1.5413-1.0273,2.4773-1.0273,1.9299,0,3.5,1.5701,3.5,3.5,0,.9348-.364,1.8137-1.0249,2.4749l-4.9998,4.9996c-.6609,.6613-1.54,1.0255-2.4753,1.0255Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16.5 31c-1.9299 0-3.5-1.5701-3.5-3.5 0-.9348.364-1.8137 1.0249-2.4749l4.9998-4.9996c.6609-.6613 1.54-1.0255 2.4753-1.0255 1.9299 0 3.5 1.5701 3.5 3.5 0 .9346-.3638 1.8134-1.0244 2.4742l-1.4146-1.4138c.283-.2832.439-.6598.439-1.0604 0-.8271-.6729-1.5-1.5-1.5-.4009 0-.7776.1561-1.061.4396l-4.9998 4.9998c-.2832.2833-.4392.66-.4392 1.0607 0 .8271.6729 1.5 1.5 1.5.4011 0 .7783-.1564 1.0618-.4404l1.4155 1.4131c-.6616.6625-1.5413 1.0273-2.4773 1.0273zM16 2c-5.2979 0-11 1.252-11 4V24c0 1.6797 2.134 2.7979 5 3.415v-2.0459c-1.9939-.4727-2.9453-1.1431-3-1.3691v-3.5723c1.4937.749 3.6738 1.2153 6 1.4302v-1.9976c-3.8779-.3774-5.8774-1.4219-6-1.8604v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723 5.2979 0 11-1.252 11-4V5.9995c-.0007-2.748-5.7024-3.9995-11-3.9995zM6.9985 6.0151c.1523-.5552 3.1514-2.0151 9.0015-2.0151 5.7976 0 8.7949 1.4341 8.9968 2-.2019.5659-3.1992 2-8.9968 2-5.8501 0-8.8491-1.46-9.0015-1.9849zm18.0015 5.9722c-.1606.5571-3.1587 2.0127-9 2.0127-5.8501 0-8.8491-1.46-9-2v-3.5723c2.1279 1.0674 5.6426 1.5723 9 1.5723s6.8721-.5049 9-1.5723v3.5596z"
    }
  }]);

  const CicsExplorer32 = createSVGComponent('CicsExplorer32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 16L19.4 14.6 21.7 10.3 17.4 12.6 16 8 14.6 12.6 10.3 10.3 12.6 14.6 8 16 12.6 17.4 10.3 21.7 14.6 19.4 16 24 17.4 19.4 21.7 21.7 19.4 17.4 24 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CicsExplorer24 = createSVGComponent('CicsExplorer24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 16L19.4 14.6 21.7 10.3 17.4 12.6 16 8 14.6 12.6 10.3 10.3 12.6 14.6 8 16 12.6 17.4 10.3 21.7 14.6 19.4 16 24 17.4 19.4 21.7 21.7 19.4 17.4 24 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CicsExplorer20 = createSVGComponent('CicsExplorer20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 16L19.4 14.6 21.7 10.3 17.4 12.6 16 8 14.6 12.6 10.3 10.3 12.6 14.6 8 16 12.6 17.4 10.3 21.7 14.6 19.4 16 24 17.4 19.4 21.7 21.7 19.4 17.4 24 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CicsExplorer16 = createSVGComponent('CicsExplorer16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M24 16L19.4 14.6 21.7 10.3 17.4 12.6 16 8 14.6 12.6 10.3 10.3 12.6 14.6 8 16 12.6 17.4 10.3 21.7 14.6 19.4 16 24 17.4 19.4 21.7 21.7 19.4 17.4 24 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CicsProgram32 = createSVGComponent('CicsProgram32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.17 19L17.58 21.59 19 23 23 19 19 15 17.58 16.41 20.17 19zM11.83 19L14.42 16.41 13 15 9 19 13 23 14.42 21.59 11.83 19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4c-1.1028,0-2,.8975-2,2V26c0,1.1025,.8972,2,2,2H28c1.1028,0,2-.8975,2-2V6c0-1.1025-.8972-2-2-2Zm0,2v4H4V6H28ZM4,26V12H28v14H4Z"
    }
  }]);

  const CicsProgram24 = createSVGComponent('CicsProgram24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.17 19L17.58 21.59 19 23 23 19 19 15 17.58 16.41 20.17 19zM11.83 19L14.42 16.41 13 15 9 19 13 23 14.42 21.59 11.83 19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4c-1.1028,0-2,.8975-2,2V26c0,1.1025,.8972,2,2,2H28c1.1028,0,2-.8975,2-2V6c0-1.1025-.8972-2-2-2Zm0,2v4H4V6H28ZM4,26V12H28v14H4Z"
    }
  }]);

  const CicsProgram20 = createSVGComponent('CicsProgram20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.17 19L17.58 21.59 19 23 23 19 19 15 17.58 16.41 20.17 19zM11.83 19L14.42 16.41 13 15 9 19 13 23 14.42 21.59 11.83 19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4c-1.1028,0-2,.8975-2,2V26c0,1.1025,.8972,2,2,2H28c1.1028,0,2-.8975,2-2V6c0-1.1025-.8972-2-2-2Zm0,2v4H4V6H28ZM4,26V12H28v14H4Z"
    }
  }]);

  const CicsProgram16 = createSVGComponent('CicsProgram16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M20.17 19L17.58 21.59 19 23 23 19 19 15 17.58 16.41 20.17 19zM11.83 19L14.42 16.41 13 15 9 19 13 23 14.42 21.59 11.83 19z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "9",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "6",
      "cy": "8",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M28,4H4c-1.1028,0-2,.8975-2,2V26c0,1.1025,.8972,2,2,2H28c1.1028,0,2-.8975,2-2V6c0-1.1025-.8972-2-2-2Zm0,2v4H4V6H28ZM4,26V12H28v14H4Z"
    }
  }]);

  const CicsSit32 = createSVGComponent('CicsSit32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 22L30 27 23 32 23 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,3H6c-1.6543,0-3,1.3457-3,3V26c0,1.6543,1.3457,3,3,3h11v-9h12V6c0-1.6543-1.3457-3-3-3ZM6,5H26c.5515,0,1,.4482,1,1v3H5v-3c0-.5518,.4485-1,1-1Zm9,6v7H5v-7H15Zm0,16H6c-.5515,0-1-.4482-1-1v-6H15v7Zm2-9v-7h10v7h-10Z"
    }
  }]);

  const CicsSit24 = createSVGComponent('CicsSit24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 22L30 27 23 32 23 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,3H6c-1.6543,0-3,1.3457-3,3V26c0,1.6543,1.3457,3,3,3h11v-9h12V6c0-1.6543-1.3457-3-3-3ZM6,5H26c.5515,0,1,.4482,1,1v3H5v-3c0-.5518,.4485-1,1-1Zm9,6v7H5v-7H15Zm0,16H6c-.5515,0-1-.4482-1-1v-6H15v7Zm2-9v-7h10v7h-10Z"
    }
  }]);

  const CicsSit20 = createSVGComponent('CicsSit20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 22L30 27 23 32 23 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,3H6c-1.6543,0-3,1.3457-3,3V26c0,1.6543,1.3457,3,3,3h11v-9h12V6c0-1.6543-1.3457-3-3-3ZM6,5H26c.5515,0,1,.4482,1,1v3H5v-3c0-.5518,.4485-1,1-1Zm9,6v7H5v-7H15Zm0,16H6c-.5515,0-1-.4482-1-1v-6H15v7Zm2-9v-7h10v7h-10Z"
    }
  }]);

  const CicsSit16 = createSVGComponent('CicsSit16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23 22L30 27 23 32 23 22z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,3H6c-1.6543,0-3,1.3457-3,3V26c0,1.6543,1.3457,3,3,3h11v-9h12V6c0-1.6543-1.3457-3-3-3ZM6,5H26c.5515,0,1,.4482,1,1v3H5v-3c0-.5518,.4485-1,1-1Zm9,6v7H5v-7H15Zm0,16H6c-.5515,0-1-.4482-1-1v-6H15v7Zm2-9v-7h10v7h-10Z"
    }
  }]);

  const CicsSitOverrides32 = createSVGComponent('CicsSitOverrides32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.707 20.293l-3-3c-.3901-.3906-1.0239-.3906-1.4141 0l-9.293 9.293v4.4141h4.4143l9.2927-9.293c.3906-.3906.3906-1.0234 0-1.4141zm-7.4141 6l-2.7073 2.707h-1.5857v-1.5859l2.707-2.707 2.293-2.293 1.5859 1.5859-2.293 2.293zm3.707-3.707l-1.5859-1.5859 1.5859-1.5859 1.5857 1.5859-1.5857 1.5859zM20 20v-2h-4v-7h10v2h2V6c0-1.6543-1.3457-3-3-3H5c-1.6543 0-3 1.3457-3 3V26c0 1.6543 1.3457 3 3 3h11v-9h4zm-6-2H4v-7H14v7zM5 5H25c.5515 0 1 .4482 1 1v3H4v-3c0-.5518.4485-1 1-1zM14 27H5c-.5515 0-1-.4482-1-1v-6H14v7z"
    }
  }]);

  const CicsSitOverrides24 = createSVGComponent('CicsSitOverrides24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.707 20.293l-3-3c-.3901-.3906-1.0239-.3906-1.4141 0l-9.293 9.293v4.4141h4.4143l9.2927-9.293c.3906-.3906.3906-1.0234 0-1.4141zm-7.4141 6l-2.7073 2.707h-1.5857v-1.5859l2.707-2.707 2.293-2.293 1.5859 1.5859-2.293 2.293zm3.707-3.707l-1.5859-1.5859 1.5859-1.5859 1.5857 1.5859-1.5857 1.5859zM20 20v-2h-4v-7h10v2h2V6c0-1.6543-1.3457-3-3-3H5c-1.6543 0-3 1.3457-3 3V26c0 1.6543 1.3457 3 3 3h11v-9h4zm-6-2H4v-7H14v7zM5 5H25c.5515 0 1 .4482 1 1v3H4v-3c0-.5518.4485-1 1-1zM14 27H5c-.5515 0-1-.4482-1-1v-6H14v7z"
    }
  }]);

  const CicsSitOverrides20 = createSVGComponent('CicsSitOverrides20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.707 20.293l-3-3c-.3901-.3906-1.0239-.3906-1.4141 0l-9.293 9.293v4.4141h4.4143l9.2927-9.293c.3906-.3906.3906-1.0234 0-1.4141zm-7.4141 6l-2.7073 2.707h-1.5857v-1.5859l2.707-2.707 2.293-2.293 1.5859 1.5859-2.293 2.293zm3.707-3.707l-1.5859-1.5859 1.5859-1.5859 1.5857 1.5859-1.5857 1.5859zM20 20v-2h-4v-7h10v2h2V6c0-1.6543-1.3457-3-3-3H5c-1.6543 0-3 1.3457-3 3V26c0 1.6543 1.3457 3 3 3h11v-9h4zm-6-2H4v-7H14v7zM5 5H25c.5515 0 1 .4482 1 1v3H4v-3c0-.5518.4485-1 1-1zM14 27H5c-.5515 0-1-.4482-1-1v-6H14v7z"
    }
  }]);

  const CicsSitOverrides16 = createSVGComponent('CicsSitOverrides16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31.707 20.293l-3-3c-.3901-.3906-1.0239-.3906-1.4141 0l-9.293 9.293v4.4141h4.4143l9.2927-9.293c.3906-.3906.3906-1.0234 0-1.4141zm-7.4141 6l-2.7073 2.707h-1.5857v-1.5859l2.707-2.707 2.293-2.293 1.5859 1.5859-2.293 2.293zm3.707-3.707l-1.5859-1.5859 1.5859-1.5859 1.5857 1.5859-1.5857 1.5859zM20 20v-2h-4v-7h10v2h2V6c0-1.6543-1.3457-3-3-3H5c-1.6543 0-3 1.3457-3 3V26c0 1.6543 1.3457 3 3 3h11v-9h4zm-6-2H4v-7H14v7zM5 5H25c.5515 0 1 .4482 1 1v3H4v-3c0-.5518.4485-1 1-1zM14 27H5c-.5515 0-1-.4482-1-1v-6H14v7z"
    }
  }]);

  const CicsSystemGroup32 = createSVGComponent('CicsSystemGroup32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 2H23V4h5V28H23v2h5a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0028 2zM14 17H8a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V18A.9448.9448 0 0014 17zm-1 6H9V19h4z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25 24V18a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6A1.0021 1.0021 0 0025 24zm-2-1H19V19h4zM14 7H8A.9448.9448 0 007 8v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V8A.9448.9448 0 0014 7zm-1 6H9V9h4zM18 15h6a.9448.9448 0 001-1V8a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6A1.0021 1.0021 0 0018 15zm1-6h4v4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,4H9V2H4A2.0059,2.0059,0,0,0,2,4V28a2.0059,2.0059,0,0,0,2,2H9V28H4Z"
    }
  }]);

  const CicsSystemGroup24 = createSVGComponent('CicsSystemGroup24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 2H23V4h5V28H23v2h5a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0028 2zM14 17H8a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V18A.9448.9448 0 0014 17zm-1 6H9V19h4z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25 24V18a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6A1.0021 1.0021 0 0025 24zm-2-1H19V19h4zM14 7H8A.9448.9448 0 007 8v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V8A.9448.9448 0 0014 7zm-1 6H9V9h4zM18 15h6a.9448.9448 0 001-1V8a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6A1.0021 1.0021 0 0018 15zm1-6h4v4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,4H9V2H4A2.0059,2.0059,0,0,0,2,4V28a2.0059,2.0059,0,0,0,2,2H9V28H4Z"
    }
  }]);

  const CicsSystemGroup20 = createSVGComponent('CicsSystemGroup20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 2H23V4h5V28H23v2h5a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0028 2zM14 17H8a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V18A.9448.9448 0 0014 17zm-1 6H9V19h4z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25 24V18a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6A1.0021 1.0021 0 0025 24zm-2-1H19V19h4zM14 7H8A.9448.9448 0 007 8v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V8A.9448.9448 0 0014 7zm-1 6H9V9h4zM18 15h6a.9448.9448 0 001-1V8a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6A1.0021 1.0021 0 0018 15zm1-6h4v4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,4H9V2H4A2.0059,2.0059,0,0,0,2,4V28a2.0059,2.0059,0,0,0,2,2H9V28H4Z"
    }
  }]);

  const CicsSystemGroup16 = createSVGComponent('CicsSystemGroup16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M28 2H23V4h5V28H23v2h5a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0028 2zM14 17H8a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V18A.9448.9448 0 0014 17zm-1 6H9V19h4z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M25 24V18a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6a.9448.9448 0 001 1h6A1.0021 1.0021 0 0025 24zm-2-1H19V19h4zM14 7H8A.9448.9448 0 007 8v6a.9448.9448 0 001 1h6a.9448.9448 0 001-1V8A.9448.9448 0 0014 7zm-1 6H9V9h4zM18 15h6a.9448.9448 0 001-1V8a.9448.9448 0 00-1-1H18a.9448.9448 0 00-1 1v6A1.0021 1.0021 0 0018 15zm1-6h4v4H19z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M4,4H9V2H4A2.0059,2.0059,0,0,0,2,4V28a2.0059,2.0059,0,0,0,2,2H9V28H4Z"
    }
  }]);

  const CicsTransactionServerZos32 = createSVGComponent('CicsTransactionServerZos32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,29h-7v-2h7c4.9626,0,9-4.0374,9-9v-4h2v4c0,6.0654-4.9346,11-11,11Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,21c-2.7571,0-5-2.2429-5-5s2.2429-5,5-5,5,2.2429,5,5-2.2429,5-5,5Zm0-8c-1.6543,0-3,1.3457-3,3s1.3457,3,3,3,3-1.3457,3-3-1.3457-3-3-3Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5,18H3v-4C3,7.9346,7.9346,3,14,3h7v2h-7c-4.9626,0-9,4.0374-9,9v4Z"
    }
  }]);

  const CicsTransactionServerZos24 = createSVGComponent('CicsTransactionServerZos24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,29h-7v-2h7c4.9626,0,9-4.0374,9-9v-4h2v4c0,6.0654-4.9346,11-11,11Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,21c-2.7571,0-5-2.2429-5-5s2.2429-5,5-5,5,2.2429,5,5-2.2429,5-5,5Zm0-8c-1.6543,0-3,1.3457-3,3s1.3457,3,3,3,3-1.3457,3-3-1.3457-3-3-3Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5,18H3v-4C3,7.9346,7.9346,3,14,3h7v2h-7c-4.9626,0-9,4.0374-9,9v4Z"
    }
  }]);

  const CicsTransactionServerZos20 = createSVGComponent('CicsTransactionServerZos20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,29h-7v-2h7c4.9626,0,9-4.0374,9-9v-4h2v4c0,6.0654-4.9346,11-11,11Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,21c-2.7571,0-5-2.2429-5-5s2.2429-5,5-5,5,2.2429,5,5-2.2429,5-5,5Zm0-8c-1.6543,0-3,1.3457-3,3s1.3457,3,3,3,3-1.3457,3-3-1.3457-3-3-3Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5,18H3v-4C3,7.9346,7.9346,3,14,3h7v2h-7c-4.9626,0-9,4.0374-9,9v4Z"
    }
  }]);

  const CicsTransactionServerZos16 = createSVGComponent('CicsTransactionServerZos16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "28",
      "cy": "10",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M18,29h-7v-2h7c4.9626,0,9-4.0374,9-9v-4h2v4c0,6.0654-4.9346,11-11,11Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,21c-2.7571,0-5-2.2429-5-5s2.2429-5,5-5,5,2.2429,5,5-2.2429,5-5,5Zm0-8c-1.6543,0-3,1.3457-3,3s1.3457,3,3,3,3-1.3457,3-3-1.3457-3-3-3Z"
    }
  }, {
    "elem": "circle",
    "attrs": {
      "cx": "4",
      "cy": "22",
      "r": "2"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M5,18H3v-4C3,7.9346,7.9346,3,14,3h7v2h-7c-4.9626,0-9,4.0374-9,9v4Z"
    }
  }]);

  const CicsWuiRegion32 = createSVGComponent('CicsWuiRegion32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 22L24 22 24 28 22 28 22 30 28 30 28 28 26 28 26 22 28 22 28 20 22 20 22 22zM18 28H16V20H14v8.6A1.4529 1.4529 0 0015.5 30h3A1.4529 1.4529 0 0020 28.6V20H18zM10.2 20L10 28.5 9 22 7 22 6 28.5 5.8 20 4 20 4.72 30 7 30 8 23.5 9 30 11.28 30 12 20 10.2 20zM16 11L13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V18H6V6H26V18h2V6A2.0059,2.0059,0,0,0,26,4Z"
    }
  }]);

  const CicsWuiRegion24 = createSVGComponent('CicsWuiRegion24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 22L24 22 24 28 22 28 22 30 28 30 28 28 26 28 26 22 28 22 28 20 22 20 22 22zM18 28H16V20H14v8.6A1.4529 1.4529 0 0015.5 30h3A1.4529 1.4529 0 0020 28.6V20H18zM10.2 20L10 28.5 9 22 7 22 6 28.5 5.8 20 4 20 4.72 30 7 30 8 23.5 9 30 11.28 30 12 20 10.2 20zM16 11L13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V18H6V6H26V18h2V6A2.0059,2.0059,0,0,0,26,4Z"
    }
  }]);

  const CicsWuiRegion20 = createSVGComponent('CicsWuiRegion20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 22L24 22 24 28 22 28 22 30 28 30 28 28 26 28 26 22 28 22 28 20 22 20 22 22zM18 28H16V20H14v8.6A1.4529 1.4529 0 0015.5 30h3A1.4529 1.4529 0 0020 28.6V20H18zM10.2 20L10 28.5 9 22 7 22 6 28.5 5.8 20 4 20 4.72 30 7 30 8 23.5 9 30 11.28 30 12 20 10.2 20zM16 11L13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V18H6V6H26V18h2V6A2.0059,2.0059,0,0,0,26,4Z"
    }
  }]);

  const CicsWuiRegion16 = createSVGComponent('CicsWuiRegion16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 22L24 22 24 28 22 28 22 30 28 30 28 28 26 28 26 22 28 22 28 20 22 20 22 22zM18 28H16V20H14v8.6A1.4529 1.4529 0 0015.5 30h3A1.4529 1.4529 0 0020 28.6V20H18zM10.2 20L10 28.5 9 22 7 22 6 28.5 5.8 20 4 20 4.72 30 7 30 8 23.5 9 30 11.28 30 12 20 10.2 20zM16 11L13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13 16 11z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V18H6V6H26V18h2V6A2.0059,2.0059,0,0,0,26,4Z"
    }
  }]);

  const CicsRegion32 = createSVGComponent('CicsRegion32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.5 18L21 18.7 21 16 19 16 19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18zM16 13L16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V6A2.0059,2.0059,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CicsRegion24 = createSVGComponent('CicsRegion24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.5 18L21 18.7 21 16 19 16 19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18zM16 13L16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V6A2.0059,2.0059,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CicsRegion20 = createSVGComponent('CicsRegion20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.5 18L21 18.7 21 16 19 16 19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18zM16 13L16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V6A2.0059,2.0059,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CicsRegion16 = createSVGComponent('CicsRegion16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M23.5 18L21 18.7 21 16 19 16 19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18zM16 13L16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16 13 13 16 13z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V6A2.0059,2.0059,0,0,0,26,4ZM6,26V6H26V26Z"
    }
  }]);

  const CicsRegionAlt32 = createSVGComponent('CicsRegionAlt32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 13v-2h-4c-1.1028 0-2 .8975-2 2v2c0 1.1025.8972 2 2 2h2v2h-4v2h4c1.1028 0 2-.8975 2-2v-2c0-1.1025-.8972-2-2-2h-2v-2h4zM17 13v6c0 1.1025.8972 2 2 2h4v-2h-4v-6h4v-2h-4c-1.1028 0-2 .8975-2 2zM9 13L11 13 11 19 9 19 9 21 15 21 15 19 13 19 13 13 15 13 15 11 9 11 9 13zM1 13v6c0 1.1025.8972 2 2 2H7v-2H3v-6H7v-2H3c-1.1028 0-2 .8975-2 2z"
    }
  }]);

  const CicsRegionAlt24 = createSVGComponent('CicsRegionAlt24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 13v-2h-4c-1.1028 0-2 .8975-2 2v2c0 1.1025.8972 2 2 2h2v2h-4v2h4c1.1028 0 2-.8975 2-2v-2c0-1.1025-.8972-2-2-2h-2v-2h4zM17 13v6c0 1.1025.8972 2 2 2h4v-2h-4v-6h4v-2h-4c-1.1028 0-2 .8975-2 2zM9 13L11 13 11 19 9 19 9 21 15 21 15 19 13 19 13 13 15 13 15 11 9 11 9 13zM1 13v6c0 1.1025.8972 2 2 2H7v-2H3v-6H7v-2H3c-1.1028 0-2 .8975-2 2z"
    }
  }]);

  const CicsRegionAlt20 = createSVGComponent('CicsRegionAlt20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 13v-2h-4c-1.1028 0-2 .8975-2 2v2c0 1.1025.8972 2 2 2h2v2h-4v2h4c1.1028 0 2-.8975 2-2v-2c0-1.1025-.8972-2-2-2h-2v-2h4zM17 13v6c0 1.1025.8972 2 2 2h4v-2h-4v-6h4v-2h-4c-1.1028 0-2 .8975-2 2zM9 13L11 13 11 19 9 19 9 21 15 21 15 19 13 19 13 13 15 13 15 11 9 11 9 13zM1 13v6c0 1.1025.8972 2 2 2H7v-2H3v-6H7v-2H3c-1.1028 0-2 .8975-2 2z"
    }
  }]);

  const CicsRegionAlt16 = createSVGComponent('CicsRegionAlt16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M31 13v-2h-4c-1.1028 0-2 .8975-2 2v2c0 1.1025.8972 2 2 2h2v2h-4v2h4c1.1028 0 2-.8975 2-2v-2c0-1.1025-.8972-2-2-2h-2v-2h4zM17 13v6c0 1.1025.8972 2 2 2h4v-2h-4v-6h4v-2h-4c-1.1028 0-2 .8975-2 2zM9 13L11 13 11 19 9 19 9 21 15 21 15 19 13 19 13 13 15 13 15 11 9 11 9 13zM1 13v6c0 1.1025.8972 2 2 2H7v-2H3v-6H7v-2H3c-1.1028 0-2 .8975-2 2z"
    }
  }]);

  const CicsRegionRouting32 = createSVGComponent('CicsRegionRouting32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 2L22 4 26.6 4 20 10.6 21.4 12 28 5.4 28 10 30 10 30 2 22 2zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionRouting24 = createSVGComponent('CicsRegionRouting24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 2L22 4 26.6 4 20 10.6 21.4 12 28 5.4 28 10 30 10 30 2 22 2zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionRouting20 = createSVGComponent('CicsRegionRouting20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 2L22 4 26.6 4 20 10.6 21.4 12 28 5.4 28 10 30 10 30 2 22 2zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionRouting16 = createSVGComponent('CicsRegionRouting16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M22 2L22 4 26.6 4 20 10.6 21.4 12 28 5.4 28 10 30 10 30 2 22 2zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionTarget32 = createSVGComponent('CicsRegionTarget32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 7H28V10H26zM29 4H32V6H29zM26 0H28V3H26zM22 4H25V6H22zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionTarget24 = createSVGComponent('CicsRegionTarget24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 7H28V10H26zM29 4H32V6H29zM26 0H28V3H26zM22 4H25V6H22zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionTarget20 = createSVGComponent('CicsRegionTarget20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 7H28V10H26zM29 4H32V6H29zM26 0H28V3H26zM22 4H25V6H22zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const CicsRegionTarget16 = createSVGComponent('CicsRegionTarget16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M26 7H28V10H26zM29 4H32V6H29zM26 0H28V3H26zM22 4H25V6H22zM19 16L19 18.7 16.5 18 16 19.9 18.4 20.6 17 23 18.7 24 20 21.8 21.3 24 23 23 21.6 20.6 24 19.9 23.5 18 21 18.7 21 16 19 16zM13 16L13 13 16 13 16 11 13 11 13 8 11 8 11 11 8 11 8 13 11 13 11 16 13 16z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M26,26H6V6H19V4H6A2.0059,2.0059,0,0,0,4,6V26a2.0059,2.0059,0,0,0,2,2H26a2.0059,2.0059,0,0,0,2-2V13H26Z"
    }
  }]);

  const Cicsplex32 = createSVGComponent('Cicsplex32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 18.6V17H6v1.6A7.3833 7.3833 0 0013.4 26H15V24H13.4A5.3775 5.3775 0 018 18.6zM28 18H20a2.0059 2.0059 0 00-2 2v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V20A2.0059 2.0059 0 0028 18zM20 28V20h8v8zM24 13.4V15h2V13.4A7.3833 7.3833 0 0018.6 6H17V8h1.6A5.3775 5.3775 0 0124 13.4zM12 2H4A2.0059 2.0059 0 002 4v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0012 2zM4 12V4h8v8z"
    }
  }]);

  const Cicsplex24 = createSVGComponent('Cicsplex24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 18.6V17H6v1.6A7.3833 7.3833 0 0013.4 26H15V24H13.4A5.3775 5.3775 0 018 18.6zM28 18H20a2.0059 2.0059 0 00-2 2v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V20A2.0059 2.0059 0 0028 18zM20 28V20h8v8zM24 13.4V15h2V13.4A7.3833 7.3833 0 0018.6 6H17V8h1.6A5.3775 5.3775 0 0124 13.4zM12 2H4A2.0059 2.0059 0 002 4v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0012 2zM4 12V4h8v8z"
    }
  }]);

  const Cicsplex20 = createSVGComponent('Cicsplex20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 18.6V17H6v1.6A7.3833 7.3833 0 0013.4 26H15V24H13.4A5.3775 5.3775 0 018 18.6zM28 18H20a2.0059 2.0059 0 00-2 2v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V20A2.0059 2.0059 0 0028 18zM20 28V20h8v8zM24 13.4V15h2V13.4A7.3833 7.3833 0 0018.6 6H17V8h1.6A5.3775 5.3775 0 0124 13.4zM12 2H4A2.0059 2.0059 0 002 4v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0012 2zM4 12V4h8v8z"
    }
  }]);

  const Cicsplex16 = createSVGComponent('Cicsplex16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8 18.6V17H6v1.6A7.3833 7.3833 0 0013.4 26H15V24H13.4A5.3775 5.3775 0 018 18.6zM28 18H20a2.0059 2.0059 0 00-2 2v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V20A2.0059 2.0059 0 0028 18zM20 28V20h8v8zM24 13.4V15h2V13.4A7.3833 7.3833 0 0018.6 6H17V8h1.6A5.3775 5.3775 0 0124 13.4zM12 2H4A2.0059 2.0059 0 002 4v8a2.0059 2.0059 0 002 2h8a2.0059 2.0059 0 002-2V4A2.0059 2.0059 0 0012 2zM4 12V4h8v8z"
    }
  }]);

  const CircleFilled32 = createSVGComponent('CircleFilled32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "10"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CircleFilled24 = createSVGComponent('CircleFilled24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "10"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CircleFilled20 = createSVGComponent('CircleFilled20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "10"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CircleFilled16 = createSVGComponent('CircleFilled16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "10"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    }
  }]);

  const CircleSolid32 = createSVGComponent('CircleSolid32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "14"
    }
  }]);

  const CircleSolid24 = createSVGComponent('CircleSolid24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "14"
    }
  }]);

  const CircleSolid20 = createSVGComponent('CircleSolid20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "14"
    }
  }]);

  const CircleSolid16 = createSVGComponent('CircleSolid16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "16",
      "cy": "16",
      "r": "14"
    }
  }]);

  const CircleDash32 = createSVGComponent('CircleDash32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.7 4.7a14.7 14.7 0 00-3 3.1L6.3 9A13.26 13.26 0 018.9 6.3zM4.6 12.3l-1.9-.6A12.51 12.51 0 002 16H4A11.48 11.48 0 014.6 12.3zM2.7 20.4a14.4 14.4 0 002 3.9l1.6-1.2a12.89 12.89 0 01-1.7-3.3zM7.8 27.3a14.4 14.4 0 003.9 2l.6-1.9A12.89 12.89 0 019 25.7zM11.7 2.7l.6 1.9A11.48 11.48 0 0116 4V2A12.51 12.51 0 0011.7 2.7zM24.2 27.3a15.18 15.18 0 003.1-3.1L25.7 23A11.53 11.53 0 0123 25.7zM27.4 19.7l1.9.6A15.47 15.47 0 0030 16H28A11.48 11.48 0 0127.4 19.7zM29.2 11.6a14.4 14.4 0 00-2-3.9L25.6 8.9a12.89 12.89 0 011.7 3.3zM24.1 4.6a14.4 14.4 0 00-3.9-2l-.6 1.9a12.89 12.89 0 013.3 1.7zM20.3 29.3l-.6-1.9A11.48 11.48 0 0116 28v2A21.42 21.42 0 0020.3 29.3z"
    }
  }]);

  const CircleDash24 = createSVGComponent('CircleDash24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.7 4.7a14.7 14.7 0 00-3 3.1L6.3 9A13.26 13.26 0 018.9 6.3zM4.6 12.3l-1.9-.6A12.51 12.51 0 002 16H4A11.48 11.48 0 014.6 12.3zM2.7 20.4a14.4 14.4 0 002 3.9l1.6-1.2a12.89 12.89 0 01-1.7-3.3zM7.8 27.3a14.4 14.4 0 003.9 2l.6-1.9A12.89 12.89 0 019 25.7zM11.7 2.7l.6 1.9A11.48 11.48 0 0116 4V2A12.51 12.51 0 0011.7 2.7zM24.2 27.3a15.18 15.18 0 003.1-3.1L25.7 23A11.53 11.53 0 0123 25.7zM27.4 19.7l1.9.6A15.47 15.47 0 0030 16H28A11.48 11.48 0 0127.4 19.7zM29.2 11.6a14.4 14.4 0 00-2-3.9L25.6 8.9a12.89 12.89 0 011.7 3.3zM24.1 4.6a14.4 14.4 0 00-3.9-2l-.6 1.9a12.89 12.89 0 013.3 1.7zM20.3 29.3l-.6-1.9A11.48 11.48 0 0116 28v2A21.42 21.42 0 0020.3 29.3z"
    }
  }]);

  const CircleDash20 = createSVGComponent('CircleDash20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.7 4.7a14.7 14.7 0 00-3 3.1L6.3 9A13.26 13.26 0 018.9 6.3zM4.6 12.3l-1.9-.6A12.51 12.51 0 002 16H4A11.48 11.48 0 014.6 12.3zM2.7 20.4a14.4 14.4 0 002 3.9l1.6-1.2a12.89 12.89 0 01-1.7-3.3zM7.8 27.3a14.4 14.4 0 003.9 2l.6-1.9A12.89 12.89 0 019 25.7zM11.7 2.7l.6 1.9A11.48 11.48 0 0116 4V2A12.51 12.51 0 0011.7 2.7zM24.2 27.3a15.18 15.18 0 003.1-3.1L25.7 23A11.53 11.53 0 0123 25.7zM27.4 19.7l1.9.6A15.47 15.47 0 0030 16H28A11.48 11.48 0 0127.4 19.7zM29.2 11.6a14.4 14.4 0 00-2-3.9L25.6 8.9a12.89 12.89 0 011.7 3.3zM24.1 4.6a14.4 14.4 0 00-3.9-2l-.6 1.9a12.89 12.89 0 013.3 1.7zM20.3 29.3l-.6-1.9A11.48 11.48 0 0116 28v2A21.42 21.42 0 0020.3 29.3z"
    }
  }]);

  const CircleDash16 = createSVGComponent('CircleDash16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M7.7 4.7a14.7 14.7 0 00-3 3.1L6.3 9A13.26 13.26 0 018.9 6.3zM4.6 12.3l-1.9-.6A12.51 12.51 0 002 16H4A11.48 11.48 0 014.6 12.3zM2.7 20.4a14.4 14.4 0 002 3.9l1.6-1.2a12.89 12.89 0 01-1.7-3.3zM7.8 27.3a14.4 14.4 0 003.9 2l.6-1.9A12.89 12.89 0 019 25.7zM11.7 2.7l.6 1.9A11.48 11.48 0 0116 4V2A12.51 12.51 0 0011.7 2.7zM24.2 27.3a15.18 15.18 0 003.1-3.1L25.7 23A11.53 11.53 0 0123 25.7zM27.4 19.7l1.9.6A15.47 15.47 0 0030 16H28A11.48 11.48 0 0127.4 19.7zM29.2 11.6a14.4 14.4 0 00-2-3.9L25.6 8.9a12.89 12.89 0 011.7 3.3zM24.1 4.6a14.4 14.4 0 00-3.9-2l-.6 1.9a12.89 12.89 0 013.3 1.7zM20.3 29.3l-.6-1.9A11.48 11.48 0 0116 28v2A21.42 21.42 0 0020.3 29.3z"
    }
  }]);

  const CircleFillGlyph = createSVGComponent('CircleFillGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": "16",
    "height": "16"
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "8",
      "cy": "8",
      "r": "6"
    }
  }]);

  const WatsonHealthCircleMeasurement32 = createSVGComponent('WatsonHealthCircleMeasurement32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14,14,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,12.41V16h2V9H16v2h3.59L11,19.59V16H9v7h7V21H12.41Z"
    }
  }]);

  const WatsonHealthCircleMeasurement24 = createSVGComponent('WatsonHealthCircleMeasurement24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14,14,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,12.41V16h2V9H16v2h3.59L11,19.59V16H9v7h7V21H12.41Z"
    }
  }]);

  const WatsonHealthCircleMeasurement20 = createSVGComponent('WatsonHealthCircleMeasurement20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14,14,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,12.41V16h2V9H16v2h3.59L11,19.59V16H9v7h7V21H12.41Z"
    }
  }]);

  const WatsonHealthCircleMeasurement16 = createSVGComponent('WatsonHealthCircleMeasurement16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,30A14,14,0,1,1,30,16,14,14,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4Z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M21,12.41V16h2V9H16v2h3.59L11,19.59V16H9v7h7V21H12.41Z"
    }
  }]);

  const CirclePacking32 = createSVGComponent('CirclePacking32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm7.5,7A3.5,3.5,0,1,1,20,12.5,3.5041,3.5041,0,0,1,23.5,9Zm.4348-1.978C23.791,7.0107,23.6467,7,23.5,7a5.4826,5.4826,0,0,0-4.1323,1.8784,8.0109,8.0109,0,0,0-5.5664-4.6675A11.8554,11.8554,0,0,1,23.9348,7.022ZM16,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,28ZM12,18a6,6,0,1,1,6-6A6.0067,6.0067,0,0,1,12,18ZM4,16a11.97,11.97,0,0,1,.2112-2.1987,7.9921,7.9921,0,0,0,7.3459,6.1762,5.9581,5.9581,0,0,0-.89,6.7564A12.0025,12.0025,0,0,1,4,16ZM21.3325,26.7339a5.9834,5.9834,0,0,0-4.1782-8.6206,8.02,8.02,0,0,0,1.9126-2.3672,5.4883,5.4883,0,0,0,8.9167-.0679c.003.1079.0164.2134.0164.3218A12.0025,12.0025,0,0,1,21.3325,26.7339Z"
    }
  }]);

  const CirclePacking24 = createSVGComponent('CirclePacking24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm7.5,7A3.5,3.5,0,1,1,20,12.5,3.5041,3.5041,0,0,1,23.5,9Zm.4348-1.978C23.791,7.0107,23.6467,7,23.5,7a5.4826,5.4826,0,0,0-4.1323,1.8784,8.0109,8.0109,0,0,0-5.5664-4.6675A11.8554,11.8554,0,0,1,23.9348,7.022ZM16,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,28ZM12,18a6,6,0,1,1,6-6A6.0067,6.0067,0,0,1,12,18ZM4,16a11.97,11.97,0,0,1,.2112-2.1987,7.9921,7.9921,0,0,0,7.3459,6.1762,5.9581,5.9581,0,0,0-.89,6.7564A12.0025,12.0025,0,0,1,4,16ZM21.3325,26.7339a5.9834,5.9834,0,0,0-4.1782-8.6206,8.02,8.02,0,0,0,1.9126-2.3672,5.4883,5.4883,0,0,0,8.9167-.0679c.003.1079.0164.2134.0164.3218A12.0025,12.0025,0,0,1,21.3325,26.7339Z"
    }
  }]);

  const CirclePacking20 = createSVGComponent('CirclePacking20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm7.5,7A3.5,3.5,0,1,1,20,12.5,3.5041,3.5041,0,0,1,23.5,9Zm.4348-1.978C23.791,7.0107,23.6467,7,23.5,7a5.4826,5.4826,0,0,0-4.1323,1.8784,8.0109,8.0109,0,0,0-5.5664-4.6675A11.8554,11.8554,0,0,1,23.9348,7.022ZM16,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,28ZM12,18a6,6,0,1,1,6-6A6.0067,6.0067,0,0,1,12,18ZM4,16a11.97,11.97,0,0,1,.2112-2.1987,7.9921,7.9921,0,0,0,7.3459,6.1762,5.9581,5.9581,0,0,0-.89,6.7564A12.0025,12.0025,0,0,1,4,16ZM21.3325,26.7339a5.9834,5.9834,0,0,0-4.1782-8.6206,8.02,8.02,0,0,0,1.9126-2.3672,5.4883,5.4883,0,0,0,8.9167-.0679c.003.1079.0164.2134.0164.3218A12.0025,12.0025,0,0,1,21.3325,26.7339Z"
    }
  }]);

  const CirclePacking16 = createSVGComponent('CirclePacking16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm7.5,7A3.5,3.5,0,1,1,20,12.5,3.5041,3.5041,0,0,1,23.5,9Zm.4348-1.978C23.791,7.0107,23.6467,7,23.5,7a5.4826,5.4826,0,0,0-4.1323,1.8784,8.0109,8.0109,0,0,0-5.5664-4.6675A11.8554,11.8554,0,0,1,23.9348,7.022ZM16,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,28ZM12,18a6,6,0,1,1,6-6A6.0067,6.0067,0,0,1,12,18ZM4,16a11.97,11.97,0,0,1,.2112-2.1987,7.9921,7.9921,0,0,0,7.3459,6.1762,5.9581,5.9581,0,0,0-.89,6.7564A12.0025,12.0025,0,0,1,4,16ZM21.3325,26.7339a5.9834,5.9834,0,0,0-4.1782-8.6206,8.02,8.02,0,0,0,1.9126-2.3672,5.4883,5.4883,0,0,0,8.9167-.0679c.003.1079.0164.2134.0164.3218A12.0025,12.0025,0,0,1,21.3325,26.7339Z"
    }
  }]);

  const CircleStrokeGlyph = createSVGComponent('CircleStrokeGlyph', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 16 16",
    "fill": "currentColor",
    "width": "16",
    "height": "16"
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M8,4A4,4,0,1,1,4,8,4.0045,4.0045,0,0,1,8,4M8,2a6,6,0,1,0,6,6A6,6,0,0,0,8,2Z"
    }
  }]);

  const QCircuitComposer32 = createSVGComponent('QCircuitComposer32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9L18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"
    }
  }]);

  const QCircuitComposer24 = createSVGComponent('QCircuitComposer24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9L18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"
    }
  }]);

  const QCircuitComposer20 = createSVGComponent('QCircuitComposer20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9L18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"
    }
  }]);

  const QCircuitComposer16 = createSVGComponent('QCircuitComposer16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "path",
    "attrs": {
      "d": "M18 9L18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9z"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"
    }
  }]);

  const Classification32 = createSVGComponent('Classification32', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 32,
    "height": 32
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "19",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"
    }
  }]);

  const Classification24 = createSVGComponent('Classification24', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 24,
    "height": 24
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "19",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"
    }
  }]);

  const Classification20 = createSVGComponent('Classification20', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 20,
    "height": 20
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "19",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"
    }
  }]);

  const Classification16 = createSVGComponent('Classification16', {
    "xmlns": "http://www.w3.org/2000/svg",
    "viewBox": "0 0 32 32",
    "fill": "currentColor",
    "width": 16,
    "height": 16
  }, [{
    "elem": "circle",
    "attrs": {
      "cx": "15",
      "cy": "19",
      "r": "1"
    }
  }, {
    "elem": "path",
    "attrs": {
      "d": "M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"
   