(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CarbonMotion = {}));
})(this, (function (exports) { 'use strict';

  /**
   * Copyright IBM Corp. 2018, 2023
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var fast01 = '70ms';
  var fast02 = '110ms';
  var moderate01 = '150ms';
  var moderate02 = '240ms';
  var slow01 = '400ms';
  var slow02 = '700ms';
  // V11 Tokens
  var durationFast01 = fast01;
  var durationFast02 = fast02;
  var durationModerate01 = moderate01;
  var durationModerate02 = moderate02;
  var durationSlow01 = slow01;
  var durationSlow02 = slow02;
  var unstable_tokens = ['fast01', 'fast02', 'moderate01', 'moderate02', 'slow01', 'slow02', 'durationFast01', 'durationFast02', 'durationModerate01', 'durationModerate02', 'durationSlow01', 'durationSlow02'];
  var easings = {
    standard: {
      productive: 'cubic-bezier(0.2, 0, 0.38, 0.9)',
      expressive: 'cubic-bezier(0.4, 0.14, 0.3, 1)'
    },
    entrance: {
      productive: 'cubic-bezier(0, 0, 0.38, 0.9)',
      expressive: 'cubic-bezier(0, 0, 0.3, 1)'
    },
    exit: {
      productive: 'cubic-bezier(0.2, 0, 1, 0.9)',
      expressive: 'cubic-bezier(0.4, 0.14, 1, 1)'
    }
  };
  function motion(name, mode) {
    if (!easings[name]) {
      throw new Error("Unable to find easing `".concat(name, "` in our supported easings. Expected ") + "One of: ".concat(Object.keys(easings).join(', ')));
    }
    var easing = easings[name];
    if (!easing[mode]) {
      throw new Error("Unable to find a mode for the easing `".concat(name, "` called: `").concat(mode, "`"));
    }
    return easing[mode];
  }

  exports.durationFast01 = durationFast01;
  exports.durationFast02 = durationFast02;
  exports.durationModerate01 = durationModerate01;
  exports.durationModerate02 = durationModerate02;
  exports.durationSlow01 = durationSlow01;
  exports.durationSlow02 = durationSlow02;
  exports.easings = easings;
  exports.fast01 = fast01;
  exports.fast02 = fast02;
  exports.moderate01 = moderate01;
  exports.moderate02 = moderate02;
  exports.motion = motion;
  exports.slow01 = slow01;
  exports.slow02 = slow02;
  exports.unstable_tokens = unstable_tokens;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
