'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var colors$1 = require('@carbon/colors');
var Color = require('color');
var type$2 = require('@carbon/type');
var layout$2 = require('@carbon/layout');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var Color__default = /*#__PURE__*/_interopDefaultLegacy(Color);

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _regeneratorRuntime() {
  _regeneratorRuntime = function () {
    return exports;
  };
  var exports = {},
    Op = Object.prototype,
    hasOwn = Op.hasOwnProperty,
    defineProperty = Object.defineProperty || function (obj, key, desc) {
      obj[key] = desc.value;
    },
    $Symbol = "function" == typeof Symbol ? Symbol : {},
    iteratorSymbol = $Symbol.iterator || "@@iterator",
    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
  function define(obj, key, value) {
    return Object.defineProperty(obj, key, {
      value: value,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }), obj[key];
  }
  try {
    define({}, "");
  } catch (err) {
    define = function (obj, key, value) {
      return obj[key] = value;
    };
  }
  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
      generator = Object.create(protoGenerator.prototype),
      context = new Context(tryLocsList || []);
    return defineProperty(generator, "_invoke", {
      value: makeInvokeMethod(innerFn, self, context)
    }), generator;
  }
  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }
  exports.wrap = wrap;
  var ContinueSentinel = {};
  function Generator() {}
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  var IteratorPrototype = {};
  define(IteratorPrototype, iteratorSymbol, function () {
    return this;
  });
  var getProto = Object.getPrototypeOf,
    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }
  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);
      if ("throw" !== record.type) {
        var result = record.arg,
          value = result.value;
        return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
          invoke("next", value, resolve, reject);
        }, function (err) {
          invoke("throw", err, resolve, reject);
        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped, resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
      reject(record.arg);
    }
    var previousPromise;
    defineProperty(this, "_invoke", {
      value: function (method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function (resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }
        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
      }
    });
  }
  function makeInvokeMethod(innerFn, self, context) {
    var state = "suspendedStart";
    return function (method, arg) {
      if ("executing" === state) throw new Error("Generator is already running");
      if ("completed" === state) {
        if ("throw" === method) throw arg;
        return doneResult();
      }
      for (context.method = method, context.arg = arg;;) {
        var delegate = context.delegate;
        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);
          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }
        if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
          if ("suspendedStart" === state) throw state = "completed", context.arg;
          context.dispatchException(context.arg);
        } else "return" === context.method && context.abrupt("return", context.arg);
        state = "executing";
        var record = tryCatch(innerFn, self, context);
        if ("normal" === record.type) {
          if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
          return {
            value: record.arg,
            done: context.done
          };
        }
        "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
      }
    };
  }
  function maybeInvokeDelegate(delegate, context) {
    var methodName = context.method,
      method = delegate.iterator[methodName];
    if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
    var record = tryCatch(method, delegate.iterator, context.arg);
    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
    var info = record.arg;
    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
  }
  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };
    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
  }
  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal", delete record.arg, entry.completion = record;
  }
  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
  }
  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];
      if (iteratorMethod) return iteratorMethod.call(iterable);
      if ("function" == typeof iterable.next) return iterable;
      if (!isNaN(iterable.length)) {
        var i = -1,
          next = function next() {
            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
            return next.value = undefined, next.done = !0, next;
          };
        return next.next = next;
      }
    }
    return {
      next: doneResult
    };
  }
  function doneResult() {
    return {
      value: undefined,
      done: !0
    };
  }
  return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
    value: GeneratorFunctionPrototype,
    configurable: !0
  }), defineProperty(GeneratorFunctionPrototype, "constructor", {
    value: GeneratorFunction,
    configurable: !0
  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
    var ctor = "function" == typeof genFun && genFun.constructor;
    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
  }, exports.mark = function (genFun) {
    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
  }, exports.awrap = function (arg) {
    return {
      __await: arg
    };
  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
    return this;
  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    void 0 === PromiseImpl && (PromiseImpl = Promise);
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
    return this;
  }), define(Gp, "toString", function () {
    return "[object Generator]";
  }), exports.keys = function (val) {
    var object = Object(val),
      keys = [];
    for (var key in object) keys.push(key);
    return keys.reverse(), function next() {
      for (; keys.length;) {
        var key = keys.pop();
        if (key in object) return next.value = key, next.done = !1, next;
      }
      return next.done = !0, next;
    };
  }, exports.values = values, Context.prototype = {
    constructor: Context,
    reset: function (skipTempReset) {
      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
    },
    stop: function () {
      this.done = !0;
      var rootRecord = this.tryEntries[0].completion;
      if ("throw" === rootRecord.type) throw rootRecord.arg;
      return this.rval;
    },
    dispatchException: function (exception) {
      if (this.done) throw exception;
      var context = this;
      function handle(loc, caught) {
        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
      }
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i],
          record = entry.completion;
        if ("root" === entry.tryLoc) return handle("end");
        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc"),
            hasFinally = hasOwn.call(entry, "finallyLoc");
          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
          } else {
            if (!hasFinally) throw new Error("try statement without catch or finally");
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          }
        }
      }
    },
    abrupt: function (type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }
      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
      var record = finallyEntry ? finallyEntry.completion : {};
      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
    },
    complete: function (record, afterLoc) {
      if ("throw" === record.type) throw record.arg;
      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
    },
    finish: function (finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
      }
    },
    catch: function (tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;
          if ("throw" === record.type) {
            var thrown = record.arg;
            resetTryEntry(entry);
          }
          return thrown;
        }
      }
      throw new Error("illegal catch attempt");
    },
    delegateYield: function (iterable, resultName, nextLoc) {
      return this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
    }
  }, exports;
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _createForOfIteratorHelper(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (!it) {
    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it) o = it;
      var i = 0;
      var F = function () {};
      return {
        s: F,
        n: function () {
          if (i >= o.length) return {
            done: true
          };
          return {
            done: false,
            value: o[i++]
          };
        },
        e: function (e) {
          throw e;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true,
    didErr = false,
    err;
  return {
    s: function () {
      it = it.call(o);
    },
    n: function () {
      var step = it.next();
      normalCompletion = step.done;
      return step;
    },
    e: function (e) {
      didErr = true;
      err = e;
    },
    f: function () {
      try {
        if (!normalCompletion && it.return != null) it.return();
      } finally {
        if (didErr) throw err;
      }
    }
  };
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}

/**
 * Adjust a given token's lightness by a specified percentage
 * Example: token = hsl(10, 10, 10);
 * adjustLightness(token, 5) === hsl(10, 10, 15);
 * adjustLightness(token, -5) === hsl(10, 10, 5);
 * @param {string} token
 * @param {integer} shift The number of percentage points (positive or negative) by which to shift the lightness of a token.
 * @returns {string}
 */
function adjustLightness(token, shift) {
  var original = Color__default["default"](token).hsl().object();
  return Color__default["default"](_objectSpread2(_objectSpread2({}, original), {}, {
    l: original.l += shift
  })).round().hex().toLowerCase();
}

/**
 * Adjust a given token's alpha by a specified amount
 * Example: token = rgba(10, 10, 10, 1.0);
 * adjustAlpha(token, 0.3) === rgba(10, 10, 10, 0.3);
 * @param {string} token
 * @param {float} alpha
 * @returns {string}
 */
function adjustAlpha(token, alpha) {
  return Color__default["default"](token).rgb().alpha(alpha).string();
}
var numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];

/**
 * Format a given token into the format expected in CSS/SCSS-based projects.
 * @param {string} token
 * @returns {string}
 */
function formatTokenName(token) {
  var string = '';
  for (var i = 0; i < token.length; i++) {
    // If we run into a number, we hit the scale step at the end of a token name
    // and can safely truncate the rest of the token
    if (numbers.indexOf(token[i]) !== -1) {
      string += '-' + token.slice(i);
      break;
    }

    // When encountering an uppercase name, we will want to start adding `-`
    // between words
    if (token[i] === token[i].toUpperCase()) {
      // Check backwards to see if previous letter was also capitalized, if so
      // we are in a special case like UI where each piece should be connected
      if (token[i - 1] && token[i - 1] === token[i - 1].toUpperCase()) {
        string += token[i].toLowerCase();
        continue;
      }

      // Otherwise, just concatenate this new part on to the existing string
      string += '-' + token[i].toLowerCase();
      continue;
    }

    // By default, we add the current character to the output string
    string += token[i];
  }
  return string;
}

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

// Background
var background$8 = colors$1.white;
var backgroundInverse$7 = colors$1.gray80;
var backgroundBrand$7 = colors$1.blue60;
var backgroundActive$7 = adjustAlpha(colors$1.gray50, 0.5);
var backgroundHover$7 = adjustAlpha(colors$1.gray50, 0.12);
var backgroundInverseHover$7 = colors$1.gray80Hover;
var backgroundSelected$7 = adjustAlpha(colors$1.gray50, 0.2);
var backgroundSelectedHover$7 = adjustAlpha(colors$1.gray50, 0.32);

// Layer
// layer-01
var layer01$3 = colors$1.gray10;
var layerActive01$3 = colors$1.gray30;
var layerHover01$3 = colors$1.gray10Hover;
var layerSelected01$3 = colors$1.gray20;
var layerSelectedHover01$3 = colors$1.gray20Hover;

// layer-02
var layer02$3 = colors$1.white;
var layerActive02$3 = colors$1.gray30;
var layerHover02$3 = colors$1.whiteHover;
var layerSelected02$3 = colors$1.gray20;
var layerSelectedHover02$3 = colors$1.gray20Hover;

// layer-03
var layer03$3 = colors$1.gray10;
var layerActive03$3 = colors$1.gray30;
var layerHover03$3 = colors$1.gray10Hover;
var layerSelected03$3 = colors$1.gray20;
var layerSelectedHover03$3 = colors$1.gray20Hover;

// layer
var layerSelectedInverse$7 = colors$1.gray100;
var layerSelectedDisabled$7 = colors$1.gray50;

// layer-accent-01
var layerAccent01$3 = colors$1.gray20;
var layerAccentActive01$3 = colors$1.gray40;
var layerAccentHover01$3 = colors$1.gray20Hover;

// layer-accent-02
var layerAccent02$3 = colors$1.gray20;
var layerAccentActive02$3 = colors$1.gray40;
var layerAccentHover02$3 = colors$1.gray20Hover;

// layer-accent-03
var layerAccent03$3 = colors$1.gray20;
var layerAccentActive03$3 = colors$1.gray40;
var layerAccentHover03$3 = colors$1.gray20Hover;

// Field
// field-01
var field01$7 = colors$1.gray10;
var fieldHover01$3 = colors$1.gray10Hover;

// field-02
var field02$7 = colors$1.white;
var fieldHover02$3 = colors$1.whiteHover;

// field-03
var field03$3 = colors$1.gray10;
var fieldHover03$3 = colors$1.gray10Hover;

// Border
// border-subtle-00
var borderSubtle00$3 = colors$1.gray20;

// border-subtle-01
var borderSubtle01$3 = colors$1.gray30;
var borderSubtleSelected01$3 = colors$1.gray30;

// border-subtle-02
var borderSubtle02$3 = colors$1.gray20;
var borderSubtleSelected02$3 = colors$1.gray30;

// border-subtle-03
var borderSubtle03$3 = colors$1.gray30;
var borderSubtleSelected03$3 = colors$1.gray30;

// border-strong
var borderStrong01$3 = colors$1.gray50;
var borderStrong02$3 = colors$1.gray50;
var borderStrong03$3 = colors$1.gray50;

// border-tile
var borderTile01$3 = colors$1.gray30;
var borderTile02$3 = colors$1.gray40;
var borderTile03$3 = colors$1.gray30;

// border-inverse
var borderInverse$7 = colors$1.gray100;

// border-interactive
var borderInteractive$7 = colors$1.blue60;

// border
var borderDisabled$7 = colors$1.gray30;

// Text
var textPrimary$7 = colors$1.gray100;
var textSecondary$7 = colors$1.gray70;
var textPlaceholder$7 = adjustAlpha(textPrimary$7, 0.4);
var textHelper$7 = colors$1.gray60;
var textError$7 = colors$1.red60;
var textInverse$7 = colors$1.white;
var textOnColor$7 = colors$1.white;
var textOnColorDisabled$7 = colors$1.gray50;
var textDisabled$7 = adjustAlpha(textPrimary$7, 0.25);

// Link
var linkPrimary$7 = colors$1.blue60;
var linkPrimaryHover$7 = colors$1.blue70;
var linkSecondary$7 = colors$1.blue70;
var linkInverse$7 = colors$1.blue40;
var linkVisited$7 = colors$1.purple60;
var linkInverseActive$3 = colors$1.gray10;
var linkInverseHover$3 = colors$1.blue30;

// Icon
var iconPrimary$7 = colors$1.gray100;
var iconSecondary$7 = colors$1.gray70;
var iconInverse$7 = colors$1.white;
var iconOnColor$7 = colors$1.white;
var iconOnColorDisabled$7 = colors$1.gray50;
var iconDisabled$7 = adjustAlpha(iconPrimary$7, 0.25);
var iconInteractive$3 = colors$1.blue60;

// Support
var supportError$7 = colors$1.red60;
var supportSuccess$7 = colors$1.green50;
var supportWarning$7 = colors$1.yellow30;
var supportInfo$7 = colors$1.blue70;
var supportErrorInverse$7 = colors$1.red50;
var supportSuccessInverse$7 = colors$1.green40;
var supportWarningInverse$7 = colors$1.yellow30;
var supportInfoInverse$7 = colors$1.blue50;
var supportCautionMinor$3 = colors$1.yellow30;
var supportCautionMajor$3 = colors$1.orange40;
var supportCautionUndefined$3 = colors$1.purple60;

// Focus
var focus$8 = colors$1.blue60;
var focusInset$7 = colors$1.white;
var focusInverse$7 = colors$1.white;

// Skeleton
var skeletonBackground$7 = colors$1.whiteHover;
var skeletonElement$7 = colors$1.gray30;

// Misc
var interactive$7 = colors$1.blue60;
var highlight$7 = colors$1.blue20;
var overlay$7 = 'rgba(22, 22, 22, 0.5)';
var toggleOff$7 = colors$1.gray50;
var shadow$7 = 'rgba(0, 0, 0, 0.3)';

//// AI - Experimental (Use at your own risk)
// Slug tokens
var slugBackground$3 = colors$1.gray70;
var slugGradient$3 = "".concat(colors$1.gray100, " linear-gradient(135deg, ").concat(colors$1.gray40, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugBackgroundHover$3 = colors$1.gray60;
var slugGradientHover$3 = "".concat(colors$1.gray100, " linear-gradient(135deg, ").concat(colors$1.gray20Hover, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugHollowHover$3 = colors$1.gray80Hover;
var slugCalloutGradientTop$3 = colors$1.rgba(colors$1.gray10, 0.85);
var slugCalloutGradientBottom$3 = colors$1.rgba(colors$1.gray20, 0.85);
var slugCalloutAuraStart$3 = colors$1.rgba(colors$1.blue10, 0.6);
var slugCalloutAuraEnd$3 = colors$1.rgba(colors$1.white, 0);
// Linear gradient tokens
var aiGradientStart01$3 = colors$1.rgba(colors$1.coolGray10, 0.5);
var aiGradientStart02$3 = colors$1.rgba(colors$1.blue10, 0.5);
var aiGradientEnd$3 = colors$1.rgba(colors$1.white, 0);

var white$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  background: background$8,
  backgroundInverse: backgroundInverse$7,
  backgroundBrand: backgroundBrand$7,
  backgroundActive: backgroundActive$7,
  backgroundHover: backgroundHover$7,
  backgroundInverseHover: backgroundInverseHover$7,
  backgroundSelected: backgroundSelected$7,
  backgroundSelectedHover: backgroundSelectedHover$7,
  layer01: layer01$3,
  layerActive01: layerActive01$3,
  layerHover01: layerHover01$3,
  layerSelected01: layerSelected01$3,
  layerSelectedHover01: layerSelectedHover01$3,
  layer02: layer02$3,
  layerActive02: layerActive02$3,
  layerHover02: layerHover02$3,
  layerSelected02: layerSelected02$3,
  layerSelectedHover02: layerSelectedHover02$3,
  layer03: layer03$3,
  layerActive03: layerActive03$3,
  layerHover03: layerHover03$3,
  layerSelected03: layerSelected03$3,
  layerSelectedHover03: layerSelectedHover03$3,
  layerSelectedInverse: layerSelectedInverse$7,
  layerSelectedDisabled: layerSelectedDisabled$7,
  layerAccent01: layerAccent01$3,
  layerAccentActive01: layerAccentActive01$3,
  layerAccentHover01: layerAccentHover01$3,
  layerAccent02: layerAccent02$3,
  layerAccentActive02: layerAccentActive02$3,
  layerAccentHover02: layerAccentHover02$3,
  layerAccent03: layerAccent03$3,
  layerAccentActive03: layerAccentActive03$3,
  layerAccentHover03: layerAccentHover03$3,
  field01: field01$7,
  fieldHover01: fieldHover01$3,
  field02: field02$7,
  fieldHover02: fieldHover02$3,
  field03: field03$3,
  fieldHover03: fieldHover03$3,
  borderSubtle00: borderSubtle00$3,
  borderSubtle01: borderSubtle01$3,
  borderSubtleSelected01: borderSubtleSelected01$3,
  borderSubtle02: borderSubtle02$3,
  borderSubtleSelected02: borderSubtleSelected02$3,
  borderSubtle03: borderSubtle03$3,
  borderSubtleSelected03: borderSubtleSelected03$3,
  borderStrong01: borderStrong01$3,
  borderStrong02: borderStrong02$3,
  borderStrong03: borderStrong03$3,
  borderTile01: borderTile01$3,
  borderTile02: borderTile02$3,
  borderTile03: borderTile03$3,
  borderInverse: borderInverse$7,
  borderInteractive: borderInteractive$7,
  borderDisabled: borderDisabled$7,
  textPrimary: textPrimary$7,
  textSecondary: textSecondary$7,
  textPlaceholder: textPlaceholder$7,
  textHelper: textHelper$7,
  textError: textError$7,
  textInverse: textInverse$7,
  textOnColor: textOnColor$7,
  textOnColorDisabled: textOnColorDisabled$7,
  textDisabled: textDisabled$7,
  linkPrimary: linkPrimary$7,
  linkPrimaryHover: linkPrimaryHover$7,
  linkSecondary: linkSecondary$7,
  linkInverse: linkInverse$7,
  linkVisited: linkVisited$7,
  linkInverseActive: linkInverseActive$3,
  linkInverseHover: linkInverseHover$3,
  iconPrimary: iconPrimary$7,
  iconSecondary: iconSecondary$7,
  iconInverse: iconInverse$7,
  iconOnColor: iconOnColor$7,
  iconOnColorDisabled: iconOnColorDisabled$7,
  iconDisabled: iconDisabled$7,
  iconInteractive: iconInteractive$3,
  supportError: supportError$7,
  supportSuccess: supportSuccess$7,
  supportWarning: supportWarning$7,
  supportInfo: supportInfo$7,
  supportErrorInverse: supportErrorInverse$7,
  supportSuccessInverse: supportSuccessInverse$7,
  supportWarningInverse: supportWarningInverse$7,
  supportInfoInverse: supportInfoInverse$7,
  supportCautionMinor: supportCautionMinor$3,
  supportCautionMajor: supportCautionMajor$3,
  supportCautionUndefined: supportCautionUndefined$3,
  focus: focus$8,
  focusInset: focusInset$7,
  focusInverse: focusInverse$7,
  skeletonBackground: skeletonBackground$7,
  skeletonElement: skeletonElement$7,
  interactive: interactive$7,
  highlight: highlight$7,
  overlay: overlay$7,
  toggleOff: toggleOff$7,
  shadow: shadow$7,
  slugBackground: slugBackground$3,
  slugGradient: slugGradient$3,
  slugBackgroundHover: slugBackgroundHover$3,
  slugGradientHover: slugGradientHover$3,
  slugHollowHover: slugHollowHover$3,
  slugCalloutGradientTop: slugCalloutGradientTop$3,
  slugCalloutGradientBottom: slugCalloutGradientBottom$3,
  slugCalloutAuraStart: slugCalloutAuraStart$3,
  slugCalloutAuraEnd: slugCalloutAuraEnd$3,
  aiGradientStart01: aiGradientStart01$3,
  aiGradientStart02: aiGradientStart02$3,
  aiGradientEnd: aiGradientEnd$3,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

// Background
var background$7 = colors$1.gray10;
var backgroundInverse$6 = colors$1.gray80;
var backgroundBrand$6 = colors$1.blue60;
var backgroundActive$6 = adjustAlpha(colors$1.gray50, 0.5);
var backgroundHover$6 = adjustAlpha(colors$1.gray50, 0.12);
var backgroundInverseHover$6 = colors$1.gray80Hover;
var backgroundSelected$6 = adjustAlpha(colors$1.gray50, 0.2);
var backgroundSelectedHover$6 = adjustAlpha(colors$1.gray50, 0.32);

// Layer
// layer-01
var layer01$2 = colors$1.white;
var layerActive01$2 = colors$1.gray30;
var layerHover01$2 = colors$1.whiteHover;
var layerSelected01$2 = colors$1.gray20;
var layerSelectedHover01$2 = colors$1.gray20Hover;

// layer-02
var layer02$2 = colors$1.gray10;
var layerActive02$2 = colors$1.gray30;
var layerHover02$2 = colors$1.gray10Hover;
var layerSelected02$2 = colors$1.gray20;
var layerSelectedHover02$2 = colors$1.gray20Hover;

// layer-03
var layer03$2 = colors$1.white;
var layerActive03$2 = colors$1.gray30;
var layerHover03$2 = colors$1.whiteHover;
var layerSelected03$2 = colors$1.gray20;
var layerSelectedHover03$2 = colors$1.gray20Hover;

// layer
var layerSelectedInverse$6 = colors$1.gray100;
var layerSelectedDisabled$6 = colors$1.gray50;

// layer-accent-01
var layerAccent01$2 = colors$1.gray20;
var layerAccentActive01$2 = colors$1.gray40;
var layerAccentHover01$2 = colors$1.gray20Hover;

// layer-accent-02
var layerAccent02$2 = colors$1.gray20;
var layerAccentActive02$2 = colors$1.gray40;
var layerAccentHover02$2 = colors$1.gray20Hover;

// layer-accent-03
var layerAccent03$2 = colors$1.gray20;
var layerAccentActive03$2 = colors$1.gray40;
var layerAccentHover03$2 = colors$1.gray20Hover;

// Field
// field-01
var field01$6 = colors$1.white;
var fieldHover01$2 = colors$1.whiteHover;

// field-02
var field02$6 = colors$1.gray10;
var fieldHover02$2 = colors$1.gray10Hover;

// field-03
var field03$2 = colors$1.white;
var fieldHover03$2 = colors$1.whiteHover;

// Border
// border-subtle-00
var borderSubtle00$2 = colors$1.gray30;

// border-subtle-01
var borderSubtle01$2 = colors$1.gray20;
var borderSubtleSelected01$2 = colors$1.gray30;

// border-subtle-02
var borderSubtle02$2 = colors$1.gray30;
var borderSubtleSelected02$2 = colors$1.gray30;

// border-subtle-03
var borderSubtle03$2 = colors$1.gray20;
var borderSubtleSelected03$2 = colors$1.gray30;

// border-strong
var borderStrong01$2 = colors$1.gray50;
var borderStrong02$2 = colors$1.gray50;
var borderStrong03$2 = colors$1.gray50;

// border-tile
var borderTile01$2 = colors$1.gray40;
var borderTile02$2 = colors$1.gray30;
var borderTile03$2 = colors$1.gray40;

// border-inverse
var borderInverse$6 = colors$1.gray100;

// border-interactive
var borderInteractive$6 = colors$1.blue60;

// border
var borderDisabled$6 = colors$1.gray30;

// Text
var textPrimary$6 = colors$1.gray100;
var textSecondary$6 = colors$1.gray70;
var textPlaceholder$6 = adjustAlpha(textPrimary$6, 0.4);
var textHelper$6 = colors$1.gray60;
var textError$6 = colors$1.red60;
var textInverse$6 = colors$1.white;
var textOnColor$6 = colors$1.white;
var textOnColorDisabled$6 = colors$1.gray50;
var textDisabled$6 = adjustAlpha(textPrimary$6, 0.25);

// Link
var linkPrimary$6 = colors$1.blue60;
var linkPrimaryHover$6 = colors$1.blue70;
var linkSecondary$6 = colors$1.blue70;
var linkInverse$6 = colors$1.blue40;
var linkVisited$6 = colors$1.purple60;
var linkInverseActive$2 = colors$1.gray10;
var linkInverseHover$2 = colors$1.blue30;

// Icon
var iconPrimary$6 = colors$1.gray100;
var iconSecondary$6 = colors$1.gray70;
var iconInverse$6 = colors$1.white;
var iconOnColor$6 = colors$1.white;
var iconOnColorDisabled$6 = colors$1.gray50;
var iconDisabled$6 = adjustAlpha(iconPrimary$6, 0.25);
var iconInteractive$2 = colors$1.blue60;

// Support
var supportError$6 = colors$1.red60;
var supportSuccess$6 = colors$1.green50;
var supportWarning$6 = colors$1.yellow30;
var supportInfo$6 = colors$1.blue70;
var supportErrorInverse$6 = colors$1.red50;
var supportSuccessInverse$6 = colors$1.green40;
var supportWarningInverse$6 = colors$1.yellow30;
var supportInfoInverse$6 = colors$1.blue50;
var supportCautionMinor$2 = colors$1.yellow30;
var supportCautionMajor$2 = colors$1.orange40;
var supportCautionUndefined$2 = colors$1.purple60;

// Focus
var focus$7 = colors$1.blue60;
var focusInset$6 = colors$1.white;
var focusInverse$6 = colors$1.white;

// Skeleton
var skeletonBackground$6 = colors$1.gray10Hover;
var skeletonElement$6 = colors$1.gray30;

// Misc
var interactive$6 = colors$1.blue60;
var highlight$6 = colors$1.blue20;
var overlay$6 = 'rgba(22, 22, 22, 0.5)';
var toggleOff$6 = colors$1.gray50;
var shadow$6 = 'rgba(0, 0, 0, 0.3)';

//// AI - Experimental (Use at your own risk)
// Slug tokens
var slugBackground$2 = colors$1.gray70;
var slugGradient$2 = "".concat(colors$1.gray100, " linear-gradient(135deg, ").concat(colors$1.gray40, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugBackgroundHover$2 = colors$1.gray60;
var slugGradientHover$2 = "".concat(colors$1.gray100, " linear-gradient(135deg, ").concat(colors$1.gray20Hover, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugHollowHover$2 = colors$1.gray80Hover;
var slugCalloutGradientTop$2 = colors$1.rgba(colors$1.gray10, 0.85);
var slugCalloutGradientBottom$2 = colors$1.rgba(colors$1.gray20, 0.85);
var slugCalloutAuraStart$2 = colors$1.rgba(colors$1.blue10, 0.6);
var slugCalloutAuraEnd$2 = colors$1.rgba(colors$1.white, 0);
// Linear gradient tokens
var aiGradientStart01$2 = colors$1.rgba(colors$1.coolGray10, 0.5);
var aiGradientStart02$2 = colors$1.rgba(colors$1.blue10, 0.5);
var aiGradientEnd$2 = colors$1.rgba(colors$1.white, 0);

var g10$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  background: background$7,
  backgroundInverse: backgroundInverse$6,
  backgroundBrand: backgroundBrand$6,
  backgroundActive: backgroundActive$6,
  backgroundHover: backgroundHover$6,
  backgroundInverseHover: backgroundInverseHover$6,
  backgroundSelected: backgroundSelected$6,
  backgroundSelectedHover: backgroundSelectedHover$6,
  layer01: layer01$2,
  layerActive01: layerActive01$2,
  layerHover01: layerHover01$2,
  layerSelected01: layerSelected01$2,
  layerSelectedHover01: layerSelectedHover01$2,
  layer02: layer02$2,
  layerActive02: layerActive02$2,
  layerHover02: layerHover02$2,
  layerSelected02: layerSelected02$2,
  layerSelectedHover02: layerSelectedHover02$2,
  layer03: layer03$2,
  layerActive03: layerActive03$2,
  layerHover03: layerHover03$2,
  layerSelected03: layerSelected03$2,
  layerSelectedHover03: layerSelectedHover03$2,
  layerSelectedInverse: layerSelectedInverse$6,
  layerSelectedDisabled: layerSelectedDisabled$6,
  layerAccent01: layerAccent01$2,
  layerAccentActive01: layerAccentActive01$2,
  layerAccentHover01: layerAccentHover01$2,
  layerAccent02: layerAccent02$2,
  layerAccentActive02: layerAccentActive02$2,
  layerAccentHover02: layerAccentHover02$2,
  layerAccent03: layerAccent03$2,
  layerAccentActive03: layerAccentActive03$2,
  layerAccentHover03: layerAccentHover03$2,
  field01: field01$6,
  fieldHover01: fieldHover01$2,
  field02: field02$6,
  fieldHover02: fieldHover02$2,
  field03: field03$2,
  fieldHover03: fieldHover03$2,
  borderSubtle00: borderSubtle00$2,
  borderSubtle01: borderSubtle01$2,
  borderSubtleSelected01: borderSubtleSelected01$2,
  borderSubtle02: borderSubtle02$2,
  borderSubtleSelected02: borderSubtleSelected02$2,
  borderSubtle03: borderSubtle03$2,
  borderSubtleSelected03: borderSubtleSelected03$2,
  borderStrong01: borderStrong01$2,
  borderStrong02: borderStrong02$2,
  borderStrong03: borderStrong03$2,
  borderTile01: borderTile01$2,
  borderTile02: borderTile02$2,
  borderTile03: borderTile03$2,
  borderInverse: borderInverse$6,
  borderInteractive: borderInteractive$6,
  borderDisabled: borderDisabled$6,
  textPrimary: textPrimary$6,
  textSecondary: textSecondary$6,
  textPlaceholder: textPlaceholder$6,
  textHelper: textHelper$6,
  textError: textError$6,
  textInverse: textInverse$6,
  textOnColor: textOnColor$6,
  textOnColorDisabled: textOnColorDisabled$6,
  textDisabled: textDisabled$6,
  linkPrimary: linkPrimary$6,
  linkPrimaryHover: linkPrimaryHover$6,
  linkSecondary: linkSecondary$6,
  linkInverse: linkInverse$6,
  linkVisited: linkVisited$6,
  linkInverseActive: linkInverseActive$2,
  linkInverseHover: linkInverseHover$2,
  iconPrimary: iconPrimary$6,
  iconSecondary: iconSecondary$6,
  iconInverse: iconInverse$6,
  iconOnColor: iconOnColor$6,
  iconOnColorDisabled: iconOnColorDisabled$6,
  iconDisabled: iconDisabled$6,
  iconInteractive: iconInteractive$2,
  supportError: supportError$6,
  supportSuccess: supportSuccess$6,
  supportWarning: supportWarning$6,
  supportInfo: supportInfo$6,
  supportErrorInverse: supportErrorInverse$6,
  supportSuccessInverse: supportSuccessInverse$6,
  supportWarningInverse: supportWarningInverse$6,
  supportInfoInverse: supportInfoInverse$6,
  supportCautionMinor: supportCautionMinor$2,
  supportCautionMajor: supportCautionMajor$2,
  supportCautionUndefined: supportCautionUndefined$2,
  focus: focus$7,
  focusInset: focusInset$6,
  focusInverse: focusInverse$6,
  skeletonBackground: skeletonBackground$6,
  skeletonElement: skeletonElement$6,
  interactive: interactive$6,
  highlight: highlight$6,
  overlay: overlay$6,
  toggleOff: toggleOff$6,
  shadow: shadow$6,
  slugBackground: slugBackground$2,
  slugGradient: slugGradient$2,
  slugBackgroundHover: slugBackgroundHover$2,
  slugGradientHover: slugGradientHover$2,
  slugHollowHover: slugHollowHover$2,
  slugCalloutGradientTop: slugCalloutGradientTop$2,
  slugCalloutGradientBottom: slugCalloutGradientBottom$2,
  slugCalloutAuraStart: slugCalloutAuraStart$2,
  slugCalloutAuraEnd: slugCalloutAuraEnd$2,
  aiGradientStart01: aiGradientStart01$2,
  aiGradientStart02: aiGradientStart02$2,
  aiGradientEnd: aiGradientEnd$2,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

// Background
var background$6 = colors$1.gray90;
var backgroundInverse$5 = colors$1.gray10;
var backgroundBrand$5 = colors$1.blue60;
var backgroundActive$5 = adjustAlpha(colors$1.gray50, 0.4);
var backgroundHover$5 = adjustAlpha(colors$1.gray50, 0.16);
var backgroundInverseHover$5 = colors$1.gray10Hover;
var backgroundSelected$5 = adjustAlpha(colors$1.gray50, 0.24);
var backgroundSelectedHover$5 = adjustAlpha(colors$1.gray50, 0.32);

// Layer
// layer-01
var layer01$1 = colors$1.gray80;
var layerActive01$1 = colors$1.gray60;
var layerHover01$1 = colors$1.gray80Hover;
var layerSelected01$1 = colors$1.gray70;
var layerSelectedHover01$1 = colors$1.gray70Hover;

// layer-02
var layer02$1 = colors$1.gray70;
var layerActive02$1 = colors$1.gray50;
var layerHover02$1 = colors$1.gray70Hover;
var layerSelected02$1 = colors$1.gray60;
var layerSelectedHover02$1 = colors$1.gray60Hover;

// layer-03
var layer03$1 = colors$1.gray60;
var layerActive03$1 = colors$1.gray80;
var layerHover03$1 = colors$1.gray60Hover;
var layerSelected03$1 = colors$1.gray70;
var layerSelectedHover03$1 = colors$1.gray70Hover;

// layer
var layerSelectedInverse$5 = colors$1.gray10;
var layerSelectedDisabled$5 = colors$1.gray40;

// layer-accent-01
var layerAccent01$1 = colors$1.gray70;
var layerAccentActive01$1 = colors$1.gray50;
var layerAccentHover01$1 = colors$1.gray70Hover;

// layer-accent-02
var layerAccent02$1 = colors$1.gray60;
var layerAccentActive02$1 = colors$1.gray80;
var layerAccentHover02$1 = colors$1.gray60Hover;

// layer-accent-03
var layerAccent03$1 = colors$1.gray50;
var layerAccentActive03$1 = colors$1.gray70;
var layerAccentHover03$1 = colors$1.gray50Hover;

// Field
// field-01
var field01$5 = colors$1.gray80;
var fieldHover01$1 = colors$1.gray80Hover;

// field-02
var field02$5 = colors$1.gray70;
var fieldHover02$1 = colors$1.gray70Hover;

// field-03
var field03$1 = colors$1.gray60;
var fieldHover03$1 = colors$1.gray60Hover;

// Border
// border-subtle-00
var borderSubtle00$1 = colors$1.gray70;

// border-subtle-01
var borderSubtle01$1 = colors$1.gray70;
var borderSubtleSelected01$1 = colors$1.gray60;

// border-subtle-02
var borderSubtle02$1 = colors$1.gray60;
var borderSubtleSelected02$1 = colors$1.gray50;

// border-subtle-03
var borderSubtle03$1 = colors$1.gray50;
var borderSubtleSelected03$1 = colors$1.gray40;

// border-strong
var borderStrong01$1 = colors$1.gray50;
var borderStrong02$1 = colors$1.gray40;
var borderStrong03$1 = colors$1.gray30;

// border-tile
var borderTile01$1 = colors$1.gray60;
var borderTile02$1 = colors$1.gray50;
var borderTile03$1 = colors$1.gray40;

// border-inverse
var borderInverse$5 = colors$1.gray10;

// border-interactive
var borderInteractive$5 = colors$1.blue50;

// border
var borderDisabled$5 = adjustAlpha(colors$1.gray50, 0.5);

// Text
var textPrimary$5 = colors$1.gray10;
var textSecondary$5 = colors$1.gray30;
var textPlaceholder$5 = adjustAlpha(textPrimary$5, 0.4);
var textHelper$5 = colors$1.gray30;
var textError$5 = colors$1.red30;
var textInverse$5 = colors$1.gray100;
var textOnColor$5 = colors$1.white;
var textOnColorDisabled$5 = adjustAlpha(textOnColor$5, 0.25);
var textDisabled$5 = adjustAlpha(textPrimary$5, 0.25);

// Link
var linkPrimary$5 = colors$1.blue40;
var linkPrimaryHover$5 = colors$1.blue30;
var linkSecondary$5 = colors$1.blue30;
var linkInverse$5 = colors$1.blue60;
var linkVisited$5 = colors$1.purple40;
var linkInverseActive$1 = colors$1.gray100;
var linkInverseHover$1 = colors$1.blue70;

// Icon
var iconPrimary$5 = colors$1.gray10;
var iconSecondary$5 = colors$1.gray30;
var iconInverse$5 = colors$1.gray100;
var iconOnColor$5 = colors$1.white;
var iconOnColorDisabled$5 = adjustAlpha(iconOnColor$5, 0.25);
var iconDisabled$5 = adjustAlpha(iconPrimary$5, 0.25);
var iconInteractive$1 = colors$1.white;

// Support
var supportError$5 = colors$1.red40;
var supportSuccess$5 = colors$1.green40;
var supportWarning$5 = colors$1.yellow30;
var supportInfo$5 = colors$1.blue50;
var supportErrorInverse$5 = colors$1.red60;
var supportSuccessInverse$5 = colors$1.green50;
var supportWarningInverse$5 = colors$1.yellow30;
var supportInfoInverse$5 = colors$1.blue70;
var supportCautionMinor$1 = colors$1.yellow30;
var supportCautionMajor$1 = colors$1.orange40;
var supportCautionUndefined$1 = colors$1.purple50;

// Focus
var focus$6 = colors$1.white;
var focusInset$5 = colors$1.gray100;
var focusInverse$5 = colors$1.blue60;

// Skeleton
var skeletonBackground$5 = colors$1.gray90Hover;
var skeletonElement$5 = colors$1.gray70;

// Misc
var interactive$5 = colors$1.blue50;
var highlight$5 = colors$1.blue70;
var overlay$5 = colors$1.rgba(colors$1.black, 0.65);
var toggleOff$5 = colors$1.gray50;
var shadow$5 = colors$1.rgba(colors$1.black, 0.8);

//// AI - Experimental (Use at your own risk)
// Slug tokens
var slugBackground$1 = colors$1.gray30;
var slugGradient$1 = "".concat(colors$1.gray50, " linear-gradient(135deg, ").concat(colors$1.gray10, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugBackgroundHover$1 = colors$1.gray20;
var slugGradientHover$1 = "".concat(colors$1.gray40, " linear-gradient(135deg, ").concat(colors$1.white, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugHollowHover$1 = colors$1.gray30Hover;
var slugCalloutGradientTop$1 = colors$1.rgba(colors$1.gray100, 0.85);
var slugCalloutGradientBottom$1 = colors$1.rgba(colors$1.gray90, 0.85);
var slugCalloutAuraStart$1 = colors$1.rgba(colors$1.blue20, 0.2);
var slugCalloutAuraEnd$1 = colors$1.rgba(colors$1.gray100, 0);
// Linear gradient tokens
var aiGradientStart01$1 = colors$1.rgba(colors$1.blue20, 0.2);
var aiGradientStart02$1 = 'transparent';
var aiGradientEnd$1 = 'rgba(38, 38, 38, 0)';

var g90$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  background: background$6,
  backgroundInverse: backgroundInverse$5,
  backgroundBrand: backgroundBrand$5,
  backgroundActive: backgroundActive$5,
  backgroundHover: backgroundHover$5,
  backgroundInverseHover: backgroundInverseHover$5,
  backgroundSelected: backgroundSelected$5,
  backgroundSelectedHover: backgroundSelectedHover$5,
  layer01: layer01$1,
  layerActive01: layerActive01$1,
  layerHover01: layerHover01$1,
  layerSelected01: layerSelected01$1,
  layerSelectedHover01: layerSelectedHover01$1,
  layer02: layer02$1,
  layerActive02: layerActive02$1,
  layerHover02: layerHover02$1,
  layerSelected02: layerSelected02$1,
  layerSelectedHover02: layerSelectedHover02$1,
  layer03: layer03$1,
  layerActive03: layerActive03$1,
  layerHover03: layerHover03$1,
  layerSelected03: layerSelected03$1,
  layerSelectedHover03: layerSelectedHover03$1,
  layerSelectedInverse: layerSelectedInverse$5,
  layerSelectedDisabled: layerSelectedDisabled$5,
  layerAccent01: layerAccent01$1,
  layerAccentActive01: layerAccentActive01$1,
  layerAccentHover01: layerAccentHover01$1,
  layerAccent02: layerAccent02$1,
  layerAccentActive02: layerAccentActive02$1,
  layerAccentHover02: layerAccentHover02$1,
  layerAccent03: layerAccent03$1,
  layerAccentActive03: layerAccentActive03$1,
  layerAccentHover03: layerAccentHover03$1,
  field01: field01$5,
  fieldHover01: fieldHover01$1,
  field02: field02$5,
  fieldHover02: fieldHover02$1,
  field03: field03$1,
  fieldHover03: fieldHover03$1,
  borderSubtle00: borderSubtle00$1,
  borderSubtle01: borderSubtle01$1,
  borderSubtleSelected01: borderSubtleSelected01$1,
  borderSubtle02: borderSubtle02$1,
  borderSubtleSelected02: borderSubtleSelected02$1,
  borderSubtle03: borderSubtle03$1,
  borderSubtleSelected03: borderSubtleSelected03$1,
  borderStrong01: borderStrong01$1,
  borderStrong02: borderStrong02$1,
  borderStrong03: borderStrong03$1,
  borderTile01: borderTile01$1,
  borderTile02: borderTile02$1,
  borderTile03: borderTile03$1,
  borderInverse: borderInverse$5,
  borderInteractive: borderInteractive$5,
  borderDisabled: borderDisabled$5,
  textPrimary: textPrimary$5,
  textSecondary: textSecondary$5,
  textPlaceholder: textPlaceholder$5,
  textHelper: textHelper$5,
  textError: textError$5,
  textInverse: textInverse$5,
  textOnColor: textOnColor$5,
  textOnColorDisabled: textOnColorDisabled$5,
  textDisabled: textDisabled$5,
  linkPrimary: linkPrimary$5,
  linkPrimaryHover: linkPrimaryHover$5,
  linkSecondary: linkSecondary$5,
  linkInverse: linkInverse$5,
  linkVisited: linkVisited$5,
  linkInverseActive: linkInverseActive$1,
  linkInverseHover: linkInverseHover$1,
  iconPrimary: iconPrimary$5,
  iconSecondary: iconSecondary$5,
  iconInverse: iconInverse$5,
  iconOnColor: iconOnColor$5,
  iconOnColorDisabled: iconOnColorDisabled$5,
  iconDisabled: iconDisabled$5,
  iconInteractive: iconInteractive$1,
  supportError: supportError$5,
  supportSuccess: supportSuccess$5,
  supportWarning: supportWarning$5,
  supportInfo: supportInfo$5,
  supportErrorInverse: supportErrorInverse$5,
  supportSuccessInverse: supportSuccessInverse$5,
  supportWarningInverse: supportWarningInverse$5,
  supportInfoInverse: supportInfoInverse$5,
  supportCautionMinor: supportCautionMinor$1,
  supportCautionMajor: supportCautionMajor$1,
  supportCautionUndefined: supportCautionUndefined$1,
  focus: focus$6,
  focusInset: focusInset$5,
  focusInverse: focusInverse$5,
  skeletonBackground: skeletonBackground$5,
  skeletonElement: skeletonElement$5,
  interactive: interactive$5,
  highlight: highlight$5,
  overlay: overlay$5,
  toggleOff: toggleOff$5,
  shadow: shadow$5,
  slugBackground: slugBackground$1,
  slugGradient: slugGradient$1,
  slugBackgroundHover: slugBackgroundHover$1,
  slugGradientHover: slugGradientHover$1,
  slugHollowHover: slugHollowHover$1,
  slugCalloutGradientTop: slugCalloutGradientTop$1,
  slugCalloutGradientBottom: slugCalloutGradientBottom$1,
  slugCalloutAuraStart: slugCalloutAuraStart$1,
  slugCalloutAuraEnd: slugCalloutAuraEnd$1,
  aiGradientStart01: aiGradientStart01$1,
  aiGradientStart02: aiGradientStart02$1,
  aiGradientEnd: aiGradientEnd$1,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

// Background
var background$5 = colors$1.gray100;
var backgroundInverse$4 = colors$1.gray10;
var backgroundBrand$4 = colors$1.blue60;
var backgroundActive$4 = adjustAlpha(colors$1.gray50, 0.4);
var backgroundHover$4 = adjustAlpha(colors$1.gray50, 0.16);
var backgroundInverseHover$4 = colors$1.gray10Hover;
var backgroundSelected$4 = adjustAlpha(colors$1.gray50, 0.24);
var backgroundSelectedHover$4 = adjustAlpha(colors$1.gray50, 0.32);

// Layer
// layer-01
var layer01 = colors$1.gray90;
var layerActive01 = colors$1.gray70;
var layerHover01 = colors$1.gray90Hover;
var layerSelected01 = colors$1.gray80;
var layerSelectedHover01 = colors$1.gray80Hover;

// layer-02
var layer02 = colors$1.gray80;
var layerActive02 = colors$1.gray60;
var layerHover02 = colors$1.gray80Hover;
var layerSelected02 = colors$1.gray70;
var layerSelectedHover02 = colors$1.gray70Hover;

// layer-03
var layer03 = colors$1.gray70;
var layerActive03 = colors$1.gray50;
var layerHover03 = colors$1.gray70Hover;
var layerSelected03 = colors$1.gray60;
var layerSelectedHover03 = colors$1.gray60Hover;

// layer
var layerSelectedInverse$4 = colors$1.gray10;
var layerSelectedDisabled$4 = colors$1.gray40;

// layer-accent-01
var layerAccent01 = colors$1.gray80;
var layerAccentActive01 = colors$1.gray60;
var layerAccentHover01 = colors$1.gray80Hover;

// layer-accent-02
var layerAccent02 = colors$1.gray70;
var layerAccentActive02 = colors$1.gray50;
var layerAccentHover02 = colors$1.gray70Hover;

// layer-accent-03
var layerAccent03 = colors$1.gray60;
var layerAccentActive03 = colors$1.gray80;
var layerAccentHover03 = colors$1.gray60Hover;

// Field
// field-01
var field01$4 = colors$1.gray90;
var fieldHover01 = colors$1.gray90Hover;

// field-02
var field02$4 = colors$1.gray80;
var fieldHover02 = colors$1.gray80Hover;

// field-03
var field03 = colors$1.gray70;
var fieldHover03 = colors$1.gray70Hover;

// Border
// border-subtle-00
var borderSubtle00 = colors$1.gray80;

// border-subtle-01
var borderSubtle01 = colors$1.gray80;
var borderSubtleSelected01 = colors$1.gray70;

// border-subtle-02
var borderSubtle02 = colors$1.gray70;
var borderSubtleSelected02 = colors$1.gray60;

// border-subtle-03
var borderSubtle03 = colors$1.gray60;
var borderSubtleSelected03 = colors$1.gray50;

// border-strong
var borderStrong01 = colors$1.gray60;
var borderStrong02 = colors$1.gray50;
var borderStrong03 = colors$1.gray40;

// border-tile
var borderTile01 = colors$1.gray70;
var borderTile02 = colors$1.gray60;
var borderTile03 = colors$1.gray50;

// border-inverse
var borderInverse$4 = colors$1.gray10;

// border-interactive
var borderInteractive$4 = colors$1.blue50;

// border
var borderDisabled$4 = adjustAlpha(colors$1.gray50, 0.5);

// Text
var textPrimary$4 = colors$1.gray10;
var textSecondary$4 = colors$1.gray30;
var textPlaceholder$4 = adjustAlpha(textPrimary$4, 0.4);
var textHelper$4 = colors$1.gray40;
var textError$4 = colors$1.red40;
var textInverse$4 = colors$1.gray100;
var textOnColor$4 = colors$1.white;
var textOnColorDisabled$4 = adjustAlpha(textOnColor$4, 0.25);
var textDisabled$4 = adjustAlpha(textPrimary$4, 0.25);

// Link
var linkPrimary$4 = colors$1.blue40;
var linkPrimaryHover$4 = colors$1.blue30;
var linkSecondary$4 = colors$1.blue30;
var linkInverse$4 = colors$1.blue60;
var linkVisited$4 = colors$1.purple40;
var linkInverseActive = colors$1.gray100;
var linkInverseHover = colors$1.blue70;

// Icon
var iconPrimary$4 = colors$1.gray10;
var iconSecondary$4 = colors$1.gray30;
var iconInverse$4 = colors$1.gray100;
var iconOnColor$4 = colors$1.white;
var iconOnColorDisabled$4 = adjustAlpha(iconOnColor$4, 0.25);
var iconDisabled$4 = adjustAlpha(iconPrimary$4, 0.25);
var iconInteractive = colors$1.white;

// Support
var supportError$4 = colors$1.red50;
var supportSuccess$4 = colors$1.green40;
var supportWarning$4 = colors$1.yellow30;
var supportInfo$4 = colors$1.blue50;
var supportErrorInverse$4 = colors$1.red60;
var supportSuccessInverse$4 = colors$1.green50;
var supportWarningInverse$4 = colors$1.yellow30;
var supportInfoInverse$4 = colors$1.blue70;
var supportCautionMinor = colors$1.yellow30;
var supportCautionMajor = colors$1.orange40;
var supportCautionUndefined = colors$1.purple50;

// Focus
var focus$5 = colors$1.white;
var focusInset$4 = colors$1.gray100;
var focusInverse$4 = colors$1.blue60;

// Skeleton
var skeletonBackground$4 = adjustLightness(background$5, 7);
var skeletonElement$4 = colors$1.gray80;

// Misc
var interactive$4 = colors$1.blue50;
var highlight$4 = colors$1.blue80;
var overlay$4 = colors$1.rgba(colors$1.black, 0.65);
var toggleOff$4 = colors$1.gray60;
var shadow$4 = colors$1.rgba(colors$1.black, 0.8);

//// AI - Experimental (Use at your own risk)
// Slug tokens
var slugBackground = colors$1.gray30;
var slugGradient = "".concat(colors$1.gray50, " linear-gradient(135deg, ").concat(colors$1.gray10, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugBackgroundHover = colors$1.gray20;
var slugGradientHover = "".concat(colors$1.gray40, " linear-gradient(135deg, ").concat(colors$1.white, " 0%, rgba(").concat(colors$1.white, ", 0) 100%)");
var slugHollowHover = colors$1.gray30Hover;
var slugCalloutGradientTop = colors$1.rgba(colors$1.gray100, 0.85);
var slugCalloutGradientBottom = colors$1.rgba(colors$1.gray90, 0.85);
var slugCalloutAuraStart = colors$1.rgba(colors$1.blue20, 0.2);
var slugCalloutAuraEnd = colors$1.rgba(colors$1.gray100, 0);
// Linear gradient tokens
var aiGradientStart01 = colors$1.rgba(colors$1.blue20, 0.2);
var aiGradientStart02 = 'transparent';
var aiGradientEnd = 'rgba(38, 38, 38, 0)';

var g100$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  background: background$5,
  backgroundInverse: backgroundInverse$4,
  backgroundBrand: backgroundBrand$4,
  backgroundActive: backgroundActive$4,
  backgroundHover: backgroundHover$4,
  backgroundInverseHover: backgroundInverseHover$4,
  backgroundSelected: backgroundSelected$4,
  backgroundSelectedHover: backgroundSelectedHover$4,
  layer01: layer01,
  layerActive01: layerActive01,
  layerHover01: layerHover01,
  layerSelected01: layerSelected01,
  layerSelectedHover01: layerSelectedHover01,
  layer02: layer02,
  layerActive02: layerActive02,
  layerHover02: layerHover02,
  layerSelected02: layerSelected02,
  layerSelectedHover02: layerSelectedHover02,
  layer03: layer03,
  layerActive03: layerActive03,
  layerHover03: layerHover03,
  layerSelected03: layerSelected03,
  layerSelectedHover03: layerSelectedHover03,
  layerSelectedInverse: layerSelectedInverse$4,
  layerSelectedDisabled: layerSelectedDisabled$4,
  layerAccent01: layerAccent01,
  layerAccentActive01: layerAccentActive01,
  layerAccentHover01: layerAccentHover01,
  layerAccent02: layerAccent02,
  layerAccentActive02: layerAccentActive02,
  layerAccentHover02: layerAccentHover02,
  layerAccent03: layerAccent03,
  layerAccentActive03: layerAccentActive03,
  layerAccentHover03: layerAccentHover03,
  field01: field01$4,
  fieldHover01: fieldHover01,
  field02: field02$4,
  fieldHover02: fieldHover02,
  field03: field03,
  fieldHover03: fieldHover03,
  borderSubtle00: borderSubtle00,
  borderSubtle01: borderSubtle01,
  borderSubtleSelected01: borderSubtleSelected01,
  borderSubtle02: borderSubtle02,
  borderSubtleSelected02: borderSubtleSelected02,
  borderSubtle03: borderSubtle03,
  borderSubtleSelected03: borderSubtleSelected03,
  borderStrong01: borderStrong01,
  borderStrong02: borderStrong02,
  borderStrong03: borderStrong03,
  borderTile01: borderTile01,
  borderTile02: borderTile02,
  borderTile03: borderTile03,
  borderInverse: borderInverse$4,
  borderInteractive: borderInteractive$4,
  borderDisabled: borderDisabled$4,
  textPrimary: textPrimary$4,
  textSecondary: textSecondary$4,
  textPlaceholder: textPlaceholder$4,
  textHelper: textHelper$4,
  textError: textError$4,
  textInverse: textInverse$4,
  textOnColor: textOnColor$4,
  textOnColorDisabled: textOnColorDisabled$4,
  textDisabled: textDisabled$4,
  linkPrimary: linkPrimary$4,
  linkPrimaryHover: linkPrimaryHover$4,
  linkSecondary: linkSecondary$4,
  linkInverse: linkInverse$4,
  linkVisited: linkVisited$4,
  linkInverseActive: linkInverseActive,
  linkInverseHover: linkInverseHover,
  iconPrimary: iconPrimary$4,
  iconSecondary: iconSecondary$4,
  iconInverse: iconInverse$4,
  iconOnColor: iconOnColor$4,
  iconOnColorDisabled: iconOnColorDisabled$4,
  iconDisabled: iconDisabled$4,
  iconInteractive: iconInteractive,
  supportError: supportError$4,
  supportSuccess: supportSuccess$4,
  supportWarning: supportWarning$4,
  supportInfo: supportInfo$4,
  supportErrorInverse: supportErrorInverse$4,
  supportSuccessInverse: supportSuccessInverse$4,
  supportWarningInverse: supportWarningInverse$4,
  supportInfoInverse: supportInfoInverse$4,
  supportCautionMinor: supportCautionMinor,
  supportCautionMajor: supportCautionMajor,
  supportCautionUndefined: supportCautionUndefined,
  focus: focus$5,
  focusInset: focusInset$4,
  focusInverse: focusInverse$4,
  skeletonBackground: skeletonBackground$4,
  skeletonElement: skeletonElement$4,
  interactive: interactive$4,
  highlight: highlight$4,
  overlay: overlay$4,
  toggleOff: toggleOff$4,
  shadow: shadow$4,
  slugBackground: slugBackground,
  slugGradient: slugGradient,
  slugBackgroundHover: slugBackgroundHover,
  slugGradientHover: slugGradientHover,
  slugHollowHover: slugHollowHover,
  slugCalloutGradientTop: slugCalloutGradientTop,
  slugCalloutGradientBottom: slugCalloutGradientBottom,
  slugCalloutAuraStart: slugCalloutAuraStart,
  slugCalloutAuraEnd: slugCalloutAuraEnd,
  aiGradientStart01: aiGradientStart01,
  aiGradientStart02: aiGradientStart02,
  aiGradientEnd: aiGradientEnd,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var interactive01$3 = colors$1.blue60;
var interactive02$3 = colors$1.gray80;
var interactive03$3 = colors$1.blue60;
var interactive04$3 = colors$1.blue60;
var uiBackground$3 = colors$1.white;
var ui01$3 = colors$1.gray10;
var ui02$3 = colors$1.white;
var ui03$3 = colors$1.gray20;
var ui04$3 = colors$1.gray50;
var ui05$3 = colors$1.gray100;
var text01$3 = colors$1.gray100;
var text02$3 = colors$1.gray70;
var text03$3 = colors$1.gray40;
var text04$3 = colors$1.white;
var text05$3 = colors$1.gray60;
var textError$3 = colors$1.red60;
var icon01$3 = colors$1.gray100;
var icon02$3 = colors$1.gray70;
var icon03$3 = colors$1.white;
var link01$3 = colors$1.blue60;
var link02$3 = colors$1.blue70;
var inverseLink$3 = colors$1.blue40;
var field01$3 = colors$1.gray10;
var field02$3 = colors$1.white;
var inverse01$3 = colors$1.white;
var inverse02$3 = colors$1.gray80;
var support01$3 = colors$1.red60;
var support02$3 = colors$1.green60;
var support03$3 = colors$1.yellow30;
var support04$3 = colors$1.blue70;
var inverseSupport01$3 = colors$1.red50;
var inverseSupport02$3 = colors$1.green40;
var inverseSupport03$3 = colors$1.yellow30;
var inverseSupport04$3 = colors$1.blue50;
var overlay01$3 = colors$1.rgba(colors$1.gray100, 0.5);
var danger01$3 = colors$1.red60;
var danger02$3 = colors$1.red60;

// Interaction states
var focus$4 = colors$1.blue60;
var inverseFocusUi$3 = colors$1.white;
var hoverPrimary$3 = '#0353e9';
var activePrimary$3 = colors$1.blue80;
var hoverPrimaryText$3 = colors$1.blue70;
var hoverSecondary$3 = '#4c4c4c';
var activeSecondary$3 = colors$1.gray60;
var hoverTertiary$3 = '#0353e9';
var activeTertiary$3 = colors$1.blue80;
var hoverUI$3 = '#e5e5e5';
var hoverLightUI$3 = '#e5e5e5';
var activeUI$3 = colors$1.gray30;
var activeLightUI$3 = colors$1.gray30;
var selectedUI$3 = colors$1.gray20;
var selectedLightUI$3 = colors$1.gray20;
var inverseHoverUI$3 = '#4c4c4c';
var hoverSelectedUI$3 = '#cacaca';
var hoverDanger$3 = adjustLightness(danger01$3, -8);
var activeDanger$3 = colors$1.red80;
var hoverRow$3 = '#e5e5e5';
var visitedLink$3 = colors$1.purple60;
var disabled01$3 = colors$1.gray10;
var disabled02$3 = colors$1.gray30;
var disabled03$3 = colors$1.gray50;
var highlight$3 = colors$1.blue20;
var decorative01$3 = colors$1.gray20;
var buttonSeparator$4 = '#e0e0e0';
var skeleton01$3 = '#e5e5e5';
var skeleton02$3 = colors$1.gray30;

// New color tokens
// TO-DO: remove fallback color when v11 is released and assign carbon colors to new tokens
var background$4 = uiBackground$3;
var layer$4 = ui01$3;
var layerAccent$3 = ui03$3;
var layerAccentActive$3 = colors$1.gray40;
var layerAccentHover$3 = adjustLightness(layerAccent$3, -6);
var field$4 = field01$3;
var backgroundInverse$3 = inverse02$3;
var backgroundBrand$3 = interactive01$3;
var interactive$3 = interactive04$3;
var borderSubtle$3 = ui03$3;
var borderStrong$3 = ui04$3;
var borderInverse$3 = ui05$3;
var borderInteractive$3 = interactive04$3;
var textPrimary$3 = text01$3;
var textSecondary$3 = text02$3;
var textPlaceholder$3 = text03$3;
var textHelper$3 = text05$3;
var textOnColor$3 = text04$3;
var textInverse$3 = inverse01$3;
var linkPrimary$3 = link01$3;
var linkSecondary$3 = link02$3;
var linkVisited$3 = visitedLink$3;
var linkInverse$3 = inverseLink$3;
var iconPrimary$3 = icon01$3;
var iconSecondary$3 = icon02$3;
var iconOnColor$3 = icon03$3;
var iconInverse$3 = inverse01$3;
var supportError$3 = support01$3;
var supportSuccess$3 = support02$3;
var supportWarning$3 = support03$3;
var supportInfo$3 = support04$3;
var supportErrorInverse$3 = inverseSupport01$3;
var supportSuccessInverse$3 = inverseSupport02$3;
var supportWarningInverse$3 = inverseSupport03$3;
var supportInfoInverse$3 = inverseSupport04$3;
var overlay$3 = overlay01$3;
var toggleOff$3 = ui04$3;
var shadow$3 = colors$1.rgba(colors$1.black, 0.3);
var buttonPrimary$4 = interactive01$3;
var buttonSecondary$4 = interactive02$3;
var buttonTertiary$4 = interactive03$3;
var buttonDangerPrimary$4 = danger01$3;
var buttonDangerSecondary$4 = danger02$3;
var backgroundActive$3 = activeUI$3;
var layerActive$3 = activeUI$3;
var buttonDangerActive$4 = activeDanger$3;
var buttonPrimaryActive$4 = activePrimary$3;
var buttonSecondaryActive$4 = activeSecondary$3;
var buttonTertiaryActive$4 = activeTertiary$3;
var focusInset$3 = inverse01$3;
var focusInverse$3 = inverseFocusUi$3;
var backgroundHover$3 = hoverUI$3;
var layerHover$3 = hoverUI$3;
var fieldHover$3 = hoverUI$3;
var backgroundInverseHover$3 = inverseHoverUI$3;
var linkPrimaryHover$3 = hoverPrimaryText$3;
var buttonDangerHover$4 = hoverDanger$3;
var buttonPrimaryHover$4 = hoverPrimary$3;
var buttonSecondaryHover$4 = hoverSecondary$3;
var buttonTertiaryHover$4 = hoverTertiary$3;
var backgroundSelected$3 = selectedUI$3;
var backgroundSelectedHover$3 = hoverSelectedUI$3;
var layerSelected$3 = selectedUI$3;
var layerSelectedHover$3 = hoverSelectedUI$3;
var layerSelectedInverse$3 = ui05$3;
var borderSubtleSelected$3 = activeUI$3;
var borderDisabled$3 = disabled01$3;
var textDisabled$3 = disabled02$3;
var buttonDisabled$4 = disabled02$3;
var iconDisabled$3 = disabled02$3;
var textOnColorDisabled$3 = disabled03$3;
var iconOnColorDisabled$3 = disabled03$3;
var layerSelectedDisabled$3 = disabled03$3;
var skeletonBackground$3 = skeleton01$3;
var skeletonElement$3 = skeleton02$3;

// Deprecated ☠️
var brand01$3 = interactive01$3;
var brand02$3 = interactive02$3;
var brand03$3 = interactive03$3;
var active01$3 = activeUI$3;
var hoverField$3 = hoverUI$3;
var danger$3 = danger01$3;

var white = /*#__PURE__*/Object.freeze({
  __proto__: null,
  interactive01: interactive01$3,
  interactive02: interactive02$3,
  interactive03: interactive03$3,
  interactive04: interactive04$3,
  uiBackground: uiBackground$3,
  ui01: ui01$3,
  ui02: ui02$3,
  ui03: ui03$3,
  ui04: ui04$3,
  ui05: ui05$3,
  text01: text01$3,
  text02: text02$3,
  text03: text03$3,
  text04: text04$3,
  text05: text05$3,
  textError: textError$3,
  icon01: icon01$3,
  icon02: icon02$3,
  icon03: icon03$3,
  link01: link01$3,
  link02: link02$3,
  inverseLink: inverseLink$3,
  field01: field01$3,
  field02: field02$3,
  inverse01: inverse01$3,
  inverse02: inverse02$3,
  support01: support01$3,
  support02: support02$3,
  support03: support03$3,
  support04: support04$3,
  inverseSupport01: inverseSupport01$3,
  inverseSupport02: inverseSupport02$3,
  inverseSupport03: inverseSupport03$3,
  inverseSupport04: inverseSupport04$3,
  overlay01: overlay01$3,
  danger01: danger01$3,
  danger02: danger02$3,
  focus: focus$4,
  inverseFocusUi: inverseFocusUi$3,
  hoverPrimary: hoverPrimary$3,
  activePrimary: activePrimary$3,
  hoverPrimaryText: hoverPrimaryText$3,
  hoverSecondary: hoverSecondary$3,
  activeSecondary: activeSecondary$3,
  hoverTertiary: hoverTertiary$3,
  activeTertiary: activeTertiary$3,
  hoverUI: hoverUI$3,
  hoverLightUI: hoverLightUI$3,
  activeUI: activeUI$3,
  activeLightUI: activeLightUI$3,
  selectedUI: selectedUI$3,
  selectedLightUI: selectedLightUI$3,
  inverseHoverUI: inverseHoverUI$3,
  hoverSelectedUI: hoverSelectedUI$3,
  hoverDanger: hoverDanger$3,
  activeDanger: activeDanger$3,
  hoverRow: hoverRow$3,
  visitedLink: visitedLink$3,
  disabled01: disabled01$3,
  disabled02: disabled02$3,
  disabled03: disabled03$3,
  highlight: highlight$3,
  decorative01: decorative01$3,
  buttonSeparator: buttonSeparator$4,
  skeleton01: skeleton01$3,
  skeleton02: skeleton02$3,
  background: background$4,
  layer: layer$4,
  layerAccent: layerAccent$3,
  layerAccentActive: layerAccentActive$3,
  layerAccentHover: layerAccentHover$3,
  field: field$4,
  backgroundInverse: backgroundInverse$3,
  backgroundBrand: backgroundBrand$3,
  interactive: interactive$3,
  borderSubtle: borderSubtle$3,
  borderStrong: borderStrong$3,
  borderInverse: borderInverse$3,
  borderInteractive: borderInteractive$3,
  textPrimary: textPrimary$3,
  textSecondary: textSecondary$3,
  textPlaceholder: textPlaceholder$3,
  textHelper: textHelper$3,
  textOnColor: textOnColor$3,
  textInverse: textInverse$3,
  linkPrimary: linkPrimary$3,
  linkSecondary: linkSecondary$3,
  linkVisited: linkVisited$3,
  linkInverse: linkInverse$3,
  iconPrimary: iconPrimary$3,
  iconSecondary: iconSecondary$3,
  iconOnColor: iconOnColor$3,
  iconInverse: iconInverse$3,
  supportError: supportError$3,
  supportSuccess: supportSuccess$3,
  supportWarning: supportWarning$3,
  supportInfo: supportInfo$3,
  supportErrorInverse: supportErrorInverse$3,
  supportSuccessInverse: supportSuccessInverse$3,
  supportWarningInverse: supportWarningInverse$3,
  supportInfoInverse: supportInfoInverse$3,
  overlay: overlay$3,
  toggleOff: toggleOff$3,
  shadow: shadow$3,
  buttonPrimary: buttonPrimary$4,
  buttonSecondary: buttonSecondary$4,
  buttonTertiary: buttonTertiary$4,
  buttonDangerPrimary: buttonDangerPrimary$4,
  buttonDangerSecondary: buttonDangerSecondary$4,
  backgroundActive: backgroundActive$3,
  layerActive: layerActive$3,
  buttonDangerActive: buttonDangerActive$4,
  buttonPrimaryActive: buttonPrimaryActive$4,
  buttonSecondaryActive: buttonSecondaryActive$4,
  buttonTertiaryActive: buttonTertiaryActive$4,
  focusInset: focusInset$3,
  focusInverse: focusInverse$3,
  backgroundHover: backgroundHover$3,
  layerHover: layerHover$3,
  fieldHover: fieldHover$3,
  backgroundInverseHover: backgroundInverseHover$3,
  linkPrimaryHover: linkPrimaryHover$3,
  buttonDangerHover: buttonDangerHover$4,
  buttonPrimaryHover: buttonPrimaryHover$4,
  buttonSecondaryHover: buttonSecondaryHover$4,
  buttonTertiaryHover: buttonTertiaryHover$4,
  backgroundSelected: backgroundSelected$3,
  backgroundSelectedHover: backgroundSelectedHover$3,
  layerSelected: layerSelected$3,
  layerSelectedHover: layerSelectedHover$3,
  layerSelectedInverse: layerSelectedInverse$3,
  borderSubtleSelected: borderSubtleSelected$3,
  borderDisabled: borderDisabled$3,
  textDisabled: textDisabled$3,
  buttonDisabled: buttonDisabled$4,
  iconDisabled: iconDisabled$3,
  textOnColorDisabled: textOnColorDisabled$3,
  iconOnColorDisabled: iconOnColorDisabled$3,
  layerSelectedDisabled: layerSelectedDisabled$3,
  skeletonBackground: skeletonBackground$3,
  skeletonElement: skeletonElement$3,
  brand01: brand01$3,
  brand02: brand02$3,
  brand03: brand03$3,
  active01: active01$3,
  hoverField: hoverField$3,
  danger: danger$3,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  legal01: type$2.legal01,
  legal02: type$2.legal02,
  bodyCompact01: type$2.bodyCompact01,
  bodyCompact02: type$2.bodyCompact02,
  body01: type$2.body01,
  body02: type$2.body02,
  headingCompact01: type$2.headingCompact01,
  headingCompact02: type$2.headingCompact02,
  heading03: type$2.heading03,
  heading04: type$2.heading04,
  heading05: type$2.heading05,
  heading06: type$2.heading06,
  heading07: type$2.heading07,
  fluidHeading03: type$2.fluidHeading03,
  fluidHeading04: type$2.fluidHeading04,
  fluidHeading05: type$2.fluidHeading05,
  fluidHeading06: type$2.fluidHeading06,
  fluidParagraph01: type$2.fluidParagraph01,
  fluidQuotation01: type$2.fluidQuotation01,
  fluidQuotation02: type$2.fluidQuotation02,
  fluidDisplay01: type$2.fluidDisplay01,
  fluidDisplay02: type$2.fluidDisplay02,
  fluidDisplay03: type$2.fluidDisplay03,
  fluidDisplay04: type$2.fluidDisplay04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var interactive01$2 = colors$1.blue60;
var interactive02$2 = colors$1.gray80;
var interactive03$2 = colors$1.blue60;
var interactive04$2 = colors$1.blue60;
var uiBackground$2 = colors$1.gray10;
var ui01$2 = colors$1.white;
var ui02$2 = colors$1.gray10;
var ui03$2 = colors$1.gray20;
var ui04$2 = colors$1.gray50;
var ui05$2 = colors$1.gray100;
var text01$2 = colors$1.gray100;
var text02$2 = colors$1.gray70;
var text03$2 = colors$1.gray40;
var text04$2 = colors$1.white;
var text05$2 = colors$1.gray60;
var textError$2 = colors$1.red60;
var icon01$2 = colors$1.gray100;
var icon02$2 = colors$1.gray70;
var icon03$2 = colors$1.white;
var link01$2 = colors$1.blue60;
var link02$2 = colors$1.blue70;
var inverseLink$2 = colors$1.blue40;
var field01$2 = colors$1.white;
var field02$2 = colors$1.gray10;
var inverse01$2 = colors$1.white;
var inverse02$2 = colors$1.gray80;
var support01$2 = colors$1.red60;
var support02$2 = colors$1.green60;
var support03$2 = colors$1.yellow30;
var support04$2 = colors$1.blue70;
var inverseSupport01$2 = colors$1.red50;
var inverseSupport02$2 = colors$1.green40;
var inverseSupport03$2 = colors$1.yellow30;
var inverseSupport04$2 = colors$1.blue50;
var overlay01$2 = colors$1.rgba(colors$1.gray100, 0.5);
var danger01$2 = colors$1.red60;
var danger02$2 = colors$1.red60;

// Interaction states
var focus$3 = colors$1.blue60;
var inverseFocusUi$2 = colors$1.white;
var hoverPrimary$2 = '#0353e9';
var activePrimary$2 = colors$1.blue80;
var hoverPrimaryText$2 = colors$1.blue70;
var hoverSecondary$2 = '#4c4c4c';
var activeSecondary$2 = colors$1.gray60;
var hoverTertiary$2 = '#0353e9';
var activeTertiary$2 = colors$1.blue80;
var hoverUI$2 = '#e5e5e5';
var hoverLightUI$2 = '#e5e5e5';
var activeUI$2 = colors$1.gray30;
var activeLightUI$2 = colors$1.gray30;
var selectedUI$2 = colors$1.gray20;
var selectedLightUI$2 = colors$1.gray20;
var inverseHoverUI$2 = '#4c4c4c';
var hoverSelectedUI$2 = '#cacaca';
var hoverDanger$2 = adjustLightness(danger01$2, -8);
var activeDanger$2 = colors$1.red80;
var hoverRow$2 = '#e5e5e5';
var visitedLink$2 = colors$1.purple60;
var disabled01$2 = colors$1.white;
var disabled02$2 = colors$1.gray30;
var disabled03$2 = colors$1.gray50;
var highlight$2 = colors$1.blue20;
var decorative01$2 = colors$1.gray20;
var buttonSeparator$3 = '#e0e0e0';
var skeleton01$2 = '#e5e5e5';
var skeleton02$2 = colors$1.gray30;

// New color tokens
// TO-DO: remove fallback color when v11 is released and assign carbon colors to new tokens
var background$3 = uiBackground$2;
var layer$3 = ui01$2;
var layerAccent$2 = ui03$2;
var layerAccentActive$2 = colors$1.gray40;
var layerAccentHover$2 = adjustLightness(layerAccent$2, -6);
var field$3 = field01$2;
var backgroundInverse$2 = inverse02$2;
var backgroundBrand$2 = interactive01$2;
var interactive$2 = interactive04$2;
var borderSubtle$2 = ui03$2;
var borderStrong$2 = ui04$2;
var borderInverse$2 = ui05$2;
var borderInteractive$2 = interactive04$2;
var textPrimary$2 = text01$2;
var textSecondary$2 = text02$2;
var textPlaceholder$2 = text03$2;
var textHelper$2 = text05$2;
var textOnColor$2 = text04$2;
var textInverse$2 = inverse01$2;
var linkPrimary$2 = link01$2;
var linkSecondary$2 = link02$2;
var linkVisited$2 = visitedLink$2;
var linkInverse$2 = inverseLink$2;
var iconPrimary$2 = icon01$2;
var iconSecondary$2 = icon02$2;
var iconOnColor$2 = icon03$2;
var iconInverse$2 = inverse01$2;
var supportError$2 = support01$2;
var supportSuccess$2 = support02$2;
var supportWarning$2 = support03$2;
var supportInfo$2 = support04$2;
var supportErrorInverse$2 = inverseSupport01$2;
var supportSuccessInverse$2 = inverseSupport02$2;
var supportWarningInverse$2 = inverseSupport03$2;
var supportInfoInverse$2 = inverseSupport04$2;
var overlay$2 = overlay01$2;
var toggleOff$2 = ui04$2;
var shadow$2 = colors$1.rgba(colors$1.black, 0.3);
var buttonPrimary$3 = interactive01$2;
var buttonSecondary$3 = interactive02$2;
var buttonTertiary$3 = interactive03$2;
var buttonDangerPrimary$3 = danger01$2;
var buttonDangerSecondary$3 = danger02$2;
var backgroundActive$2 = activeUI$2;
var layerActive$2 = activeUI$2;
var buttonDangerActive$3 = activeDanger$2;
var buttonPrimaryActive$3 = activePrimary$2;
var buttonSecondaryActive$3 = activeSecondary$2;
var buttonTertiaryActive$3 = activeTertiary$2;
var focusInset$2 = inverse01$2;
var focusInverse$2 = inverseFocusUi$2;
var backgroundHover$2 = hoverUI$2;
var layerHover$2 = hoverUI$2;
var fieldHover$2 = hoverUI$2;
var backgroundInverseHover$2 = inverseHoverUI$2;
var linkPrimaryHover$2 = hoverPrimaryText$2;
var buttonDangerHover$3 = hoverDanger$2;
var buttonPrimaryHover$3 = hoverPrimary$2;
var buttonSecondaryHover$3 = hoverSecondary$2;
var buttonTertiaryHover$3 = hoverTertiary$2;
var backgroundSelected$2 = selectedUI$2;
var backgroundSelectedHover$2 = hoverSelectedUI$2;
var layerSelected$2 = selectedUI$2;
var layerSelectedHover$2 = hoverSelectedUI$2;
var layerSelectedInverse$2 = ui05$2;
var borderSubtleSelected$2 = activeUI$2;
var borderDisabled$2 = disabled01$2;
var textDisabled$2 = disabled02$2;
var buttonDisabled$3 = disabled02$2;
var iconDisabled$2 = disabled02$2;
var textOnColorDisabled$2 = disabled03$2;
var iconOnColorDisabled$2 = disabled03$2;
var layerSelectedDisabled$2 = disabled03$2;
var skeletonBackground$2 = skeleton01$2;
var skeletonElement$2 = skeleton02$2;

// Deprecated ☠️
var brand01$2 = interactive01$2;
var brand02$2 = interactive02$2;
var brand03$2 = interactive03$2;
var active01$2 = activeUI$2;
var hoverField$2 = hoverUI$2;
var danger$2 = danger01$2;

var g10 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  interactive01: interactive01$2,
  interactive02: interactive02$2,
  interactive03: interactive03$2,
  interactive04: interactive04$2,
  uiBackground: uiBackground$2,
  ui01: ui01$2,
  ui02: ui02$2,
  ui03: ui03$2,
  ui04: ui04$2,
  ui05: ui05$2,
  text01: text01$2,
  text02: text02$2,
  text03: text03$2,
  text04: text04$2,
  text05: text05$2,
  textError: textError$2,
  icon01: icon01$2,
  icon02: icon02$2,
  icon03: icon03$2,
  link01: link01$2,
  link02: link02$2,
  inverseLink: inverseLink$2,
  field01: field01$2,
  field02: field02$2,
  inverse01: inverse01$2,
  inverse02: inverse02$2,
  support01: support01$2,
  support02: support02$2,
  support03: support03$2,
  support04: support04$2,
  inverseSupport01: inverseSupport01$2,
  inverseSupport02: inverseSupport02$2,
  inverseSupport03: inverseSupport03$2,
  inverseSupport04: inverseSupport04$2,
  overlay01: overlay01$2,
  danger01: danger01$2,
  danger02: danger02$2,
  focus: focus$3,
  inverseFocusUi: inverseFocusUi$2,
  hoverPrimary: hoverPrimary$2,
  activePrimary: activePrimary$2,
  hoverPrimaryText: hoverPrimaryText$2,
  hoverSecondary: hoverSecondary$2,
  activeSecondary: activeSecondary$2,
  hoverTertiary: hoverTertiary$2,
  activeTertiary: activeTertiary$2,
  hoverUI: hoverUI$2,
  hoverLightUI: hoverLightUI$2,
  activeUI: activeUI$2,
  activeLightUI: activeLightUI$2,
  selectedUI: selectedUI$2,
  selectedLightUI: selectedLightUI$2,
  inverseHoverUI: inverseHoverUI$2,
  hoverSelectedUI: hoverSelectedUI$2,
  hoverDanger: hoverDanger$2,
  activeDanger: activeDanger$2,
  hoverRow: hoverRow$2,
  visitedLink: visitedLink$2,
  disabled01: disabled01$2,
  disabled02: disabled02$2,
  disabled03: disabled03$2,
  highlight: highlight$2,
  decorative01: decorative01$2,
  buttonSeparator: buttonSeparator$3,
  skeleton01: skeleton01$2,
  skeleton02: skeleton02$2,
  background: background$3,
  layer: layer$3,
  layerAccent: layerAccent$2,
  layerAccentActive: layerAccentActive$2,
  layerAccentHover: layerAccentHover$2,
  field: field$3,
  backgroundInverse: backgroundInverse$2,
  backgroundBrand: backgroundBrand$2,
  interactive: interactive$2,
  borderSubtle: borderSubtle$2,
  borderStrong: borderStrong$2,
  borderInverse: borderInverse$2,
  borderInteractive: borderInteractive$2,
  textPrimary: textPrimary$2,
  textSecondary: textSecondary$2,
  textPlaceholder: textPlaceholder$2,
  textHelper: textHelper$2,
  textOnColor: textOnColor$2,
  textInverse: textInverse$2,
  linkPrimary: linkPrimary$2,
  linkSecondary: linkSecondary$2,
  linkVisited: linkVisited$2,
  linkInverse: linkInverse$2,
  iconPrimary: iconPrimary$2,
  iconSecondary: iconSecondary$2,
  iconOnColor: iconOnColor$2,
  iconInverse: iconInverse$2,
  supportError: supportError$2,
  supportSuccess: supportSuccess$2,
  supportWarning: supportWarning$2,
  supportInfo: supportInfo$2,
  supportErrorInverse: supportErrorInverse$2,
  supportSuccessInverse: supportSuccessInverse$2,
  supportWarningInverse: supportWarningInverse$2,
  supportInfoInverse: supportInfoInverse$2,
  overlay: overlay$2,
  toggleOff: toggleOff$2,
  shadow: shadow$2,
  buttonPrimary: buttonPrimary$3,
  buttonSecondary: buttonSecondary$3,
  buttonTertiary: buttonTertiary$3,
  buttonDangerPrimary: buttonDangerPrimary$3,
  buttonDangerSecondary: buttonDangerSecondary$3,
  backgroundActive: backgroundActive$2,
  layerActive: layerActive$2,
  buttonDangerActive: buttonDangerActive$3,
  buttonPrimaryActive: buttonPrimaryActive$3,
  buttonSecondaryActive: buttonSecondaryActive$3,
  buttonTertiaryActive: buttonTertiaryActive$3,
  focusInset: focusInset$2,
  focusInverse: focusInverse$2,
  backgroundHover: backgroundHover$2,
  layerHover: layerHover$2,
  fieldHover: fieldHover$2,
  backgroundInverseHover: backgroundInverseHover$2,
  linkPrimaryHover: linkPrimaryHover$2,
  buttonDangerHover: buttonDangerHover$3,
  buttonPrimaryHover: buttonPrimaryHover$3,
  buttonSecondaryHover: buttonSecondaryHover$3,
  buttonTertiaryHover: buttonTertiaryHover$3,
  backgroundSelected: backgroundSelected$2,
  backgroundSelectedHover: backgroundSelectedHover$2,
  layerSelected: layerSelected$2,
  layerSelectedHover: layerSelectedHover$2,
  layerSelectedInverse: layerSelectedInverse$2,
  borderSubtleSelected: borderSubtleSelected$2,
  borderDisabled: borderDisabled$2,
  textDisabled: textDisabled$2,
  buttonDisabled: buttonDisabled$3,
  iconDisabled: iconDisabled$2,
  textOnColorDisabled: textOnColorDisabled$2,
  iconOnColorDisabled: iconOnColorDisabled$2,
  layerSelectedDisabled: layerSelectedDisabled$2,
  skeletonBackground: skeletonBackground$2,
  skeletonElement: skeletonElement$2,
  brand01: brand01$2,
  brand02: brand02$2,
  brand03: brand03$2,
  active01: active01$2,
  hoverField: hoverField$2,
  danger: danger$2,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  legal01: type$2.legal01,
  legal02: type$2.legal02,
  bodyCompact01: type$2.bodyCompact01,
  bodyCompact02: type$2.bodyCompact02,
  body01: type$2.body01,
  body02: type$2.body02,
  headingCompact01: type$2.headingCompact01,
  headingCompact02: type$2.headingCompact02,
  heading03: type$2.heading03,
  heading04: type$2.heading04,
  heading05: type$2.heading05,
  heading06: type$2.heading06,
  heading07: type$2.heading07,
  fluidHeading03: type$2.fluidHeading03,
  fluidHeading04: type$2.fluidHeading04,
  fluidHeading05: type$2.fluidHeading05,
  fluidHeading06: type$2.fluidHeading06,
  fluidParagraph01: type$2.fluidParagraph01,
  fluidQuotation01: type$2.fluidQuotation01,
  fluidQuotation02: type$2.fluidQuotation02,
  fluidDisplay01: type$2.fluidDisplay01,
  fluidDisplay02: type$2.fluidDisplay02,
  fluidDisplay03: type$2.fluidDisplay03,
  fluidDisplay04: type$2.fluidDisplay04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var interactive01$1 = colors$1.blue60;
var interactive02$1 = colors$1.gray60;
var interactive03$1 = colors$1.white;
var interactive04$1 = colors$1.blue50;
var uiBackground$1 = colors$1.gray90;
var ui01$1 = colors$1.gray80;
var ui02$1 = colors$1.gray70;
var ui03$1 = colors$1.gray70;
var ui04$1 = colors$1.gray50;
var ui05$1 = colors$1.gray10;
var text01$1 = colors$1.gray10;
var text02$1 = colors$1.gray30;
var text03$1 = colors$1.gray60;
var text04$1 = colors$1.white;
var text05$1 = colors$1.gray50;
var textError$1 = colors$1.red30;
var icon01$1 = colors$1.gray10;
var icon02$1 = colors$1.gray30;
var icon03$1 = colors$1.white;
var link01$1 = colors$1.blue40;
var link02$1 = colors$1.blue30;
var inverseLink$1 = colors$1.blue60;
var field01$1 = colors$1.gray80;
var field02$1 = colors$1.gray70;
var inverse01$1 = colors$1.gray100;
var inverse02$1 = colors$1.gray10;
var support01$1 = colors$1.red40;
var support02$1 = colors$1.green40;
var support03$1 = colors$1.yellow30;
var support04$1 = colors$1.blue50;
var inverseSupport01$1 = colors$1.red60;
var inverseSupport02$1 = colors$1.green50;
var inverseSupport03$1 = colors$1.yellow30;
var inverseSupport04$1 = colors$1.blue60;
var overlay01$1 = colors$1.rgba(colors$1.black, 0.65);
var danger01$1 = colors$1.red60;
var danger02$1 = colors$1.red40;

// Interaction states
var focus$2 = colors$1.white;
var inverseFocusUi$1 = colors$1.blue60;
var hoverPrimary$1 = '#0353e9';
var activePrimary$1 = colors$1.blue80;
var hoverPrimaryText$1 = colors$1.blue30;
var hoverSecondary$1 = '#606060';
var activeSecondary$1 = colors$1.gray80;
var hoverTertiary$1 = colors$1.gray10;
var activeTertiary$1 = colors$1.gray30;
var hoverUI$1 = '#4c4c4c';
var hoverLightUI$1 = '#656565';
var activeUI$1 = colors$1.gray60;
var activeLightUI$1 = colors$1.gray50;
var selectedUI$1 = colors$1.gray70;
var selectedLightUI$1 = colors$1.gray60;
var inverseHoverUI$1 = '#e5e5e5';
var hoverSelectedUI$1 = '#656565';
var hoverDanger$1 = adjustLightness(danger01$1, -8);
var activeDanger$1 = colors$1.red80;
var hoverRow$1 = '#4c4c4c';
var visitedLink$1 = colors$1.purple40;
var disabled01$1 = colors$1.gray80;
var disabled02$1 = colors$1.gray60;
var disabled03$1 = colors$1.gray40;
var highlight$1 = colors$1.blue70;
var decorative01$1 = colors$1.gray60;
var buttonSeparator$2 = '#161616';
var skeleton01$1 = '#353535';
var skeleton02$1 = colors$1.gray70;

// New color tokens
// TO-DO: remove fallback color when v11 is released and assign carbon colors to new tokens
var background$2 = uiBackground$1;
var layer$2 = ui01$1;
var layerAccent$1 = ui03$1;
var layerAccentActive$1 = colors$1.gray50;
var layerAccentHover$1 = adjustLightness(layerAccent$1, +7);
var field$2 = field01$1;
var backgroundInverse$1 = inverse02$1;
var backgroundBrand$1 = interactive01$1;
var interactive$1 = interactive04$1;
var borderSubtle$1 = ui03$1;
var borderStrong$1 = ui04$1;
var borderInverse$1 = ui05$1;
var borderInteractive$1 = interactive04$1;
var textPrimary$1 = text01$1;
var textSecondary$1 = text02$1;
var textPlaceholder$1 = text03$1;
var textHelper$1 = text05$1;
var textOnColor$1 = text04$1;
var textInverse$1 = inverse01$1;
var linkPrimary$1 = link01$1;
var linkSecondary$1 = link02$1;
var linkVisited$1 = visitedLink$1;
var linkInverse$1 = inverseLink$1;
var iconPrimary$1 = icon01$1;
var iconSecondary$1 = icon02$1;
var iconOnColor$1 = icon03$1;
var iconInverse$1 = inverse01$1;
var supportError$1 = support01$1;
var supportSuccess$1 = support02$1;
var supportWarning$1 = support03$1;
var supportInfo$1 = support04$1;
var supportErrorInverse$1 = inverseSupport01$1;
var supportSuccessInverse$1 = inverseSupport02$1;
var supportWarningInverse$1 = inverseSupport03$1;
var supportInfoInverse$1 = inverseSupport04$1;
var overlay$1 = overlay01$1;
var toggleOff$1 = ui04$1;
var shadow$1 = colors$1.rgba(colors$1.black, 0.8);
var buttonPrimary$2 = interactive01$1;
var buttonSecondary$2 = interactive02$1;
var buttonTertiary$2 = interactive03$1;
var buttonDangerPrimary$2 = danger01$1;
var buttonDangerSecondary$2 = danger02$1;
var backgroundActive$1 = activeUI$1;
var layerActive$1 = activeUI$1;
var buttonDangerActive$2 = activeDanger$1;
var buttonPrimaryActive$2 = activePrimary$1;
var buttonSecondaryActive$2 = activeSecondary$1;
var buttonTertiaryActive$2 = activeTertiary$1;
var focusInset$1 = inverse01$1;
var focusInverse$1 = inverseFocusUi$1;
var backgroundHover$1 = hoverUI$1;
var layerHover$1 = hoverUI$1;
var fieldHover$1 = hoverUI$1;
var backgroundInverseHover$1 = inverseHoverUI$1;
var linkPrimaryHover$1 = hoverPrimaryText$1;
var buttonDangerHover$2 = hoverDanger$1;
var buttonPrimaryHover$2 = hoverPrimary$1;
var buttonSecondaryHover$2 = hoverSecondary$1;
var buttonTertiaryHover$2 = hoverTertiary$1;
var backgroundSelected$1 = selectedUI$1;
var backgroundSelectedHover$1 = hoverSelectedUI$1;
var layerSelected$1 = selectedUI$1;
var layerSelectedHover$1 = hoverSelectedUI$1;
var layerSelectedInverse$1 = ui05$1;
var borderSubtleSelected$1 = activeUI$1;
var borderDisabled$1 = disabled01$1;
var textDisabled$1 = disabled02$1;
var buttonDisabled$2 = disabled02$1;
var iconDisabled$1 = disabled02$1;
var textOnColorDisabled$1 = disabled03$1;
var iconOnColorDisabled$1 = disabled03$1;
var layerSelectedDisabled$1 = disabled03$1;
var skeletonBackground$1 = skeleton01$1;
var skeletonElement$1 = skeleton02$1;

// Deprecated ☠️
var brand01$1 = interactive01$1;
var brand02$1 = interactive02$1;
var brand03$1 = interactive03$1;
var active01$1 = activeUI$1;
var hoverField$1 = hoverUI$1;
var danger$1 = danger01$1;

var g90 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  interactive01: interactive01$1,
  interactive02: interactive02$1,
  interactive03: interactive03$1,
  interactive04: interactive04$1,
  uiBackground: uiBackground$1,
  ui01: ui01$1,
  ui02: ui02$1,
  ui03: ui03$1,
  ui04: ui04$1,
  ui05: ui05$1,
  text01: text01$1,
  text02: text02$1,
  text03: text03$1,
  text04: text04$1,
  text05: text05$1,
  textError: textError$1,
  icon01: icon01$1,
  icon02: icon02$1,
  icon03: icon03$1,
  link01: link01$1,
  link02: link02$1,
  inverseLink: inverseLink$1,
  field01: field01$1,
  field02: field02$1,
  inverse01: inverse01$1,
  inverse02: inverse02$1,
  support01: support01$1,
  support02: support02$1,
  support03: support03$1,
  support04: support04$1,
  inverseSupport01: inverseSupport01$1,
  inverseSupport02: inverseSupport02$1,
  inverseSupport03: inverseSupport03$1,
  inverseSupport04: inverseSupport04$1,
  overlay01: overlay01$1,
  danger01: danger01$1,
  danger02: danger02$1,
  focus: focus$2,
  inverseFocusUi: inverseFocusUi$1,
  hoverPrimary: hoverPrimary$1,
  activePrimary: activePrimary$1,
  hoverPrimaryText: hoverPrimaryText$1,
  hoverSecondary: hoverSecondary$1,
  activeSecondary: activeSecondary$1,
  hoverTertiary: hoverTertiary$1,
  activeTertiary: activeTertiary$1,
  hoverUI: hoverUI$1,
  hoverLightUI: hoverLightUI$1,
  activeUI: activeUI$1,
  activeLightUI: activeLightUI$1,
  selectedUI: selectedUI$1,
  selectedLightUI: selectedLightUI$1,
  inverseHoverUI: inverseHoverUI$1,
  hoverSelectedUI: hoverSelectedUI$1,
  hoverDanger: hoverDanger$1,
  activeDanger: activeDanger$1,
  hoverRow: hoverRow$1,
  visitedLink: visitedLink$1,
  disabled01: disabled01$1,
  disabled02: disabled02$1,
  disabled03: disabled03$1,
  highlight: highlight$1,
  decorative01: decorative01$1,
  buttonSeparator: buttonSeparator$2,
  skeleton01: skeleton01$1,
  skeleton02: skeleton02$1,
  background: background$2,
  layer: layer$2,
  layerAccent: layerAccent$1,
  layerAccentActive: layerAccentActive$1,
  layerAccentHover: layerAccentHover$1,
  field: field$2,
  backgroundInverse: backgroundInverse$1,
  backgroundBrand: backgroundBrand$1,
  interactive: interactive$1,
  borderSubtle: borderSubtle$1,
  borderStrong: borderStrong$1,
  borderInverse: borderInverse$1,
  borderInteractive: borderInteractive$1,
  textPrimary: textPrimary$1,
  textSecondary: textSecondary$1,
  textPlaceholder: textPlaceholder$1,
  textHelper: textHelper$1,
  textOnColor: textOnColor$1,
  textInverse: textInverse$1,
  linkPrimary: linkPrimary$1,
  linkSecondary: linkSecondary$1,
  linkVisited: linkVisited$1,
  linkInverse: linkInverse$1,
  iconPrimary: iconPrimary$1,
  iconSecondary: iconSecondary$1,
  iconOnColor: iconOnColor$1,
  iconInverse: iconInverse$1,
  supportError: supportError$1,
  supportSuccess: supportSuccess$1,
  supportWarning: supportWarning$1,
  supportInfo: supportInfo$1,
  supportErrorInverse: supportErrorInverse$1,
  supportSuccessInverse: supportSuccessInverse$1,
  supportWarningInverse: supportWarningInverse$1,
  supportInfoInverse: supportInfoInverse$1,
  overlay: overlay$1,
  toggleOff: toggleOff$1,
  shadow: shadow$1,
  buttonPrimary: buttonPrimary$2,
  buttonSecondary: buttonSecondary$2,
  buttonTertiary: buttonTertiary$2,
  buttonDangerPrimary: buttonDangerPrimary$2,
  buttonDangerSecondary: buttonDangerSecondary$2,
  backgroundActive: backgroundActive$1,
  layerActive: layerActive$1,
  buttonDangerActive: buttonDangerActive$2,
  buttonPrimaryActive: buttonPrimaryActive$2,
  buttonSecondaryActive: buttonSecondaryActive$2,
  buttonTertiaryActive: buttonTertiaryActive$2,
  focusInset: focusInset$1,
  focusInverse: focusInverse$1,
  backgroundHover: backgroundHover$1,
  layerHover: layerHover$1,
  fieldHover: fieldHover$1,
  backgroundInverseHover: backgroundInverseHover$1,
  linkPrimaryHover: linkPrimaryHover$1,
  buttonDangerHover: buttonDangerHover$2,
  buttonPrimaryHover: buttonPrimaryHover$2,
  buttonSecondaryHover: buttonSecondaryHover$2,
  buttonTertiaryHover: buttonTertiaryHover$2,
  backgroundSelected: backgroundSelected$1,
  backgroundSelectedHover: backgroundSelectedHover$1,
  layerSelected: layerSelected$1,
  layerSelectedHover: layerSelectedHover$1,
  layerSelectedInverse: layerSelectedInverse$1,
  borderSubtleSelected: borderSubtleSelected$1,
  borderDisabled: borderDisabled$1,
  textDisabled: textDisabled$1,
  buttonDisabled: buttonDisabled$2,
  iconDisabled: iconDisabled$1,
  textOnColorDisabled: textOnColorDisabled$1,
  iconOnColorDisabled: iconOnColorDisabled$1,
  layerSelectedDisabled: layerSelectedDisabled$1,
  skeletonBackground: skeletonBackground$1,
  skeletonElement: skeletonElement$1,
  brand01: brand01$1,
  brand02: brand02$1,
  brand03: brand03$1,
  active01: active01$1,
  hoverField: hoverField$1,
  danger: danger$1,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  legal01: type$2.legal01,
  legal02: type$2.legal02,
  bodyCompact01: type$2.bodyCompact01,
  bodyCompact02: type$2.bodyCompact02,
  body01: type$2.body01,
  body02: type$2.body02,
  headingCompact01: type$2.headingCompact01,
  headingCompact02: type$2.headingCompact02,
  heading03: type$2.heading03,
  heading04: type$2.heading04,
  heading05: type$2.heading05,
  heading06: type$2.heading06,
  heading07: type$2.heading07,
  fluidHeading03: type$2.fluidHeading03,
  fluidHeading04: type$2.fluidHeading04,
  fluidHeading05: type$2.fluidHeading05,
  fluidHeading06: type$2.fluidHeading06,
  fluidParagraph01: type$2.fluidParagraph01,
  fluidQuotation01: type$2.fluidQuotation01,
  fluidQuotation02: type$2.fluidQuotation02,
  fluidDisplay01: type$2.fluidDisplay01,
  fluidDisplay02: type$2.fluidDisplay02,
  fluidDisplay03: type$2.fluidDisplay03,
  fluidDisplay04: type$2.fluidDisplay04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var interactive01 = colors$1.blue60;
var interactive02 = colors$1.gray60;
var interactive03 = colors$1.white;
var interactive04 = colors$1.blue50;
var uiBackground = colors$1.gray100;
var ui01 = colors$1.gray90;
var ui02 = colors$1.gray80;
var ui03 = colors$1.gray80;
var ui04 = colors$1.gray60;
var ui05 = colors$1.gray10;
var text01 = colors$1.gray10;
var text02 = colors$1.gray30;
var text03 = colors$1.gray60;
var text04 = colors$1.white;
var text05 = colors$1.gray50;
var textError = colors$1.red40;
var icon01 = colors$1.gray10;
var icon02 = colors$1.gray30;
var icon03 = colors$1.white;
var link01 = colors$1.blue40;
var link02 = colors$1.blue30;
var inverseLink = colors$1.blue60;
var field01 = colors$1.gray90;
var field02 = colors$1.gray80;
var inverse01 = colors$1.gray100;
var inverse02 = colors$1.gray10;
var support01 = colors$1.red50;
var support02 = colors$1.green40;
var support03 = colors$1.yellow30;
var support04 = colors$1.blue50;
var inverseSupport01 = colors$1.red60;
var inverseSupport02 = colors$1.green50;
var inverseSupport03 = colors$1.yellow30;
var inverseSupport04 = colors$1.blue60;
var overlay01 = colors$1.rgba(colors$1.black, 0.65);
var danger01 = colors$1.red60;
var danger02 = colors$1.red50;

// Interaction states
var focus$1 = colors$1.white;
var inverseFocusUi = colors$1.blue60;
var hoverPrimary = '#0353e9';
var activePrimary = colors$1.blue80;
var hoverPrimaryText = colors$1.blue30;
var hoverSecondary = '#606060';
var activeSecondary = colors$1.gray80;
var hoverTertiary = colors$1.gray10;
var activeTertiary = colors$1.gray30;
var hoverUI = '#353535';
var hoverLightUI = '#4c4c4c';
var activeUI = colors$1.gray70;
var activeLightUI = colors$1.gray60;
var selectedUI = colors$1.gray80;
var selectedLightUI = colors$1.gray70;
var inverseHoverUI = '#e5e5e5';
var hoverSelectedUI = '#4c4c4c';
var hoverDanger = adjustLightness(danger01, -8);
var activeDanger = colors$1.red80;
var hoverRow = '#353535';
var visitedLink = colors$1.purple40;
var disabled01 = colors$1.gray90;
var disabled02 = colors$1.gray70;
var disabled03 = colors$1.gray50;
var highlight = colors$1.blue80;
var decorative01 = colors$1.gray70;
var buttonSeparator$1 = '#161616';
var skeleton01 = '#353535';
var skeleton02 = colors$1.gray70;

// New color tokens
// TO-DO: remove fallback color when v11 is released and assign carbon colors to new tokens
var background$1 = uiBackground;
var layer$1 = ui01;
var layerAccent = ui03;
var layerAccentActive = colors$1.gray60;
var layerAccentHover = adjustLightness(layerAccent, +6);
var field$1 = field01;
var backgroundInverse = inverse02;
var backgroundBrand = interactive01;
var interactive = interactive04;
var borderSubtle = ui03;
var borderStrong = ui04;
var borderInverse = ui05;
var borderInteractive = interactive04;
var textPrimary = text01;
var textSecondary = text02;
var textPlaceholder = text03;
var textHelper = text05;
var textOnColor = text04;
var textInverse = inverse01;
var linkPrimary = link01;
var linkSecondary = link02;
var linkVisited = visitedLink;
var linkInverse = inverseLink;
var iconPrimary = icon01;
var iconSecondary = icon02;
var iconOnColor = icon03;
var iconInverse = inverse01;
var supportError = support01;
var supportSuccess = support02;
var supportWarning = support03;
var supportInfo = support04;
var supportErrorInverse = inverseSupport01;
var supportSuccessInverse = inverseSupport02;
var supportWarningInverse = inverseSupport03;
var supportInfoInverse = inverseSupport04;
var overlay = overlay01;
var toggleOff = ui04;
var shadow = colors$1.rgba(colors$1.black, 0.8);
var buttonPrimary$1 = interactive01;
var buttonSecondary$1 = interactive02;
var buttonTertiary$1 = interactive03;
var buttonDangerPrimary$1 = danger01;
var buttonDangerSecondary$1 = danger02;
var backgroundActive = activeUI;
var layerActive = activeUI;
var buttonDangerActive$1 = activeDanger;
var buttonPrimaryActive$1 = activePrimary;
var buttonSecondaryActive$1 = activeSecondary;
var buttonTertiaryActive$1 = activeTertiary;
var focusInset = inverse01;
var focusInverse = inverseFocusUi;
var backgroundHover = hoverUI;
var layerHover = hoverUI;
var fieldHover = hoverUI;
var backgroundInverseHover = inverseHoverUI;
var linkPrimaryHover = hoverPrimaryText;
var buttonDangerHover$1 = hoverDanger;
var buttonPrimaryHover$1 = hoverPrimary;
var buttonSecondaryHover$1 = hoverSecondary;
var buttonTertiaryHover$1 = hoverTertiary;
var backgroundSelected = selectedUI;
var backgroundSelectedHover = hoverSelectedUI;
var layerSelected = selectedUI;
var layerSelectedHover = hoverSelectedUI;
var layerSelectedInverse = ui05;
var borderSubtleSelected = activeUI;
var borderDisabled = disabled01;
var textDisabled = disabled02;
var buttonDisabled$1 = disabled02;
var iconDisabled = disabled02;
var textOnColorDisabled = disabled03;
var iconOnColorDisabled = disabled03;
var layerSelectedDisabled = disabled03;
var skeletonBackground = skeleton01;
var skeletonElement = skeleton02;

// Deprecated ☠️
var brand01 = interactive01;
var brand02 = interactive02;
var brand03 = interactive03;
var active01 = activeUI;
var hoverField = hoverUI;
var danger = danger01;

var g100 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  interactive01: interactive01,
  interactive02: interactive02,
  interactive03: interactive03,
  interactive04: interactive04,
  uiBackground: uiBackground,
  ui01: ui01,
  ui02: ui02,
  ui03: ui03,
  ui04: ui04,
  ui05: ui05,
  text01: text01,
  text02: text02,
  text03: text03,
  text04: text04,
  text05: text05,
  textError: textError,
  icon01: icon01,
  icon02: icon02,
  icon03: icon03,
  link01: link01,
  link02: link02,
  inverseLink: inverseLink,
  field01: field01,
  field02: field02,
  inverse01: inverse01,
  inverse02: inverse02,
  support01: support01,
  support02: support02,
  support03: support03,
  support04: support04,
  inverseSupport01: inverseSupport01,
  inverseSupport02: inverseSupport02,
  inverseSupport03: inverseSupport03,
  inverseSupport04: inverseSupport04,
  overlay01: overlay01,
  danger01: danger01,
  danger02: danger02,
  focus: focus$1,
  inverseFocusUi: inverseFocusUi,
  hoverPrimary: hoverPrimary,
  activePrimary: activePrimary,
  hoverPrimaryText: hoverPrimaryText,
  hoverSecondary: hoverSecondary,
  activeSecondary: activeSecondary,
  hoverTertiary: hoverTertiary,
  activeTertiary: activeTertiary,
  hoverUI: hoverUI,
  hoverLightUI: hoverLightUI,
  activeUI: activeUI,
  activeLightUI: activeLightUI,
  selectedUI: selectedUI,
  selectedLightUI: selectedLightUI,
  inverseHoverUI: inverseHoverUI,
  hoverSelectedUI: hoverSelectedUI,
  hoverDanger: hoverDanger,
  activeDanger: activeDanger,
  hoverRow: hoverRow,
  visitedLink: visitedLink,
  disabled01: disabled01,
  disabled02: disabled02,
  disabled03: disabled03,
  highlight: highlight,
  decorative01: decorative01,
  buttonSeparator: buttonSeparator$1,
  skeleton01: skeleton01,
  skeleton02: skeleton02,
  background: background$1,
  layer: layer$1,
  layerAccent: layerAccent,
  layerAccentActive: layerAccentActive,
  layerAccentHover: layerAccentHover,
  field: field$1,
  backgroundInverse: backgroundInverse,
  backgroundBrand: backgroundBrand,
  interactive: interactive,
  borderSubtle: borderSubtle,
  borderStrong: borderStrong,
  borderInverse: borderInverse,
  borderInteractive: borderInteractive,
  textPrimary: textPrimary,
  textSecondary: textSecondary,
  textPlaceholder: textPlaceholder,
  textHelper: textHelper,
  textOnColor: textOnColor,
  textInverse: textInverse,
  linkPrimary: linkPrimary,
  linkSecondary: linkSecondary,
  linkVisited: linkVisited,
  linkInverse: linkInverse,
  iconPrimary: iconPrimary,
  iconSecondary: iconSecondary,
  iconOnColor: iconOnColor,
  iconInverse: iconInverse,
  supportError: supportError,
  supportSuccess: supportSuccess,
  supportWarning: supportWarning,
  supportInfo: supportInfo,
  supportErrorInverse: supportErrorInverse,
  supportSuccessInverse: supportSuccessInverse,
  supportWarningInverse: supportWarningInverse,
  supportInfoInverse: supportInfoInverse,
  overlay: overlay,
  toggleOff: toggleOff,
  shadow: shadow,
  buttonPrimary: buttonPrimary$1,
  buttonSecondary: buttonSecondary$1,
  buttonTertiary: buttonTertiary$1,
  buttonDangerPrimary: buttonDangerPrimary$1,
  buttonDangerSecondary: buttonDangerSecondary$1,
  backgroundActive: backgroundActive,
  layerActive: layerActive,
  buttonDangerActive: buttonDangerActive$1,
  buttonPrimaryActive: buttonPrimaryActive$1,
  buttonSecondaryActive: buttonSecondaryActive$1,
  buttonTertiaryActive: buttonTertiaryActive$1,
  focusInset: focusInset,
  focusInverse: focusInverse,
  backgroundHover: backgroundHover,
  layerHover: layerHover,
  fieldHover: fieldHover,
  backgroundInverseHover: backgroundInverseHover,
  linkPrimaryHover: linkPrimaryHover,
  buttonDangerHover: buttonDangerHover$1,
  buttonPrimaryHover: buttonPrimaryHover$1,
  buttonSecondaryHover: buttonSecondaryHover$1,
  buttonTertiaryHover: buttonTertiaryHover$1,
  backgroundSelected: backgroundSelected,
  backgroundSelectedHover: backgroundSelectedHover,
  layerSelected: layerSelected,
  layerSelectedHover: layerSelectedHover,
  layerSelectedInverse: layerSelectedInverse,
  borderSubtleSelected: borderSubtleSelected,
  borderDisabled: borderDisabled,
  textDisabled: textDisabled,
  buttonDisabled: buttonDisabled$1,
  iconDisabled: iconDisabled,
  textOnColorDisabled: textOnColorDisabled,
  iconOnColorDisabled: iconOnColorDisabled,
  layerSelectedDisabled: layerSelectedDisabled,
  skeletonBackground: skeletonBackground,
  skeletonElement: skeletonElement,
  brand01: brand01,
  brand02: brand02,
  brand03: brand03,
  active01: active01,
  hoverField: hoverField,
  danger: danger,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  legal01: type$2.legal01,
  legal02: type$2.legal02,
  bodyCompact01: type$2.bodyCompact01,
  bodyCompact02: type$2.bodyCompact02,
  body01: type$2.body01,
  body02: type$2.body02,
  headingCompact01: type$2.headingCompact01,
  headingCompact02: type$2.headingCompact02,
  heading03: type$2.heading03,
  heading04: type$2.heading04,
  heading05: type$2.heading05,
  heading06: type$2.heading06,
  heading07: type$2.heading07,
  fluidHeading03: type$2.fluidHeading03,
  fluidHeading04: type$2.fluidHeading04,
  fluidHeading05: type$2.fluidHeading05,
  fluidHeading06: type$2.fluidHeading06,
  fluidParagraph01: type$2.fluidParagraph01,
  fluidQuotation01: type$2.fluidQuotation01,
  fluidQuotation02: type$2.fluidQuotation02,
  fluidDisplay01: type$2.fluidDisplay01,
  fluidDisplay02: type$2.fluidDisplay02,
  fluidDisplay03: type$2.fluidDisplay03,
  fluidDisplay04: type$2.fluidDisplay04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

// The color token names for a Carbon theme, value corresponds to what they're
// exported as in JavaScript
var colors = [
// Core
'interactive01', 'interactive02', 'interactive03', 'interactive04', 'uiBackground', 'ui01', 'ui02', 'ui03', 'ui04', 'ui05', 'text01', 'text02', 'text03', 'text04', 'text05', 'textError', 'icon01', 'icon02', 'icon03', 'link01', 'link02', 'inverseLink', 'field01', 'field02', 'inverse01', 'inverse02', 'support01', 'support02', 'support03', 'support04', 'inverseSupport01', 'inverseSupport02', 'inverseSupport03', 'inverseSupport04', 'overlay01', 'danger01', 'danger02',
// Interactive states
'focus', 'inverseFocusUi', 'hoverPrimary', 'activePrimary', 'hoverPrimaryText', 'hoverSecondary', 'activeSecondary', 'hoverTertiary', 'activeTertiary', 'hoverUI', 'hoverLightUI', 'hoverSelectedUI', 'activeUI', 'activeLightUI', 'selectedUI', 'selectedLightUI', 'inverseHoverUI', 'hoverDanger', 'activeDanger', 'hoverRow', 'visitedLink', 'disabled01', 'disabled02', 'disabled03', 'highlight', 'decorative01', 'buttonSeparator', 'skeleton01', 'skeleton02',
// New color tokens
// TO-DO: remove fallback color when v11 is released and assign carbon colors to new tokens
'background', 'layer', 'layerAccent', 'layerAccentHover', 'layerAccentActive', 'field', 'backgroundInverse', 'backgroundBrand', 'interactive', 'borderSubtle', 'borderStrong', 'borderInverse', 'borderInteractive', 'textPrimary', 'textSecondary', 'textPlaceholder', 'textHelper', 'textOnColor', 'textInverse', 'linkPrimary', 'linkSecondary', 'linkVisited', 'linkInverse', 'iconPrimary', 'iconSecondary', 'iconOnColor', 'iconInverse', 'supportError', 'supportSuccess', 'supportWarning', 'supportInfo', 'supportErrorInverse', 'supportSuccessInverse', 'supportWarningInverse', 'supportInfoInverse', 'overlay', 'toggleOff', 'shadow', 'buttonPrimary', 'buttonSecondary', 'buttonTertiary', 'buttonDangerPrimary', 'buttonDangerSecondary', 'backgroundActive', 'layerActive', 'buttonDangerActive', 'buttonPrimaryActive', 'buttonSecondaryActive', 'buttonTertiaryActive', 'focusInset', 'focusInverse', 'backgroundHover', 'layerHover', 'fieldHover', 'backgroundInverseHover', 'linkPrimaryHover', 'buttonDangerHover', 'buttonPrimaryHover', 'buttonSecondaryHover', 'buttonTertiaryHover', 'backgroundSelected', 'backgroundSelectedHover', 'layerSelected', 'layerSelectedHover', 'layerSelectedInverse', 'borderSubtleSelected', 'borderDisabled', 'textDisabled', 'buttonDisabled', 'iconDisabled', 'textOnColorDisabled', 'iconOnColorDisabled', 'layerSelectedDisabled', 'skeletonBackground', 'skeletonElement',
// Deprecated
'brand01', 'brand02', 'brand03', 'active01', 'hoverField', 'danger'];
var tokens$3 = {
  colors: colors,
  type: type$2.unstable_tokens,
  layout: layout$2.unstable_tokens
};

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var themes$1 = {
  white: white,
  g10: g10,
  g90: g90,
  g100: g100
};

var index$3 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  white: white,
  g10: g10,
  g90: g90,
  g100: g100,
  themes: themes$1,
  tokens: tokens$3,
  caption01: type$2.caption01,
  caption02: type$2.caption02,
  label01: type$2.label01,
  label02: type$2.label02,
  helperText01: type$2.helperText01,
  helperText02: type$2.helperText02,
  bodyShort01: type$2.bodyShort01,
  bodyLong01: type$2.bodyLong01,
  bodyShort02: type$2.bodyShort02,
  bodyLong02: type$2.bodyLong02,
  code01: type$2.code01,
  code02: type$2.code02,
  heading01: type$2.heading01,
  productiveHeading01: type$2.productiveHeading01,
  heading02: type$2.heading02,
  productiveHeading02: type$2.productiveHeading02,
  productiveHeading03: type$2.productiveHeading03,
  productiveHeading04: type$2.productiveHeading04,
  productiveHeading05: type$2.productiveHeading05,
  productiveHeading06: type$2.productiveHeading06,
  productiveHeading07: type$2.productiveHeading07,
  expressiveHeading01: type$2.expressiveHeading01,
  expressiveHeading02: type$2.expressiveHeading02,
  expressiveHeading03: type$2.expressiveHeading03,
  expressiveHeading04: type$2.expressiveHeading04,
  expressiveHeading05: type$2.expressiveHeading05,
  expressiveHeading06: type$2.expressiveHeading06,
  expressiveParagraph01: type$2.expressiveParagraph01,
  quotation01: type$2.quotation01,
  quotation02: type$2.quotation02,
  display01: type$2.display01,
  display02: type$2.display02,
  display03: type$2.display03,
  display04: type$2.display04,
  legal01: type$2.legal01,
  legal02: type$2.legal02,
  bodyCompact01: type$2.bodyCompact01,
  bodyCompact02: type$2.bodyCompact02,
  body01: type$2.body01,
  body02: type$2.body02,
  headingCompact01: type$2.headingCompact01,
  headingCompact02: type$2.headingCompact02,
  heading03: type$2.heading03,
  heading04: type$2.heading04,
  heading05: type$2.heading05,
  heading06: type$2.heading06,
  heading07: type$2.heading07,
  fluidHeading03: type$2.fluidHeading03,
  fluidHeading04: type$2.fluidHeading04,
  fluidHeading05: type$2.fluidHeading05,
  fluidHeading06: type$2.fluidHeading06,
  fluidParagraph01: type$2.fluidParagraph01,
  fluidQuotation01: type$2.fluidQuotation01,
  fluidQuotation02: type$2.fluidQuotation02,
  fluidDisplay01: type$2.fluidDisplay01,
  fluidDisplay02: type$2.fluidDisplay02,
  fluidDisplay03: type$2.fluidDisplay03,
  fluidDisplay04: type$2.fluidDisplay04,
  spacing01: layout$2.spacing01,
  spacing02: layout$2.spacing02,
  spacing03: layout$2.spacing03,
  spacing04: layout$2.spacing04,
  spacing05: layout$2.spacing05,
  spacing06: layout$2.spacing06,
  spacing07: layout$2.spacing07,
  spacing08: layout$2.spacing08,
  spacing09: layout$2.spacing09,
  spacing10: layout$2.spacing10,
  spacing11: layout$2.spacing11,
  spacing12: layout$2.spacing12,
  spacing13: layout$2.spacing13,
  fluidSpacing01: layout$2.fluidSpacing01,
  fluidSpacing02: layout$2.fluidSpacing02,
  fluidSpacing03: layout$2.fluidSpacing03,
  fluidSpacing04: layout$2.fluidSpacing04,
  container01: layout$2.container01,
  container02: layout$2.container02,
  container03: layout$2.container03,
  container04: layout$2.container04,
  container05: layout$2.container05,
  sizeXSmall: layout$2.sizeXSmall,
  sizeSmall: layout$2.sizeSmall,
  sizeMedium: layout$2.sizeMedium,
  sizeLarge: layout$2.sizeLarge,
  sizeXLarge: layout$2.sizeXLarge,
  size2XLarge: layout$2.size2XLarge,
  iconSize01: layout$2.iconSize01,
  iconSize02: layout$2.iconSize02,
  layout01: layout$2.layout01,
  layout02: layout$2.layout02,
  layout03: layout$2.layout03,
  layout04: layout$2.layout04,
  layout05: layout$2.layout05,
  layout06: layout$2.layout06,
  layout07: layout$2.layout07,
  interactive01: interactive01$3,
  interactive02: interactive02$3,
  interactive03: interactive03$3,
  interactive04: interactive04$3,
  uiBackground: uiBackground$3,
  ui01: ui01$3,
  ui02: ui02$3,
  ui03: ui03$3,
  ui04: ui04$3,
  ui05: ui05$3,
  text01: text01$3,
  text02: text02$3,
  text03: text03$3,
  text04: text04$3,
  text05: text05$3,
  textError: textError$3,
  icon01: icon01$3,
  icon02: icon02$3,
  icon03: icon03$3,
  link01: link01$3,
  link02: link02$3,
  inverseLink: inverseLink$3,
  field01: field01$3,
  field02: field02$3,
  inverse01: inverse01$3,
  inverse02: inverse02$3,
  support01: support01$3,
  support02: support02$3,
  support03: support03$3,
  support04: support04$3,
  inverseSupport01: inverseSupport01$3,
  inverseSupport02: inverseSupport02$3,
  inverseSupport03: inverseSupport03$3,
  inverseSupport04: inverseSupport04$3,
  overlay01: overlay01$3,
  danger01: danger01$3,
  danger02: danger02$3,
  focus: focus$4,
  inverseFocusUi: inverseFocusUi$3,
  hoverPrimary: hoverPrimary$3,
  activePrimary: activePrimary$3,
  hoverPrimaryText: hoverPrimaryText$3,
  hoverSecondary: hoverSecondary$3,
  activeSecondary: activeSecondary$3,
  hoverTertiary: hoverTertiary$3,
  activeTertiary: activeTertiary$3,
  hoverUI: hoverUI$3,
  hoverLightUI: hoverLightUI$3,
  activeUI: activeUI$3,
  activeLightUI: activeLightUI$3,
  selectedUI: selectedUI$3,
  selectedLightUI: selectedLightUI$3,
  inverseHoverUI: inverseHoverUI$3,
  hoverSelectedUI: hoverSelectedUI$3,
  hoverDanger: hoverDanger$3,
  activeDanger: activeDanger$3,
  hoverRow: hoverRow$3,
  visitedLink: visitedLink$3,
  disabled01: disabled01$3,
  disabled02: disabled02$3,
  disabled03: disabled03$3,
  highlight: highlight$3,
  decorative01: decorative01$3,
  buttonSeparator: buttonSeparator$4,
  skeleton01: skeleton01$3,
  skeleton02: skeleton02$3,
  background: background$4,
  layer: layer$4,
  layerAccent: layerAccent$3,
  layerAccentActive: layerAccentActive$3,
  layerAccentHover: layerAccentHover$3,
  field: field$4,
  backgroundInverse: backgroundInverse$3,
  backgroundBrand: backgroundBrand$3,
  interactive: interactive$3,
  borderSubtle: borderSubtle$3,
  borderStrong: borderStrong$3,
  borderInverse: borderInverse$3,
  borderInteractive: borderInteractive$3,
  textPrimary: textPrimary$3,
  textSecondary: textSecondary$3,
  textPlaceholder: textPlaceholder$3,
  textHelper: textHelper$3,
  textOnColor: textOnColor$3,
  textInverse: textInverse$3,
  linkPrimary: linkPrimary$3,
  linkSecondary: linkSecondary$3,
  linkVisited: linkVisited$3,
  linkInverse: linkInverse$3,
  iconPrimary: iconPrimary$3,
  iconSecondary: iconSecondary$3,
  iconOnColor: iconOnColor$3,
  iconInverse: iconInverse$3,
  supportError: supportError$3,
  supportSuccess: supportSuccess$3,
  supportWarning: supportWarning$3,
  supportInfo: supportInfo$3,
  supportErrorInverse: supportErrorInverse$3,
  supportSuccessInverse: supportSuccessInverse$3,
  supportWarningInverse: supportWarningInverse$3,
  supportInfoInverse: supportInfoInverse$3,
  overlay: overlay$3,
  toggleOff: toggleOff$3,
  shadow: shadow$3,
  buttonPrimary: buttonPrimary$4,
  buttonSecondary: buttonSecondary$4,
  buttonTertiary: buttonTertiary$4,
  buttonDangerPrimary: buttonDangerPrimary$4,
  buttonDangerSecondary: buttonDangerSecondary$4,
  backgroundActive: backgroundActive$3,
  layerActive: layerActive$3,
  buttonDangerActive: buttonDangerActive$4,
  buttonPrimaryActive: buttonPrimaryActive$4,
  buttonSecondaryActive: buttonSecondaryActive$4,
  buttonTertiaryActive: buttonTertiaryActive$4,
  focusInset: focusInset$3,
  focusInverse: focusInverse$3,
  backgroundHover: backgroundHover$3,
  layerHover: layerHover$3,
  fieldHover: fieldHover$3,
  backgroundInverseHover: backgroundInverseHover$3,
  linkPrimaryHover: linkPrimaryHover$3,
  buttonDangerHover: buttonDangerHover$4,
  buttonPrimaryHover: buttonPrimaryHover$4,
  buttonSecondaryHover: buttonSecondaryHover$4,
  buttonTertiaryHover: buttonTertiaryHover$4,
  backgroundSelected: backgroundSelected$3,
  backgroundSelectedHover: backgroundSelectedHover$3,
  layerSelected: layerSelected$3,
  layerSelectedHover: layerSelectedHover$3,
  layerSelectedInverse: layerSelectedInverse$3,
  borderSubtleSelected: borderSubtleSelected$3,
  borderDisabled: borderDisabled$3,
  textDisabled: textDisabled$3,
  buttonDisabled: buttonDisabled$4,
  iconDisabled: iconDisabled$3,
  textOnColorDisabled: textOnColorDisabled$3,
  iconOnColorDisabled: iconOnColorDisabled$3,
  layerSelectedDisabled: layerSelectedDisabled$3,
  skeletonBackground: skeletonBackground$3,
  skeletonElement: skeletonElement$3,
  brand01: brand01$3,
  brand02: brand02$3,
  brand03: brand03$3,
  active01: active01$3,
  hoverField: hoverField$3,
  danger: danger$3
});

var buttonSeparator = {
  fallback: '#e0e0e0',
  whiteTheme: '#e0e0e0',
  g10: '#e0e0e0',
  g90: '#161616',
  g100: '#161616'
};
var buttonPrimary = {
  whiteTheme: '#0f62fe',
  g10: '#0f62fe',
  g90: '#0f62fe',
  g100: '#0f62fe'
};
var buttonSecondary = {
  whiteTheme: '#393939',
  g10: '#393939',
  g90: '#6f6f6f',
  g100: '#6f6f6f'
};
var buttonTertiary = {
  whiteTheme: '#0f62fe',
  g10: '#0f62fe',
  g90: '#ffffff',
  g100: '#ffffff'
};
var buttonDangerPrimary = {
  whiteTheme: '#da1e28',
  g10: '#da1e28',
  g90: '#da1e28',
  g100: '#da1e28'
};
var buttonDangerSecondary = {
  whiteTheme: '#da1e28',
  g10: '#da1e28',
  g90: '#ff8389',
  g100: '#fa4d56'
};
var buttonDangerActive = {
  whiteTheme: '#750e13',
  g10: '#750e13',
  g90: '#750e13',
  g100: '#750e13'
};
var buttonPrimaryActive = {
  whiteTheme: '#002d9c',
  g10: '#002d9c',
  g90: '#002d9c',
  g100: '#002d9c'
};
var buttonSecondaryActive = {
  whiteTheme: '#6f6f6f',
  g10: '#6f6f6f',
  g90: '#393939',
  g100: '#393939'
};
var buttonTertiaryActive = {
  whiteTheme: '#002d9c',
  g10: '#002d9c',
  g90: '#c6c6c6',
  g100: '#c6c6c6'
};
var buttonDangerHover = {
  whiteTheme: '#b81921',
  g10: '#b81921',
  g90: '#b81921',
  g100: '#b81921'
};
var buttonPrimaryHover = {
  whiteTheme: '#0050e6',
  g10: '#0050e6',
  g90: '#0050e6',
  g100: '#0050e6'
};
var buttonSecondaryHover = {
  whiteTheme: '#474747',
  g10: '#474747',
  g90: '#5e5e5e',
  g100: '#5e5e5e'
};
var buttonTertiaryHover = {
  whiteTheme: '#0050e6',
  g10: '#0050e6',
  g90: '#f4f4f4',
  g100: '#f4f4f4'
};
var buttonDisabled = {
  whiteTheme: '#c6c6c6',
  g10: '#c6c6c6',
  g90: 'rgb(141 141 141 / 30%)',
  g100: 'rgb(141 141 141 / 30%)'
};

var tokens$2 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  buttonSeparator: buttonSeparator,
  buttonPrimary: buttonPrimary,
  buttonSecondary: buttonSecondary,
  buttonTertiary: buttonTertiary,
  buttonDangerPrimary: buttonDangerPrimary,
  buttonDangerSecondary: buttonDangerSecondary,
  buttonDangerActive: buttonDangerActive,
  buttonPrimaryActive: buttonPrimaryActive,
  buttonSecondaryActive: buttonSecondaryActive,
  buttonTertiaryActive: buttonTertiaryActive,
  buttonDangerHover: buttonDangerHover,
  buttonPrimaryHover: buttonPrimaryHover,
  buttonSecondaryHover: buttonSecondaryHover,
  buttonTertiaryHover: buttonTertiaryHover,
  buttonDisabled: buttonDisabled
});

var index$2 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  buttonTokens: tokens$2
});

var tagBackgroundRed = {
  whiteTheme: colors$1.red20,
  g10: colors$1.red20,
  g90: colors$1.red70,
  g100: colors$1.red70
};
var tagColorRed = {
  whiteTheme: colors$1.red80,
  g10: colors$1.red80,
  g90: colors$1.red20,
  g100: colors$1.red20
};
var tagHoverRed = {
  whiteTheme: colors$1.red20Hover,
  g10: colors$1.red20Hover,
  g90: colors$1.red70Hover,
  g100: colors$1.red70Hover
};
var tagBackgroundMagenta = {
  whiteTheme: colors$1.magenta20,
  g10: colors$1.magenta20,
  g90: colors$1.magenta70,
  g100: colors$1.magenta70
};
var tagColorMagenta = {
  whiteTheme: colors$1.magenta80,
  g10: colors$1.magenta80,
  g90: colors$1.magenta20,
  g100: colors$1.magenta20
};
var tagHoverMagenta = {
  whiteTheme: colors$1.magenta20Hover,
  g10: colors$1.magenta20Hover,
  g90: colors$1.magenta70Hover,
  g100: colors$1.magenta70Hover
};
var tagBackgroundPurple = {
  whiteTheme: colors$1.purple20,
  g10: colors$1.purple20,
  g90: colors$1.purple70,
  g100: colors$1.purple70
};
var tagColorPurple = {
  whiteTheme: colors$1.purple80,
  g10: colors$1.purple80,
  g90: colors$1.purple20,
  g100: colors$1.purple20
};
var tagHoverPurple = {
  whiteTheme: colors$1.purple20Hover,
  g10: colors$1.purple20Hover,
  g90: colors$1.purple70Hover,
  g100: colors$1.purple70Hover
};
var tagBackgroundBlue = {
  whiteTheme: colors$1.blue20,
  g10: colors$1.blue20,
  g90: colors$1.blue70,
  g100: colors$1.blue70
};
var tagColorBlue = {
  whiteTheme: colors$1.blue80,
  g10: colors$1.blue80,
  g90: colors$1.blue20,
  g100: colors$1.blue20
};
var tagHoverBlue = {
  whiteTheme: colors$1.blue20Hover,
  g10: colors$1.blue20Hover,
  g90: colors$1.blue70Hover,
  g100: colors$1.blue70Hover
};
var tagBackgroundCyan = {
  whiteTheme: colors$1.cyan20,
  g10: colors$1.cyan20,
  g90: colors$1.cyan70,
  g100: colors$1.cyan70
};
var tagColorCyan = {
  whiteTheme: colors$1.cyan80,
  g10: colors$1.cyan80,
  g90: colors$1.cyan20,
  g100: colors$1.cyan20
};
var tagHoverCyan = {
  whiteTheme: colors$1.cyan20Hover,
  g10: colors$1.cyan20Hover,
  g90: colors$1.cyan70Hover,
  g100: colors$1.cyan70Hover
};
var tagBackgroundTeal = {
  whiteTheme: colors$1.teal20,
  g10: colors$1.teal20,
  g90: colors$1.teal70,
  g100: colors$1.teal70
};
var tagColorTeal = {
  whiteTheme: colors$1.teal80,
  g10: colors$1.teal80,
  g90: colors$1.teal20,
  g100: colors$1.teal20
};
var tagHoverTeal = {
  whiteTheme: colors$1.teal20Hover,
  g10: colors$1.teal20Hover,
  g90: colors$1.teal70Hover,
  g100: colors$1.teal70Hover
};
var tagBackgroundGreen = {
  whiteTheme: colors$1.green20,
  g10: colors$1.green20,
  g90: colors$1.green70,
  g100: colors$1.green70
};
var tagColorGreen = {
  whiteTheme: colors$1.green80,
  g10: colors$1.green80,
  g90: colors$1.green20,
  g100: colors$1.green20
};
var tagHoverGreen = {
  whiteTheme: colors$1.green20Hover,
  g10: colors$1.green20Hover,
  g90: colors$1.green70Hover,
  g100: colors$1.green70Hover
};
var tagBackgroundGray = {
  whiteTheme: colors$1.gray20,
  g10: colors$1.gray20,
  g90: colors$1.gray70,
  g100: colors$1.gray70
};
var tagColorGray = {
  whiteTheme: colors$1.gray80,
  g10: colors$1.gray80,
  g90: colors$1.gray20,
  g100: colors$1.gray20
};
var tagHoverGray = {
  whiteTheme: colors$1.gray20Hover,
  g10: colors$1.gray20Hover,
  g90: colors$1.gray70Hover,
  g100: colors$1.gray70Hover
};
var tagBackgroundCoolGray = {
  whiteTheme: colors$1.coolGray20,
  g10: colors$1.coolGray20,
  g90: colors$1.coolGray70,
  g100: colors$1.coolGray70
};
var tagColorCoolGray = {
  whiteTheme: colors$1.coolGray80,
  g10: colors$1.coolGray80,
  g90: colors$1.coolGray20,
  g100: colors$1.coolGray20
};
var tagHoverCoolGray = {
  whiteTheme: colors$1.coolGray20Hover,
  g10: colors$1.coolGray20Hover,
  g90: colors$1.coolGray70Hover,
  g100: colors$1.coolGray70Hover
};
var tagBackgroundWarmGray = {
  whiteTheme: colors$1.warmGray20,
  g10: colors$1.warmGray20,
  g90: colors$1.warmGray70,
  g100: colors$1.warmGray70
};
var tagColorWarmGray = {
  whiteTheme: colors$1.warmGray80,
  g10: colors$1.warmGray80,
  g90: colors$1.warmGray20,
  g100: colors$1.warmGray20
};
var tagHoverWarmGray = {
  whiteTheme: colors$1.warmGray20Hover,
  g10: colors$1.warmGray20Hover,
  g90: colors$1.warmGray70Hover,
  g100: colors$1.warmGray70Hover
};

var tokens$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  tagBackgroundRed: tagBackgroundRed,
  tagColorRed: tagColorRed,
  tagHoverRed: tagHoverRed,
  tagBackgroundMagenta: tagBackgroundMagenta,
  tagColorMagenta: tagColorMagenta,
  tagHoverMagenta: tagHoverMagenta,
  tagBackgroundPurple: tagBackgroundPurple,
  tagColorPurple: tagColorPurple,
  tagHoverPurple: tagHoverPurple,
  tagBackgroundBlue: tagBackgroundBlue,
  tagColorBlue: tagColorBlue,
  tagHoverBlue: tagHoverBlue,
  tagBackgroundCyan: tagBackgroundCyan,
  tagColorCyan: tagColorCyan,
  tagHoverCyan: tagHoverCyan,
  tagBackgroundTeal: tagBackgroundTeal,
  tagColorTeal: tagColorTeal,
  tagHoverTeal: tagHoverTeal,
  tagBackgroundGreen: tagBackgroundGreen,
  tagColorGreen: tagColorGreen,
  tagHoverGreen: tagHoverGreen,
  tagBackgroundGray: tagBackgroundGray,
  tagColorGray: tagColorGray,
  tagHoverGray: tagHoverGray,
  tagBackgroundCoolGray: tagBackgroundCoolGray,
  tagColorCoolGray: tagColorCoolGray,
  tagHoverCoolGray: tagHoverCoolGray,
  tagBackgroundWarmGray: tagBackgroundWarmGray,
  tagColorWarmGray: tagColorWarmGray,
  tagHoverWarmGray: tagHoverWarmGray
});

var index$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  tagTokens: tokens$1
});

var notificationBackgroundError = {
  whiteTheme: colors$1.red10,
  g10: colors$1.red10,
  g90: colors$1.gray80,
  g100: colors$1.gray90
};
var notificationBackgroundSuccess = {
  whiteTheme: colors$1.green10,
  g10: colors$1.green10,
  g90: colors$1.gray80,
  g100: colors$1.gray90
};
var notificationBackgroundInfo = {
  whiteTheme: colors$1.blue10,
  g10: colors$1.blue10,
  g90: colors$1.gray80,
  g100: colors$1.gray90
};
var colorMap = {
  yellow30: colors$1.yellow30,
  white0: colors$1.white0
};
var notificationBackgroundWarning = {
  whiteTheme: colorMap,
  g10: colorMap,
  g90: colors$1.gray80,
  g100: colors$1.gray90
};
var notificationActionHover = {
  whiteTheme: colors$1.white0,
  g10: colors$1.white0
};
var notificationActionTertiaryInverse = {
  whiteTheme: buttonTertiary.g100,
  g10: buttonTertiary.g90,
  g90: buttonTertiary.g10,
  g100: buttonTertiary.whiteTheme
};
var notificationActionTertiaryInverseActive = {
  whiteTheme: buttonTertiaryActive.g100,
  g10: buttonTertiaryActive.g90,
  g90: buttonTertiaryActive.g10,
  g100: buttonTertiaryActive.whiteTheme
};
var notificationActionTertiaryInverseHover = {
  whiteTheme: buttonTertiaryHover.g100,
  g10: buttonTertiaryHover.g90,
  g90: buttonTertiaryHover.g10,
  g100: buttonTertiaryHover.whiteTheme
};
var notificationActionTertiaryInverseText = {
  whiteTheme: textInverse$4,
  g10: textInverse$5,
  g90: textInverse$6,
  g100: textInverse$7
};
var notificationActionTertiaryInverseTextOnColorDisabled = {
  whiteTheme: textOnColorDisabled$4,
  g10: textOnColorDisabled$5,
  g90: textOnColorDisabled$6,
  g100: textOnColorDisabled$7
};

var tokens = /*#__PURE__*/Object.freeze({
  __proto__: null,
  notificationBackgroundError: notificationBackgroundError,
  notificationBackgroundSuccess: notificationBackgroundSuccess,
  notificationBackgroundInfo: notificationBackgroundInfo,
  colorMap: colorMap,
  notificationBackgroundWarning: notificationBackgroundWarning,
  notificationActionHover: notificationActionHover,
  notificationActionTertiaryInverse: notificationActionTertiaryInverse,
  notificationActionTertiaryInverseActive: notificationActionTertiaryInverseActive,
  notificationActionTertiaryInverseHover: notificationActionTertiaryInverseHover,
  notificationActionTertiaryInverseText: notificationActionTertiaryInverseText,
  notificationActionTertiaryInverseTextOnColorDisabled: notificationActionTertiaryInverseTextOnColorDisabled
});

var index = /*#__PURE__*/Object.freeze({
  __proto__: null,
  notificationTokens: tokens
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * A Token is the simplest unit in our theme. It can have a name, properties
 * that it applies to like border or background, along with a state if the
 * token should only be used for specific states like hover or focus.
 */
var Token = /*#__PURE__*/function () {
  function Token(name, properties, state) {
    _classCallCheck(this, Token);
    this.kind = 'Token';
    this.name = name;
    if (properties) {
      this.properties = properties;
    }
    if (state) {
      this.state = state;
    }
  }
  _createClass(Token, null, [{
    key: "create",
    value: function create(token) {
      if (typeof token === 'string') {
        return new Token(token);
      }
      return new Token(token.name, token.properties, token.state);
    }
  }]);
  return Token;
}();

/**
 * A TokenGroup allows us to group up a collection of tokens and nested token
 * groups. A group allows us to colocate related tokens and write information
 * once that applies to the entire collection of tokens. For example, if all the
 * tokens apply to the `border` color property then we can specify this property
 * at the group level
 *
 * A TokenGroup allows us to colocate all this information while also providing
 * ways to get information about the entire group, including properties and
 * states
 */
var TokenGroup = /*#__PURE__*/function (_Symbol$iterator) {
  function TokenGroup(name, tokens, properties) {
    _classCallCheck(this, TokenGroup);
    this.kind = 'TokenGroup';
    this.name = name;
    if (properties) {
      this.properties = properties;
    }
    this.children = tokens.map(function (child) {
      if (child.kind === 'TokenGroup') {
        return child;
      }
      return Token.create(child);
    });
  }
  _createClass(TokenGroup, [{
    key: _Symbol$iterator,
    value: /*#__PURE__*/_regeneratorRuntime().mark(function value() {
      var _iterator, _step, child;
      return _regeneratorRuntime().wrap(function value$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return this;
          case 2:
            _iterator = _createForOfIteratorHelper(this.children);
            _context.prev = 3;
            _iterator.s();
          case 5:
            if ((_step = _iterator.n()).done) {
              _context.next = 13;
              break;
            }
            child = _step.value;
            _context.next = 9;
            return child;
          case 9:
            if (!(child.kind === 'TokenGroup')) {
              _context.next = 11;
              break;
            }
            return _context.delegateYield(child, "t0", 11);
          case 11:
            _context.next = 5;
            break;
          case 13:
            _context.next = 18;
            break;
          case 15:
            _context.prev = 15;
            _context.t1 = _context["catch"](3);
            _iterator.e(_context.t1);
          case 18:
            _context.prev = 18;
            _iterator.f();
            return _context.finish(18);
          case 21:
          case "end":
            return _context.stop();
        }
      }, value, this, [[3, 15, 18, 21]]);
    })
    /**
     * Get all the tokens available in every Token Group in this TokenGroup,
     * including itself.
     * @returns {Array<Token>}
     */
  }, {
    key: "getTokens",
    value: function getTokens() {
      var parentContext = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var context = _objectSpread2(_objectSpread2({}, parentContext), {}, {
        groups: parentContext.groups ? parentContext.groups.concat(this) : [this],
        properties: this.properties || parentContext.properties
      });
      return this.children.flatMap(function (child) {
        if (child.kind === 'TokenGroup') {
          return child.getTokens(context);
        }
        var token = _objectSpread2(_objectSpread2({}, context), {}, {
          name: child.name,
          properties: child.properties || context.properties
        });
        if (child.state) {
          token.state = child.state;
        }
        return token;
      });
    }

    /**
     * Get a specific token from the TokenGroup, or form one of its nested
     * TokenGroups
     * @returns {Token}
     */
  }, {
    key: "getToken",
    value: function getToken(tokenOrName) {
      var name = typeof tokenOrName === 'string' ? tokenOrName : tokenOrName.name;
      var _iterator2 = _createForOfIteratorHelper(this),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var child = _step2.value;
          if (child.kind === 'TokenGroup') {
            continue;
          }
          if (child.name === name) {
            return child;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return null;
    }

    /**
     * Get all the unique groups in the token group, including this group
     * @returns {Array<TokenGroup>}
     */
  }, {
    key: "getTokenGroups",
    value: function getTokenGroups() {
      var set = new Set();
      var _iterator3 = _createForOfIteratorHelper(this),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var child = _step3.value;
          if (child.kind !== 'TokenGroup') {
            continue;
          }
          set.add(child);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return Array.from(set);
    }

    /**
     * Get all the unique properties in the token group, including this group
     * @returns {Array<string>}
     */
  }, {
    key: "getTokenProperties",
    value: function getTokenProperties() {
      var set = new Set();
      var _iterator4 = _createForOfIteratorHelper(this),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var child = _step4.value;
          if (!Array.isArray(child.properties)) {
            continue;
          }
          var _iterator5 = _createForOfIteratorHelper(child.properties),
            _step5;
          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var property = _step5.value;
              set.add(property);
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      return Array.from(set);
    }

    /**
     * Get all the unique states in the token group, including this group
     * @returns {Array<string>}
     */
  }, {
    key: "getTokenStates",
    value: function getTokenStates() {
      var set = new Set();
      var _iterator6 = _createForOfIteratorHelper(this),
        _step6;
      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var child = _step6.value;
          if (child.kind !== 'Token') {
            continue;
          }
          if (child.state) {
            set.add(child.state);
          }
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
      return Array.from(set);
    }
  }], [{
    key: "create",
    value: function create(_ref) {
      var name = _ref.name,
        properties = _ref.properties,
        _ref$tokens = _ref.tokens,
        tokens = _ref$tokens === void 0 ? [] : _ref$tokens;
      return new TokenGroup(name, tokens, properties);
    }
  }]);
  return TokenGroup;
}(Symbol.iterator);

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var background = TokenGroup.create({
  name: 'Background',
  properties: ['background'],
  tokens: ['background', {
    name: 'background-active',
    state: 'active'
  }, {
    name: 'background-selected',
    state: 'selected'
  }, {
    name: 'background-selected-hover',
    state: 'hover'
  }, {
    name: 'background-hover',
    state: 'hover'
  }, 'background-brand', 'background-inverse', {
    state: 'hover',
    name: 'background-inverse-hover'
  }]
});
var layer = TokenGroup.create({
  name: 'Layer',
  properties: ['background'],
  tokens: [{
    name: 'layer-01'
  }, {
    state: 'active',
    name: 'layer-active-01'
  }, {
    state: 'hover',
    name: 'layer-hover-01'
  }, {
    state: 'selected',
    name: 'layer-selected-01'
  }, {
    state: 'hover',
    name: 'layer-selected-hover-01'
  }, {
    name: 'layer-02'
  }, {
    state: 'active',
    name: 'layer-active-02'
  }, {
    state: 'hover',
    name: 'layer-hover-02'
  }, {
    state: 'selected',
    name: 'layer-selected-02'
  }, {
    state: 'hover',
    name: 'layer-selected-hover-02'
  }, {
    name: 'layer-03'
  }, {
    state: 'active',
    name: 'layer-active-03'
  }, {
    state: 'hover',
    name: 'layer-hover-03'
  }, {
    state: 'selected',
    name: 'layer-selected-03'
  }, {
    state: 'hover',
    name: 'layer-selected-hover-03'
  }, {
    name: 'layer-selected-inverse'
  }, {
    state: 'disabled',
    name: 'layer-selected-disabled'
  }, {
    name: 'layer-accent-01'
  }, {
    state: 'active',
    name: 'layer-accent-active-01'
  }, {
    state: 'hover',
    name: 'layer-accent-hover-01'
  }, {
    name: 'layer-accent-02'
  }, {
    state: 'active',
    name: 'layer-accent-active-02'
  }, {
    state: 'hover',
    name: 'layer-accent-hover-02'
  }, {
    name: 'layer-accent-03'
  }, {
    state: 'active',
    name: 'layer-accent-active-03'
  }, {
    state: 'hover',
    name: 'layer-accent-hover-03'
  }]
});
var field = TokenGroup.create({
  name: 'Field',
  properties: ['background'],
  tokens: [{
    name: 'field-01'
  }, {
    state: 'hover',
    name: 'field-hover-01'
  }, {
    name: 'field-02'
  }, {
    state: 'hover',
    name: 'field-hover-02'
  }, {
    name: 'field-03'
  }, {
    state: 'hover',
    name: 'field-hover-03'
  }]
});
var border = TokenGroup.create({
  name: 'Borders',
  properties: ['border'],
  tokens: [{
    name: 'border-subtle-00'
  }, {
    name: 'border-subtle-01'
  }, {
    state: 'selected',
    name: 'border-subtle-selected-01'
  }, {
    name: 'border-subtle-02'
  }, {
    state: 'selected',
    name: 'border-subtle-selected-02'
  }, {
    name: 'border-subtle-03'
  }, {
    state: 'selected',
    name: 'border-subtle-selected-03'
  },
  // Border strong
  'border-strong-01', 'border-strong-02', 'border-strong-03',
  // Border tile
  'border-tile-01', 'border-tile-02', 'border-tile-03',
  // Border inverse
  'border-inverse',
  // Border interactive
  'border-interactive', {
    state: 'disabled',
    name: 'border-disabled'
  }]
});
var text = TokenGroup.create({
  name: 'Text',
  properties: ['text'],
  tokens: ['text-primary', 'text-secondary', 'text-placeholder', 'text-helper', 'text-error', 'text-inverse', {
    name: 'text-on-color'
  }, {
    state: 'disabled',
    name: 'text-on-color-disabled'
  }, {
    state: 'disabled',
    name: 'text-disabled'
  }]
});
var link = TokenGroup.create({
  name: 'Link',
  properties: ['text'],
  tokens: [{
    name: 'link-primary'
  }, {
    state: 'hover',
    name: 'link-primary-hover'
  }, 'link-secondary', {
    state: 'visited',
    name: 'link-visited'
  }, 'link-inverse', 'link-inverse-active', 'link-inverse-hover']
});
var icon = TokenGroup.create({
  name: 'Icons',
  properties: ['background', 'fill', 'stroke'],
  tokens: ['icon-primary', 'icon-secondary', 'icon-inverse', {
    name: 'icon-on-color'
  }, {
    state: 'disabled',
    name: 'icon-on-color-disabled'
  }, {
    state: 'disabled',
    name: 'icon-disabled'
  }, 'icon-interactive']
});
var support = TokenGroup.create({
  name: 'Support',
  properties: ['background', 'fill', 'stroke'],
  tokens: ['support-error', 'support-success', 'support-warning', 'support-info', 'support-error-inverse', 'support-success-inverse', 'support-warning-inverse', 'support-info-inverse', 'support-caution-major', 'support-caution-minor', 'support-caution-undefined']
});
var focus = TokenGroup.create({
  name: 'Focus',
  properties: ['border'],
  tokens: ['focus', 'focus-inset', 'focus-inverse']
});
var skeleton = TokenGroup.create({
  name: 'Skeleton',
  properties: ['background'],
  tokens: ['skeleton-background', 'skeleton-element']
});
var contextual = TokenGroup.create({
  name: 'Contextual',
  properties: [],
  tokens: ['layer', 'layer-active', 'layer-hover', 'layer-selected', 'layer-selected-hover', 'layer-accent', 'layer-accent-hover', 'layer-accent-active', 'field', 'field-hover', 'border-subtle', 'border-subtle-selected', 'border-strong', 'border-tile']
});
var ai = TokenGroup.create({
  name: 'AI',
  properties: ['background'],
  tokens: ['slug-background', 'slug-gradient', 'slug-background-hover', 'slug-gradient-hover', 'slug-hollow-hover', 'slug-callout-gradient-top', 'slug-callout-gradient-bottom', 'slug-callout-aura-start', 'slug-callout-aura-end', 'ai-gradient-start-01', 'ai-gradient-start-02', 'ai-gradient-end']
});
var group = TokenGroup.create({
  name: 'All',
  tokens: [background, layer, field,
  // Interactive
  {
    name: 'interactive',
    properties: ['background', 'text']
  }, border, text, link, icon, support, ai,
  // Misc
  {
    name: 'highlight'
  }, {
    name: 'overlay',
    properties: ['background']
  }, {
    name: 'toggle-off'
  }, {
    name: 'shadow'
  }, focus, skeleton]
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var button = TokenGroup.create({
  name: 'Button',
  properties: [],
  tokens: ['button-separator', 'button-primary', 'button-secondary', 'button-tertiary', 'button-danger-primary', 'button-danger-secondary', 'button-danger-active', 'button-primary-active', 'button-secondary-active', 'button-tertiary-active', 'button-danger-hover', 'button-primary-hover', 'button-secondary-hover', 'button-tertiary-hover', 'button-disabled']
});
var notification = TokenGroup.create({
  name: 'Notification',
  properties: [],
  tokens: ['notification-background-error', 'notification-background-success', 'notification-background-info', 'notification-background-warning', 'notification-action-hover', 'notification-action-tertiary-inverse', 'notification-action-tertiary-inverse-active', 'notification-action-tertiary-inverse-hover', 'notification-action-tertiary-inverse-text', 'notification-action-tertiary-inverse-text-on-color-disabled']
});
var tag = TokenGroup.create({
  name: 'Tag',
  properties: [],
  tokens: ['tag-background-red', 'tag-color-red', 'tag-hover-red', 'tag-background-magenta', 'tag-color-magenta', 'tag-hover-magenta', 'tag-background-purple', 'tag-color-purple', 'tag-hover-purple', 'tag-background-blue', 'tag-color-blue', 'tag-hover-blue', 'tag-background-cyan', 'tag-color-cyan', 'tag-hover-cyan', 'tag-background-teal', 'tag-color-teal', 'tag-hover-teal', 'tag-background-green', 'tag-color-green', 'tag-hover-green', 'tag-background-gray', 'tag-color-gray', 'tag-hover-gray', 'tag-background-cool-gray', 'tag-color-cool-gray', 'tag-hover-cool-gray', 'tag-background-warm-gray', 'tag-color-warm-gray', 'tag-hover-warm-gray']
});

var components = /*#__PURE__*/Object.freeze({
  __proto__: null,
  button: button,
  notification: notification,
  tag: tag
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var type$1 = TokenGroup.create({
  name: 'Type',
  properties: [],
  tokens: ['caption-01', 'caption-02', 'label-01', 'label-02', 'helper-text-01', 'helper-text-02', 'body-short-01', 'body-long-01', 'body-short-02', 'body-long-02', 'code-01', 'code-02', 'heading-01', 'productive-heading-01', 'heading-02', 'productive-Heading-02', 'productive-heading-03', 'productive-heading-04', 'productive-heading-05', 'productive-heading-06', 'productive-heading-07', 'expressive-heading-01', 'expressive-heading-02', 'expressive-heading-03', 'expressive-heading-04', 'expressive-heading-05', 'expressive-heading-06', 'expressive-paragraph-01', 'quotation-01', 'quotation-02', 'display-01', 'display-02', 'display-03', 'display-04']
});

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var layout$1 = TokenGroup.create({
  name: 'Layout',
  properties: [],
  tokens: ['spacing-01', 'spacing-02', 'spacing-03', 'spacing-04', 'spacing-05', 'spacing-06', 'spacing-07', 'spacing-08', 'spacing-09', 'spacing-10', 'spacing-11', 'spacing-12', 'spacing-13', 'fluid-spacing-01', 'fluid-spacing-02', 'fluid-spacing-03', 'fluid-spacing-04', 'container-01', 'container-02', 'container-03', 'container-04', 'container-05', 'icon-size-01', 'icon-size-02']
});

var color = TokenGroup.create({
  name: 'Color',
  properties: [],
  tokens: ['interactive-01', 'interactive-02', 'interactive-03', 'interactive-04', 'ui-background', 'ui-01', 'ui-02', 'ui-03', 'ui-04', 'ui-05', 'text-01', 'text-02', 'text-03', 'text-04', 'text-05', 'text-error', 'icon-01', 'icon-02', 'icon-03', 'link-01', 'link-02', 'inverse-link', 'field-01', 'field-02', 'inverse-01', 'inverse-02', 'support-01', 'support-02', 'support-03', 'support-04', 'inverse-support-01', 'inverse-support-02', 'inverse-support-03', 'inverse-support-04', 'overlay-01', 'danger-01', 'danger-02', 'focus', 'inverse-focus-ui', 'hover-primary', 'active-primary', 'hover-primary-text', 'hover-secondary', 'active-secondary', 'hover-tertiary', 'active-tertiary', 'hover-ui', 'hover-light-ui', 'hover-selected-ui', 'active-ui', 'active-light-ui', 'selected-ui', 'selected-light-ui', 'inverse-hover-ui', 'hover-danger', 'active-danger', 'hover-row', 'visited-link', 'disabled-01', 'disabled-02', 'disabled-03', 'highlight', 'decorative-01', 'button-separator', 'skeleton-01', 'skeleton-02',
  // deprecated
  'brand-01', 'brand-02', 'brand-03', 'active-01', 'hover-field', 'danger']
});
var type = TokenGroup.create({
  name: 'Type',
  properties: [],
  tokens: ['caption-01', 'caption-02', 'label-01', 'label-02', 'helper-text-01', 'helper-text-02', 'body-short-01', 'body-long-01', 'body-short-02', 'body-long-02', 'code-01', 'code-02', 'heading-01', 'productive-heading-01', 'heading-02', 'productive-Heading-02', 'productive-heading-03', 'productive-heading-04', 'productive-heading-05', 'productive-heading-06', 'productive-heading-07', 'expressive-heading-01', 'expressive-heading-02', 'expressive-heading-03', 'expressive-heading-04', 'expressive-heading-05', 'expressive-heading-06', 'expressive-paragraph-01', 'quotation-01', 'quotation-02', 'display-01', 'display-02', 'display-03', 'display-04']
});
var layout = TokenGroup.create({
  name: 'Layout',
  properties: [],
  tokens: ['spacing-01', 'spacing-02', 'spacing-03', 'spacing-04', 'spacing-05', 'spacing-06', 'spacing-07', 'spacing-08', 'spacing-09', 'spacing-10', 'spacing-11', 'spacing-12', 'spacing-13', 'layout-01', 'layout-02', 'layout-03', 'layout-04', 'layout-05', 'layout-06', 'layout-07', 'fluid-spacing-01', 'fluid-spacing-02', 'fluid-spacing-03', 'fluid-spacing-04', 'container-01', 'container-02', 'container-03', 'container-04', 'container-05', 'icon-size-01', 'icon-size-02']
});
var v10 = [].concat(_toConsumableArray(color.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'color'
  };
})), _toConsumableArray(type.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'type'
  };
})), _toConsumableArray(layout.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'layout'
  };
})));

var v11 = [].concat(_toConsumableArray(group.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'color'
  };
})), _toConsumableArray(contextual.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'color'
  };
})), _toConsumableArray(Object.values(components).flatMap(function (group) {
  return group.getTokens().map(function (token) {
    return {
      name: token.name,
      type: 'color'
    };
  });
})), _toConsumableArray(type$1.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'type'
  };
})), _toConsumableArray(layout$1.getTokens().map(function (token) {
  return {
    name: token.name,
    type: 'layout'
  };
})));
var unstable_metadata = {
  v11: v11,
  v10: v10
};

/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var themes = {
  white: white$1,
  g10: g10$1,
  g90: g90$1,
  g100: g100$1
};

Object.defineProperty(exports, 'bodyLong01', {
  enumerable: true,
  get: function () { return type$2.bodyLong01; }
});
Object.defineProperty(exports, 'bodyLong02', {
  enumerable: true,
  get: function () { return type$2.bodyLong02; }
});
Object.defineProperty(exports, 'bodyShort01', {
  enumerable: true,
  get: function () { return type$2.bodyShort01; }
});
Object.defineProperty(exports, 'bodyShort02', {
  enumerable: true,
  get: function () { return type$2.bodyShort02; }
});
Object.defineProperty(exports, 'caption01', {
  enumerable: true,
  get: function () { return type$2.caption01; }
});
Object.defineProperty(exports, 'caption02', {
  enumerable: true,
  get: function () { return type$2.caption02; }
});
Object.defineProperty(exports, 'code01', {
  enumerable: true,
  get: function () { return type$2.code01; }
});
Object.defineProperty(exports, 'code02', {
  enumerable: true,
  get: function () { return type$2.code02; }
});
Object.defineProperty(exports, 'display01', {
  enumerable: true,
  get: function () { return type$2.display01; }
});
Object.defineProperty(exports, 'display02', {
  enumerable: true,
  get: function () { return type$2.display02; }
});
Object.defineProperty(exports, 'display03', {
  enumerable: true,
  get: function () { return type$2.display03; }
});
Object.defineProperty(exports, 'display04', {
  enumerable: true,
  get: function () { return type$2.display04; }
});
Object.defineProperty(exports, 'expressiveHeading01', {
  enumerable: true,
  get: function () { return type$2.expressiveHeading01; }
});
Object.defineProperty(exports, 'expressiveHeading02', {
  enumerable: true,
  get: function () { return type$2.expressiveHeading02; }
});
Object.defineProperty(exports, 'expressiveHeading03', {
  enumerable: true,
  get: function () { return type$2.expressiveHeading03; }
});
Object.defineProperty(exports, 'expressiveHeading04', {
  enumerable: true,
  get: function () { return type$2.expressiveHeading04; }
});
Object.defineProperty(exports, 'expressiveHeading05', {
  enumerable: true,
  get: function () { return type$2.expressiveHeading05; }
});
Object.defineProperty(exports, 'expressiveHeading06', {
  enumerable: true,
  get: function () { return type$2.expressiveHeading06; }
});
Object.defineProperty(exports, 'expressiveParagraph01', {
  enumerable: true,
  get: function () { return type$2.expressiveParagraph01; }
});
Object.defineProperty(exports, 'heading01', {
  enumerable: true,
  get: function () { return type$2.heading01; }
});
Object.defineProperty(exports, 'heading02', {
  enumerable: true,
  get: function () { return type$2.heading02; }
});
Object.defineProperty(exports, 'helperText01', {
  enumerable: true,
  get: function () { return type$2.helperText01; }
});
Object.defineProperty(exports, 'helperText02', {
  enumerable: true,
  get: function () { return type$2.helperText02; }
});
Object.defineProperty(exports, 'label01', {
  enumerable: true,
  get: function () { return type$2.label01; }
});
Object.defineProperty(exports, 'label02', {
  enumerable: true,
  get: function () { return type$2.label02; }
});
Object.defineProperty(exports, 'productiveHeading01', {
  enumerable: true,
  get: function () { return type$2.productiveHeading01; }
});
Object.defineProperty(exports, 'productiveHeading02', {
  enumerable: true,
  get: function () { return type$2.productiveHeading02; }
});
Object.defineProperty(exports, 'productiveHeading03', {
  enumerable: true,
  get: function () { return type$2.productiveHeading03; }
});
Object.defineProperty(exports, 'productiveHeading04', {
  enumerable: true,
  get: function () { return type$2.productiveHeading04; }
});
Object.defineProperty(exports, 'productiveHeading05', {
  enumerable: true,
  get: function () { return type$2.productiveHeading05; }
});
Object.defineProperty(exports, 'productiveHeading06', {
  enumerable: true,
  get: function () { return type$2.productiveHeading06; }
});
Object.defineProperty(exports, 'productiveHeading07', {
  enumerable: true,
  get: function () { return type$2.productiveHeading07; }
});
Object.defineProperty(exports, 'quotation01', {
  enumerable: true,
  get: function () { return type$2.quotation01; }
});
Object.defineProperty(exports, 'quotation02', {
  enumerable: true,
  get: function () { return type$2.quotation02; }
});
Object.defineProperty(exports, 'container01', {
  enumerable: true,
  get: function () { return layout$2.container01; }
});
Object.defineProperty(exports, 'container02', {
  enumerable: true,
  get: function () { return layout$2.container02; }
});
Object.defineProperty(exports, 'container03', {
  enumerable: true,
  get: function () { return layout$2.container03; }
});
Object.defineProperty(exports, 'container04', {
  enumerable: true,
  get: function () { return layout$2.container04; }
});
Object.defineProperty(exports, 'container05', {
  enumerable: true,
  get: function () { return layout$2.container05; }
});
Object.defineProperty(exports, 'fluidSpacing01', {
  enumerable: true,
  get: function () { return layout$2.fluidSpacing01; }
});
Object.defineProperty(exports, 'fluidSpacing02', {
  enumerable: true,
  get: function () { return layout$2.fluidSpacing02; }
});
Object.defineProperty(exports, 'fluidSpacing03', {
  enumerable: true,
  get: function () { return layout$2.fluidSpacing03; }
});
Object.defineProperty(exports, 'fluidSpacing04', {
  enumerable: true,
  get: function () { return layout$2.fluidSpacing04; }
});
Object.defineProperty(exports, 'iconSize01', {
  enumerable: true,
  get: function () { return layout$2.iconSize01; }
});
Object.defineProperty(exports, 'iconSize02', {
  enumerable: true,
  get: function () { return layout$2.iconSize02; }
});
Object.defineProperty(exports, 'layout01', {
  enumerable: true,
  get: function () { return layout$2.layout01; }
});
Object.defineProperty(exports, 'layout02', {
  enumerable: true,
  get: function () { return layout$2.layout02; }
});
Object.defineProperty(exports, 'layout03', {
  enumerable: true,
  get: function () { return layout$2.layout03; }
});
Object.defineProperty(exports, 'layout04', {
  enumerable: true,
  get: function () { return layout$2.layout04; }
});
Object.defineProperty(exports, 'layout05', {
  enumerable: true,
  get: function () { return layout$2.layout05; }
});
Object.defineProperty(exports, 'layout06', {
  enumerable: true,
  get: function () { return layout$2.layout06; }
});
Object.defineProperty(exports, 'layout07', {
  enumerable: true,
  get: function () { return layout$2.layout07; }
});
Object.defineProperty(exports, 'size2XLarge', {
  enumerable: true,
  get: function () { return layout$2.size2XLarge; }
});
Object.defineProperty(exports, 'sizeLarge', {
  enumerable: true,
  get: function () { return layout$2.sizeLarge; }
});
Object.defineProperty(exports, 'sizeMedium', {
  enumerable: true,
  get: function () { return layout$2.sizeMedium; }
});
Object.defineProperty(exports, 'sizeSmall', {
  enumerable: true,
  get: function () { return layout$2.sizeSmall; }
});
Object.defineProperty(exports, 'sizeXLarge', {
  enumerable: true,
  get: function () { return layout$2.sizeXLarge; }
});
Object.defineProperty(exports, 'sizeXSmall', {
  enumerable: true,
  get: function () { return layout$2.sizeXSmall; }
});
Object.defineProperty(exports, 'spacing01', {
  enumerable: true,
  get: function () { return layout$2.spacing01; }
});
Object.defineProperty(exports, 'spacing02', {
  enumerable: true,
  get: function () { return layout$2.spacing02; }
});
Object.defineProperty(exports, 'spacing03', {
  enumerable: true,
  get: function () { return layout$2.spacing03; }
});
Object.defineProperty(exports, 'spacing04', {
  enumerable: true,
  get: function () { return layout$2.spacing04; }
});
Object.defineProperty(exports, 'spacing05', {
  enumerable: true,
  get: function () { return layout$2.spacing05; }
});
Object.defineProperty(exports, 'spacing06', {
  enumerable: true,
  get: function () { return layout$2.spacing06; }
});
Object.defineProperty(exports, 'spacing07', {
  enumerable: true,
  get: function () { return layout$2.spacing07; }
});
Object.defineProperty(exports, 'spacing08', {
  enumerable: true,
  get: function () { return layout$2.spacing08; }
});
Object.defineProperty(exports, 'spacing09', {
  enumerable: true,
  get: function () { return layout$2.spacing09; }
});
Object.defineProperty(exports, 'spacing10', {
  enumerable: true,
  get: function () { return layout$2.spacing10; }
});
Object.defineProperty(exports, 'spacing11', {
  enumerable: true,
  get: function () { return layout$2.spacing11; }
});
Object.defineProperty(exports, 'spacing12', {
  enumerable: true,
  get: function () { return layout$2.spacing12; }
});
Object.defineProperty(exports, 'spacing13', {
  enumerable: true,
  get: function () { return layout$2.spacing13; }
});
exports.aiGradientEnd = aiGradientEnd$3;
exports.aiGradientStart01 = aiGradientStart01$3;
exports.aiGradientStart02 = aiGradientStart02$3;
exports.background = background$8;
exports.backgroundActive = backgroundActive$7;
exports.backgroundBrand = backgroundBrand$7;
exports.backgroundHover = backgroundHover$7;
exports.backgroundInverse = backgroundInverse$7;
exports.backgroundInverseHover = backgroundInverseHover$7;
exports.backgroundSelected = backgroundSelected$7;
exports.backgroundSelectedHover = backgroundSelectedHover$7;
exports.borderDisabled = borderDisabled$7;
exports.borderInteractive = borderInteractive$7;
exports.borderInverse = borderInverse$7;
exports.borderStrong01 = borderStrong01$3;
exports.borderStrong02 = borderStrong02$3;
exports.borderStrong03 = borderStrong03$3;
exports.borderSubtle00 = borderSubtle00$3;
exports.borderSubtle01 = borderSubtle01$3;
exports.borderSubtle02 = borderSubtle02$3;
exports.borderSubtle03 = borderSubtle03$3;
exports.borderSubtleSelected01 = borderSubtleSelected01$3;
exports.borderSubtleSelected02 = borderSubtleSelected02$3;
exports.borderSubtleSelected03 = borderSubtleSelected03$3;
exports.borderTile01 = borderTile01$3;
exports.borderTile02 = borderTile02$3;
exports.borderTile03 = borderTile03$3;
exports.buttonTokens = index$2;
exports.field01 = field01$7;
exports.field02 = field02$7;
exports.field03 = field03$3;
exports.fieldHover01 = fieldHover01$3;
exports.fieldHover02 = fieldHover02$3;
exports.fieldHover03 = fieldHover03$3;
exports.focus = focus$8;
exports.focusInset = focusInset$7;
exports.focusInverse = focusInverse$7;
exports.formatTokenName = formatTokenName;
exports.g10 = g10$1;
exports.g100 = g100$1;
exports.g90 = g90$1;
exports.highlight = highlight$7;
exports.iconDisabled = iconDisabled$7;
exports.iconInteractive = iconInteractive$3;
exports.iconInverse = iconInverse$7;
exports.iconOnColor = iconOnColor$7;
exports.iconOnColorDisabled = iconOnColorDisabled$7;
exports.iconPrimary = iconPrimary$7;
exports.iconSecondary = iconSecondary$7;
exports.interactive = interactive$7;
exports.layer01 = layer01$3;
exports.layer02 = layer02$3;
exports.layer03 = layer03$3;
exports.layerAccent01 = layerAccent01$3;
exports.layerAccent02 = layerAccent02$3;
exports.layerAccent03 = layerAccent03$3;
exports.layerAccentActive01 = layerAccentActive01$3;
exports.layerAccentActive02 = layerAccentActive02$3;
exports.layerAccentActive03 = layerAccentActive03$3;
exports.layerAccentHover01 = layerAccentHover01$3;
exports.layerAccentHover02 = layerAccentHover02$3;
exports.layerAccentHover03 = layerAccentHover03$3;
exports.layerActive01 = layerActive01$3;
exports.layerActive02 = layerActive02$3;
exports.layerActive03 = layerActive03$3;
exports.layerHover01 = layerHover01$3;
exports.layerHover02 = layerHover02$3;
exports.layerHover03 = layerHover03$3;
exports.layerSelected01 = layerSelected01$3;
exports.layerSelected02 = layerSelected02$3;
exports.layerSelected03 = layerSelected03$3;
exports.layerSelectedDisabled = layerSelectedDisabled$7;
exports.layerSelectedHover01 = layerSelectedHover01$3;
exports.layerSelectedHover02 = layerSelectedHover02$3;
exports.layerSelectedHover03 = layerSelectedHover03$3;
exports.layerSelectedInverse = layerSelectedInverse$7;
exports.linkInverse = linkInverse$7;
exports.linkInverseActive = linkInverseActive$3;
exports.linkInverseHover = linkInverseHover$3;
exports.linkPrimary = linkPrimary$7;
exports.linkPrimaryHover = linkPrimaryHover$7;
exports.linkSecondary = linkSecondary$7;
exports.linkVisited = linkVisited$7;
exports.notificationTokens = index;
exports.overlay = overlay$7;
exports.shadow = shadow$7;
exports.skeletonBackground = skeletonBackground$7;
exports.skeletonElement = skeletonElement$7;
exports.slugBackground = slugBackground$3;
exports.slugBackgroundHover = slugBackgroundHover$3;
exports.slugCalloutAuraEnd = slugCalloutAuraEnd$3;
exports.slugCalloutAuraStart = slugCalloutAuraStart$3;
exports.slugCalloutGradientBottom = slugCalloutGradientBottom$3;
exports.slugCalloutGradientTop = slugCalloutGradientTop$3;
exports.slugGradient = slugGradient$3;
exports.slugGradientHover = slugGradientHover$3;
exports.slugHollowHover = slugHollowHover$3;
exports.supportCautionMajor = supportCautionMajor$3;
exports.supportCautionMinor = supportCautionMinor$3;
exports.supportCautionUndefined = supportCautionUndefined$3;
exports.supportError = supportError$7;
exports.supportErrorInverse = supportErrorInverse$7;
exports.supportInfo = supportInfo$7;
exports.supportInfoInverse = supportInfoInverse$7;
exports.supportSuccess = supportSuccess$7;
exports.supportSuccessInverse = supportSuccessInverse$7;
exports.supportWarning = supportWarning$7;
exports.supportWarningInverse = supportWarningInverse$7;
exports.tagTokens = index$1;
exports.textDisabled = textDisabled$7;
exports.textError = textError$7;
exports.textHelper = textHelper$7;
exports.textInverse = textInverse$7;
exports.textOnColor = textOnColor$7;
exports.textOnColorDisabled = textOnColorDisabled$7;
exports.textPlaceholder = textPlaceholder$7;
exports.textPrimary = textPrimary$7;
exports.textSecondary = textSecondary$7;
exports.themes = themes;
exports.toggleOff = toggleOff$7;
exports.unstable_metadata = unstable_metadata;
exports.v10 = index$3;
exports.white = white$1;
