/**
 * Utilites to manipulate the position of elements relative to other elements
 */
export declare enum PLACEMENTS {
    LEFT = "left",
    RIGHT = "right",
    TOP = "top",
    BOTTOM = "bottom"
}
export interface AbsolutePosition {
    top: number;
    left: number;
    position?: AbsolutePosition;
}
export declare type Offset = {
    top: number;
    left: number;
};
export declare type ReferenceRect = {
    height: number;
    width: number;
};
export declare type Positions = {
    [key: string]: (referenceOffset: Offset, target: HTMLElement, referenceRect: ReferenceRect) => AbsolutePosition;
};
export declare const defaultPositions: Positions;
export declare class Position {
    protected positions: Positions;
    constructor(positions?: Positions);
    getRelativeOffset(target: HTMLElement): Offset;
    getAbsoluteOffset(target: HTMLElement): Offset;
    findRelative(reference: Element, target: Element, placement: string): AbsolutePosition;
    findAbsolute(reference: Element, target: Element, placement: string): AbsolutePosition;
    findPosition(reference: Element, target: Element, placement: string, offsetFunction?: (target: HTMLElement) => Offset): AbsolutePosition;
    findPositionAt(offset: Offset, target: Element, placement: string): AbsolutePosition;
    /**
     * Get the dimensions of an element from an AbsolutePosition and a reference element
     */
    getPlacementBox(target: HTMLElement, position: AbsolutePosition): {
        top: number;
        bottom: number;
        left: number;
        right: number;
    };
    addOffset(position: AbsolutePosition, top?: number, left?: number): AbsolutePosition;
    setElement(element: Element, position: AbsolutePosition): void;
    findBestPlacement(reference: Element, target: Element, placements: string[], containerFunction?: () => ReferenceRect, positionFunction?: (reference: Element, target: Element, placement: string, offsetFunction?: (target: HTMLElement) => Offset) => AbsolutePosition): string;
    findBestPlacementAt(offset: Offset, target: Element, placements: string[], containerFunction?: () => ReferenceRect): string;
    protected defaultContainerFunction(): ReferenceRect;
    protected calculatePosition(referenceOffset: Offset, referenceRect: ReferenceRect, target: Element, placement: string): AbsolutePosition;
}
export declare const position: Position;
export default Position;
